<?php
session_start();
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario_id = $_POST['usuario_id'] ?? null;
    $permisos = $_POST['permisos'] ?? [];

    if (!$usuario_id) {
        $_SESSION['message'] = 'Debe seleccionar un usuario.';
        header('Location: ../views/roles'); // cambia a tu ruta real
        exit;
    }

    try {
        $database = new Connection();
        $db = $database->open();

        // Eliminar permisos anteriores
        $stmt = $db->prepare("DELETE FROM usuario_permiso WHERE usuario_id = ?");
        $stmt->execute([$usuario_id]);

        // Insertar nuevos permisos
        if (!empty($permisos)) {
            $stmt = $db->prepare("INSERT INTO usuario_permiso (usuario_id, permiso_id) VALUES (?, ?)");
            foreach ($permisos as $permiso_id) {
                $stmt->execute([$usuario_id, $permiso_id]);
            }
        }

        $_SESSION['message'] = 'Permisos actualizados correctamente. Favor de cerrar sesion y volver acceder.';
        header('Location: ../views/roles'); // cambia a tu vista real
    } catch (PDOException $e) {
        $_SESSION['message'] = 'Error al guardar los permisos: ' . $e->getMessage();
        header('Location: ../views/roles');
    }

    $database->close();
} else {
    header('Location: ../views/roles'); // acceso no permitido
}
