<?php
header('Content-Type: application/json');
include '../config/conexion.php';

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'No ID enviado']);
    exit;
}

$id = intval($_GET['id']);

$database = new Connection();
$db = $database->open();

try {
    $stmt = $db->prepare("SELECT * FROM usuarios WHERE id = :id");
    $stmt->execute([':id' => $id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        echo json_encode(['success' => true, 'user' => $user]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Usuario no encontrado']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$database->close();
?>