<?php
session_start();
include '../config/conexion.php';

if (isset($_POST['editar'])) {

    // Validar ID
    if (!isset($_GET['id']) || empty($_GET['id'])) {
        $_SESSION['message'] = 'ID de usuario no proporcionado.';
        header('location: ../views/usuario');
        exit;
    }

    $id = $_GET['id'];

    // Conexión a BD
    $database = new Connection();
    $db = $database->open();

    try {
        // Consulta SQL base (sin foto)
        $sql = "UPDATE usuarios 
                SET nro_document = :nro_document,
                    fullname = :fullname,
                    fecha_nacimiento = :fecha_nacimiento,
                    fecha_ingreso = :fecha_ingreso,
                    direccion = :direccion,
                    rol = :rol,
                    nro_contacto = :nro_contacto
                WHERE id = :id";

        $stmt = $db->prepare($sql);

        // Parámetros
        $params = [
            ':nro_document'     => $_POST['nro_document'],
            ':fullname'         => $_POST['fullname'],
            ':fecha_nacimiento' => $_POST['fecha_nacimiento'],
            ':fecha_ingreso'    => $_POST['fecha_ingreso'],
            ':direccion'        => $_POST['direccion'],
            ':rol'              => $_POST['rol'],
            ':nro_contacto'     => $_POST['nro_contacto'],
            ':id'               => $id
        ];

        // Ejecutar
        if ($stmt->execute($params)) {
            $_SESSION['message'] = "✅ Usuario actualizado correctamente.";
        } else {
            $_SESSION['message'] = "⚠️ No se pudo actualizar el usuario.";
        }
    } catch (PDOException $e) {
        $_SESSION['message'] = "Error en la base de datos: " . $e->getMessage();
    }

    $database->close();
    header('location: ../views/usuario');

} else {
    $_SESSION['message'] = 'Complete el formulario de edición.';
    header('location: ../views/usuario');
}
?>
