<?php
include '../config/conexion.php';
header('Content-Type: application/json');

if (isset($_GET['placa'])) {
    $placa = trim($_GET['placa']);
    $db = (new Connection())->open();

    // Buscar datos de la flota
    $stmt = $db->prepare("SELECT * FROM flota WHERE placa = :placa LIMIT 1");
    $stmt->execute([':placa' => $placa]);
    $flota = $stmt->fetch(PDO::FETCH_ASSOC);

    // Buscar datos del seguro
    $stmt2 = $db->prepare("SELECT * FROM seguro WHERE nro_placa = :placa ORDER BY fecha_vto DESC LIMIT 1");
    $stmt2->execute([':placa' => $placa]);
    $seguro = $stmt2->fetch(PDO::FETCH_ASSOC);

    if ($flota || $seguro) {
        echo json_encode([
            'success' => true,
            'flota' => $flota,
            'seguro' => $seguro
        ]);
    } else {
        echo json_encode(['success' => false]);
    }

    $db = null;
} else {
    echo json_encode(['success' => false]);
}
?>
