<?php
include '../config/conexion.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $placa = $_POST['placa'];
    $tipo = $_POST['tipo'];
    $marca = $_POST['marca'];
    $modelo = $_POST['modelo'];
    $aseguradora = $_POST['aseguradora'];
    $nro_poliza_seguro = $_POST['nro_poliza_seguro'];
    $chofer = $_POST['chofer'];
    $comentarios = $_POST['comentarios'];

    // ✅ Convertir coordenadas a número o null si no existen
    $lat = isset($_POST['lat']) && $_POST['lat'] !== '' ? floatval($_POST['lat']) : null;
    $lng = isset($_POST['lng']) && $_POST['lng'] !== '' ? floatval($_POST['lng']) : null;

    try {
        $database = new Connection();
        $db = $database->open();

        $stmt = $db->prepare("INSERT INTO registro_unidad 
            (placa, tipo, marca, modelo, aseguradora, nro_poliza_seguro, chofer, comentarios, lat, lng,estado) 
            VALUES (:placa, :tipo, :marca, :modelo, :aseguradora, :nro_poliza_seguro, :chofer, :comentarios, :lat, :lng,0)");

        $stmt->bindParam(':placa', $placa);
        $stmt->bindParam(':tipo', $tipo);
        $stmt->bindParam(':marca', $marca);
        $stmt->bindParam(':modelo', $modelo);
        $stmt->bindParam(':aseguradora', $aseguradora);
        $stmt->bindParam(':nro_poliza_seguro', $nro_poliza_seguro);
        $stmt->bindParam(':chofer', $chofer);
        $stmt->bindParam(':comentarios', $comentarios);
        $stmt->bindValue(':lat', $lat, is_null($lat) ? PDO::PARAM_NULL : PDO::PARAM_STR);
        $stmt->bindValue(':lng', $lng, is_null($lng) ? PDO::PARAM_NULL : PDO::PARAM_STR);

        $stmt->execute();

        $_SESSION['message'] = '✅ Unidad registrada correctamente.';

        // 🧠 Registro opcional de depuración (para revisar qué datos llegaron)
        // file_put_contents(__DIR__ . '/debug_post.log', json_encode($_POST, JSON_PRETTY_PRINT));

    } catch (PDOException $e) {
        $_SESSION['message'] = '❌ Error al registrar: ' . $e->getMessage();
    }
    // Redirigir de vuelta a la página que hizo la petición
    $redirectUrl = $_SERVER['HTTP_REFERER'] ?? '../views/registro_unidad';
    header("Location: " . $redirectUrl);
    exit;
}
?>
