<?php
session_start();
include '../config/conexion.php';

if (isset($_GET['id'])) {
    $id = $_GET['id'];

    $database = new Connection();
    $db = $database->open();

    try {
        // Usar sentencia preparada para evitar inyección SQL
        $stmt = $db->prepare("DELETE FROM conductor WHERE id = :id");
        $result = $stmt->execute([':id' => $id]);

        if ($result && $stmt->rowCount() > 0) {
            $_SESSION['message'] = '✅ Conductor eliminado correctamente.';
        } else {
            $_SESSION['message'] = '⚠️ No se encontró el conductor o no se pudo eliminar.';
        }
    } catch (PDOException $e) {
        $_SESSION['message'] = '❌ Error: ' . $e->getMessage();
    }

    // Cerrar conexión
    $database->close();
} else {
    $_SESSION['message'] = '⚠️ Debes seleccionar un conductor para eliminar.';
}

// Redirigir a la vista
header('Location: ../views/conductor');
exit();
?>
