<?php
header('Content-Type: application/json');
include '../config/conexion.php';

if (!isset($_GET['placa'])) {
    echo json_encode([]);
    exit;
}

$placa = trim($_GET['placa']);

try {
    $database = new Connection();
    $db = $database->open();

    $stmt = $db->prepare("SELECT lat, lng, fecha FROM login_geolocalizacion WHERE placa = :placa ORDER BY fecha ASC");
    $stmt->bindParam(':placa', $placa);
    $stmt->execute();

    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
