<?php
include '../config/conexion.php';
header('Content-Type: application/json');

$placa = $_GET['placa'] ?? '';
$inicio = $_GET['inicio'] ?? '';
$fin = $_GET['fin'] ?? '';

if(!$placa || !$inicio || !$fin){
    echo json_encode([]);
    exit;
}

try{
    $db = (new Connection())->open();
    $stmt = $db->prepare("
        SELECT lat,lng,fecha 
        FROM login_geolocalizacion 
        WHERE placa=:placa 
          AND fecha BETWEEN :inicio AND :fin
        ORDER BY fecha ASC
    ");
    $stmt->execute([
        'placa'=>$placa,
        'inicio'=>$inicio.' 00:00:00',
        'fin'=>$fin.' 23:59:59'
    ]);
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($data);
}catch(PDOException $e){
    echo json_encode([]);
}
