<?php 
session_start();
include '../config/conexion.php';

$msg = ""; 

if (isset($_POST['submitBtnLogin'])) {
    $username = trim($_POST['usuario']);
    $password = trim($_POST['password']);
    $lat = isset($_POST['lat']) ? $_POST['lat'] : null;
    $lng = isset($_POST['lng']) ? $_POST['lng'] : null;

    if ($username != "" && $password != "") {
        try {
            $database = new Connection();
            $db = $database->open();

            $query = "SELECT * FROM `usuarios` WHERE `usuario` = :usuario";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':usuario', $username, PDO::PARAM_STR);
            $stmt->execute();
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($row && password_verify($password, $row['pass'])) {
                // Guardar datos en sesión
                $_SESSION['sess_name'] = $row['fullname'];
                $_SESSION['sess_foto'] = $row['foto'];
                $_SESSION['sess_tipo'] = $row['rol'];
                $_SESSION['sess_id'] = $row['id'];
                $_SESSION["verificar"] = true;

                // Obtener permisos
                $id_user = $_SESSION['sess_id'];
                $permisoQuery = $db->prepare("
                    SELECT p.nombre 
                    FROM permisos p 
                    INNER JOIN usuario_permiso up ON p.id = up.permiso_id 
                    WHERE up.usuario_id = ?
                ");
                $permisoQuery->execute([$id_user]);
                $permisos = $permisoQuery->fetchAll(PDO::FETCH_COLUMN);
                $_SESSION['permisos'] = $permisos;

                // 📍 Registrar geolocalización
                if ($lat && $lng) {
                    $geoQuery = $db->prepare("
                        INSERT INTO accesos_usuarios (usuario_id, latitud, longitud)
                        VALUES (:usuario_id, :latitud, :longitud)
                    ");
                    $geoQuery->bindParam(':usuario_id', $id_user);
                    $geoQuery->bindParam(':latitud', $lat);
                    $geoQuery->bindParam(':longitud', $lng);
                    $geoQuery->execute();
                }

                header('location: ../views/principal');
                exit();
            } else {
                $error = sha1(md5("Error"));
                header("location: ../views/page-login?error=$error");
                exit();
            }
        } catch (PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
    } else {
        $msg = "Ambos campos son obligatorios!";
    }
}
?>
