<?php
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $estado = $_POST['estado'];
    $comentarios = $_POST['comentarios'];

    try {
        $db = (new Connection())->open();
        $sql = "UPDATE registro_unidad SET estado = :estado, comentario_salida = :comentarios, hora_salida = now() WHERE id = :id";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':estado', $estado);
        $stmt->bindParam(':comentarios', $comentarios);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        session_start();
        $_SESSION['message'] = "Registro actualizado correctamente";

        // Redirigir a la página que hizo la petición
        $redirect = $_SERVER['HTTP_REFERER'] ?? '../views/registro_unidad';
        header("Location: $redirect");
        exit();
    } catch (PDOException $e) {
        die("Error: " . $e->getMessage());
    }
}
?>
