<?php
session_start();
include '../config/conexion.php';

if (isset($_POST['editar'])) {
    $database = new Connection();
    $db = $database->open();

    try {
        $sql = "UPDATE personal_seguridad 
                SET nro_documento = :doc,
                    nombre_completo = :nom,
                    cargo = :cargo,
                    turno = :turno,
                    nro_celular = :cel,
                    fecha_ingreso = :fecha,
                    estado = :estado
                WHERE id = :id";

        $stmt = $db->prepare($sql);
        $stmt->execute([
            ':doc'   => $_POST['nro_documento'],
            ':nom'   => $_POST['nombre_completo'],
            ':cargo' => $_POST['cargo'],
            ':turno' => $_POST['turno'],
            ':cel'   => $_POST['nro_celular'],
            ':fecha' => $_POST['fecha_ingreso'],
            ':estado'=> $_POST['estado'],
            ':id'    => $_POST['id']
        ]);

        $_SESSION['message'] = 'Personal actualizado correctamente.';
    } catch (PDOException $e) {
        $_SESSION['message'] = 'Error al actualizar: ' . $e->getMessage();
    }

    $database->close();

    // ✅ Redirigir correctamente
    header('Location: ../views/seguridad');
    exit();
} else {
    $_SESSION['message'] = 'Formulario de edición incompleto.';
    header('Location: ../views/seguridad');
    exit();
}
