<?php
session_start();
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db = (new Connection())->open();
    try {
        $estado = isset($_POST['estado']) ? 1 : 0;

        $sql = "UPDATE registro_unidad 
                SET placa=:placa, tipo=:tipo, marca=:marca, modelo=:modelo, 
                    aseguradora=:aseguradora, nro_poliza_seguro=:nro_poliza_seguro, 
                    chofer=:chofer, comentarios=:comentarios, estado=:estado
                WHERE id=:id";
        $stmt = $db->prepare($sql);
        $stmt->execute([
            ':placa' => $_POST['placa'],
            ':tipo' => $_POST['tipo'],
            ':marca' => $_POST['marca'],
            ':modelo' => $_POST['modelo'],
            ':aseguradora' => $_POST['aseguradora'],
            ':nro_poliza_seguro' => $_POST['nro_poliza_seguro'],
            ':chofer' => $_POST['chofer'],
            ':comentarios' => $_POST['comentarios'],
            ':estado' => $estado,
            ':id' => $_POST['id']
        ]);
        $_SESSION['message'] = 'Unidad actualizada correctamente.';
    } catch (PDOException $e) {
        $_SESSION['message'] = 'Error al actualizar: ' . $e->getMessage();
    }
    header('Location: ../views/registro');
}
?>
