<?php
session_start();
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Abrir conexión
    $database = new Connection();
    $db = $database->open();

    try {
        // Obtener valores del formulario
        $id = $_POST['id'];
        $nro_document = $_POST['nro_document'];
        $fullname = $_POST['fullname'];
        $nro_licencia = $_POST['nro_licencia'];
        $direccion = $_POST['direccion'];
        $nro_celular = $_POST['nro_celular'];
        $nro_contacto_emergencia = $_POST['nro_contacto_emergencia'];
        $categoria_licencia = $_POST['categoria_licencia'];
        $fecha_vto_licencia = $_POST['fecha_vto_licencia'];

        // Query usando prepared statements (más seguro)
        $sql = "UPDATE conductor 
                SET nro_document = :nro_document,
                    fullname = :fullname,
                    nro_licencia = :nro_licencia,
                    direccion = :direccion,
                    nro_celular = :nro_celular,
                    nro_contacto_emergencia = :nro_contacto_emergencia,
                    categoria_licencia = :categoria_licencia,
                    fecha_vto_licencia = :fecha_vto_licencia
                WHERE id = :id";

        $stmt = $db->prepare($sql);
        $stmt->execute([
            ':nro_document' => $nro_document,
            ':fullname' => $fullname,
            ':nro_licencia' => $nro_licencia,
            ':direccion' => $direccion,
            ':nro_celular' => $nro_celular,
            ':nro_contacto_emergencia' => $nro_contacto_emergencia,
            ':categoria_licencia' => $categoria_licencia,
            ':fecha_vto_licencia' => $fecha_vto_licencia,
            ':id' => $id
        ]);

        $_SESSION['message'] = '✅ Conductor actualizado correctamente.';
    } 
    catch (PDOException $e) {
        $_SESSION['message'] = '❌ Error: ' . $e->getMessage();
    }

    // Cerrar conexión y redirigir
    $database->close();
    header('Location: ../views/conductor');
    exit();
} 
else {
    $_SESSION['message'] = 'Complete el formulario de edición.';
    header('Location: ../views/conductor');
    exit();
}
?>
