<div class="modal fade" id="modalNuevaUnidad" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <form action="../controller/create_unidad.php" method="POST" id="formNuevaUnidad">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title"><i class="fa fa-plus-circle"></i> Registrar Nueva Unidad</h5>
          <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
        </div>

        <div class="modal-body">
          <div class="row">
            <div class="col-md-4">
              <label>Placa</label>
              <div class="input-group">
                <input type="text" name="placa" id="placa" class="form-control" required>
                <div class="input-group-append">
                  <button class="btn btn-outline-primary" type="button" id="btnBuscarPlaca">
                    <i class="fa fa-search"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="col-md-4"><label>Tipo</label><input name="tipo" id="tipo" class="form-control"></div>
            <div class="col-md-4"><label>Marca</label><input name="marca" id="marca" class="form-control"></div>
            <div class="col-md-4 mt-2"><label>Modelo</label><input name="modelo" id="modelo" class="form-control"></div>
            <div class="col-md-4 mt-2"><label>Aseguradora</label><input name="aseguradora" id="aseguradora" class="form-control"></div>
            <div class="col-md-4 mt-2"><label>N° Póliza Seguro</label><input name="nro_poliza_seguro" id="nro_poliza_seguro" class="form-control"></div>
            <div class="col-md-6 mt-2">
            <label>Conductor:</label>
            <input name="chofer" value="<?php echo $_SESSION['sess_name']; ?>" class="form-control" readonly>
          </div>
          <div class="col-md-6 mt-2">
    <label>Comentarios:</label>
    <textarea name="comentarios" class="form-control" rows="3" placeholder="Ingresa tus comentarios aquí" required></textarea>
</div>

            <div class="col-md-12 mt-3 text-center">
              <button type="button" id="btnCapturarUbicacion" class="btn btn-outline-success">
                <i class="fa fa-location-arrow"></i> Capturar Ubicación Actual
              </button>
              <p class="text-muted mt-2" id="ubicacionStatus"></p>
            </div>
            
            <input type="text" name="lat" id="lat">
            <input type="text" name="lng" id="lng">
            
            <div class="col-md-12 mt-3">
              <div id="mapaUbicacion" style="height: 250px; display: none;" class="border rounded"></div>
            </div>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Guardar</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

<script>
let map; // variable global para Leaflet

// --- Buscar por placa ---
$('#btnBuscarPlaca').click(function() {
  const placa = $('#placa').val().trim();
  if (!placa) {
    Swal.fire('Atención', 'Por favor ingrese una placa.', 'warning');
    return;
  }
  $.ajax({
    url: '../controller/buscar_flota.php',
    type: 'GET',
    data: { placa },
    dataType: 'json',
    success: function(data) {
      if (data.success) {
        if (data.flota) {
          $('#tipo').val(data.flota.tipo);
          $('#marca').val(data.flota.marca);
          $('#modelo').val(data.flota.modelo);
        }
        if (data.seguro) {
          $('#aseguradora').val(data.seguro.aseguradora);
          $('#nro_poliza_seguro').val(data.seguro.nro_poliza_seguro);
        }
        Swal.fire('Éxito', 'Datos cargados correctamente.', 'success');
      } else {
        Swal.fire('No encontrado', 'No se encontró ningún vehículo con esa placa.', 'info');
      }
    },
    error: function() {
      Swal.fire('Error', 'Ocurrió un problema al buscar la placa.', 'error');
    }
  });
});

// --- Función para capturar ubicación ---
function capturarUbicacion() {
  const status = $('#ubicacionStatus');
  status.text('📡 Detectando ubicación...');
  $('#mapaUbicacion').hide();

  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(
      function(pos) {
        const lat = pos.coords.latitude.toFixed(6);
        const lng = pos.coords.longitude.toFixed(6);

        // ✅ Se asigna el valor a los campos ocultos
        $('#lat').val(lat);
        $('#lng').val(lng);

        status.text(`✅ Lat: ${lat}, Lng: ${lng}`);
        $('#mapaUbicacion').show();

        if (map) map.remove();
        map = L.map('mapaUbicacion').setView([lat, lng], 15);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19 }).addTo(map);
        L.marker([lat, lng]).addTo(map)
          .bindPopup(`Tu ubicación:<br>Lat: ${lat}<br>Lng: ${lng}`)
          .openPopup();

        Swal.fire({
          icon: 'success',
          title: 'Ubicación detectada',
          text: `Latitud: ${lat}, Longitud: ${lng}`,
          timer: 2500,
          showConfirmButton: false
        });
      },
      function(error) {
        let msg = 'No se pudo obtener tu ubicación.';
        if (error.code === error.PERMISSION_DENIED) msg = 'Has denegado el permiso de ubicación. Actívalo en el candado 🔒.';
        if (error.code === error.POSITION_UNAVAILABLE) msg = 'La información de ubicación no está disponible.';
        if (error.code === error.TIMEOUT) msg = 'La solicitud de ubicación expiró.';

        Swal.fire({ icon: 'warning', title: 'Ubicación no disponible', text: msg });
        status.text('⚠️ ' + msg);
      },
      { enableHighAccuracy: true, timeout: 10000, maximumAge: 0 }
    );
  } else {
    Swal.fire({ icon: 'error', title: 'No compatible', text: 'Tu navegador no soporta geolocalización.' });
  }
}

// --- Captura manual con botón ---
$('#btnCapturarUbicacion').click(capturarUbicacion);

// --- Captura automática al abrir el modal ---
// Esto lo mantiene por si falla al cargar la página.
$('#modalNuevaUnidad').on('shown.bs.modal', function () {
    // Si los campos ya tienen datos, no hace nada. Si no, intenta capturar la ubicación.
    if ($('#lat').val() === '' || $('#lng').val() === '') {
        capturarUbicacion();
    }
});

// --- Validar coordenadas antes de enviar ---
$('#formNuevaUnidad').on('submit', function(e) {
  const lat = $('#lat').val();
  const lng = $('#lng').val();
  if (!lat || !lng) {
    e.preventDefault();
    Swal.fire({
      icon: 'warning',
      title: 'Ubicación no detectada',
      text: 'Presiona el botón "Capturar Ubicación Actual" antes de guardar.'
    });
  }
});

// --- NUEVA LÓGICA: Solicita la ubicación inmediatamente al cargar el documento ---
// Esto asegura que, si el usuario da permiso, los campos se llenen antes de cualquier interacción.
$(document).ready(function() {
    capturarUbicacion();
});
</script>