<div class="modal fade" id="largeModal" tabindex="-1" role="dialog" aria-labelledby="largeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="largeModalLabel">Crear Nuevo Usuario</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" action="../controller/CrearUsuario.php" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12 col-md-6 mb-3">
                            <small>Número Documento:</small>
                            <input type="text" id="nro_document" name="nro_document" class="form-control" placeholder="Nro. Documento" required>
                        </div>
                        <div class="col-12 col-md-6 mb-3">
                            <small>Nombres Completos:</small>
                            <input type="text" id="fullname" name="fullname" class="form-control" placeholder="Nombres Completos" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 col-md-6 mb-3">
                            <small>Fecha Nacimiento:</small>
                            <input type="date" name="fecha_nacimiento" class="form-control" required>
                        </div>
                        <div class="col-12 col-md-6 mb-3">
                            <small>Fecha Ingreso:</small>
                            <input type="date" name="fecha_ingreso" class="form-control" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 col-md-6 mb-3">
                            <small>Dirección Domicilio:</small>
                            <input type="text" name="direccion" class="form-control" placeholder="Dirección Domicilio" required>
                        </div>
                        <div class="col-12 col-md-6 mb-3">
                            <small>Fotografía:</small>
                            <input type="file" name="foto" accept="image/*" class="form-control" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 col-md-4 mb-3">
                            <small>Usuario:</small>
                            <input type="text" id="usuario" name="usuario" class="form-control" placeholder="AutoGenerando..." readonly required>
                        </div>
                        <div class="col-12 col-md-4 mb-3">
                            <small>Contraseña:</small>
                            <input type="text" id="pass" name="pass" class="form-control" placeholder="Password" readonly required>
                        </div>
                        <div class="col-12 col-md-4 mb-3">
                            <small>Roles:</small>
                            <select name="rol" class="form-control" required>
                                <option value="">Seleccione Rol:</option>
                                <option value="Gerente">Gerente</option>
                                <option value="Seguridad de la Empresa<">Seguridad de la Empresa</option>
                                <option value="Conductor">Conductor</option>
                                <option value="Mecanico">Mecanico</option>
                                <option value="Sistemas">Sistemas</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 col-md-4 mb-3">
                            <small>Nro. Contacto:</small>
                            <input type="text" name="nro_contacto" class="form-control" placeholder="# Contacto" required>
                        </div>
                    </div>
                </div> <!-- /.modal-body -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" name="agregar" class="btn btn-primary">Confirmar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    // Función para obtener la fecha actual en formato YYYYMMDD
    function getCurrentDateYYYYMMDD() {
        const now = new Date();
        const year = now.getFullYear();
        const month = String(now.getMonth() + 1).padStart(2, '0'); // meses 0-11
        const day = String(now.getDate()).padStart(2, '0');
        return `${year}${month}${day}`;
    }

    // Función para actualizar el campo usuario
    function actualizarUsuario() {
        const nroDocument = document.getElementById('nro_document').value.trim();
        const fullname = document.getElementById('fullname').value.trim();

        if (nroDocument && fullname.length >= 2) {
            const primerasLetras = fullname.substring(0, 2).toLowerCase();
            document.getElementById('usuario').value = nroDocument + primerasLetras;
        } else {
            document.getElementById('usuario').value = '';
        }
    }

    // Al cargar la página y cuando el usuario escribe, actualizar los campos
    document.addEventListener('DOMContentLoaded', () => {
        // Setear la contraseña con la fecha actual al cargar el modal
        document.getElementById('pass').value = getCurrentDateYYYYMMDD();

        // Actualizar usuario cuando cambie nro_document o fullname
        document.getElementById('nro_document').addEventListener('input', actualizarUsuario);
        document.getElementById('fullname').addEventListener('input', actualizarUsuario);
    });
</script>
