<?php
require_once '../config/conexion.php';

class Conductor {
    private $db;

    public function __construct() {
        $this->db = (new Connection())->open();
    }

    public function getAll() {
        return $this->db->query("SELECT * FROM conductor ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function insert($data) {
        $sql = "INSERT INTO conductor (nro_document, fullname, nro_licencia, direccion, nro_celular, nro_contacto_emergencia, categoria_licencia, fecha_vto_licencia)
                VALUES (:nro_document, :fullname, :nro_licencia, :direccion, :nro_celular, :nro_contacto_emergencia, :categoria_licencia, :fecha_vto_licencia)";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute($data);
    }

    public function delete($id) {
        $stmt = $this->db->prepare("DELETE FROM conductor WHERE id = ?");
        return $stmt->execute([$id]);
    }
}
