<?php
require_once '../config/conexion.php';

class Flota {
    private $db;

    public function __construct() {
        $this->db = (new Connection())->open();
    }

    public function getAll() {
        return $this->db->query("SELECT * FROM flota ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function insert($data) {
        $sql = "INSERT INTO flota (tipo, marca, modelo, placa, nro_serie, color, ano, carga_maxima, tipo_combustible, tipo_de_aceite, cantidad_aceite, comentarios)
                VALUES (:tipo, :marca, :modelo, :placa, :nro_serie, :color, :ano, :carga_maxima, :tipo_combustible, :tipo_de_aceite, :cantidad_aceite, :comentarios)";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute($data);
    }

    public function delete($id) {
        $stmt = $this->db->prepare("DELETE FROM flota WHERE id = ?");
        return $stmt->execute([$id]);
    }
}
