<?php
require_once '../config/conexion.php';

class LoginGeolocalizacion {
    private $db;
    public function __construct() {
        $this->db = (new Connection())->open();
    }

    public function registrar($data) {
        $sql = "INSERT INTO login_geolocalizacion (usuario_id, placa, lat, lng)
                VALUES (:usuario_id, :placa, :lat, :lng)";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute($data);
    }

    public function getByUsuario($usuario_id) {
        $stmt = $this->db->prepare("SELECT * FROM login_geolocalizacion WHERE usuario_id = ? ORDER BY fecha DESC");
        $stmt->execute([$usuario_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
