<?php
require_once '../config/conexion.php';

class Usuario {
    private $conn;

    public function __construct() {
        $database = new Connection();
        $this->conn = $database->open();
    }

    public function obtenerUsuarios() {
        try {
            $sql = "SELECT * FROM usuarios ORDER BY id DESC";
            $stmt = $this->conn->prepare($sql);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            return [];
        }
    }

    public function obtenerUsuarioPorId($id) {
        try {
            $sql = "SELECT * FROM usuarios WHERE id = :id";
            $stmt = $this->conn->prepare($sql);
            $stmt->bindParam(':id', $id);
            $stmt->execute();
            return $stmt->fetch(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            return false;
        }
    }

    public function agregarUsuario($data) {
        try {
            $sql = "INSERT INTO usuarios (nro_document, fullname, fecha_nacimiento, fecha_ingreso, direccion, foto, usuario, pass, rol, nro_contacto)
                    VALUES (:nro_document, :fullname, :fecha_nacimiento, :fecha_ingreso, :direccion, :foto, :usuario, :pass, :rol, :nro_contacto)";
            $stmt = $this->conn->prepare($sql);
            return $stmt->execute($data);
        } catch (PDOException $e) {
            return false;
        }
    }

    public function actualizarUsuario($id, $data) {
        try {
            $sql = "UPDATE usuarios 
                    SET nro_document = :nro_document, fullname = :fullname, fecha_nacimiento = :fecha_nacimiento, 
                        fecha_ingreso = :fecha_ingreso, direccion = :direccion, rol = :rol, nro_contacto = :nro_contacto
                    WHERE id = :id";
            $stmt = $this->conn->prepare($sql);
            $data['id'] = $id;
            return $stmt->execute($data);
        } catch (PDOException $e) {
            return false;
        }
    }

    public function eliminarUsuario($id) {
        try {
            $sql = "DELETE FROM usuarios WHERE id = :id";
            $stmt = $this->conn->prepare($sql);
            $stmt->bindParam(':id', $id);
            return $stmt->execute();
        } catch (PDOException $e) {
            return false;
        }
    }

    public function actualizarPassword($id, $newPass) {
        try {
            $sql = "UPDATE usuarios SET pass = :pass WHERE id = :id";
            $stmt = $this->conn->prepare($sql);
            $stmt->bindParam(':pass', $newPass);
            $stmt->bindParam(':id', $id);
            return $stmt->execute();
        } catch (PDOException $e) {
            return false;
        }
    }
}
?>
