/**
 * @license Highcharts Gantt JS v11.3.0 (2024-01-10)
 * @module highcharts/modules/gantt
 * @requires highcharts
 *
 * Gantt series
 *
 * (c) 2016-2024 Lars A. V. Cabrera
 *
 * License: www.highcharts.com/license
 */
'use strict';
import Highcharts from '../../Core/Globals.js';
import ArrowSymbols from '../../Extensions/ArrowSymbols.js';
import Connection from '../../Gantt/Connection.js';
import CurrentDateIndication from '../../Extensions/CurrentDateIndication.js';
import GanttChart from '../../Core/Chart/GanttChart.js';
import Navigator from '../../Stock/Navigator/Navigator.js';
import Pathfinder from '../../Gantt/Pathfinder.js';
import RangeSelector from '../../Stock/RangeSelector/RangeSelector.js';
import Scrollbar from '../../Stock/Scrollbar/Scrollbar.js';
import StaticScale from '../../Extensions/StaticScale.js';
// Series
import XRangeSeries from '../../Series/XRange/XRangeSeries.js';
import GanttSeries from '../../Series/Gantt/GanttSeries.js';
const G = Highcharts;
// Classes
G.Connection = Connection;
G.GanttChart = GanttChart;
G.ganttChart = GanttChart.ganttChart;
G.Navigator = Navigator;
G.Pathfinder = Pathfinder;
G.RangeSelector = RangeSelector;
G.Scrollbar = Scrollbar;
// Compositions
ArrowSymbols.compose(G.SVGRenderer);
CurrentDateIndication.compose(G.Axis, G.PlotLineOrBand);
GanttSeries.compose(G.Axis, G.Chart, G.Series, G.Tick);
Navigator.compose(G.Axis, G.Chart, G.Series);
Pathfinder.compose(G.Chart, G.Point);
RangeSelector.compose(G.Axis, G.Chart);
Scrollbar.compose(G.Axis);
XRangeSeries.compose(G.Axis);
StaticScale.compose(G.Axis, G.Chart);
