/**
 * Highstock JS v11.3.0 (2024-01-10)
 *
 * All technical indicators for Highcharts Stock
 *
 * (c) 2010-2024 Pawel Fus
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function o(t,e,o,r){t.hasOwnProperty(e)||(t[e]=r.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}o(e,"Stock/Indicators/SMA/SMAIndicator.js",[e["Core/Chart/Chart.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.line,s=o.addEvent,a=o.fireEvent,p=o.error,l=o.extend,u=o.isArray,c=o.merge,h=o.pick,y=o.splat,f=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return n(o,e),o.prototype.destroy=function(){this.dataEventsToUnbind.forEach(function(t){t()}),e.prototype.destroy.apply(this,arguments)},o.prototype.getName=function(){var t=[],e=this.name;return e||((this.nameComponents||[]).forEach(function(e,o){t.push(this.options.params[e]+h(this.nameSuffixes[o],""))},this),e=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+t.join(", ")+")":"")),e},o.prototype.getValues=function(t,e){var o,r,n=e.period,i=t.xData,s=t.yData,a=s.length,p=[],l=[],c=[],h=-1,y=0,f=0;if(!(i.length<n)){for(u(s[0])&&(h=e.index?e.index:0);y<n-1;)f+=h<0?s[y]:s[y][h],y++;for(o=y;o<a;o++)f+=h<0?s[o]:s[o][h],r=[i[o],f/n],p.push(r),l.push(r[0]),c.push(r[1]),f-=h<0?s[o-y]:s[o-y][h];return{values:p,xData:l,yData:c}}},o.prototype.init=function(o,r){var n=this;e.prototype.init.call(n,o,r);var i=s(t,"afterLinkSeries",function(t){if(!t.isUpdating){var e=!!n.dataEventsToUnbind.length;if(!n.linkedParent)return p("Series "+n.options.linkedTo+" not found! Check `linkedTo`.",!1,o);if(!e&&(n.dataEventsToUnbind.push(s(n.linkedParent,"updatedData",function(){n.recalculateValues()})),n.calculateOn.xAxis&&n.dataEventsToUnbind.push(s(n.linkedParent.xAxis,n.calculateOn.xAxis,function(){n.recalculateValues()}))),"init"===n.calculateOn.chart)n.processedYData||n.recalculateValues();else if(!e)var r=s(n.chart,n.calculateOn.chart,function(){n.recalculateValues(),r()})}},{order:0});n.dataEventsToUnbind=[],n.eventsToUnbind.push(i)},o.prototype.recalculateValues=function(){var t,e,o,r,n,i,s=[],p=this.points||[],l=(this.xData||[]).length,u=!0,c=this.linkedParent.options&&this.linkedParent.yData&&this.linkedParent.yData.length&&this.getValues(this.linkedParent,this.options.params)||{values:[],xData:[],yData:[]};if(l&&!this.hasGroupedData&&this.visible&&this.points){if(this.cropped){for(this.xAxis&&(r=this.xAxis.min,n=this.xAxis.max),o=this.cropData(c.xData,c.yData,r,n),i=0;i<o.xData.length;i++)s.push([o.xData[i]].concat(y(o.yData[i])));t=c.xData.indexOf(this.xData[0]),e=c.xData.indexOf(this.xData[this.xData.length-1]),-1===t&&e===c.xData.length-2&&s[0][0]===p[0].x&&s.shift(),this.updateData(s)}else(this.updateAllPoints||c.xData.length!==l-1&&c.xData.length!==l+1)&&(u=!1,this.updateData(c.values))}u&&(this.xData=c.xData,this.yData=c.yData,this.options.data=c.values),this.calculateOn.xAxis&&this.processedXData&&(delete this.processedXData,this.isDirty=!0,this.redraw()),this.isDirtyData=!!this.linkedSeries.length,a(this,"updatedData")},o.prototype.processData=function(){var t=this.options.compareToMain,o=this.linkedParent;e.prototype.processData.apply(this,arguments),this.dataModify&&o&&o.dataModify&&o.dataModify.compareValue&&t&&(this.dataModify.compareValue=o.dataModify.compareValue)},o.defaultOptions=c(i.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:3,period:14}}),o}(i);return l(f.prototype,{calculateOn:{chart:"init"},hasDerivedData:!0,nameComponents:["period"],nameSuffixes:[],useCommonDataGrouping:!0}),e.registerSeriesType("sma",f),f}),o(e,"Stock/Indicators/EMA/EMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.correctFloat,s=e.isArray,a=e.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.accumulatePeriodPoints=function(t,e,o){for(var r=0,n=0;n<t;)r+=e<0?o[n]:o[n][e],n++;return r},e.prototype.calculateEma=function(t,e,o,r,n,s,a){var p=t[o-1],l=s<0?e[o-1]:e[o-1][s];return[p,void 0===n?a:i(l*r+n*(1-r))]},e.prototype.getValues=function(t,e){var o,r,n,i=e.period,a=t.xData,p=t.yData,l=p?p.length:0,u=2/(i+1),c=[],h=[],y=[],f=-1,d=0;if(!(l<i)){for(s(p[0])&&(f=e.index?e.index:0),d=this.accumulatePeriodPoints(i,f,p)/i,n=i;n<l+1;n++)r=this.calculateEma(a,p,n,u,o,f,d),c.push(r),h.push(r[0]),y.push(r[1]),o=r[1];return{values:c,xData:h,yData:y}}},e.defaultOptions=a(n.defaultOptions,{params:{index:3,period:9}}),e}(n);return t.registerSeriesType("ema",p),p}),o(e,"Stock/Indicators/AD/ADIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.error,s=e.extend,a=e.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.populateAverage=function(t,e,o,r,n){var i=e[r][1],s=e[r][2],a=e[r][3],p=o[r];return[t[r],a===i&&a===s||i===s?0:(2*a-s-i)/(i-s)*p]},e.prototype.getValues=function(t,o){var r,n,s,a=o.period,p=t.xData,l=t.yData,u=o.volumeSeriesID,c=t.chart.get(u),h=c&&c.yData,y=l?l.length:0,f=[],d=[],g=[];if(!(p.length<=a)||!y||4===l[0].length){if(!c){i("Series "+u+" not found! Check `volumeSeriesID`.",!0,t.chart);return}for(n=a;n<y;n++)r=f.length,s=e.populateAverage(p,l,h,n,a),r>0&&(s[1]+=f[r-1][1]),f.push(s),d.push(s[0]),g.push(s[1]);return{values:f,xData:d,yData:g}}},e.defaultOptions=a(n.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}}),e}(n);return s(p.prototype,{nameComponents:!1,nameBase:"Accumulation/Distribution"}),t.registerSeriesType("ad",p),p}),o(e,"Stock/Indicators/AO/AOIndicator.js",[e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=t.noop,s=e.seriesTypes,a=s.column.prototype,p=s.sma,l=o.extend,u=o.merge,c=o.correctFloat,h=o.isArray,y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.drawGraph=function(){var t,e=this.options,o=this.points,r=this.userOptions.color,n=e.greaterBarColor,i=e.lowerBarColor,s=o[0];if(!r&&s)for(t=1,s.color=n;t<o.length;t++)o[t].y>o[t-1].y?o[t].color=n:o[t].y<o[t-1].y?o[t].color=i:o[t].color=o[t-1].color},e.prototype.getValues=function(t){var e,o,r,n,i,s,a=t.xData||[],p=t.yData||[],l=p.length,u=[],y=[],f=[],d=0,g=0;if(!(a.length<=34)&&h(p[0])&&4===p[0].length){for(i=0;i<33;i++)n=(p[i][1]+p[i][2])/2,i>=29&&(g=c(g+n)),d=c(d+n);for(s=33;s<l;s++)g=c(g+(n=(p[s][1]+p[s][2])/2)),d=c(d+n),e=c(g/5-d/34),u.push([a[s],e]),y.push(a[s]),f.push(e),o=s+1-5,r=s+1-34,g=c(g-(p[o][1]+p[o][2])/2),d=c(d-(p[r][1]+p[r][2])/2);return{values:u,xData:y,yData:f}}},e.defaultOptions=u(p.defaultOptions,{params:{index:void 0,period:void 0},greaterBarColor:"#06b535",lowerBarColor:"#f21313",threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,states:{hover:{halo:{size:0}}}}),e}(p);return l(y.prototype,{nameBase:"AO",nameComponents:void 0,markerAttribs:i,getColumnMetrics:a.getColumnMetrics,crispCol:a.crispCol,translate:a.translate,drawPoints:a.drawPoints}),e.registerSeriesType("ao",y),y}),o(e,"Stock/Indicators/MultipleLinesComposition.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=t.seriesTypes.sma.prototype,n=e.defined,i=e.error,s=e.merge;return function(t){var e=["bottomLine"],o=["top","bottom"],a=["top"];function p(t){return"plot"+t.charAt(0).toUpperCase()+t.slice(1)}function l(t,e){var o=[];return(t.pointArrayMap||[]).forEach(function(t){t!==e&&o.push(p(t))}),o}function u(){var t,e=this,o=e.pointValKey,a=e.linesApiNames,u=e.areaLinesNames,c=e.points,h=e.options,y=e.graph,f={options:{gapSize:h.gapSize}},d=[],g=l(e,o),m=c.length;if(g.forEach(function(e,o){for(d[o]=[];m--;)t=c[m],d[o].push({x:t.x,plotX:t.plotX,plotY:t[e],isNull:!n(t[e])});m=c.length}),e.userOptions.fillColor&&u.length){var v=d[g.indexOf(p(u[0]))],x=1===u.length?c:d[g.indexOf(p(u[1]))],_=e.color;e.points=x,e.nextPoints=v,e.color=e.userOptions.fillColor,e.options=s(c,f),e.graph=e.area,e.fillGraph=!0,r.drawGraph.call(e),e.area=e.graph,delete e.nextPoints,delete e.fillGraph,e.color=_}a.forEach(function(t,o){d[o]?(e.points=d[o],h[t]?e.options=s(h[t].styles,f):i('Error: "There is no '+t+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names."'),e.graph=e["graph"+t],r.drawGraph.call(e),e["graph"+t]=e.graph):i('Error: "'+t+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")}),e.points=c,e.options=h,e.graph=y,r.drawGraph.call(e)}function c(t){var e,o=[],n=[];if(t=t||this.points,this.fillGraph&&this.nextPoints){if((e=r.getGraphPath.call(this,this.nextPoints))&&e.length){e[0][0]="L",o=r.getGraphPath.call(this,t),n=e.slice(0,o.length);for(var i=n.length-1;i>=0;i--)o.push(n[i])}}else o=r.getGraphPath.apply(this,arguments);return o}function h(t){var e=[];return(this.pointArrayMap||[]).forEach(function(o){e.push(t[o])}),e}function y(){var t,e=this,o=this.pointArrayMap,n=[];n=l(this),r.translate.apply(this,arguments),this.points.forEach(function(r){o.forEach(function(o,i){t=r[o],e.dataModify&&(t=e.dataModify.modifyValue(t)),null!==t&&(r[n[i]]=e.yAxis.toPixels(t,!0))})})}t.compose=function(t){var r=t.prototype;return r.linesApiNames=r.linesApiNames||e.slice(),r.pointArrayMap=r.pointArrayMap||o.slice(),r.pointValKey=r.pointValKey||"top",r.areaLinesNames=r.areaLinesNames||a.slice(),r.drawGraph=u,r.getGraphPath=c,r.toYData=h,r.translate=y,t}}(o||(o={})),o}),o(e,"Stock/Indicators/Aroon/AroonIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.sma,s=o.extend,a=o.merge,p=o.pick;function l(t,e){var o,r=t[0],n=0;for(o=1;o<t.length;o++)("max"===e&&t[o]>=r||"min"===e&&t[o]<=r)&&(r=t[o],n=o);return n}var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.getValues=function(t,e){var o,r,n,i,s,a=e.period,u=t.xData,c=t.yData,h=c?c.length:0,y=[],f=[],d=[];for(i=a-1;i<h;i++)n=l((s=c.slice(i-a+1,i+2)).map(function(t){return p(t[2],t)}),"min"),o=l(s.map(function(t){return p(t[1],t)}),"max")/a*100,r=n/a*100,u[i+1]&&(y.push([u[i+1],o,r]),f.push(u[i+1]),d.push([o,r]));return{values:y,xData:f,yData:d}},e.defaultOptions=a(i.defaultOptions,{params:{index:void 0,period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}}),e}(i);return s(u.prototype,{areaLinesNames:[],linesApiNames:["aroonDown"],nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y"}),t.compose(u),e.registerSeriesType("aroon",u),u}),o(e,"Stock/Indicators/AroonOscillator/AroonOscillatorIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.aroon,s=o.extend,a=o.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.getValues=function(e,o){var r,n,i=[],s=[],a=[],p=t.prototype.getValues.call(this,e,o);for(n=0;n<p.yData.length;n++)r=p.yData[n][0]-p.yData[n][1],i.push([p.xData[n],r]),s.push(p.xData[n]),a.push(r);return{values:i,xData:s,yData:a}},e.defaultOptions=a(i.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b>: {point.y}'}}),e}(i);return s(p.prototype,{nameBase:"Aroon Oscillator",linesApiNames:[],pointArrayMap:["y"],pointValKey:"y"}),t.compose(i),e.registerSeriesType("aroonoscillator",p),p}),o(e,"Stock/Indicators/ATR/ATRIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.isArray,s=e.merge;function a(t,e){return Math.max(t[1]-t[2],void 0===e?0:Math.abs(t[1]-e[3]),void 0===e?0:Math.abs(t[2]-e[3]))}var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n,s,p=e.period,l=t.xData,u=t.yData,c=u?u.length:0,h=[[l[0],u[0]]],y=[],f=[],d=[],g=0,m=1,v=0;if(!(l.length<=p)&&i(u[0])&&4===u[0].length){for(s=1;s<=c;s++)((function(t,e,o,r){var n=e[r],i=o[r];t.push([n,i])})(h,l,u,s),p<m)?(o=s,r=g,g=(n=[l[o-1],(r*(p-1)+a(u[o-1],u[o-2]))/p])[1],y.push(n),f.push(n[0]),d.push(n[1])):(p===m?(g=v/(s-1),y.push([l[s-1],g]),f.push(l[s-1]),d.push(g)):v+=a(u[s-1],u[s-2]),m++);return{values:y,xData:f,yData:d}}},e.defaultOptions=s(n.defaultOptions,{params:{index:void 0}}),e}(n);return t.registerSeriesType("atr",p),p}),o(e,"Stock/Indicators/BB/BBIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.sma,s=o.extend,a=o.isArray,p=o.merge,l=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return n(o,t),o.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments),this.options=p({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},o.prototype.getValues=function(t,o){var r,n,i,s,p,l,u,c,h,y=o.period,f=o.standardDeviation,d=[],g=[],m=t.xData,v=t.yData,x=v?v.length:0,_=[];if(!(m.length<y)){var S=a(v[0]);for(h=y;h<=x;h++)p=m.slice(h-y,h),l=v.slice(h-y,h),s=(c=e.seriesTypes.sma.prototype.getValues.call(this,{xData:p,yData:l},o)).xData[0],r=c.yData[0],u=function(t,e,o,r){for(var n,i=t.length,s=0,a=0;s<i;s++)a+=(n=(o?t[s][e]:t[s])-r)*n;return Math.sqrt(a/=i-1)}(l,o.index,S,r),n=r+f*u,i=r-f*u,_.push([s,n,r,i]),d.push(s),g.push([n,r,i]);return{values:_,xData:d,yData:g}}},o.defaultOptions=p(i.defaultOptions,{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"}}),o}(i);return s(l.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameComponents:["period","standardDeviation"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"}),t.compose(l),e.registerSeriesType("bb",l),l}),o(e,"Stock/Indicators/CCI/CCIIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.isArray,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n,s,a,p,l,u=e.period,c=t.xData,h=t.yData,y=h?h.length:0,f=[],d=[],g=[],m=[],v=[],x=1;if(!(c.length<=u)&&i(h[0])&&4===h[0].length){for(;x<u;)r=h[x-1],f.push((r[1]+r[2]+r[3])/3),x++;for(l=u;l<=y;l++)a=((r=h[l-1])[1]+r[2]+r[3])/3,n=f.push(a),s=(v=f.slice(n-u)).reduce(function(t,e){return t+e},0)/u,p=function(t,e){var o,r=t.length,n=0;for(o=0;o<r;o++)n+=Math.abs(e-t[o]);return n}(v,s)/u,o=(a-s)/(.015*p),d.push([c[l-1],o]),g.push(c[l-1]),m.push(o);return{values:d,xData:g,yData:m}}},e.defaultOptions=s(n.defaultOptions,{params:{index:void 0}}),e}(n);return t.registerSeriesType("cci",a),a}),o(e,"Stock/Indicators/CMF/CMFIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.merge,s=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.nameBase="Chaikin Money Flow",e}return r(e,t),e.prototype.isValid=function(){var t=this.chart,e=this.options,o=this.linkedParent,r=this.volumeSeries||(this.volumeSeries=t.get(e.params.volumeSeriesID)),n=o&&o.yData&&4===o.yData[0].length;function i(t){return t.xData&&t.xData.length>=e.params.period}return!!(o&&r&&i(o)&&i(r)&&n)},e.prototype.getValues=function(t,e){if(this.isValid())return this.getMoneyFlow(t.xData,t.yData,this.volumeSeries.yData,e.period)},e.prototype.getMoneyFlow=function(t,e,o,r){var n,i,s=e.length,a=[],p=[],l=[],u=[],c=-1,h=0,y=0;function f(t,e){var o=t[1],r=t[2],i=t[3];return null!==e&&null!==o&&null!==r&&null!==i&&o!==r?(i-r-(o-i))/(o-r)*e:(c=n,null)}if(r>0&&r<=s){for(n=0;n<r;n++)a[n]=f(e[n],o[n]),h+=o[n],y+=a[n];for(p.push(t[n-1]),l.push(n-c>=r&&0!==h?y/h:null),u.push([p[0],l[0]]);n<s;n++)a[n]=f(e[n],o[n]),h-=o[n-r],h+=o[n],y-=a[n-r],y+=a[n],i=[t[n],n-c>=r?y/h:null],p.push(i[0]),l.push(i[1]),u.push([i[0],i[1]])}return{values:u,xData:p,yData:l}},e.defaultOptions=i(n.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}}),e}(n);return t.registerSeriesType("cmf",s),s}),o(e,"Stock/Indicators/DMI/DMIIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.sma,s=o.correctFloat,a=o.extend,p=o.isArray,l=o.merge,u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.calculateDM=function(t,e,o){var r=t[e][1],n=t[e][2],i=t[e-1][1],a=t[e-1][2];return s(r-i>a-n?o?Math.max(r-i,0):0:o?0:Math.max(a-n,0))},e.prototype.calculateDI=function(t,e){return t/e*100},e.prototype.calculateDX=function(t,e){return s(Math.abs(t-e)/Math.abs(t+e)*100)},e.prototype.smoothValues=function(t,e,o){return s(t-t/o+e)},e.prototype.getTR=function(t,e){return s(Math.max(t[1]-t[2],e?Math.abs(t[1]-e[3]):0,e?Math.abs(t[2]-e[3]):0))},e.prototype.getValues=function(t,e){var o=e.period,r=t.xData,n=t.yData,i=n?n.length:0,s=[],a=[],l=[];if(!(r.length<=o)&&p(n[0])&&4===n[0].length){var u,c=0,h=0,y=0;for(u=1;u<i;u++){var f=void 0,d=void 0,g=void 0,m=void 0,v=void 0,x=void 0,_=void 0,S=void 0,D=void 0;u<=o?(m=this.calculateDM(n,u,!0),v=this.calculateDM(n,u),x=this.getTR(n[u],n[u-1]),c+=m,h+=v,y+=x,u===o&&(_=this.calculateDI(c,y),S=this.calculateDI(h,y),D=this.calculateDX(c,h),s.push([r[u],D,_,S]),a.push(r[u]),l.push([D,_,S]))):(m=this.calculateDM(n,u,!0),v=this.calculateDM(n,u),x=this.getTR(n[u],n[u-1]),f=this.smoothValues(c,m,o),d=this.smoothValues(h,v,o),g=this.smoothValues(y,x,o),c=f,h=d,y=g,_=this.calculateDI(c,y),S=this.calculateDI(h,y),D=this.calculateDX(c,h),s.push([r[u],D,_,S]),a.push(r[u]),l.push([D,_,S]))}return{values:s,xData:a,yData:l}}},e.defaultOptions=l(i.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">●</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},plusDILine:{styles:{lineWidth:1,lineColor:"#06b535"}},minusDILine:{styles:{lineWidth:1,lineColor:"#f21313"}},dataGrouping:{approximation:"averages"}}),e}(i);return a(u.prototype,{areaLinesNames:[],nameBase:"DMI",linesApiNames:["plusDILine","minusDILine"],pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y"}),t.compose(u),e.registerSeriesType("dmi",u),u}),o(e,"Stock/Indicators/DPO/DPOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.extend,s=e.merge,a=e.correctFloat,p=e.pick;function l(t,e,o,r,n){var i=p(e[o][r],e[o]);return n?a(t-i):a(t+i)}var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n,i,s,a=e.period,u=e.index,c=a+Math.floor(a/2+1),h=t.xData||[],y=t.yData||[],f=y.length,d=[],g=[],m=[],v=0;if(!(h.length<=c)){for(i=0;i<a-1;i++)v=l(v,y,i,u);for(s=0;s<=f-c;s++)r=s+a-1,n=s+c-1,v=l(v,y,r,u),o=p(y[n][u],y[n])-v/a,v=l(v,y,s,u,!0),d.push([h[n],o]),g.push(h[n]),m.push(o);return{values:d,xData:g,yData:m}}},e.defaultOptions=s(n.defaultOptions,{params:{index:0,period:21}}),e}(n);return i(u.prototype,{nameBase:"DPO"}),t.registerSeriesType("dpo",u),u}),o(e,"Stock/Indicators/Chaikin/ChaikinIndicator.js",[e["Stock/Indicators/AD/ADIndicator.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.ema,s=o.correctFloat,a=o.extend,p=o.merge,l=o.error,u=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return n(o,e),o.prototype.getValues=function(o,r){var n,i,a=r.periods,p=r.period,u=[],c=[],h=[];if(2!==a.length||a[1]<=a[0]){l('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');return}var y=t.prototype.getValues.call(this,o,{volumeSeriesID:r.volumeSeriesID,period:p});if(y){var f=e.prototype.getValues.call(this,y,{period:a[0]}),d=e.prototype.getValues.call(this,y,{period:a[1]});if(f&&d){var g=a[1]-a[0];for(i=0;i<d.yData.length;i++)n=s(f.yData[i+g]-d.yData[i]),u.push([d.xData[i],n]),c.push(d.xData[i]),h.push(n);return{values:u,xData:c,yData:h}}}},o.defaultOptions=p(i.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",period:9,periods:[3,10]}}),o}(i);return a(u.prototype,{nameBase:"Chaikin Osc",nameComponents:["periods"]}),e.registerSeriesType("chaikin",u),u}),o(e,"Stock/Indicators/CMO/CMOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.isNumber,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n=e.period,s=t.xData,a=t.yData,p=a?a.length:0,l=[],u=[],c=[],h=e.index;if(!(s.length<n)){i(a[0])?r=a:(h=Math.min(h,a[0].length-1),r=a.map(function(t){return t[h]}));for(var y,f=0,d=0,g=0,m=n;m>0;m--)r[m]>r[m-1]?d+=r[m]-r[m-1]:r[m]<r[m-1]&&(g+=r[m-1]-r[m]);for(y=d+g>0?100*(d-g)/(d+g):0,u.push(s[n]),c.push(y),l.push([s[n],y]),o=n+1;o<p;o++)f=Math.abs(r[o-n-1]-r[o-n]),r[o]>r[o-1]?d+=r[o]-r[o-1]:r[o]<r[o-1]&&(g+=r[o-1]-r[o]),r[o-n]>r[o-n-1]?d-=f:g-=f,y=d+g>0?100*(d-g)/(d+g):0,u.push(s[o]),c.push(y),l.push([s[o],y]);return{values:l,xData:u,yData:c}}},e.defaultOptions=s(n.defaultOptions,{params:{period:20,index:3}}),e}(n);return t.registerSeriesType("cmo",a),a}),o(e,"Stock/Indicators/DEMA/DEMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.ema,i=e.correctFloat,s=e.isArray,a=e.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getEMA=function(e,o,r,n,i,s){return t.prototype.calculateEma.call(this,s||[],e,void 0===i?1:i,this.EMApercent,o,void 0===n?-1:n,r)},e.prototype.getValues=function(e,o){var r,n,a,p,l,u=o.period,c=[],h=2*u,y=e.xData,f=e.yData,d=f?f.length:0,g=[],m=[],v=[],x=0,_=0,S=-1,D=0;if(this.EMApercent=2/(u+1),!(d<2*u-1)){for(s(f[0])&&(S=o.index?o.index:0),D=(x=t.prototype.accumulatePeriodPoints.call(this,u,S,f))/u,x=0,p=u;p<d+2;p++)p<d+1&&(_=this.getEMA(f,n,D,S,p)[1],c.push(_)),n=_,p<h?x+=_:(p===h&&(D=x/u),_=c[p-u-1],r=this.getEMA([_],a,D)[1],l=[y[p-2],i(2*_-r)],g.push(l),m.push(l[0]),v.push(l[1]),a=r);return{values:g,xData:m,yData:v}}},e.defaultOptions=a(n.defaultOptions),e}(n);return t.registerSeriesType("dema",p),p}),o(e,"Stock/Indicators/TEMA/TEMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.ema,i=e.correctFloat,s=e.isArray,a=e.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getEMA=function(e,o,r,n,i,s){return t.prototype.calculateEma.call(this,s||[],e,void 0===i?1:i,this.EMApercent,o,void 0===n?-1:n,r)},e.prototype.getTemaPoint=function(t,e,o,r){return[t[r-3],i(3*o.level1-3*o.level2+o.level3)]},e.prototype.getValues=function(e,o){var r,n,i,a,p=o.period,l=2*p,u=3*p,c=e.xData,h=e.yData,y=h?h.length:0,f=[],d=[],g=[],m=[],v=[],x={},_=-1,S=0,D=0;if(this.EMApercent=2/(p+1),!(y<3*p-2)){for(s(h[0])&&(_=o.index?o.index:0),D=(S=t.prototype.accumulatePeriodPoints.call(this,p,_,h))/p,S=0,i=p;i<y+3;i++)i<y+1&&(x.level1=this.getEMA(h,r,D,_,i)[1],m.push(x.level1)),r=x.level1,i<l?S+=x.level1:(i===l&&(D=S/p,S=0),x.level1=m[i-p-1],x.level2=this.getEMA([x.level1],n,D)[1],v.push(x.level2),n=x.level2,i<u?S+=x.level2:(i===u&&(D=S/p),i===y+1&&(x.level1=m[i-p-1],x.level2=this.getEMA([x.level1],n,D)[1],v.push(x.level2)),x.level1=m[i-p-2],x.level2=v[i-2*p-1],x.level3=this.getEMA([x.level2],x.prevLevel3,D)[1],(a=this.getTemaPoint(c,u,x,i))&&(f.push(a),d.push(a[0]),g.push(a[1])),x.prevLevel3=x.level3));return{values:f,xData:d,yData:g}}},e.defaultOptions=a(n.defaultOptions),e}(n);return t.registerSeriesType("tema",p),p}),o(e,"Stock/Indicators/TRIX/TRIXIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.tema,i=e.correctFloat,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getTemaPoint=function(t,e,o,r){if(r>e)return[t[r-3],0!==o.prevLevel3?i(o.level3-o.prevLevel3)/o.prevLevel3*100:null]},e.defaultOptions=s(n.defaultOptions),e}(n);return t.registerSeriesType("trix",a),a}),o(e,"Stock/Indicators/APO/APOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.ema,i=e.extend,s=e.merge,a=e.error,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(e,o){var r,n,i=o.periods,s=o.index,p=[],l=[],u=[];if(2!==i.length||i[1]<=i[0]){a('Error: "APO requires two periods. Notice, first period should be lower than the second one."');return}var c=t.prototype.getValues.call(this,e,{index:s,period:i[0]}),h=t.prototype.getValues.call(this,e,{index:s,period:i[1]});if(c&&h){var y=i[1]-i[0];for(n=0;n<h.yData.length;n++)r=c.yData[n+y]-h.yData[n],p.push([h.xData[n],r]),l.push(h.xData[n]),u.push(r);return{values:p,xData:l,yData:u}}},e.defaultOptions=s(n.defaultOptions,{params:{period:void 0,periods:[10,20]}}),e}(n);return i(p.prototype,{nameBase:"APO",nameComponents:["periods"]}),t.registerSeriesType("apo",p),p}),o(e,"Stock/Indicators/IKH/IKHIndicator.js",[e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Core/Color/Color.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,r){var n,i=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),s=e.parse,a=o.seriesTypes.sma,p=r.defined,l=r.extend,u=r.isArray,c=r.isNumber,h=r.getClosestDistance,y=r.merge,f=r.objectEach;function d(t){return{high:t.reduce(function(t,e){return Math.max(t,e[1])},-1/0),low:t.reduce(function(t,e){return Math.min(t,e[2])},1/0)}}function g(t){var e=t.indicator;e.points=t.points,e.nextPoints=t.nextPoints,e.color=t.color,e.options=y(t.options.senkouSpan.styles,t.gap),e.graph=t.graph,e.fillGraph=!0,o.seriesTypes.sma.prototype.drawGraph.call(e)}var m=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.data=[],e.options={},e.points=[],e.graphCollection=[],e}return i(e,t),e.prototype.init=function(){t.prototype.init.apply(this,arguments),this.options=y({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:s(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:s(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:s(this.color).setOpacity(.2).get()}}},this.options)},e.prototype.toYData=function(t){return[t.tenkanSen,t.kijunSen,t.chikouSpan,t.senkouSpanA,t.senkouSpanB]},e.prototype.translate=function(){o.seriesTypes.sma.prototype.translate.apply(this);for(var t=0,e=this.points;t<e.length;t++)for(var r=e[t],n=0,i=this.pointArrayMap;n<i.length;n++){var s=i[n],a=r[s];c(a)&&(r["plot"+s]=this.yAxis.toPixels(a,!0),r.plotY=r["plot"+s],r.tooltipPos=[r.plotX,r["plot"+s]],r.isNull=!1)}},e.prototype.drawGraph=function(){var t,e,r,n,i,s,a,l,u,c,h,d,m,v=this,x=v.points,_=v.options,S=v.graph,D=v.color,O={options:{gapSize:_.gapSize}},C=v.pointArrayMap.length,b=[[],[],[],[],[],[]],j={tenkanLine:b[0],kijunLine:b[1],chikouLine:b[2],senkouSpanA:b[3],senkouSpanB:b[4],senkouSpan:b[5]},A=[],P=v.options.senkouSpan,T=P.color||P.styles.fill,w=P.negativeColor,I=[[],[]],k=[[],[]],M=x.length,L=0;for(v.ikhMap=j;M--;){for(r=0,e=x[M];r<C;r++)p(e[t=v.pointArrayMap[r]])&&b[r].push({plotX:e.plotX,plotY:e["plot"+t],isNull:!1});if(w&&M!==x.length-1){var E=j.senkouSpanB.length-1,V=function(t,e,o,r){if(t&&e&&o&&r){var n=e.plotX-t.plotX,i=e.plotY-t.plotY,s=r.plotX-o.plotX,a=r.plotY-o.plotY,p=t.plotX-o.plotX,l=t.plotY-o.plotY,u=(-i*p+n*l)/(-s*i+n*a),c=(s*l-a*p)/(-s*i+n*a);if(u>=0&&u<=1&&c>=0&&c<=1)return{plotX:t.plotX+c*n,plotY:t.plotY+c*i}}}(j.senkouSpanA[E-1],j.senkouSpanA[E],j.senkouSpanB[E-1],j.senkouSpanB[E]);if(V){var R={plotX:V.plotX,plotY:V.plotY,isNull:!1,intersectPoint:!0};j.senkouSpanA.splice(E,0,R),j.senkouSpanB.splice(E,0,R),A.push(E)}}}if(f(j,function(t,e){_[e]&&"senkouSpan"!==e&&(v.points=b[L],v.options=y(_[e].styles,O),v.graph=v["graph"+e],v.fillGraph=!1,v.color=D,o.seriesTypes.sma.prototype.drawGraph.call(v),v["graph"+e]=v.graph),L++}),v.graphCollection)for(var B=0,N=v.graphCollection;B<N.length;B++){var U=N[B];v[U].destroy(),delete v[U]}if(v.graphCollection=[],w&&j.senkouSpanA[0]&&j.senkouSpanB[0]){for(A.unshift(0),A.push(j.senkouSpanA.length-1),d=0;d<A.length-1;d++)if(n=A[d],i=A[d+1],s=j.senkouSpanB.slice(n,i+1),a=j.senkouSpanA.slice(n,i+1),Math.floor(s.length/2)>=1){var G=Math.floor(s.length/2);if(s[G].plotY===a[G].plotY){for(m=0,l=0,u=0;m<s.length;m++)l+=s[m].plotY,u+=a[m].plotY;I[h=l>u?0:1]=I[h].concat(s),k[h]=k[h].concat(a)}else I[h=s[G].plotY>a[G].plotY?0:1]=I[h].concat(s),k[h]=k[h].concat(a)}else I[h=s[0].plotY>a[0].plotY?0:1]=I[h].concat(s),k[h]=k[h].concat(a);["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(t,e){I[e].length&&k[e].length&&(c=0===e?T:w,g({indicator:v,points:I[e],nextPoints:k[e],color:c,options:_,gap:O,graph:v[t]}),v[t]=v.graph,v.graphCollection.push(t))})}else g({indicator:v,points:j.senkouSpanB,nextPoints:j.senkouSpanA,color:T,options:_,gap:O,graph:v.graphsenkouSpan}),v.graphsenkouSpan=v.graph;delete v.nextPoints,delete v.fillGraph,v.points=x,v.options=_,v.graph=S,v.color=D},e.prototype.getGraphPath=function(t){var e,r=[],n=[];if(t=t||this.points,this.fillGraph&&this.nextPoints){if((e=o.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&e.length){e[0][0]="L",r=o.seriesTypes.sma.prototype.getGraphPath.call(this,t),n=e.slice(0,r.length);for(var i=n.length-1;i>=0;i--)r.push(n[i])}}else r=o.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return r},e.prototype.getValues=function(t,e){var o,r,n,i,s,a,p,l,c,y,f=e.period,g=e.periodTenkan,m=e.periodSenkouSpanB,v=t.xData,x=t.yData,_=t.xAxis,S=x&&x.length||0,D=h(_.series.map(function(t){return t.xData||[]})),O=[],C=[];if(!(v.length<=f)&&u(x[0])&&4===x[0].length){var b=v[0]-f*D;for(s=0;s<f;s++)C.push(b+s*D);for(s=0;s<S;s++)s>=g&&(a=((r=d(x.slice(s-g,s))).high+r.low)/2),s>=f&&(c=(a+(p=((n=d(x.slice(s-f,s))).high+n.low)/2))/2),s>=m&&(y=((i=d(x.slice(s-m,s))).high+i.low)/2),l=x[s][3],o=v[s],void 0===O[s]&&(O[s]=[]),void 0===O[s+f-1]&&(O[s+f-1]=[]),O[s+f-1][0]=a,O[s+f-1][1]=p,O[s+f-1][2]=void 0,void 0===O[s+1]&&(O[s+1]=[]),O[s+1][2]=l,s<=f&&(O[s+f-1][3]=void 0,O[s+f-1][4]=void 0),void 0===O[s+2*f-2]&&(O[s+2*f-2]=[]),O[s+2*f-2][3]=c,O[s+2*f-2][4]=y,C.push(o);for(s=1;s<=f;s++)C.push(o+s*D);return{values:O,xData:C,yData:O}}},e.defaultOptions=y(a.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}}),e}(a);return l(m.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period","periodTenkan"]}),t["ichimoku-averages"]=function(){var e,o=[];return[].forEach.call(arguments,function(r,n){o.push(t.average(r)),e=!e&&void 0===o[n]}),e?void 0:o},o.registerSeriesType("ikh",m),m}),o(e,"Stock/Indicators/KeltnerChannels/KeltnerChannelsIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.sma,s=o.correctFloat,a=o.extend,p=o.merge,l=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return n(o,t),o.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments),this.options=p({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},o.prototype.getValues=function(t,o){var r,n,i,a,p,l,u,c=o.period,h=o.periodATR,y=o.multiplierATR,f=o.index,d=t.yData,g=d?d.length:0,m=[],v=e.seriesTypes.ema.prototype.getValues(t,{period:c,index:f}),x=e.seriesTypes.atr.prototype.getValues(t,{period:h}),_=[],S=[];if(!(g<c)){for(u=c;u<=g;u++)p=v.values[u-c],l=x.values[u-h],a=p[0],n=s(p[1]+y*l[1]),i=s(p[1]-y*l[1]),r=p[1],m.push([a,n,r,i]),_.push(a),S.push([n,r,i]);return{values:m,xData:_,yData:S}}},o.defaultOptions=p(i.defaultOptions,{params:{index:0,period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1}),o}(i);return a(l.prototype,{nameBase:"Keltner Channels",areaLinesNames:["top","bottom"],nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"}),t.compose(l),e.registerSeriesType("keltnerchannels",l),l}),o(e,"Stock/Indicators/Klinger/KlingerIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes,s=i.ema,a=i.sma,p=o.correctFloat,l=o.error,u=o.extend,c=o.isArray,h=o.merge,y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.calculateTrend=function(t,e){return t[e][1]+t[e][2]+t[e][3]>t[e-1][1]+t[e-1][2]+t[e-1][3]?1:-1},e.prototype.isValidData=function(t){var e=this.chart,o=this.options,r=this.linkedParent,n=c(t)&&4===t.length,i=this.volumeSeries||(this.volumeSeries=e.get(o.params.volumeSeriesID));return i||l("Series "+o.params.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,r.chart),!!([r,i].every(function(t){return t&&t.xData&&t.xData.length>=o.params.slowAvgPeriod})&&n)},e.prototype.getCM=function(t,e,o,r,n){return p(e+(o===r?t:n))},e.prototype.getDM=function(t,e){return p(t-e)},e.prototype.getVolumeForce=function(t){for(var e,o,r=[],n=0,i=1,s=0,a=t[0][1]-t[0][2],p=0;i<t.length;i++)o=this.calculateTrend(t,i),e=this.getDM(t[i][1],t[i][2]),n=this.getCM(s,e,o,p,a),r.push([this.volumeSeries.yData[i]*o*Math.abs(2*(e/n-1))*100]),p=o,s=n,a=e;return r},e.prototype.getEMA=function(t,e,o,r,n,i,a){return s.prototype.calculateEma(a||[],t,void 0===i?1:i,r,e,void 0===n?-1:n,o)},e.prototype.getSMA=function(t,e,o){return s.prototype.accumulatePeriodPoints(t,e,o)/t},e.prototype.getValues=function(t,e){var o,r,n=[],i=t.xData,s=t.yData,a=[],l=[],u=[],c=0,h=0,y=void 0,f=void 0,d=null;if(this.isValidData(s[0])){for(var g=this.getVolumeForce(s),m=this.getSMA(e.fastAvgPeriod,0,g),v=this.getSMA(e.slowAvgPeriod,0,g),x=2/(e.fastAvgPeriod+1),_=2/(e.slowAvgPeriod+1);c<s.length;c++)c>=e.fastAvgPeriod&&(y=h=this.getEMA(g,y,m,x,0,c,i)[1]),c>=e.slowAvgPeriod&&(f=r=this.getEMA(g,f,v,_,0,c,i)[1],o=p(h-r),u.push(o),u.length>=e.signalPeriod&&(d=u.slice(-e.signalPeriod).reduce(function(t,e){return t+e})/e.signalPeriod),n.push([i[c],o,d]),a.push(i[c]),l.push([o,d]));return{values:n,xData:a,yData:l}}},e.defaultOptions=h(a.defaultOptions,{params:{fastAvgPeriod:34,slowAvgPeriod:55,signalPeriod:13,volumeSeriesID:"volume"},signalLine:{styles:{lineWidth:1,lineColor:"#ff0000"}},dataGrouping:{approximation:"averages"},tooltip:{pointFormat:'<span style="color: {point.color}">●</span><b> {series.name}</b><br/><span style="color: {point.color}">Klinger</span>: {point.y}<br/><span style="color: {point.series.options.signalLine.styles.lineColor}">Signal</span>: {point.signal}<br/>'}}),e}(a);return u(y.prototype,{areaLinesNames:[],linesApiNames:["signalLine"],nameBase:"Klinger",nameComponents:["fastAvgPeriod","slowAvgPeriod"],pointArrayMap:["y","signal"],parallelArrays:["x","y","signal"],pointValKey:"y"}),t.compose(y),e.registerSeriesType("klinger",y),y}),o(e,"Stock/Indicators/MACD/MACDIndicator.js",[e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=t.noop,s=e.seriesTypes,a=(s.column,s.sma),p=o.extend,l=o.correctFloat,u=o.defined,c=o.merge,h=function(o){function r(){return null!==o&&o.apply(this,arguments)||this}return n(r,o),r.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);var t=this.color;this.options&&(u(this.colorIndex)&&(this.options.signalLine&&this.options.signalLine.styles&&!this.options.signalLine.styles.lineColor&&(this.options.colorIndex=this.colorIndex+1,this.getCyclic("color",void 0,this.chart.options.colors),this.options.signalLine.styles.lineColor=this.color),this.options.macdLine&&this.options.macdLine.styles&&!this.options.macdLine.styles.lineColor&&(this.options.colorIndex=this.colorIndex+1,this.getCyclic("color",void 0,this.chart.options.colors),this.options.macdLine.styles.lineColor=this.color)),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length}),this.color=t},r.prototype.toYData=function(t){return[t.y,t.signal,t.MACD]},r.prototype.translate=function(){var e=this,o=["plotSignal","plotMACD"];t.seriesTypes.column.prototype.translate.apply(e),e.points.forEach(function(t){[t.signal,t.MACD].forEach(function(r,n){null!==r&&(t[o[n]]=e.yAxis.toPixels(r,!0))})})},r.prototype.destroy=function(){this.graph=null,this.graphmacd=this.graphmacd&&this.graphmacd.destroy(),this.graphsignal=this.graphsignal&&this.graphsignal.destroy(),e.seriesTypes.sma.prototype.destroy.apply(this,arguments)},r.prototype.drawGraph=function(){for(var t,o=this,r=o.points,n=o.options,i=o.zones,s={options:{gapSize:n.gapSize}},a=[[],[]],p=r.length;p--;)u((t=r[p]).plotMACD)&&a[0].push({plotX:t.plotX,plotY:t.plotMACD,isNull:!u(t.plotMACD)}),u(t.plotSignal)&&a[1].push({plotX:t.plotX,plotY:t.plotSignal,isNull:!u(t.plotMACD)});["macd","signal"].forEach(function(t,r){var i;o.points=a[r],o.options=c((null===(i=n["".concat(t,"Line")])||void 0===i?void 0:i.styles)||{},s),o.graph=o["graph".concat(t)],o.zones=(o["".concat(t,"Zones")].zones||[]).slice(o["".concat(t,"Zones")].startIndex||0),e.seriesTypes.sma.prototype.drawGraph.call(o),o["graph".concat(t)]=o.graph}),o.points=r,o.options=n,o.zones=i},r.prototype.applyZones=function(){var t=this.zones;this.zones=this.signalZones.zones,e.seriesTypes.sma.prototype.applyZones.call(this),this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide(),this.zones=t},r.prototype.getValues=function(t,o){var r,n,i,s=o.longPeriod-o.shortPeriod,a=[],p=[],c=[],h=0,y=[];if(!(t.xData.length<o.longPeriod+o.signalPeriod)){for(i=0,r=e.seriesTypes.ema.prototype.getValues(t,{period:o.shortPeriod,index:o.index}),n=e.seriesTypes.ema.prototype.getValues(t,{period:o.longPeriod,index:o.index}),r=r.values,n=n.values;i<=r.length;i++)u(n[i])&&u(n[i][1])&&u(r[i+s])&&u(r[i+s][0])&&a.push([r[i+s][0],0,null,r[i+s][1]-n[i][1]]);for(i=0;i<a.length;i++)p.push(a[i][0]),c.push([0,null,a[i][3]]);for(i=0,y=(y=e.seriesTypes.ema.prototype.getValues({xData:p,yData:c},{period:o.signalPeriod,index:2})).values;i<a.length;i++)a[i][0]>=y[0][0]&&(a[i][2]=y[h][1],c[i]=[0,y[h][1],a[i][3]],null===a[i][3]?(a[i][1]=0,c[i][0]=0):(a[i][1]=l(a[i][3]-y[h][1]),c[i][0]=l(a[i][3]-y[h][1])),h++);return{values:a,xData:p,yData:c}}},r.defaultOptions=c(a.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0}),r}(a);return p(h.prototype,{nameComponents:["longPeriod","shortPeriod","signalPeriod"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:i,getColumnMetrics:t.seriesTypes.column.prototype.getColumnMetrics,crispCol:t.seriesTypes.column.prototype.crispCol,drawPoints:t.seriesTypes.column.prototype.drawPoints}),e.registerSeriesType("macd",h),h}),o(e,"Stock/Indicators/MFI/MFIIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.extend,s=e.merge,a=e.error,p=e.isArray;function l(t){return t.reduce(function(t,e){return t+e})}function u(t){return(t[1]+t[2]+t[3])/3}var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n,i,s,c,h=e.period,y=t.xData,f=t.yData,d=f?f.length:0,g=e.decimals,m=t.chart.get(e.volumeSeriesID),v=m&&m.yData,x=[],_=[],S=[],D=[],O=[],C=!1,b=1;if(!m){a("Series "+e.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,t.chart);return}if(!(y.length<=h)&&p(f[0])&&4===f[0].length&&v){for(o=u(f[b]);b<h+1;)r=o,C=(o=u(f[b]))>=r,n=o*v[b],D.push(C?n:0),O.push(C?0:n),b++;for(c=b-1;c<d;c++)c>b-1&&(D.shift(),O.shift(),r=o,C=(o=u(f[c]))>r,n=o*v[c],D.push(C?n:0),O.push(C?0:n)),i=l(O),s=parseFloat((100-100/(1+l(D)/i)).toFixed(g)),x.push([y[c],s]),_.push(y[c]),S.push(s);return{values:x,xData:_,yData:S}}},e.defaultOptions=s(n.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",decimals:4}}),e}(n);return i(c.prototype,{nameBase:"Money Flow Index"}),t.registerSeriesType("mfi",c),c}),o(e,"Stock/Indicators/Momentum/MomentumIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.extend,s=e.isArray,a=e.merge;function p(t,e,o,r,n){var i=e[o-1][n]-e[o-r-1][n];return[t[o-1],i]}var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n=e.period,i=e.index,a=t.xData,l=t.yData,u=l?l.length:0,c=[],h=[],y=[];if(!(a.length<=n)&&s(l[0])){for(o=n+1;o<u;o++)r=p(a,l,o,n,i),c.push(r),h.push(r[0]),y.push(r[1]);return r=p(a,l,o,n,i),c.push(r),h.push(r[0]),y.push(r[1]),{values:c,xData:h,yData:y}}},e.defaultOptions=a(n.defaultOptions,{params:{index:3}}),e}(n);return i(l.prototype,{nameBase:"Momentum"}),t.registerSeriesType("momentum",l),l}),o(e,"Stock/Indicators/NATR/NATRIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.atr,i=e.merge,s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(e,o){var r=t.prototype.getValues.apply(this,arguments),n=r.values.length,i=e.yData,s=0,a=o.period-1;if(r){for(;s<n;s++)r.yData[s]=r.values[s][1]/i[a][3]*100,r.values[s][1]=r.yData[s],a++;return r}},e.defaultOptions=i(n.defaultOptions,{tooltip:{valueSuffix:"%"}}),e}(n);return t.registerSeriesType("natr",s),s}),o(e,"Stock/Indicators/OBV/OBVIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.isNumber,s=e.error,a=e.extend,p=e.merge,l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r=t.chart.get(e.volumeSeriesID),n=t.xData,a=t.yData,p=[],l=[],u=[],c=!i(a[0]),h=[],y=1,f=0,d=0,g=0,m=0;if(r)for(o=r.yData,h=[n[0],f],g=c?a[0][3]:a[0],p.push(h),l.push(n[0]),u.push(h[1]);y<a.length;y++)d=(m=c?a[y][3]:a[y])>g?f+o[y]:m===g?f:f-o[y],h=[n[y],d],f=d,g=m,p.push(h),l.push(n[y]),u.push(h[1]);else{s("Series "+e.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,t.chart);return}return{values:p,xData:l,yData:u}},e.defaultOptions=p(n.defaultOptions,{marker:{enabled:!1},params:{index:void 0,period:void 0,volumeSeriesID:"volume"},tooltip:{valueDecimals:0}}),e}(n);return a(l.prototype,{nameComponents:void 0}),t.registerSeriesType("obv",l),l}),o(e,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(t){var e,o=this&&this.__extends||(e=function(t,o){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,o)},function(t,o){if("function"!=typeof o&&null!==o)throw TypeError("Class extends value "+String(o)+" is not a constructor or null");function r(){this.constructor=t}e(t,o),t.prototype=null===o?Object.create(o):(r.prototype=o.prototype,new r)});function r(e,o){var r,n=e.series.pointArrayMap,i=n.length;for(t.seriesTypes.sma.prototype.pointClass.prototype[o].call(e);i--;)e[r="dataLabel"+n[i]]&&e[r].element&&e[r].destroy(),e[r]=null}return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o(e,t),e.prototype.destroyElements=function(){r(this,"destroyElements")},e.prototype.destroy=function(){r(this,"destroyElements")},e}(t.seriesTypes.sma.prototype.pointClass)}),o(e,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[e["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.sma,s=o.merge,a=o.extend,p=o.defined,l=o.isArray,u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.toYData=function(t){return[t.P]},e.prototype.translate=function(){var e=this;t.prototype.translate.apply(e),e.points.forEach(function(t){e.pointArrayMap.forEach(function(o){p(t[o])&&(t["plot"+o]=e.yAxis.toPixels(t[o],!0))})}),e.plotEndPoint=e.xAxis.toPixels(e.endPoint,!0)},e.prototype.getGraphPath=function(e){for(var o,r,n,i=this,s=[[],[],[],[],[],[],[],[],[]],a=i.pointArrayMap.length,l=i.plotEndPoint,u=[],c=e.length;c--;){for(n=0,r=e[c];n<a;n++)p(r[o=i.pointArrayMap[n]])&&s[n].push({plotX:r.plotX,plotY:r["plot"+o],isNull:!1},{plotX:l,plotY:r["plot"+o],isNull:!1},{plotX:l,plotY:null,isNull:!0});l=r.plotX}return s.forEach(function(e){u=u.concat(t.prototype.getGraphPath.call(i,e))}),u},e.prototype.drawDataLabels=function(){var e,o,r,n,i=this,s=i.pointArrayMap;i.options.dataLabels.enabled&&(o=i.points.length,s.concat([!1]).forEach(function(a,p){for(n=o;n--;)r=i.points[n],a?(r.y=r[a],r.pivotLine=a,r.plotY=r["plot"+a],e=r["dataLabel"+a],p&&(r["dataLabel"+s[p-1]]=r.dataLabel),r.dataLabels||(r.dataLabels=[]),r.dataLabels[0]=r.dataLabel=e=e&&e.element?e:null):r["dataLabel"+s[p-1]]=r.dataLabel;t.prototype.drawDataLabels.call(i)}))},e.prototype.getValues=function(t,e){var o,r,n,i,s,a,p,u=e.period,c=t.xData,h=t.yData,y=h?h.length:0,f=this[e.algorithm+"Placement"],d=[],g=[],m=[];if(!(c.length<u)&&l(h[0])&&4===h[0].length){for(p=u+1;p<=y+u;p+=u)n=c.slice(p-u-1,p),i=h.slice(p-u-1,p),r=n.length,o=n[r-1],a=f(this.getPivotAndHLC(i)),s=d.push([o].concat(a)),g.push(o),m.push(d[s-1].slice(1));return this.endPoint=n[0]+(o-n[0])/r*u,{values:d,xData:g,yData:m}}},e.prototype.getPivotAndHLC=function(t){var e=t[t.length-1][3],o=-1/0,r=1/0;return t.forEach(function(t){o=Math.max(o,t[1]),r=Math.min(r,t[2])}),[(o+r+e)/3,o,r,e]},e.prototype.standardPlacement=function(t){var e=t[1]-t[2];return[null,null,t[0]+e,2*t[0]-t[2],t[0],2*t[0]-t[1],t[0]-e,null,null]},e.prototype.camarillaPlacement=function(t){var e=t[1]-t[2];return[t[3]+1.5*e,t[3]+1.25*e,t[3]+1.1666*e,t[3]+1.0833*e,t[0],t[3]-1.0833*e,t[3]-1.1666*e,t[3]-1.25*e,t[3]-1.5*e]},e.prototype.fibonacciPlacement=function(t){var e=t[1]-t[2];return[null,t[0]+e,t[0]+.618*e,t[0]+.382*e,t[0],t[0]-.382*e,t[0]-.618*e,t[0]-e,null]},e.defaultOptions=s(i.defaultOptions,{params:{index:void 0,period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}}),e}(i);return a(u.prototype,{nameBase:"Pivot Points",pointArrayMap:["R4","R3","R2","R1","P","S1","S2","S3","S4"],pointValKey:"P",pointClass:t}),e.registerSeriesType("pivotpoints",u),u}),o(e,"Stock/Indicators/PPO/PPOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.ema,i=e.correctFloat,s=e.extend,a=e.merge,p=e.error,l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(e,o){var r,n,s=o.periods,a=o.index,l=[],u=[],c=[];if(2!==s.length||s[1]<=s[0]){p('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');return}var h=t.prototype.getValues.call(this,e,{index:a,period:s[0]}),y=t.prototype.getValues.call(this,e,{index:a,period:s[1]});if(h&&y){var f=s[1]-s[0];for(n=0;n<y.yData.length;n++)r=i((h.yData[n+f]-y.yData[n])/y.yData[n]*100),l.push([y.xData[n],r]),u.push(y.xData[n]),c.push(r);return{values:l,xData:u,yData:c}}},e.defaultOptions=a(n.defaultOptions,{params:{period:void 0,periods:[12,26]}}),e}(n);return s(l.prototype,{nameBase:"PPO",nameComponents:["periods"]}),t.registerSeriesType("ppo",l),l}),o(e,"Stock/Indicators/ArrayUtilities.js",[],function(){return{getArrayExtremes:function(t,e,o){return t.reduce(function(t,r){return[Math.min(t[0],r[e]),Math.max(t[1],r[o])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}}),o(e,"Stock/Indicators/PC/PCIndicator.js",[e["Stock/Indicators/ArrayUtilities.js"],e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Color/Palettes.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,r,n){var i,s=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),a=r.seriesTypes.sma,p=n.merge,l=n.extend,u=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return s(r,e),r.prototype.getValues=function(e,o){var r,n,i,s,a,p,l,u=o.period,c=e.xData,h=e.yData,y=h?h.length:0,f=[],d=[],g=[];if(!(y<u)){for(l=u;l<=y;l++)s=c[l-1],a=h.slice(l-u,l),r=((n=(p=t.getArrayExtremes(a,2,1))[1])+(i=p[0]))/2,f.push([s,n,r,i]),d.push(s),g.push([n,r,i]);return{values:f,xData:d,yData:g}}},r.defaultOptions=p(a.defaultOptions,{params:{index:void 0,period:20},lineWidth:1,topLine:{styles:{lineColor:o.colors[2],lineWidth:1}},bottomLine:{styles:{lineColor:o.colors[8],lineWidth:1}},dataGrouping:{approximation:"averages"}}),r}(a);return l(u.prototype,{areaLinesNames:["top","bottom"],nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"}),e.compose(u),r.registerSeriesType("pc",u),u}),o(e,"Stock/Indicators/PriceEnvelopes/PriceEnvelopesIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.sma,s=o.extend,a=o.isArray,p=o.merge,l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.init=function(){t.prototype.init.apply(this,arguments),this.options=p({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},e.prototype.getValues=function(e,o){var r,n,i,s,p,l,u,c,h=o.period,y=o.topBand,f=o.bottomBand,d=e.xData,g=e.yData,m=g?g.length:0,v=[],x=[],_=[];if(!(d.length<h)&&a(g[0])&&4===g[0].length){for(c=h;c<=m;c++)p=d.slice(c-h,c),l=g.slice(c-h,c),s=(u=t.prototype.getValues.call(this,{xData:p,yData:l},o)).xData[0],n=(r=u.yData[0])*(1+y),i=r*(1-f),v.push([s,n,r,i]),x.push(s),_.push([n,r,i]);return{values:v,xData:x,yData:_}}},e.defaultOptions=p(i.defaultOptions,{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}}),e}(i);return s(l.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle"}),t.compose(l),e.registerSeriesType("priceenvelopes",l),l}),o(e,"Stock/Indicators/PSAR/PSARIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.merge;function s(t,e){return parseFloat(t.toFixed(e))}var a=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.nameComponents=void 0,e}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n,i,a,p,l,u,c,h,y,f,d,g,m,v,x,_,S,D,O,C,b,j,A,P=t.xData,T=t.yData,w=e.maxAccelerationFactor,I=e.increment,k=e.initialAccelerationFactor,M=e.decimals,L=e.index,E=[],V=[],R=[],B=e.initialAccelerationFactor,N=T[0][1],U=1,G=T[0][2];if(!(L>=T.length)){for(A=0;A<L;A++)N=Math.max(T[A][1],N),G=Math.min(T[A][2],s(G,M));for(g=T[A][1]>G?1:-1,m=N-G,v=(B=e.initialAccelerationFactor)*m,E.push([P[L],G]),V.push(P[L]),R.push(s(G,M)),A=L+1;A<T.length;A++)_=T[A-1][2],S=T[A-2][2],D=T[A-1][1],O=T[A-2][1],b=T[A][1],j=T[A][2],null!==S&&null!==O&&null!==_&&null!==D&&null!==b&&null!==j&&(o=g,r=U,n=G,i=v,a=N,G=o===r?1===o?n+i<Math.min(S,_)?n+i:Math.min(S,_):n+i>Math.max(O,D)?n+i:Math.max(O,D):a,h=g,y=N,C=1===h?b>y?b:y:j<y?j:y,f=U,d=G,p=x=1===f&&j>d||-1===f&&b>d?1:-1,l=g,u=N,c=B,v=(B=p===l?1===p&&C>u||-1===p&&C<u?c===w?w:s(c+I,2):c:k)*(m=C-G),E.push([P[A],s(G,M)]),V.push(P[A]),R.push(s(G,M)),U=g,g=x,N=C);return{values:E,xData:V,yData:R}}},e.defaultOptions=i(n.defaultOptions,{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{period:void 0,initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}}),e}(n);return t.registerSeriesType("psar",a),a}),o(e,"Stock/Indicators/ROC/ROCIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.isArray,s=e.merge,a=e.extend,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n=e.period,s=t.xData,a=t.yData,p=a?a.length:0,l=[],u=[],c=[],h=-1;if(!(s.length<=n)){for(i(a[0])&&(h=e.index),o=n;o<p;o++)r=function(t,e,o,r,n){var i,s;return s=n<0?(i=e[o-r])?(e[o]-i)/i*100:null:(i=e[o-r][n])?(e[o][n]-i)/i*100:null,[t[o],s]}(s,a,o,n,h),l.push(r),u.push(r[0]),c.push(r[1]);return{values:l,xData:u,yData:c}}},e.defaultOptions=s(n.defaultOptions,{params:{index:3,period:9}}),e}(n);return a(p.prototype,{nameBase:"Rate of Change"}),t.registerSeriesType("roc",p),p}),o(e,"Stock/Indicators/RSI/RSIIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.isNumber,s=e.merge;function a(t,e){return parseFloat(t.toFixed(e))}var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n,s,p,l,u=e.period,c=t.xData,h=t.yData,y=h?h.length:0,f=e.decimals,d=[],g=[],m=[],v=0,x=0,_=e.index,S=1;if(!(c.length<u)){for(i(h[0])?l=h:(_=Math.min(_,h[0].length-1),l=h.map(function(t){return t[_]}));S<u;)(r=a(l[S]-l[S-1],f))>0?v+=r:x+=Math.abs(r),S++;for(n=a(v/(u-1),f),s=a(x/(u-1),f),p=S;p<y;p++)(r=a(l[p]-l[p-1],f))>0?(v=r,x=0):(v=0,x=Math.abs(r)),n=a((n*(u-1)+v)/u,f),o=0===(s=a((s*(u-1)+x)/u,f))?100:0===n?0:a(100-100/(1+n/s),f),d.push([c[p],o]),g.push(c[p]),m.push(o);return{values:d,xData:g,yData:m}}},e.defaultOptions=s(n.defaultOptions,{params:{decimals:4,index:3}}),e}(n);return t.registerSeriesType("rsi",p),p}),o(e,"Stock/Indicators/Stochastic/StochasticIndicator.js",[e["Stock/Indicators/ArrayUtilities.js"],e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,r){var n,i=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),s=o.seriesTypes.sma,a=r.extend,p=r.isArray,l=r.merge,u=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return i(o,e),o.prototype.init=function(){e.prototype.init.apply(this,arguments),this.options=l({smoothedLine:{styles:{lineColor:this.color}}},this.options)},o.prototype.getValues=function(o,r){var n,i,s,a,l,u=r.periods[0],c=r.periods[1],h=o.xData,y=o.yData,f=y?y.length:0,d=[],g=[],m=[],v=null;if(!(f<u)&&p(y[0])&&4===y[0].length){var x=!0,_=0;for(l=u-1;l<f;l++){if(n=y.slice(l-u+1,l+1),i=(a=t.getArrayExtremes(n,2,1))[0],isNaN(s=(y[l][3]-i)/(a[1]-i)*100)&&x){_++;continue}x&&!isNaN(s)&&(x=!1);var S=g.push(h[l]);isNaN(s)?m.push([m[S-2]&&"number"==typeof m[S-2][0]?m[S-2][0]:null,null]):m.push([s,null]),l>=_+(u-1)+(c-1)&&(v=e.prototype.getValues.call(this,{xData:g.slice(-c),yData:m.slice(-c)},{period:c}).yData[0]),d.push([h[l],s,v]),m[S-1][1]=v}return{values:d,xData:g,yData:m}}},o.defaultOptions=l(s.defaultOptions,{params:{index:void 0,period:void 0,periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}}),o}(s);return a(u.prototype,{areaLinesNames:[],nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"]}),e.compose(u),o.registerSeriesType("stochastic",u),u}),o(e,"Stock/Indicators/SlowStochastic/SlowStochasticIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes,i=n.sma,s=n.stochastic,a=e.extend,p=e.merge,l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(e,o){var r=o.periods,n=t.prototype.getValues.call(this,e,o),s={values:[],xData:[],yData:[]};if(n){s.xData=n.xData.slice(r[1]-1);var a=n.yData.slice(r[1]-1),p=i.prototype.getValues.call(this,{xData:s.xData,yData:a},{index:1,period:r[2]});if(p){for(var l=0,u=s.xData.length;l<u;l++)s.yData[l]=[a[l][1],p.yData[l-r[2]+1]||null],s.values[l]=[s.xData[l],a[l][1],p.yData[l-r[2]+1]||null];return s}}},e.defaultOptions=p(s.defaultOptions,{params:{periods:[14,3,3]}}),e}(s);return a(l.prototype,{nameBase:"Slow Stochastic"}),t.registerSeriesType("slowstochastic",l),l}),o(e,"Stock/Indicators/Supertrend/SupertrendIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Core/Chart/StockChart.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=t.seriesTypes,s=i.atr,a=i.sma,p=e.addEvent,l=e.correctFloat,u=e.isArray,c=e.extend,h=e.merge,y=e.objectEach;function f(t,e,o){return{index:e,close:t.yData[e][o],x:t.xData[e]}}var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.init=function(){var e=this;t.prototype.init.apply(e,arguments);var r=p(o,"afterLinkSeries",function(){if(e.options){var t=e.options,o=e.linkedParent.options;t.cropThreshold=o.cropThreshold-(t.params.period-1)}r()},{order:1})},e.prototype.drawGraph=function(){for(var t,e,o,r,n,i,s,p,l,u=this,c=u.options,d=u.linkedParent,g=d?d.points:[],m=u.points,v=u.graph,x=g.length-m.length,_=x>0?x:0,S={options:{gapSize:c.gapSize}},D={top:[],bottom:[],intersect:[]},O={top:{styles:{lineWidth:c.lineWidth,lineColor:c.fallingTrendColor||c.color,dashStyle:c.dashStyle}},bottom:{styles:{lineWidth:c.lineWidth,lineColor:c.risingTrendColor||c.color,dashStyle:c.dashStyle}},intersect:c.changeTrendLine},C=m.length;C--;)t=m[C],e=m[C-1],o=g[C-1+_],r=g[C-2+_],n=g[C+_],i=g[C+_+1],s=t.options.color,p={x:t.x,plotX:t.plotX,plotY:t.plotY,isNull:!1},!r&&o&&d.yData[o.index-1]&&(r=f(d,o.index-1,3)),!i&&n&&d.yData[n.index+1]&&(i=f(d,n.index+1,3)),!o&&r&&d.yData[r.index+1]?o=f(d,r.index+1,3):!o&&n&&d.yData[n.index-1]&&(o=f(d,n.index-1,3)),t&&o&&n&&r&&t.x!==o.x&&(t.x===n.x?(r=o,o=n):t.x===r.x?(o=r,r={close:d.yData[o.index-1][3],x:d.xData[o.index-1]}):i&&t.x===i.x&&(o=i,r=n)),e&&r&&o?(l={x:e.x,plotX:e.plotX,plotY:e.plotY,isNull:!1},t.y>=o.close&&e.y>=r.close?(t.color=s||c.fallingTrendColor||c.color,D.top.push(p)):t.y<o.close&&e.y<r.close?(t.color=s||c.risingTrendColor||c.color,D.bottom.push(p)):(D.intersect.push(p),D.intersect.push(l),D.intersect.push(h(l,{isNull:!0})),t.y>=o.close&&e.y<r.close?(t.color=s||c.fallingTrendColor||c.color,e.color=s||c.risingTrendColor||c.color,D.top.push(p),D.top.push(h(l,{isNull:!0}))):t.y<o.close&&e.y>=r.close&&(t.color=s||c.risingTrendColor||c.color,e.color=s||c.fallingTrendColor||c.color,D.bottom.push(p),D.bottom.push(h(l,{isNull:!0}))))):o&&(t.y>=o.close?(t.color=s||c.fallingTrendColor||c.color,D.top.push(p)):(t.color=s||c.risingTrendColor||c.color,D.bottom.push(p)));y(D,function(t,e){u.points=t,u.options=h(O[e].styles,S),u.graph=u["graph"+e+"Line"],a.prototype.drawGraph.call(u),u["graph"+e+"Line"]=u.graph}),u.points=m,u.options=c,u.graph=v},e.prototype.getValues=function(t,e){var o,r,n,i,a,p,c,h,y,f=e.period,d=e.multiplier,g=t.xData,m=t.yData,v=[],x=[],_=[],S=0===f?0:f-1,D=[],O=[],C=[];if(!(g.length<=f)&&u(m[0])&&4===m[0].length&&!(f<0)){for(y=0,C=s.prototype.getValues.call(this,t,{period:f}).yData;y<C.length;y++)h=m[S+y],c=m[S+y-1]||[],i=D[y-1],a=O[y-1],p=_[y-1],0===y&&(i=a=p=0),o=l((h[1]+h[2])/2+d*C[y]),r=l((h[1]+h[2])/2-d*C[y]),o<i||c[3]>i?D[y]=o:D[y]=i,r>a||c[3]<a?O[y]=r:O[y]=a,p===i&&h[3]<D[y]||p===a&&h[3]<O[y]?n=D[y]:(p===i&&h[3]>D[y]||p===a&&h[3]>O[y])&&(n=O[y]),v.push([g[S+y],n]),x.push(g[S+y]),_.push(n);return{values:v,xData:x,yData:_}}},e.defaultOptions=h(a.defaultOptions,{params:{index:void 0,multiplier:3,period:10},risingTrendColor:"#06b535",fallingTrendColor:"#f21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}}),e}(a);return c(d.prototype,{nameBase:"Supertrend",nameComponents:["multiplier","period"]}),t.registerSeriesType("supertrend",d),d}),o(e,"Stock/Indicators/VBP/VBPPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(t){var e,o=this&&this.__extends||(e=function(t,o){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,o)},function(t,o){if("function"!=typeof o&&null!==o)throw TypeError("Class extends value "+String(o)+" is not a constructor or null");function r(){this.constructor=t}e(t,o),t.prototype=null===o?Object.create(o):(r.prototype=o.prototype,new r)});return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o(e,t),e.prototype.destroy=function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy()),t.prototype.destroy.apply(this,arguments)},e}(t.seriesTypes.sma.prototype.pointClass)}),o(e,"Stock/Indicators/VBP/VBPIndicator.js",[e["Stock/Indicators/VBP/VBPPoint.js"],e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Core/Chart/StockChart.js"]],function(t,e,o,r,n,i){var s,a=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),p=e.animObject,l=o.noop,u=r.seriesTypes,c=u.column.prototype,h=u.sma,y=n.addEvent,f=n.arrayMax,d=n.arrayMin,g=n.correctFloat,m=n.defined,v=n.error,x=n.extend,_=n.isArray,S=n.merge,D=Math.abs,O=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a(e,t),e.prototype.init=function(e,o){var r=this;delete o.data,t.prototype.init.apply(r,arguments);var n=y(i,"afterLinkSeries",function(){if(r.options){var t=r.options.params,o=r.linkedParent,i=e.get(t.volumeSeriesID);r.addCustomEvents(o,i)}n()},{order:1});return r},e.prototype.addCustomEvents=function(t,e){var o=this,r=function(){o.chart.redraw(),o.setData([]),o.zoneStarts=[],o.zoneLinesSVG&&(o.zoneLinesSVG=o.zoneLinesSVG.destroy())};return o.dataEventsToUnbind.push(y(t,"remove",function(){r()})),e&&o.dataEventsToUnbind.push(y(e,"remove",function(){r()})),o},e.prototype.animate=function(t){var e=this,o=e.chart.inverted,r=e.group,n={};if(!t&&r){var i=o?e.yAxis.top:e.xAxis.left;o?(r["forceAnimate:translateY"]=!0,n.translateY=i):(r["forceAnimate:translateX"]=!0,n.translateX=i),r.animate(n,x(p(e.options.animation),{step:function(t,o){e.group.attr({scaleX:Math.max(.001,o.pos)})}}))}},e.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),c.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1)),c.drawPoints.apply(this,arguments)},e.prototype.posNegVolume=function(t,e){var o,r,n,i,s=e?["positive","negative"]:["negative","positive"],a=this.options.volumeDivision,p=this.points.length,l=[],u=[],c=0;for(t?(this.posWidths=l,this.negWidths=u):(l=this.posWidths,u=this.negWidths);c<p;c++)(i=this.points[c])[s[0]+"Graphic"]=i.graphic,i.graphic=i[s[1]+"Graphic"],t&&(o=i.shapeArgs.width,(n=(r=this.priceZones[c]).wholeVolumeData)?(l.push(o/n*r.positiveVolumeData),u.push(o/n*r.negativeVolumeData)):(l.push(0),u.push(0))),i.color=e?a.styles.positiveColor:a.styles.negativeColor,i.shapeArgs.width=e?this.posWidths[c]:this.negWidths[c],i.shapeArgs.x=e?i.shapeArgs.x:this.posWidths[c]},e.prototype.translate=function(){var t,e,o,r,n,i,s,a,p,l,u=this,h=u.options,y=u.chart,d=u.yAxis,m=d.min,v=u.options.zoneLines,x=u.priceZones,_=0;c.translate.apply(u);var S=u.points;S.length&&(s=h.pointPadding<.5?h.pointPadding:.1,t=f(u.volumeDataArray),e=y.plotWidth/2,a=y.plotTop,o=D(d.toPixels(m)-d.toPixels(m+u.rangeStep)),n=D(d.toPixels(m)-d.toPixels(m+u.rangeStep)),s&&(r=D(o*(1-2*s)),_=D((o-r)/2),o=D(r)),S.forEach(function(r,s){p=r.barX=r.plotX=0,l=r.plotY=d.toPixels(x[s].start)-a-(d.reversed?o-n:o)-_,i=g(e*x[s].wholeVolumeData/t),r.pointWidth=i,r.shapeArgs=u.crispCol.apply(u,[p,l,i,o]),r.volumeNeg=x[s].negativeVolumeData,r.volumePos=x[s].positiveVolumeData,r.volumeAll=x[s].wholeVolumeData}),v.enabled&&u.drawZones(y,d,u.zoneStarts,v.styles))},e.prototype.getExtremes=function(){var e,o=this.options.compare,r=this.options.cumulative;return this.options.compare?(this.options.compare=void 0,e=t.prototype.getExtremes.call(this),this.options.compare=o):this.options.cumulative?(this.options.cumulative=!1,e=t.prototype.getExtremes.call(this),this.options.cumulative=r):e=t.prototype.getExtremes.call(this),e},e.prototype.getValues=function(t,e){var o=t.processedXData,r=t.processedYData,n=this.chart,i=e.ranges,s=[],a=[],p=[],l=n.get(e.volumeSeriesID);if(!t.chart){v("Base series not found! In case it has been removed, add a new one.",!0,n);return}if(!l||!l.processedXData.length){var u=l&&!l.processedXData.length?" does not contain any data.":" not found! Check `volumeSeriesID`.";v("Series "+e.volumeSeriesID+u,!0,n);return}var c=_(r[0]);if(c&&4!==r[0].length){v("Type of "+t.name+" series is different than line, OHLC or candlestick.",!0,n);return}return(this.priceZones=this.specifyZones(c,o,r,i,l)).forEach(function(t,e){s.push([t.x,t.end]),a.push(s[e][0]),p.push(s[e][1])}),{values:s,xData:a,yData:p}},e.prototype.specifyZones=function(t,e,o,r,n){var i=!!t&&function(t){for(var e,o=t.length,r=t[0][3],n=r,i=1;i<o;i++)(e=t[i][3])<r&&(r=e),e>n&&(n=e);return{min:r,max:n}}(o),s=this.zoneStarts=[],a=[],p=i?i.min:d(o),l=i?i.max:f(o),u=0,c=1,h=this.linkedParent;if(!this.options.compareToMain&&h.dataModify&&(p=h.dataModify.modifyValue(p),l=h.dataModify.modifyValue(l)),!m(p)||!m(l))return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];var y=this.rangeStep=g(l-p)/r;for(s.push(p);u<r-1;u++)s.push(g(s[u]+y));s.push(l);for(var v=s.length;c<v;c++)a.push({index:c-1,x:e[0],start:s[c-1],end:s[c]});return this.volumePerZone(t,a,n,e,o)},e.prototype.volumePerZone=function(t,e,o,r,n){var i,s,a,p,l,u=this,c=o.processedXData,h=o.processedYData,y=e.length-1,f=n.length,d=h.length;return D(f-d)&&(r[0]!==c[0]&&h.unshift(0),r[f-1]!==c[d-1]&&h.push(0)),u.volumeDataArray=[],e.forEach(function(e){for(l=0,e.wholeVolumeData=0,e.positiveVolumeData=0,e.negativeVolumeData=0;l<f;l++){s=!1,a=!1,p=t?n[l][3]:n[l],i=l?t?n[l-1][3]:n[l-1]:p;var o=u.linkedParent;!u.options.compareToMain&&o.dataModify&&(p=o.dataModify.modifyValue(p),i=o.dataModify.modifyValue(i)),p<=e.start&&0===e.index&&(s=!0),p>=e.end&&e.index===y&&(a=!0),(p>e.start||s)&&(p<e.end||a)&&(e.wholeVolumeData+=h[l],i>p?e.negativeVolumeData+=h[l]:e.positiveVolumeData+=h[l])}u.volumeDataArray.push(e.wholeVolumeData)}),e},e.prototype.drawZones=function(t,e,o,r){var n,i=t.renderer,s=t.plotWidth,a=t.plotTop,p=this.zoneLinesSVG,l=[];o.forEach(function(o){n=e.toPixels(o)-a,l=l.concat(t.renderer.crispLine([["M",0,n],["L",s,n]],r.lineWidth))}),p?p.animate({d:l}):p=this.zoneLinesSVG=i.path(l).attr({"stroke-width":r.lineWidth,stroke:r.color,dashstyle:r.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)},e.defaultOptions=S(h.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1e3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"0.5em"},verticalAlign:"top"}}),e}(h);return x(O.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],calculateOn:{chart:"render",xAxis:"afterSetExtremes"},pointClass:t,markerAttribs:l,drawGraph:l,getColumnMetrics:c.getColumnMetrics,crispCol:c.crispCol}),r.registerSeriesType("vbp",O),O}),o(e,"Stock/Indicators/VWAP/VWAPIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.error,s=e.isArray,a=e.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r=t.chart,n=t.xData,a=t.yData,p=e.period,l=!0;if(!(o=r.get(e.volumeSeriesID))){i("Series "+e.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,r);return}return s(a[0])||(l=!1),this.calculateVWAPValues(l,n,a,o,p)},e.prototype.calculateVWAPValues=function(t,e,o,r,n){var i,s,a,p,l,u,c=r.yData,h=r.xData.length,y=e.length,f=[],d=[],g=[],m=[],v=[];for(l=0,i=y<=h?y:h,u=0;l<i;l++)s=(t?(o[l][1]+o[l][2]+o[l][3])/3:o[l])*c[l],a=u?f[l-1]+s:s,p=u?d[l-1]+c[l]:c[l],f.push(a),d.push(p),v.push([e[l],a/p]),g.push(v[l][0]),m.push(v[l][1]),++u===n&&(u=0);return{values:v,xData:g,yData:m}},e.defaultOptions=a(n.defaultOptions,{params:{index:void 0,period:30,volumeSeriesID:"volume"}}),e}(n);return t.registerSeriesType("vwap",p),p}),o(e,"Stock/Indicators/WilliamsR/WilliamsRIndicator.js",[e["Stock/Indicators/ArrayUtilities.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.sma,s=o.extend,a=o.isArray,p=o.merge,l=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return n(o,e),o.prototype.getValues=function(e,o){var r,n,i,s,p,l,u=o.period,c=e.xData,h=e.yData,y=h?h.length:0,f=[],d=[],g=[];if(!(c.length<u)&&a(h[0])&&4===h[0].length){for(l=u-1;l<y;l++)r=h.slice(l-u+1,l+1),p=(n=t.getArrayExtremes(r,2,1))[0],i=-(((s=n[1])-h[l][3])/(s-p)*100),c[l]&&(f.push([c[l],i]),d.push(c[l]),g.push(i));return{values:f,xData:d,yData:g}}},o.defaultOptions=p(i.defaultOptions,{params:{index:void 0,period:14}}),o}(i);return s(l.prototype,{nameBase:"Williams %R"}),e.registerSeriesType("williamsr",l),l}),o(e,"Stock/Indicators/WMA/WMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.isArray,s=e.merge;function a(t,e,o,r,n){var i=e[r],s=n<0?o[r]:o[r][n];t.push([i,s])}function p(t,e,o,r){var n=t.length,i=t.reduce(function(t,e,o){return[null,t[1]+e[1]*(o+1)]})[1]/((n+1)/2*n),s=e[r-1];return t.shift(),[s,i]}var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n=e.period,s=t.xData,l=t.yData,u=l?l.length:0,c=s[0],h=[],y=[],f=[],d=1,g=-1,m=l[0];if(!(s.length<n)){i(l[0])&&(g=e.index,m=l[0][g]);for(var v=[[c,m]];d!==n;)a(v,s,l,d,g),d++;for(o=d;o<u;o++)r=p(v,s,l,o),h.push(r),y.push(r[0]),f.push(r[1]),a(v,s,l,o,g);return r=p(v,s,l,o),h.push(r),y.push(r[0]),f.push(r[1]),{values:h,xData:y,yData:f}}},e.defaultOptions=s(n.defaultOptions,{params:{index:3,period:9}}),e}(n);return t.registerSeriesType("wma",l),l}),o(e,"Stock/Indicators/Zigzag/ZigzagIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.merge,s=e.extend,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getValues=function(t,e){var o,r,n,i,s=e.lowIndex,a=e.highIndex,p=e.deviation/100,l={low:1+p,high:1-p},u=t.xData,c=t.yData,h=c?c.length:0,y=[],f=[],d=[],g=!1,m=!1;if(u&&!(u.length<=1)&&(!h||void 0!==c[0][s]&&void 0!==c[0][a])){var v=c[0][s],x=c[0][a];for(o=1;o<h;o++)c[o][s]<=x*l.high?(y.push([u[0],x]),n=[u[o],c[o][s]],i=!0,g=!0):c[o][a]>=v*l.low&&(y.push([u[0],v]),n=[u[o],c[o][a]],i=!1,g=!0),g&&(f.push(y[0][0]),d.push(y[0][1]),r=o++,o=h);for(o=r;o<h;o++)i?(c[o][s]<=n[1]&&(n=[u[o],c[o][s]]),c[o][a]>=n[1]*l.low&&(m=a)):(c[o][a]>=n[1]&&(n=[u[o],c[o][a]]),c[o][s]<=n[1]*l.high&&(m=s)),!1!==m&&(y.push(n),f.push(n[0]),d.push(n[1]),n=[u[o],c[o][m]],i=!i,m=!1);var _=y.length;return 0!==_&&y[_-1][0]<u[h-1]&&(y.push(n),f.push(n[0]),d.push(n[1])),{values:y,xData:f,yData:d}}},e.defaultOptions=i(n.defaultOptions,{params:{index:void 0,period:void 0,lowIndex:2,highIndex:1,deviation:1}}),e}(n);return s(a.prototype,{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag"}),t.registerSeriesType("zigzag",a),a}),o(e,"Stock/Indicators/LinearRegression/LinearRegressionIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.isArray,s=e.extend,a=e.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getRegressionLineParameters=function(t,e){var o,r,n=this.options.params.index,s=function(t,e){return i(t)?t[e]:t},a=t.reduce(function(t,e){return e+t},0),p=e.reduce(function(t,e){return s(e,n)+t},0),l=a/t.length,u=p/e.length,c=0,h=0;for(r=0;r<t.length;r++)c+=(o=t[r]-l)*(s(e[r],n)-u),h+=Math.pow(o,2);var y=h?c/h:0;return{slope:y,intercept:u-y*l}},e.prototype.getEndPointY=function(t,e){return t.slope*e+t.intercept},e.prototype.transformXData=function(t,e){var o=t[0];return t.map(function(t){return(t-o)/e})},e.prototype.findClosestDistance=function(t){var e,o,r;for(r=1;r<t.length-1;r++)(e=t[r]-t[r-1])>0&&(void 0===o||e<o)&&(o=e);return o},e.prototype.getValues=function(t,e){var o,r,n,i,s,a,p,l,u,c=t.xData,h=t.yData,y=e.period,f={xData:[],yData:[],values:[]},d=this.options.params.xAxisUnit||this.findClosestDistance(c);for(r=y-1;r<=c.length-1;r++)n=r-y+1,i=r+1,s=c[r],p=c.slice(n,i),l=h.slice(n,i),u=this.transformXData(p,d),o=this.getRegressionLineParameters(u,l),a=this.getEndPointY(o,u[u.length-1]),f.values.push({regressionLineParameters:o,x:s,y:a}),f.xData.push(s),f.yData.push(a);return f},e.defaultOptions=a(n.defaultOptions,{params:{xAxisUnit:null},tooltip:{valueDecimals:4}}),e}(n);return s(p.prototype,{nameBase:"Linear Regression Indicator"}),t.registerSeriesType("linearRegression",p),p}),o(e,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopesIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.linearRegression,i=e.extend,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getEndPointY=function(t){return t.slope},e.defaultOptions=s(n.defaultOptions),e}(n);return i(a.prototype,{nameBase:"Linear Regression Slope Indicator"}),t.registerSeriesType("linearRegressionSlope",a),a}),o(e,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionInterceptIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.linearRegression,i=e.extend,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getEndPointY=function(t){return t.intercept},e.defaultOptions=s(n.defaultOptions),e}(n);return i(a.prototype,{nameBase:"Linear Regression Intercept Indicator"}),t.registerSeriesType("linearRegressionIntercept",a),a}),o(e,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngleIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.linearRegression,i=e.extend,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.slopeToAngle=function(t){return Math.atan(t)*(180/Math.PI)},e.prototype.getEndPointY=function(t){return this.slopeToAngle(t.slope)},e.defaultOptions=s(n.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">●</span>{series.name}: <b>{point.y}\xb0</b><br/>'}}),e}(n);return i(a.prototype,{nameBase:"Linear Regression Angle Indicator"}),t.registerSeriesType("linearRegressionAngle",a),a}),o(e,"Stock/Indicators/ABands/ABandsIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.seriesTypes.sma,s=o.correctFloat,a=o.extend,p=o.merge,l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.getValues=function(e,o){var r,n,i,a,p,l,u,c,h,y,f,d,g,m=o.period,v=o.factor,x=o.index,_=e.xData,S=e.yData,D=S?S.length:0,O=[],C=[],b=[],j=[],A=[];if(!(D<m)){for(g=0;g<=D;g++)g<D&&(r=S[g][2],u=s((n=S[g][1])-r)/(s(n+r)/2)*1e3*v,O.push(S[g][1]*s(1+2*u)),C.push(S[g][2]*s(1-2*u))),g>=m&&(f=_.slice(g-m,g),d=S.slice(g-m,g),h=t.prototype.getValues.call(this,{xData:f,yData:O.slice(g-m,g)},{period:m}),y=t.prototype.getValues.call(this,{xData:f,yData:C.slice(g-m,g)},{period:m}),l=(c=t.prototype.getValues.call(this,{xData:f,yData:d},{period:m,index:x})).xData[0],a=h.yData[0],p=y.yData[0],i=c.yData[0],b.push([l,a,i,p]),j.push(l),A.push([a,i,p]));return{values:b,xData:j,yData:A}}},e.defaultOptions=p(i.defaultOptions,{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}}),e}(i);return a(l.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameBase:"Acceleration Bands",nameComponents:["period","factor"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"}),t.compose(l),e.registerSeriesType("abands",l),l}),o(e,"Stock/Indicators/TrendLine/TrendLineIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.extend,s=e.merge,a=e.isArray,p=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.updateAllPoints=!0,e}return r(e,t),e.prototype.getValues=function(t,e){for(var o=t.xData,r=t.yData,n=[],i=[],s=[],p=[],l=e.index,u=0,c=0,h=0,y=0,f=0,d=0;d<o.length;d++)(0===d||o[d]!==o[d-1])&&f++,n.push(f);for(var d=0;d<n.length;d++)h+=n[d],y+=a(r[d])?r[d][l]:r[d];for(var g=h/n.length,m=y/r.length,d=0;d<n.length;d++){var v=a(r[d])?r[d][l]:r[d];u+=(n[d]-g)*(v-m),c+=Math.pow(n[d]-g,2)}for(var d=0;d<n.length;d++)if(o[d]!==s[s.length-1]){var x=o[d],v=m+u/c*(n[d]-g);i.push([x,v]),s.push(x),p.push(v)}return{xData:s,yData:p,values:i}},e.defaultOptions=s(n.defaultOptions,{params:{period:void 0,index:3}}),e}(n);return i(p.prototype,{nameBase:"Trendline",nameComponents:void 0}),t.registerSeriesType("trendline",p),p}),o(e,"Stock/Indicators/DisparityIndex/DisparityIndexIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=t.seriesTypes.sma,i=e.correctFloat,s=e.defined,a=e.extend,p=e.isArray,l=e.merge,u=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return r(o,e),o.prototype.init=function(){var e=arguments,o=e[1].params,r=o&&o.average?o.average:void 0;this.averageIndicator=t.seriesTypes[r]||n,this.averageIndicator.prototype.init.apply(this,e)},o.prototype.calculateDisparityIndex=function(t,e){return i(t-e)/e*100},o.prototype.getValues=function(t,e){var o=e.index,r=t.xData,n=t.yData,i=n?n.length:0,a=[],l=[],u=[],c=this.averageIndicator,h=p(n[0]),y=c.prototype.getValues(t,e),f=y.yData,d=r.indexOf(y.xData[0]);if(f&&0!==f.length&&s(o)&&!(n.length<=d)){for(var g=d;g<i;g++){var m=this.calculateDisparityIndex(h?n[g][o]:n[g],f[g-d]);a.push([r[g],m]),l.push(r[g]),u.push(m)}return{values:a,xData:l,yData:u}}},o.defaultOptions=l(n.defaultOptions,{params:{average:"sma",index:3},marker:{enabled:!1},dataGrouping:{approximation:"averages"}}),o}(n);return a(u.prototype,{nameBase:"Disparity Index",nameComponents:["period","average"]}),t.registerSeriesType("disparityindex",u),u}),o(e,"masters/indicators/indicators-all.src.js",[],function(){})});