/**
 * Highstock JS v11.3.0 (2024-01-10)
 *
 * Indicator series type for Highcharts Stock
 *
 * (c) 2010-2024 Kamil Kulig
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/indicators/regressions",["highcharts","highcharts/modules/stock"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function n(t,e,n,r){t.hasOwnProperty(e)||(t[e]=r.apply(null,n),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}n(e,"Stock/Indicators/LinearRegression/LinearRegressionIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var n,r=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),o=t.seriesTypes.sma,i=e.isArray,s=e.extend,a=e.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getRegressionLineParameters=function(t,e){var n,r,o=this.options.params.index,s=function(t,e){return i(t)?t[e]:t},a=t.reduce(function(t,e){return e+t},0),p=e.reduce(function(t,e){return s(e,o)+t},0),u=a/t.length,c=p/e.length,l=0,f=0;for(r=0;r<t.length;r++)l+=(n=t[r]-u)*(s(e[r],o)-c),f+=Math.pow(n,2);var y=f?l/f:0;return{slope:y,intercept:c-y*u}},e.prototype.getEndPointY=function(t,e){return t.slope*e+t.intercept},e.prototype.transformXData=function(t,e){var n=t[0];return t.map(function(t){return(t-n)/e})},e.prototype.findClosestDistance=function(t){var e,n,r;for(r=1;r<t.length-1;r++)(e=t[r]-t[r-1])>0&&(void 0===n||e<n)&&(n=e);return n},e.prototype.getValues=function(t,e){var n,r,o,i,s,a,p,u,c,l=t.xData,f=t.yData,y=e.period,g={xData:[],yData:[],values:[]},h=this.options.params.xAxisUnit||this.findClosestDistance(l);for(r=y-1;r<=l.length-1;r++)o=r-y+1,i=r+1,s=l[r],p=l.slice(o,i),u=f.slice(o,i),c=this.transformXData(p,h),n=this.getRegressionLineParameters(c,u),a=this.getEndPointY(n,c[c.length-1]),g.values.push({regressionLineParameters:n,x:s,y:a}),g.xData.push(s),g.yData.push(a);return g},e.defaultOptions=a(o.defaultOptions,{params:{xAxisUnit:null},tooltip:{valueDecimals:4}}),e}(o);return s(p.prototype,{nameBase:"Linear Regression Indicator"}),t.registerSeriesType("linearRegression",p),p}),n(e,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopesIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var n,r=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),o=t.seriesTypes.linearRegression,i=e.extend,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getEndPointY=function(t){return t.slope},e.defaultOptions=s(o.defaultOptions),e}(o);return i(a.prototype,{nameBase:"Linear Regression Slope Indicator"}),t.registerSeriesType("linearRegressionSlope",a),a}),n(e,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionInterceptIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var n,r=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),o=t.seriesTypes.linearRegression,i=e.extend,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.getEndPointY=function(t){return t.intercept},e.defaultOptions=s(o.defaultOptions),e}(o);return i(a.prototype,{nameBase:"Linear Regression Intercept Indicator"}),t.registerSeriesType("linearRegressionIntercept",a),a}),n(e,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngleIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var n,r=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),o=t.seriesTypes.linearRegression,i=e.extend,s=e.merge,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.slopeToAngle=function(t){return Math.atan(t)*(180/Math.PI)},e.prototype.getEndPointY=function(t){return this.slopeToAngle(t.slope)},e.defaultOptions=s(o.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">●</span>{series.name}: <b>{point.y}\xb0</b><br/>'}}),e}(o);return i(a.prototype,{nameBase:"Linear Regression Angle Indicator"}),t.registerSeriesType("linearRegressionAngle",a),a}),n(e,"masters/indicators/regressions.src.js",[],function(){})});