/**
 * Highstock JS v11.3.0 (2024-01-10)
 *
 * Indicator series type for Highcharts Stock
 *
 * (c) 2010-2024 Paweł Dalek
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/indicators/volume-by-price",["highcharts","highcharts/modules/stock"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function o(t,e,o,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}o(e,"Stock/Indicators/VBP/VBPPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(t){var e,o=this&&this.__extends||(e=function(t,o){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,o)},function(t,o){if("function"!=typeof o&&null!==o)throw TypeError("Class extends value "+String(o)+" is not a constructor or null");function i(){this.constructor=t}e(t,o),t.prototype=null===o?Object.create(o):(i.prototype=o.prototype,new i)});return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o(e,t),e.prototype.destroy=function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy()),t.prototype.destroy.apply(this,arguments)},e}(t.seriesTypes.sma.prototype.pointClass)}),o(e,"Stock/Indicators/VBP/VBPIndicator.js",[e["Stock/Indicators/VBP/VBPPoint.js"],e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Core/Chart/StockChart.js"]],function(t,e,o,i,n,s){var r,a=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),p=e.animObject,l=o.noop,u=i.seriesTypes,h=u.column.prototype,c=u.sma,d=n.addEvent,f=n.arrayMax,m=n.arrayMin,y=n.correctFloat,v=n.defined,g=n.error,x=n.extend,S=n.isArray,V=n.merge,D=Math.abs,P=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a(e,t),e.prototype.init=function(e,o){var i=this;delete o.data,t.prototype.init.apply(i,arguments);var n=d(s,"afterLinkSeries",function(){if(i.options){var t=i.options.params,o=i.linkedParent,s=e.get(t.volumeSeriesID);i.addCustomEvents(o,s)}n()},{order:1});return i},e.prototype.addCustomEvents=function(t,e){var o=this,i=function(){o.chart.redraw(),o.setData([]),o.zoneStarts=[],o.zoneLinesSVG&&(o.zoneLinesSVG=o.zoneLinesSVG.destroy())};return o.dataEventsToUnbind.push(d(t,"remove",function(){i()})),e&&o.dataEventsToUnbind.push(d(e,"remove",function(){i()})),o},e.prototype.animate=function(t){var e=this,o=e.chart.inverted,i=e.group,n={};if(!t&&i){var s=o?e.yAxis.top:e.xAxis.left;o?(i["forceAnimate:translateY"]=!0,n.translateY=s):(i["forceAnimate:translateX"]=!0,n.translateX=s),i.animate(n,x(p(e.options.animation),{step:function(t,o){e.group.attr({scaleX:Math.max(.001,o.pos)})}}))}},e.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),h.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1)),h.drawPoints.apply(this,arguments)},e.prototype.posNegVolume=function(t,e){var o,i,n,s,r=e?["positive","negative"]:["negative","positive"],a=this.options.volumeDivision,p=this.points.length,l=[],u=[],h=0;for(t?(this.posWidths=l,this.negWidths=u):(l=this.posWidths,u=this.negWidths);h<p;h++)(s=this.points[h])[r[0]+"Graphic"]=s.graphic,s.graphic=s[r[1]+"Graphic"],t&&(o=s.shapeArgs.width,(n=(i=this.priceZones[h]).wholeVolumeData)?(l.push(o/n*i.positiveVolumeData),u.push(o/n*i.negativeVolumeData)):(l.push(0),u.push(0))),s.color=e?a.styles.positiveColor:a.styles.negativeColor,s.shapeArgs.width=e?this.posWidths[h]:this.negWidths[h],s.shapeArgs.x=e?s.shapeArgs.x:this.posWidths[h]},e.prototype.translate=function(){var t,e,o,i,n,s,r,a,p,l,u=this,c=u.options,d=u.chart,m=u.yAxis,v=m.min,g=u.options.zoneLines,x=u.priceZones,S=0;h.translate.apply(u);var V=u.points;V.length&&(r=c.pointPadding<.5?c.pointPadding:.1,t=f(u.volumeDataArray),e=d.plotWidth/2,a=d.plotTop,o=D(m.toPixels(v)-m.toPixels(v+u.rangeStep)),n=D(m.toPixels(v)-m.toPixels(v+u.rangeStep)),r&&(i=D(o*(1-2*r)),S=D((o-i)/2),o=D(i)),V.forEach(function(i,r){p=i.barX=i.plotX=0,l=i.plotY=m.toPixels(x[r].start)-a-(m.reversed?o-n:o)-S,s=y(e*x[r].wholeVolumeData/t),i.pointWidth=s,i.shapeArgs=u.crispCol.apply(u,[p,l,s,o]),i.volumeNeg=x[r].negativeVolumeData,i.volumePos=x[r].positiveVolumeData,i.volumeAll=x[r].wholeVolumeData}),g.enabled&&u.drawZones(d,m,u.zoneStarts,g.styles))},e.prototype.getExtremes=function(){var e,o=this.options.compare,i=this.options.cumulative;return this.options.compare?(this.options.compare=void 0,e=t.prototype.getExtremes.call(this),this.options.compare=o):this.options.cumulative?(this.options.cumulative=!1,e=t.prototype.getExtremes.call(this),this.options.cumulative=i):e=t.prototype.getExtremes.call(this),e},e.prototype.getValues=function(t,e){var o=t.processedXData,i=t.processedYData,n=this.chart,s=e.ranges,r=[],a=[],p=[],l=n.get(e.volumeSeriesID);if(!t.chart){g("Base series not found! In case it has been removed, add a new one.",!0,n);return}if(!l||!l.processedXData.length){var u=l&&!l.processedXData.length?" does not contain any data.":" not found! Check `volumeSeriesID`.";g("Series "+e.volumeSeriesID+u,!0,n);return}var h=S(i[0]);if(h&&4!==i[0].length){g("Type of "+t.name+" series is different than line, OHLC or candlestick.",!0,n);return}return(this.priceZones=this.specifyZones(h,o,i,s,l)).forEach(function(t,e){r.push([t.x,t.end]),a.push(r[e][0]),p.push(r[e][1])}),{values:r,xData:a,yData:p}},e.prototype.specifyZones=function(t,e,o,i,n){var s=!!t&&function(t){for(var e,o=t.length,i=t[0][3],n=i,s=1;s<o;s++)(e=t[s][3])<i&&(i=e),e>n&&(n=e);return{min:i,max:n}}(o),r=this.zoneStarts=[],a=[],p=s?s.min:m(o),l=s?s.max:f(o),u=0,h=1,c=this.linkedParent;if(!this.options.compareToMain&&c.dataModify&&(p=c.dataModify.modifyValue(p),l=c.dataModify.modifyValue(l)),!v(p)||!v(l))return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];var d=this.rangeStep=y(l-p)/i;for(r.push(p);u<i-1;u++)r.push(y(r[u]+d));r.push(l);for(var g=r.length;h<g;h++)a.push({index:h-1,x:e[0],start:r[h-1],end:r[h]});return this.volumePerZone(t,a,n,e,o)},e.prototype.volumePerZone=function(t,e,o,i,n){var s,r,a,p,l,u=this,h=o.processedXData,c=o.processedYData,d=e.length-1,f=n.length,m=c.length;return D(f-m)&&(i[0]!==h[0]&&c.unshift(0),i[f-1]!==h[m-1]&&c.push(0)),u.volumeDataArray=[],e.forEach(function(e){for(l=0,e.wholeVolumeData=0,e.positiveVolumeData=0,e.negativeVolumeData=0;l<f;l++){r=!1,a=!1,p=t?n[l][3]:n[l],s=l?t?n[l-1][3]:n[l-1]:p;var o=u.linkedParent;!u.options.compareToMain&&o.dataModify&&(p=o.dataModify.modifyValue(p),s=o.dataModify.modifyValue(s)),p<=e.start&&0===e.index&&(r=!0),p>=e.end&&e.index===d&&(a=!0),(p>e.start||r)&&(p<e.end||a)&&(e.wholeVolumeData+=c[l],s>p?e.negativeVolumeData+=c[l]:e.positiveVolumeData+=c[l])}u.volumeDataArray.push(e.wholeVolumeData)}),e},e.prototype.drawZones=function(t,e,o,i){var n,s=t.renderer,r=t.plotWidth,a=t.plotTop,p=this.zoneLinesSVG,l=[];o.forEach(function(o){n=e.toPixels(o)-a,l=l.concat(t.renderer.crispLine([["M",0,n],["L",r,n]],i.lineWidth))}),p?p.animate({d:l}):p=this.zoneLinesSVG=s.path(l).attr({"stroke-width":i.lineWidth,stroke:i.color,dashstyle:i.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)},e.defaultOptions=V(c.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1e3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"0.5em"},verticalAlign:"top"}}),e}(c);return x(P.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],calculateOn:{chart:"render",xAxis:"afterSetExtremes"},pointClass:t,markerAttribs:l,drawGraph:l,getColumnMetrics:h.getColumnMetrics,crispCol:h.crispCol}),i.registerSeriesType("vbp",P),P}),o(e,"masters/indicators/volume-by-price.src.js",[],function(){})});