/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Accessibility module
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Oystein Moseng
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/accessibility",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,n){t.hasOwnProperty(e)||(t[e]=n.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Accessibility/Utils/HTMLUtilities.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=t.doc,n=t.win,o=e.css,r=n.EventTarget&&new n.EventTarget||"none";function s(t){if("function"==typeof n.MouseEvent)return new n.MouseEvent(t.type,t);if(i.createEvent){var e=i.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(t.type,t.bubbles,t.cancelable,t.view||n,t.detail,t.screenX,t.screenY,t.clientX,t.clientY,t.ctrlKey,t.altKey,t.shiftKey,t.metaKey,t.button,t.relatedTarget),e}return a(t.type)}function a(t,e,o){var s=e||{x:0,y:0};if("function"==typeof n.MouseEvent)return new n.MouseEvent(t,{bubbles:!0,cancelable:!0,composed:!0,button:0,buttons:1,relatedTarget:o||r,view:n,detail:"click"===t?1:0,screenX:s.x,screenY:s.y,clientX:s.x,clientY:s.y});if(i.createEvent){var a=i.createEvent("MouseEvent");if(a.initMouseEvent)return a.initMouseEvent(t,!0,!0,n,"click"===t?1:0,s.x,s.y,s.x,s.y,!1,!1,!1,!1,0,null),a}return{type:t}}return{addClass:function(t,e){t.classList?t.classList.add(e):0>t.className.indexOf(e)&&(t.className+=" "+e)},cloneMouseEvent:s,cloneTouchEvent:function(t){var e=function(t){for(var e=[],i=0;i<t.length;++i){var n=t.item(i);n&&e.push(n)}return e};if("function"==typeof n.TouchEvent){var i=new n.TouchEvent(t.type,{touches:e(t.touches),targetTouches:e(t.targetTouches),changedTouches:e(t.changedTouches),ctrlKey:t.ctrlKey,shiftKey:t.shiftKey,altKey:t.altKey,metaKey:t.metaKey,bubbles:t.bubbles,cancelable:t.cancelable,composed:t.composed,detail:t.detail,view:t.view});return t.defaultPrevented&&i.preventDefault(),i}var o=s(t);return o.touches=t.touches,o.changedTouches=t.changedTouches,o.targetTouches=t.targetTouches,o},escapeStringForHTML:function(t){return t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")},getElement:function(t){return i.getElementById(t)},getFakeMouseEvent:a,getHeadingTagNameForElement:function(t){var e=function(t){return"h"+Math.min(6,parseInt(t.slice(1),10)+1)},i=function(t){return/H[1-6]/.test(t)},n=function(t){for(var e=t;e=e.previousSibling;){var n=e.tagName||"";if(i(n))return n}return""},o=function(t){var r=n(t);if(r)return e(r);var s=t.parentElement;if(!s)return"p";var a=s.tagName;return i(a)?e(a):o(s)};return o(t)},removeChildNodes:function(t){for(;t.lastChild;)t.removeChild(t.lastChild)},removeClass:function(t,e){t.classList?t.classList.remove(e):t.className=t.className.replace(RegExp(e,"g"),"")},removeElement:function(t){t&&t.parentNode&&t.parentNode.removeChild(t)},reverseChildNodes:function(t){for(var e=t.childNodes.length;e--;)t.appendChild(t.childNodes[e])},simulatedEventTarget:r,stripHTMLTagsFromString:function(t,e){return void 0===e&&(e=!1),"string"==typeof t?e?t.replace(/<\/?[^>]+(>|$)/g,""):t.replace(/<\/?(?!\s)[^>]+(>|$)/g,""):t},visuallyHideElement:function(t){o(t,{position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:.01})}}}),i(e,"Accessibility/A11yI18n.js",[e["Core/Templating.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i){var n,o=t.format,r=e.composed,s=i.getNestedProperty,a=i.pick,l=i.pushUnique;return function(t){function e(t,e,i){var n,r,l=[],c=0;do n=function(t,e){var i=t.slice(e||0),n=i.indexOf("{"),o=i.indexOf("}");if(n>-1&&o>n)return{statement:i.substring(n+1,o),begin:e+n+1,end:e+o}}(t,c),(r=t.substring(c,n&&n.begin-1)).length&&l.push({value:r,type:"constant"}),n&&l.push({value:n.statement,type:"statement"}),c=n?n.end+1:c+1;while(n);return l.forEach(function(t){"statement"===t.type&&(t.value=function(t,e){var i,n,o=t.indexOf("#each("),r=t.indexOf("#plural("),l=t.indexOf("["),c=t.indexOf("]");if(o>-1){var h=t.slice(o).indexOf(")")+o,d=t.substring(0,o),u=t.substring(h+1),p=t.substring(o+6,h).split(","),g=Number(p[1]),m=void 0;if(n="",i=s(p[0],e)){m=(g=isNaN(g)?i.length:g)<0?i.length+g:Math.min(g,i.length);for(var f=0;f<m;++f)n+=d+i[f]+u}return n.length?n:""}if(r>-1){var v,y=t.slice(r).indexOf(")")+r,b=t.substring(r+8,y).split(",");switch(Number(s(b[0],e))){case 0:n=a(b[4],b[1]);break;case 1:n=a(b[2],b[1]);break;case 2:n=a(b[3],b[1]);break;default:n=b[1]}return n?(v=n).trim&&v.trim()||v.replace(/^\s+|\s+$/g,""):""}if(l>-1){var x=t.substring(0,l),A=Number(t.substring(l+1,c)),w=void 0;return i=s(x,e),!isNaN(A)&&i&&(A<0?void 0===(w=i[i.length+A])&&(w=i[0]):void 0===(w=i[A])&&(w=i[i.length-1])),void 0!==w?w:""}return"{"+t+"}"}(t.value,e))}),o(l.reduce(function(t,e){return t+e.value},""),e,i)}function i(t,i){for(var n=t.split("."),o=this.options.lang,r=0;r<n.length;++r)o=o&&o[n[r]];return"string"==typeof o?e(o,i,this):""}t.compose=function t(e){l(r,t)&&(e.prototype.langFormat=i)},t.i18nFormat=e}(n||(n={})),n}),i(e,"Accessibility/Utils/ChartUtilities.js",[e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i){var n=t.doc,o=e.stripHTMLTagsFromString,r=i.defined,s=i.find,a=i.fireEvent;function l(t){if(t.points&&t.points.length){var e=s(t.points,function(t){return!!t.graphic});return e&&e.graphic&&e.graphic.element}}function c(t){var e=l(t);return e&&e.parentNode||t.graph&&t.graph.element||t.group&&t.group.element}return{fireEventOnWrappedOrUnwrappedElement:function t(e,i){var o=i.type,r=e.hcEvents;n.createEvent&&(e.dispatchEvent||e.fireEvent)?e.dispatchEvent?e.dispatchEvent(i):e.fireEvent(o,i):r&&r[o]?a(e,o,i):e.element&&t(e.element,i)},getChartTitle:function(t){return o(t.options.title.text||t.langFormat("accessibility.defaultChartTitle",{chart:t}),t.renderer.forExport)},getAxisDescription:function(t){var e,i;return t&&((null===(e=t.options.accessibility)||void 0===e?void 0:e.description)||(null===(i=t.axisTitle)||void 0===i?void 0:i.textStr)||t.options.id||t.categories&&"categories"||t.dateTime&&"Time"||"values")},getAxisRangeDescription:function(t){var e,i,n,o,r,s,a,l,c,h,d,u,p=t.options||{};return p.accessibility&&void 0!==p.accessibility.rangeDescription?p.accessibility.rangeDescription:t.categories?(e=t.chart,t.dataMax&&t.dataMin?e.langFormat("accessibility.axis.rangeCategories",{chart:e,axis:t,numCategories:t.dataMax-t.dataMin+1}):""):t.dateTime&&(0===t.min||0===t.dataMin)?(i=t.chart,n={},o=t.dataMin||t.min||0,r=t.dataMax||t.max||0,s="Seconds",n.Seconds=(r-o)/1e3,n.Minutes=n.Seconds/60,n.Hours=n.Minutes/60,n.Days=n.Hours/24,["Minutes","Hours","Days"].forEach(function(t){n[t]>2&&(s=t)}),a=n[s].toFixed("Seconds"!==s&&"Minutes"!==s?1:0),i.langFormat("accessibility.axis.timeRange"+s,{chart:i,axis:t,range:a.replace(".0","")})):(h=(c=(l=t.chart).options)&&c.accessibility&&c.accessibility.screenReaderSection.axisRangeDateFormat||"",d={min:t.dataMin||t.min||0,max:t.dataMax||t.max||0},u=function(e){return t.dateTime?l.time.dateFormat(h,d[e]):d[e].toString()},l.langFormat("accessibility.axis.rangeFromTo",{chart:l,axis:t,rangeFrom:u("min"),rangeTo:u("max")}))},getPointFromXY:function(t,e,i){for(var n,o=t.length;o--;)if(n=s(t[o].points||[],function(t){return t.x===e&&t.y===i}))return n},getSeriesFirstPointElement:l,getSeriesFromName:function(t,e){return e?(t.series||[]).filter(function(t){return t.name===e}):t.series},getSeriesA11yElement:c,unhideChartElementFromAT:function t(e,i){i.setAttribute("aria-hidden",!1),i!==e.renderTo&&i.parentNode&&i.parentNode!==n.body&&(Array.prototype.forEach.call(i.parentNode.childNodes,function(t){t.hasAttribute("aria-hidden")||t.setAttribute("aria-hidden",!0)}),t(e,i.parentNode))},hideSeriesFromAT:function(t){var e=c(t);e&&e.setAttribute("aria-hidden",!0)},scrollAxisToPoint:function(t){var e=t.series.xAxis,i=t.series.yAxis,n=e&&e.scrollbar?e:i,o=n&&n.scrollbar;if(o&&r(o.to)&&r(o.from)){var s=o.to-o.from,l=function(t,e){if(!r(t.dataMin)||!r(t.dataMax))return 0;var i=t.toPixels(t.dataMin),n=t.toPixels(t.dataMax),o="xAxis"===t.coll?"x":"y";return(t.toPixels(e[o]||0)-i)/(n-i)}(n,t);o.updatePosition(l-s/2,l+s/2),a(o,"changed",{from:o.from,to:o.to,trigger:"scrollbar",DOMEvent:null})}}}}),i(e,"Accessibility/Utils/DOMElementProvider.js",[e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e){var i=t.doc,n=e.removeElement;return function(){function t(){this.elements=[]}return t.prototype.createElement=function(){var t=i.createElement.apply(i,arguments);return this.elements.push(t),t},t.prototype.destroyCreatedElements=function(){this.elements.forEach(function(t){n(t)}),this.elements=[]},t}()}),i(e,"Accessibility/Utils/EventProvider.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=e.addEvent;return function(){function e(){this.eventRemovers=[]}return e.prototype.addEvent=function(){var e=i.apply(t,arguments);return this.eventRemovers.push(e),e},e.prototype.removeAddedEvents=function(){this.eventRemovers.forEach(function(t){return t()}),this.eventRemovers=[]},e}()}),i(e,"Accessibility/AccessibilityComponent.js",[e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/DOMElementProvider.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r=t.fireEventOnWrappedOrUnwrappedElement,s=n.getFakeMouseEvent,a=o.extend,l=function(){function t(){}return t.prototype.initBase=function(t,n){this.chart=t,this.eventProvider=new i,this.domElementProvider=new e,this.proxyProvider=n,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9,pageUp:33,pageDown:34,end:35,home:36}},t.prototype.addEvent=function(t,e,i,n){return this.eventProvider.addEvent(t,e,i,n)},t.prototype.createElement=function(t,e){return this.domElementProvider.createElement(t,e)},t.prototype.fakeClickEvent=function(t){r(t,s("click"))},t.prototype.destroyBase=function(){this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()},t}();return a(l.prototype,{init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}}),l}),i(e,"Accessibility/KeyboardNavigationHandler.js",[e["Core/Utilities.js"]],function(t){var e=t.find;return function(){function t(t,e){this.chart=t,this.keyCodeMap=e.keyCodeMap||[],this.validate=e.validate,this.init=e.init,this.terminate=e.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}return t.prototype.run=function(t){var i=t.which||t.keyCode,n=this.response.noHandler,o=e(this.keyCodeMap,function(t){return t[0].indexOf(i)>-1});return o?n=o[1].call(this,i,t):9===i&&(n=this.response[t.shiftKey?"prev":"next"]),n},t}()}),i(e,"Accessibility/Components/ContainerComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o){var r,s=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),a=i.unhideChartElementFromAT,l=i.getChartTitle,c=n.doc,h=o.stripHTMLTagsFromString;return function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s(i,t),i.prototype.onChartUpdate=function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},i.prototype.handleSVGTitleElement=function(){var t=this.chart,e="highcharts-title-"+t.index,i=h(t.langFormat("accessibility.svgContainerTitle",{chartTitle:l(t)}));if(i.length){var n=this.svgTitleElement=this.svgTitleElement||c.createElementNS("http://www.w3.org/2000/svg","title");n.textContent=i,n.id=e,t.renderTo.insertBefore(n,t.renderTo.firstChild)}},i.prototype.setSVGContainerLabel=function(){var t=this.chart,e=t.langFormat("accessibility.svgContainerLabel",{chartTitle:l(t)});t.renderer.box&&e.length&&t.renderer.box.setAttribute("aria-label",e)},i.prototype.setGraphicContainerAttrs=function(){var t=this.chart,e=t.langFormat("accessibility.graphicContainerLabel",{chartTitle:l(t)});e.length&&t.container.setAttribute("aria-label",e)},i.prototype.setRenderToAttrs=function(){var t=this.chart,e="disabled"!==t.options.accessibility.landmarkVerbosity,i=t.langFormat("accessibility.chartContainerLabel",{title:l(t),chart:t});i&&(t.renderTo.setAttribute("role",e?"region":"group"),t.renderTo.setAttribute("aria-label",i))},i.prototype.makeCreditsAccessible=function(){var t=this.chart,e=t.credits;e&&(e.textStr&&e.element.setAttribute("aria-label",t.langFormat("accessibility.credits",{creditsStr:h(e.textStr,t.renderer.forExport)})),a(t,e.element))},i.prototype.getKeyboardNavigation=function(){var t=this.chart;return new e(t,{keyCodeMap:[],validate:function(){return!0},init:function(){var e=t.accessibility;e&&e.keyboardNavigation.tabindexContainer.focus()}})},i.prototype.destroy=function(){this.chart.renderTo.setAttribute("aria-hidden",!0)},i}(t)}),i(e,"Accessibility/FocusBorder.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i,n=t.composed,o=e.addEvent,r=e.pick,s=e.pushUnique;return function(t){var e=["x","y","transform","width","height","r","d","stroke-width"];function i(){var t=this.focusElement,e=this.options.accessibility.keyboardNavigation.focusBorder;t&&(t.removeFocusBorder(),e.enabled&&t.addFocusBorder(e.margin,{stroke:e.style.color,strokeWidth:e.style.lineWidth,r:e.style.borderRadius}))}function a(t,e){var i=this.options.accessibility.keyboardNavigation.focusBorder,n=e||t.element;n&&n.focus&&(n.hcEvents&&n.hcEvents.focusin||o(n,"focusin",function(){}),n.focus(),i.hideBrowserFocusOutline&&(n.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=t,this.renderFocusBorder()}function l(t,i){this.focusBorder&&this.removeFocusBorder();var n=this.getBBox(),o=r(t,3),s=this.parentGroup,a=this.scaleX||s&&s.scaleX,l=this.scaleY||s&&s.scaleY,c=(a?!l:l)?Math.abs(a||l||1):(Math.abs(a||1)+Math.abs(l||1))/2;n.x+=this.translateX?this.translateX:0,n.y+=this.translateY?this.translateY:0;var h=n.x-o,d=n.y-o,u=n.width+2*o,p=n.height+2*o,g=!!this.text;if("text"===this.element.nodeName||g){var m,f,v=!!this.rotation,y=g?{x:v?1:0,y:0}:(m=0,f=0,"middle"===this.attr("text-anchor")?m=f=.5:this.rotation?m=.25:f=.75,{x:m,y:f}),b=+this.attr("x"),x=+this.attr("y");if(isNaN(b)||(h=b-n.width*y.x-o),isNaN(x)||(d=x-n.height*y.y-o),g&&v){var A=u;u=p,p=A,isNaN(b)||(h=b-n.height*y.x-o),isNaN(x)||(d=x-n.width*y.y-o)}}this.focusBorder=this.renderer.rect(h,d,u,p,parseInt((i&&i.r||0).toString(),10)/c).addClass("highcharts-focus-border").attr({zIndex:99}).add(s),this.renderer.styledMode||this.focusBorder.attr({stroke:i&&i.stroke,"stroke-width":(i&&i.strokeWidth||0)/c}),function(t){for(var i=[],n=1;n<arguments.length;n++)i[n-1]=arguments[n];t.focusBorderUpdateHooks||(t.focusBorderUpdateHooks={},e.forEach(function(e){var n=e+"Setter",o=t[n]||t._defaultSetter;t.focusBorderUpdateHooks[n]=o,t[n]=function(){var e=o.apply(t,arguments);return t.addFocusBorder.apply(t,i),e}}))}(this,t,i),function(t){if(!t.focusBorderDestroyHook){var e=t.destroy;t.destroy=function(){return t.focusBorder&&t.focusBorder.destroy&&t.focusBorder.destroy(),e.apply(t,arguments)},t.focusBorderDestroyHook=e}}(this)}function c(){var t;t=this,t.focusBorderUpdateHooks&&(Object.keys(t.focusBorderUpdateHooks).forEach(function(e){var i=t.focusBorderUpdateHooks[e];i===t._defaultSetter?delete t[e]:t[e]=i}),delete t.focusBorderUpdateHooks),this.focusBorderDestroyHook&&(this.destroy=this.focusBorderDestroyHook,delete this.focusBorderDestroyHook),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}t.compose=function t(e,o){if(s(n,t)){var r=e.prototype,h=o.prototype;r.renderFocusBorder=i,r.setFocusToElement=a,h.addFocusBorder=l,h.removeFocusBorder=c}}}(i||(i={})),i}),i(e,"Accessibility/Utils/Announcer.js",[e["Core/Renderer/HTML/AST.js"],e["Accessibility/Utils/DOMElementProvider.js"],e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r=i.doc,s=n.addClass,a=n.visuallyHideElement,l=o.attr;return function(){function i(t,i){this.chart=t,this.domElementProvider=new e,this.announceRegion=this.addAnnounceRegion(i)}return i.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},i.prototype.announce=function(e){var i=this;t.setElementHTML(this.announceRegion,e),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){i.announceRegion.innerHTML=t.emptyHTML,delete i.clearAnnouncementRegionTimer},3e3)},i.prototype.addAnnounceRegion=function(t){var e=this.chart.announcerContainer||this.createAnnouncerContainer(),i=this.domElementProvider.createElement("div");return l(i,{"aria-hidden":!1,"aria-live":t,"aria-atomic":!0}),this.chart.styledMode?s(i,"highcharts-visually-hidden"):a(i),e.appendChild(i),i},i.prototype.createAnnouncerContainer=function(){var t=this.chart,e=r.createElement("div");return l(e,{"aria-hidden":!1,class:"highcharts-announcer-container"}),e.style.position="relative",t.renderTo.insertBefore(e,t.renderTo.firstChild),t.announcerContainer=e,e},i}()}),i(e,"Accessibility/Components/AnnotationsA11y.js",[e["Accessibility/Utils/HTMLUtilities.js"]],function(t){var e=t.escapeStringForHTML,i=t.stripHTMLTagsFromString;function n(t){return(t.annotations||[]).reduce(function(t,e){return e.options&&!1!==e.options.visible&&(t=t.concat(e.labels)),t},[])}function o(t){return t.options&&t.options.accessibility&&t.options.accessibility.description||t.graphic&&t.graphic.text&&t.graphic.text.textStr||""}function r(t){var e=t.options&&t.options.accessibility&&t.options.accessibility.description;if(e)return e;var i=t.chart,n=o(t),r=t.points.filter(function(t){return!!t.graphic}).map(function(t){var e=t.accessibility&&t.accessibility.valueDescription||t.graphic&&t.graphic.element&&t.graphic.element.getAttribute("aria-label")||"",i=t&&t.series.name||"";return(i?i+", ":"")+"data point "+e}).filter(function(t){return!!t}),s=r.length,a=s>1?"MultiplePoints":s?"SinglePoint":"NoPoints",l={annotationText:n,annotation:t,numPoints:s,annotationPoint:r[0],additionalAnnotationPoints:r.slice(1)};return i.langFormat("accessibility.screenReaderSection.annotations.description"+a,l)}function s(t){return n(t).map(function(n){var o=e(i(r(n),t.renderer.forExport));return o?"<li>".concat(o,"</li>"):""})}return{getAnnotationsInfoHTML:function(t){var e=t.annotations;if(!(e&&e.length))return"";var i=s(t);return'<ul style="list-style-type: none">'.concat(i.join(" "),"</ul>")},getAnnotationLabelDescription:r,getAnnotationListItems:s,getPointAnnotationTexts:function(t){var e=n(t.series.chart).filter(function(e){return e.points.indexOf(t)>-1});return e.length?e.map(function(t){return"".concat(o(t))}):[]}}}),i(e,"Accessibility/Components/InfoRegionsComponent.js",[e["Accessibility/A11yI18n.js"],e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/Announcer.js"],e["Accessibility/Components/AnnotationsA11y.js"],e["Core/Renderer/HTML/AST.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Core/Templating.js"],e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o,r,s,a,l,c){var h,d=this&&this.__extends||(h=function(t,e){return(h=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}h(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),u=n.getAnnotationsInfoHTML,p=r.getAxisDescription,g=r.getAxisRangeDescription,m=r.getChartTitle,f=r.unhideChartElementFromAT,v=s.format,y=a.doc,b=l.addClass,x=l.getElement,A=l.getHeadingTagNameForElement,w=l.stripHTMLTagsFromString,C=l.visuallyHideElement,E=c.attr,T=c.pick;function M(t){return t.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}return function(e){function n(){var t=null!==e&&e.apply(this,arguments)||this;return t.screenReaderSections={},t}return d(n,e),n.prototype.init=function(){var t=this.chart,e=this;this.initRegionsDefinitions(),this.addEvent(t,"aftergetTableAST",function(t){e.onDataTableCreated(t)}),this.addEvent(t,"afterViewData",function(t){t.wasHidden&&(e.dataTableDiv=t.element,setTimeout(function(){e.focusDataTable()},300))}),this.addEvent(t,"afterHideData",function(){e.viewDataTableButton&&e.viewDataTableButton.setAttribute("aria-expanded","false")}),this.announcer=new i(t,"assertive")},n.prototype.initRegionsDefinitions=function(){var t=this,e=this.chart.options.accessibility;this.screenReaderSections={before:{element:null,buildContent:function(i){var n=e.screenReaderSection.beforeChartFormatter;return n?n(i):t.defaultBeforeChartFormatter(i)},insertIntoDOM:function(t,e){e.renderTo.insertBefore(t,e.renderTo.firstChild)},afterInserted:function(){void 0!==t.sonifyButtonId&&t.initSonifyButton(t.sonifyButtonId),void 0!==t.dataTableButtonId&&t.initDataTableButton(t.dataTableButtonId)}},after:{element:null,buildContent:function(i){var n=e.screenReaderSection.afterChartFormatter;return n?n(i):t.defaultAfterChartFormatter()},insertIntoDOM:function(t,e){e.renderTo.insertBefore(t,e.container.nextSibling)},afterInserted:function(){t.chart.accessibility&&e.keyboardNavigation.enabled&&t.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},n.prototype.onChartRender=function(){var t=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(e){t.updateScreenReaderSection(e)})},n.prototype.getLinkedDescriptionElement=function(){var t=this.chart.options.accessibility.linkedDescription;if(t){if("string"!=typeof t)return t;var e=v(t,this.chart),i=y.querySelectorAll(e);if(1===i.length)return i[0]}},n.prototype.setLinkedDescriptionAttrs=function(){var t=this.linkedDescriptionElement;t&&(t.setAttribute("aria-hidden","true"),b(t,"highcharts-linked-description"))},n.prototype.updateScreenReaderSection=function(t){var e=this.chart,i=this.screenReaderSections[t],n=i.buildContent(e),r=i.element=i.element||this.createElement("div"),s=r.firstChild||this.createElement("div");n?(this.setScreenReaderSectionAttribs(r,t),o.setElementHTML(s,n),r.appendChild(s),i.insertIntoDOM(r,e),e.styledMode?b(s,"highcharts-visually-hidden"):C(s),f(e,s),i.afterInserted&&i.afterInserted()):(r.parentNode&&r.parentNode.removeChild(r),i.element=null)},n.prototype.setScreenReaderSectionAttribs=function(t,e){var i=this.chart,n=i.langFormat("accessibility.screenReaderSection."+e+"RegionLabel",{chart:i,chartTitle:m(i)});E(t,{id:"highcharts-screen-reader-region-".concat(e,"-").concat(i.index),"aria-label":n||void 0}),t.style.position="relative",n&&t.setAttribute("role","all"===i.options.accessibility.landmarkVerbosity?"region":"group")},n.prototype.defaultBeforeChartFormatter=function(){var e=this.chart,i=e.options.accessibility.screenReaderSection.beforeChartFormat;if(!i)return"";var n=this.getAxesDescription(),o=e.sonify&&e.options.sonification&&e.options.sonification.enabled,r="highcharts-a11y-sonify-data-btn-"+e.index,s="hc-linkto-highcharts-data-table-"+e.index,a=u(e),l=e.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:e}),c={headingTagName:A(e.renderTo),chartTitle:m(e),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:n.xAxis,yAxisDescription:n.yAxis,playAsSoundButton:o?this.getSonifyButtonText(r):"",viewTableButton:e.getCSV?this.getDataTableButtonText(s):"",annotationsTitle:a?l:"",annotationsList:a},h=t.i18nFormat(i,c,e);return this.dataTableButtonId=s,this.sonifyButtonId=r,M(h)},n.prototype.defaultAfterChartFormatter=function(){var e=this.chart,i=e.options.accessibility.screenReaderSection.afterChartFormat;if(!i)return"";var n={endOfChartMarker:this.getEndOfChartMarkerText()};return M(t.i18nFormat(i,n,e))},n.prototype.getLinkedDescription=function(){var t=this.linkedDescriptionElement;return w(t&&t.innerHTML||"",this.chart.renderer.forExport)},n.prototype.getLongdescText=function(){var t=this.chart.options,e=t.caption,i=e&&e.text,n=this.getLinkedDescription();return t.accessibility.description||n||i||""},n.prototype.getTypeDescriptionText=function(){var t,e,i,n,o,r,s,a,l,c=this.chart;return c.types?c.options.accessibility.typeDescription||(t=c,r=(e=c.types)[0],s=t.series&&t.series[0]||{},a=t.mapView&&t.mapView.geoMap&&t.mapView.geoMap.title,l={numSeries:t.series.length,numPoints:s.points&&s.points.length,chart:t,mapTitle:a},r?"map"===r||"tiledwebmap"===r?l.mapTitle?t.langFormat("accessibility.chartTypes.mapTypeDescription",l):t.langFormat("accessibility.chartTypes.unknownMap",l):t.types.length>1?t.langFormat("accessibility.chartTypes.combinationChart",l):(i=e[0],n=t.langFormat("accessibility.seriesTypeDescriptions."+i,l),o=t.series&&t.series.length<2?"Single":"Multiple",(t.langFormat("accessibility.chartTypes."+i+o,l)||t.langFormat("accessibility.chartTypes.default"+o,l))+(n?" "+n:"")):t.langFormat("accessibility.chartTypes.emptyChart",l)):""},n.prototype.getDataTableButtonText=function(t){var e=this.chart;return'<button id="'+t+'">'+e.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:e,chartTitle:m(e)})+"</button>"},n.prototype.getSonifyButtonText=function(t){var e=this.chart;return e.options.sonification&&!1===e.options.sonification.enabled?"":'<button id="'+t+'">'+e.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:e,chartTitle:m(e)})+"</button>"},n.prototype.getSubtitleText=function(){var t=this.chart.options.subtitle;return w(t&&t.text||"",this.chart.renderer.forExport)},n.prototype.getEndOfChartMarkerText=function(){var t=this.chart,e=t.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:t});return'<div id="highcharts-end-of-chart-marker-'+t.index+'">'+e+"</div>"},n.prototype.onDataTableCreated=function(t){var e=this.chart;if(e.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var i=t.tree.attributes||{};i.tabindex=-1,i.summary=e.langFormat("accessibility.table.tableSummary",{chart:e}),t.tree.attributes=i}},n.prototype.focusDataTable=function(){var t=this.dataTableDiv,e=t&&t.getElementsByTagName("table")[0];e&&e.focus&&e.focus()},n.prototype.initSonifyButton=function(t){var e=this,i=this.sonifyButton=x(t),n=this.chart,o=function(t){i&&(i.setAttribute("aria-hidden","true"),i.setAttribute("aria-label","")),t.preventDefault(),t.stopPropagation();var o=n.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:n});e.announcer.announce(o),setTimeout(function(){i&&(i.removeAttribute("aria-hidden"),i.removeAttribute("aria-label")),n.sonify&&n.sonify()},1e3)};i&&n&&(i.setAttribute("tabindex",-1),i.onclick=function(t){(n.options.accessibility&&n.options.accessibility.screenReaderSection.onPlayAsSoundClick||o).call(this,t,n)})},n.prototype.initDataTableButton=function(t){var e=this.viewDataTableButton=x(t),i=this.chart,n=t.replace("hc-linkto-","");e&&(E(e,{tabindex:-1,"aria-expanded":!!x(n)}),e.onclick=i.options.accessibility.screenReaderSection.onViewDataTableClick||function(){i.viewData()})},n.prototype.getAxesDescription=function(){var t=this.chart,e=function(e,i){var n=t[e];return n.length>1||n[0]&&T(n[0].options.accessibility&&n[0].options.accessibility.enabled,i)},i=!!t.types&&0>t.types.indexOf("map")&&0>t.types.indexOf("treemap")&&0>t.types.indexOf("tilemap"),n=!!t.hasCartesianSeries,o=e("xAxis",!t.angular&&n&&i),r=e("yAxis",n&&i),s={};return o&&(s.xAxis=this.getAxisDescriptionText("xAxis")),r&&(s.yAxis=this.getAxisDescriptionText("yAxis")),s},n.prototype.getAxisDescriptionText=function(t){var e=this.chart,i=e[t];return e.langFormat("accessibility.axis."+t+"Description"+(i.length>1?"Plural":"Singular"),{chart:e,names:i.map(function(t){return p(t)}),ranges:i.map(function(t){return g(t)}),numAxes:i.length})},n.prototype.destroy=function(){this.announcer&&this.announcer.destroy()},n}(e)}),i(e,"Accessibility/Components/MenuComponent.js",[e["Core/Chart/Chart.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/AccessibilityComponent.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o,r,s){var a,l=this&&this.__extends||(a=function(t,e){return(a=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),c=e.composed,h=i.attr,d=i.pushUnique,u=r.getChartTitle,p=r.unhideChartElementFromAT,g=s.getFakeMouseEvent;function m(t){return t.exportSVGElements&&t.exportSVGElements[0]}var f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l(e,t),e.prototype.init=function(){var t=this.chart,e=this;this.addEvent(t,"exportMenuShown",function(){e.onMenuShown()}),this.addEvent(t,"exportMenuHidden",function(){e.onMenuHidden()}),this.createProxyGroup()},e.prototype.onMenuHidden=function(){var t=this.chart.exportContextMenu;t&&t.setAttribute("aria-hidden","true"),this.setExportButtonExpandedState("false")},e.prototype.onMenuShown=function(){var t=this.chart,e=t.exportContextMenu;e&&(this.addAccessibleContextMenuAttribs(),p(t,e)),this.setExportButtonExpandedState("true")},e.prototype.setExportButtonExpandedState=function(t){this.exportButtonProxy&&this.exportButtonProxy.innerElement.setAttribute("aria-expanded",t)},e.prototype.onChartRender=function(){var t=this.chart,e=t.focusElement,i=t.accessibility;this.proxyProvider.clearGroup("chartMenu"),this.proxyMenuButton(),this.exportButtonProxy&&e&&e===t.exportingGroup&&(e.focusBorder?t.setFocusToElement(e,this.exportButtonProxy.innerElement):i&&i.keyboardNavigation.tabindexContainer.focus())},e.prototype.proxyMenuButton=function(){var t,e,i=this.chart,n=this.proxyProvider,o=m(i);t=i.options.exporting,e=m(i),t&&!1!==t.enabled&&t.accessibility&&t.accessibility.enabled&&e&&e.element&&o&&(this.exportButtonProxy=n.addProxyElement("chartMenu",{click:o},"button",{"aria-label":i.langFormat("accessibility.exporting.menuButtonLabel",{chart:i,chartTitle:u(i)}),"aria-expanded":!1,title:i.options.lang.contextButtonTitle||null}))},e.prototype.createProxyGroup=function(){this.chart&&this.proxyProvider&&this.proxyProvider.addGroup("chartMenu")},e.prototype.addAccessibleContextMenuAttribs=function(){var t=this.chart,e=t.exportDivElements;if(e&&e.length){e.forEach(function(t){t&&("LI"!==t.tagName||t.children&&t.children.length?t.setAttribute("aria-hidden","true"):t.setAttribute("tabindex",-1))});var i=e[0]&&e[0].parentNode;i&&h(i,{"aria-hidden":void 0,"aria-label":t.langFormat("accessibility.exporting.chartMenuLabel",{chart:t}),role:"list"})}},e.prototype.getKeyboardNavigation=function(){var t=this.keyCodes,e=this.chart,i=this;return new o(e,{keyCodeMap:[[[t.left,t.up],function(){return i.onKbdPrevious(this)}],[[t.right,t.down],function(){return i.onKbdNext(this)}],[[t.enter,t.space],function(){return i.onKbdClick(this)}]],validate:function(){return!!e.exporting&&!1!==e.options.exporting.enabled&&!1!==e.options.exporting.accessibility.enabled},init:function(){var t=i.exportButtonProxy,n=i.chart.exportingGroup;t&&n&&e.setFocusToElement(n,t.innerElement)},terminate:function(){e.hideExportMenu()}})},e.prototype.onKbdPrevious=function(t){for(var e=this.chart,i=e.options.accessibility,n=t.response,o=e.highlightedExportItemIx||0;o--;)if(e.highlightExportItem(o))return n.success;return i.keyboardNavigation.wrapAround?(e.highlightLastExportItem(),n.success):n.prev},e.prototype.onKbdNext=function(t){for(var e=this.chart,i=e.options.accessibility,n=t.response,o=(e.highlightedExportItemIx||0)+1;o<e.exportDivElements.length;++o)if(e.highlightExportItem(o))return n.success;return i.keyboardNavigation.wrapAround?(e.highlightExportItem(0),n.success):n.next},e.prototype.onKbdClick=function(t){var e=this.chart,i=e.exportDivElements[e.highlightedExportItemIx],n=m(e).element;return e.openMenu?this.fakeClickEvent(i):(this.fakeClickEvent(n),e.highlightExportItem(0)),t.response.success},e}(n);return function(e){function i(){var t=m(this);if(t){var e=t.element;e.onclick&&e.onclick(g("click"))}}function n(){var t=this.exportDivElements;t&&this.exportContextMenu&&this.openMenu&&(t.forEach(function(t){t&&"highcharts-menu-item"===t.className&&t.onmouseout&&t.onmouseout(g("mouseout"))}),this.highlightedExportItemIx=0,this.exportContextMenu.hideMenu(),this.container.focus())}function o(t){var e=this.exportDivElements&&this.exportDivElements[t],i=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx];if(e&&"LI"===e.tagName&&!(e.children&&e.children.length)){var n=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus;return e.focus&&n&&e.focus(),i&&i.onmouseout&&i.onmouseout(g("mouseout")),e.onmouseover&&e.onmouseover(g("mouseover")),this.highlightedExportItemIx=t,!0}return!1}function r(){if(this.exportDivElements){for(var t=this.exportDivElements.length;t--;)if(this.highlightExportItem(t))return!0}return!1}e.compose=function e(s){if(d(c,e)){var a=t.prototype;a.hideExportMenu=n,a.highlightExportItem=o,a.highlightLastExportItem=r,a.showExportMenu=i}}}(f||(f={})),f}),i(e,"Accessibility/KeyboardNavigation.js",[e["Core/Globals.js"],e["Accessibility/Components/MenuComponent.js"],e["Core/Utilities.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o){var r=t.composed,s=t.doc,a=t.win,l=i.addEvent,c=i.fireEvent,h=i.pushUnique,d=o.getElement,u=o.simulatedEventTarget,p=function(){function t(t,e){this.currentModuleIx=NaN,this.modules=[],this.init(t,e)}return t.prototype.init=function(t,e){var i=this,o=this.eventProvider=new n;this.chart=t,this.components=e,this.modules=[],this.currentModuleIx=0,this.update(),o.addEvent(this.tabindexContainer,"keydown",function(t){return i.onKeydown(t)}),o.addEvent(this.tabindexContainer,"focus",function(t){return i.onFocus(t)}),["mouseup","touchend"].forEach(function(t){return o.addEvent(s,t,function(t){return i.onMouseUp(t)})}),["mousedown","touchstart"].forEach(function(e){return o.addEvent(t.renderTo,e,function(){i.isClickingChart=!0})})},t.prototype.update=function(t){var e=this.chart.options.accessibility,i=e&&e.keyboardNavigation,n=this.components;this.updateContainerTabindex(),i&&i.enabled&&t&&t.length?(this.modules=t.reduce(function(t,e){var i=n[e].getKeyboardNavigation();return t.concat(i)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},t.prototype.updateExitAnchor=function(){var t=d("highcharts-end-of-chart-marker-".concat(this.chart.index));this.removeExitAnchor(),t?(this.makeElementAnExitAnchor(t),this.exitAnchor=t):this.createExitAnchor()},t.prototype.move=function(t){var e=this.modules&&this.modules[this.currentModuleIx];e&&e.terminate&&e.terminate(t),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=t;var i=this.modules&&this.modules[this.currentModuleIx];if(i){if(i.validate&&!i.validate())return this.move(t);if(i.init)return i.init(t),!0}return this.currentModuleIx=0,this.exiting=!0,t>0?this.exitAnchor&&this.exitAnchor.focus():this.tabindexContainer.focus(),!1},t.prototype.onFocus=function(t){var e=this.chart,i=t.relatedTarget&&e.container.contains(t.relatedTarget),n=e.options.accessibility,o=n&&n.keyboardNavigation;if(o&&o.enabled&&!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!i){var r=this.getFirstValidModuleIx();null!==r&&(this.currentModuleIx=r,this.modules[r].init(1))}this.keyboardReset=!1,this.exiting=!1},t.prototype.onMouseUp=function(t){if(delete this.isClickingChart,!this.keyboardReset&&t.relatedTarget!==u){var e=this.chart;if(!t.target||!e.container.contains(t.target)){var i=this.modules&&this.modules[this.currentModuleIx||0];i&&i.terminate&&i.terminate(),this.currentModuleIx=0}e.focusElement&&(e.focusElement.removeFocusBorder(),delete e.focusElement),this.keyboardReset=!0}},t.prototype.onKeydown=function(t){var e,i=t||a.event,n=this.modules&&this.modules.length&&this.modules[this.currentModuleIx],o=i.target;if((!o||"INPUT"!==o.nodeName||o.classList.contains("highcharts-a11y-proxy-element"))&&(this.keyboardReset=!1,this.exiting=!1,n)){var r=n.run(i);r===n.response.success?e=!0:r===n.response.prev?e=this.move(-1):r===n.response.next&&(e=this.move(1)),e&&(i.preventDefault(),i.stopPropagation())}},t.prototype.updateContainerTabindex=function(){var t,e=this.chart.options.accessibility,i=e&&e.keyboardNavigation,n=!(i&&!1===i.enabled),o=this.chart,r=o.container;o.renderTo.hasAttribute("tabindex")?(r.removeAttribute("tabindex"),t=o.renderTo):t=r,this.tabindexContainer=t;var s=t.getAttribute("tabindex");n&&!s?t.setAttribute("tabindex","0"):n||o.container.removeAttribute("tabindex")},t.prototype.createExitAnchor=function(){var t=this.chart,e=this.exitAnchor=s.createElement("div");t.renderTo.appendChild(e),this.makeElementAnExitAnchor(e)},t.prototype.makeElementAnExitAnchor=function(t){var e=this.tabindexContainer.getAttribute("tabindex")||0;t.setAttribute("class","highcharts-exit-anchor"),t.setAttribute("tabindex",e),t.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(t)},t.prototype.removeExitAnchor=function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},t.prototype.addExitAnchorEventsToEl=function(t){var e=this.chart,i=this;this.eventProvider.addEvent(t,"focus",function(t){var n=t||a.event,o=!(n.relatedTarget&&e.container.contains(n.relatedTarget)||i.exiting);if(e.focusElement&&delete e.focusElement,o){if(i.tabbingInBackwards=!0,i.tabindexContainer.focus(),delete i.tabbingInBackwards,n.preventDefault(),i.modules&&i.modules.length){i.currentModuleIx=i.modules.length-1;var r=i.modules[i.currentModuleIx];r&&r.validate&&!r.validate()?i.move(-1):r&&r.init(-1)}}else i.exiting=!1})},t.prototype.getFirstValidModuleIx=function(){for(var t=this.modules.length,e=0;e<t;++e){var i=this.modules[e];if(!i.validate||i.validate())return e}return null},t.prototype.destroy=function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")},t}();return function(i){function n(){var t=this;c(this,"dismissPopupContent",{},function(){t.tooltip&&t.tooltip.hide(0),t.hideExportMenu()})}function o(e){27===(e.which||e.keyCode)&&t.charts&&t.charts.forEach(function(t){t&&t.dismissPopupContent&&t.dismissPopupContent()})}i.compose=function t(i){return e.compose(i),h(r,t)&&(i.prototype.dismissPopupContent=n,l(s,"keydown",o)),i}}(p||(p={})),p}),i(e,"Accessibility/Components/LegendComponent.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Core/Legend/Legend.js"],e["Core/Utilities.js"],e["Accessibility/AccessibilityComponent.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o,r,s,a){var l,c=this&&this.__extends||(l=function(t,e){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}l(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),h=t.animObject,d=e.composed,u=e.doc,p=n.addEvent,g=n.fireEvent,m=n.isNumber,f=n.pick,v=n.pushUnique,y=n.syncTimeout,b=s.getChartTitle,x=a.stripHTMLTagsFromString,A=a.addClass,w=a.removeClass;function C(t){var e=t.legend&&t.legend.allItems,i=t.options.legend.accessibility||{},n=t.colorAxis&&t.colorAxis.some(function(t){return!t.dataClasses||!t.dataClasses.length});return!!(e&&e.length&&!n&&!1!==i.enabled)}function E(t,e){var i=e.legendItem||{};e.setState(t?"hover":"",!0);for(var n=0,o=["group","label","symbol"];n<o.length;n++){var r=i[o[n]],s=r&&r.element||r;s&&g(s,t?"mouseover":"mouseout")}}var T=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.highlightedLegendItemIx=NaN,e.proxyGroup=null,e}return c(e,t),e.prototype.init=function(){var t=this;this.recreateProxies(),this.addEvent(i,"afterScroll",function(){this.chart===t.chart&&(t.proxyProvider.updateGroupProxyElementPositions("legend"),t.updateLegendItemProxyVisibility(),t.highlightedLegendItemIx>-1&&this.chart.highlightLegendItem(t.highlightedLegendItemIx))}),this.addEvent(i,"afterPositionItem",function(e){this.chart===t.chart&&this.chart.renderer&&t.updateProxyPositionForItem(e.item)}),this.addEvent(i,"afterRender",function(){this.chart===t.chart&&this.chart.renderer&&t.recreateProxies()&&y(function(){return t.proxyProvider.updateGroupProxyElementPositions("legend")},h(f(this.chart.renderer.globalAnimation,!0)).duration)})},e.prototype.updateLegendItemProxyVisibility=function(){var t,e=this.chart,i=e.legend,n=i.allItems||[],o=i.currentPage||1,r=i.clipHeight||0;n.forEach(function(n){if(n.a11yProxyElement){var s=i.pages&&i.pages.length,a=n.a11yProxyElement.element,l=!1;if(t=n.legendItem||{},s){var c=t.pageIx||0;l=(t.y||0)+(t.label?Math.round(t.label.getBBox().height):0)-i.pages[c]>r||c!==o-1}l?e.styledMode?A(a,"highcharts-a11y-invisible"):a.style.visibility="hidden":(w(a,"highcharts-a11y-invisible"),a.style.visibility="")}})},e.prototype.onChartRender=function(){C(this.chart)||this.removeProxies()},e.prototype.highlightAdjacentLegendPage=function(t){var e=this.chart,i=e.legend,n=(i.currentPage||1)+t,o=i.pages||[];if(n>0&&n<=o.length)for(var r=0,s=0,a=i.allItems;s<a.length;s++)((a[s].legendItem||{}).pageIx||0)+1===n&&e.highlightLegendItem(r)&&(this.highlightedLegendItemIx=r),++r},e.prototype.updateProxyPositionForItem=function(t){t.a11yProxyElement&&t.a11yProxyElement.refreshPosition()},e.prototype.recreateProxies=function(){var t=u.activeElement,e=this.proxyGroup,i=t&&e&&e.contains(t);return this.removeProxies(),!!C(this.chart)&&(this.addLegendProxyGroup(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),this.updateLegendTitle(),i&&this.chart.highlightLegendItem(this.highlightedLegendItemIx),!0)},e.prototype.removeProxies=function(){this.proxyProvider.removeGroup("legend")},e.prototype.updateLegendTitle=function(){var t=this.chart,e=x((t.legend&&t.legend.options.title&&t.legend.options.title.text||"").replace(/<br ?\/?>/g," "),t.renderer.forExport),i=t.langFormat("accessibility.legend.legendLabel"+(e?"":"NoTitle"),{chart:t,legendTitle:e,chartTitle:b(t)});this.proxyProvider.updateGroupAttrs("legend",{"aria-label":i})},e.prototype.addLegendProxyGroup=function(){var t="all"===this.chart.options.accessibility.landmarkVerbosity?"region":null;this.proxyGroup=this.proxyProvider.addGroup("legend","ul",{"aria-label":"_placeholder_",role:t})},e.prototype.proxyLegendItems=function(){var t,e=this;((this.chart.legend||{}).allItems||[]).forEach(function(i){(t=i.legendItem||{}).label&&t.label.element&&e.proxyLegendItem(i)})},e.prototype.proxyLegendItem=function(t){var e=t.legendItem||{};if(e.label&&e.group){var i=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:x(t.name,this.chart.renderer.forExport),item:t}),n={tabindex:-1,"aria-pressed":t.visible,"aria-label":i},o=e.group.div?e.label:e.group;t.a11yProxyElement=this.proxyProvider.addProxyElement("legend",{click:e.label,visual:o.element},"button",n)}},e.prototype.getKeyboardNavigation=function(){var t=this.keyCodes,e=this,i=this.chart;return new r(i,{keyCodeMap:[[[t.left,t.right,t.up,t.down],function(t){return e.onKbdArrowKey(this,t)}],[[t.enter,t.space],function(){return e.onKbdClick(this)}],[[t.pageDown,t.pageUp],function(i){var n=i===t.pageDown?1:-1;return e.highlightAdjacentLegendPage(n),this.response.success}]],validate:function(){return e.shouldHaveLegendNavigation()},init:function(){i.highlightLegendItem(0),e.highlightedLegendItemIx=0},terminate:function(){e.highlightedLegendItemIx=-1,i.legend.allItems.forEach(function(t){return E(!1,t)})}})},e.prototype.onKbdArrowKey=function(t,e){var i=this.keyCodes,n=i.left,o=i.up,r=this.highlightedLegendItemIx,s=this.chart,a=s.legend.allItems.length,l=s.options.accessibility.keyboardNavigation.wrapAround,c=e===n||e===o?-1:1;return s.highlightLegendItem(r+c)?this.highlightedLegendItemIx+=c:l&&a>1&&(this.highlightedLegendItemIx=c>0?0:a-1,s.highlightLegendItem(this.highlightedLegendItemIx)),t.response.success},e.prototype.onKbdClick=function(t){var e=this.chart.legend.allItems[this.highlightedLegendItemIx];return e&&e.a11yProxyElement&&e.a11yProxyElement.click(),t.response.success},e.prototype.shouldHaveLegendNavigation=function(){if(!C(this.chart))return!1;var t=this.chart,e=(t.options.legend||{}).accessibility||{};return!!(t.legend.display&&e.keyboardNavigation&&e.keyboardNavigation.enabled)},e.prototype.destroy=function(){this.removeProxies()},e}(o);return function(t){function e(t){var e=this.legend.allItems,i=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx,n=e[t],o=(null==n?void 0:n.legendItem)||{};if(n){m(i)&&e[i]&&E(!1,e[i]),s=((r=this.legend).allItems[t].legendItem||{}).pageIx,a=r.currentPage,void 0!==s&&s+1!==a&&r.scroll(1+s-a);var r,s,a,l=o.label,c=n.a11yProxyElement&&n.a11yProxyElement.element;return l&&l.element&&c&&this.setFocusToElement(l,c),E(!0,n),!0}return!1}function i(t){var e=this.chart.options.accessibility,i=t.item;e.enabled&&i&&i.a11yProxyElement&&i.a11yProxyElement.innerElement.setAttribute("aria-pressed",t.visible?"true":"false")}t.compose=function t(n,o){v(d,t)&&(n.prototype.highlightLegendItem=e,p(o,"afterColorizeItem",i))}}(T||(T={})),T}),i(e,"Core/Axis/NavigatorAxisComposition.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=t.composed,n=t.isTouchDevice,o=e.addEvent,r=e.correctFloat,s=e.defined,a=e.isNumber,l=e.pick,c=e.pushUnique;function h(){this.navigatorAxis||(this.navigatorAxis=new u(this))}function d(t){var e=this.chart,i=e.options,o=i.navigator,r=this.navigatorAxis,a=e.zooming.pinchType,l=i.rangeSelector,c=e.zooming.type;if(this.isXAxis&&(o&&o.enabled||l&&l.enabled)){if("y"===c)t.zoomed=!1;else if((!n&&"xy"===c||n&&"xy"===a)&&this.options.range){var h=r.previousZoom;s(t.newMin)?r.previousZoom=[this.min,this.max]:h&&(t.newMin=h[0],t.newMax=h[1],r.previousZoom=void 0)}}void 0!==t.zoomed&&t.preventDefault()}var u=function(){function t(t){this.axis=t}return t.compose=function(t){c(i,this.compose)&&(t.keepProps.push("navigatorAxis"),o(t,"init",h),o(t,"zoom",d))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,e,i,n){var o=this.axis,c=o.chart,h=l(i,o.translate(t,!0,!o.horiz)),d=l(n,o.translate(e,!0,!o.horiz)),u=c&&c.fixedRange,p=(o.pointRange||0)/2;return s(i)||(h=r(h+p)),s(n)||(d=r(d-p)),u&&o.dataMin&&o.dataMax&&(d>=o.dataMax&&(h=r(o.dataMax-u)),h<=o.dataMin&&(d=r(o.dataMin+u))),a(h)&&a(d)||(h=d=void 0),{min:h,max:d}},t}();return u}),i(e,"Stock/Navigator/NavigatorDefaults.js",[e["Core/Color/Color.js"],e["Core/Series/SeriesRegistry.js"]],function(t,e){var i=t.parse,n=e.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:i("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===n.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),i(e,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,e,i,n,o){void 0===o&&(o={});var r=o.width?o.width/2:i,s=Math.round(r/3)+.5;return[["M",-r-1,.5],["L",r,.5],["L",r,(n=o.height||n)+.5],["L",-r-1,n+.5],["L",-r-1,.5],["M",-s,4],["L",-s,n-3],["M",s-1,4],["L",s-1,n-3]]}}}),i(e,"Stock/Navigator/NavigatorComposition.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/NavigatorAxisComposition.js"],e["Stock/Navigator/NavigatorDefaults.js"],e["Stock/Navigator/NavigatorSymbols.js"],e["Core/Renderer/RendererRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,n,o,r,s){var a,l=t.defaultOptions;t.setOptions;var c=e.composed,h=e.isTouchDevice,d=r.getRendererType,u=s.addEvent,p=s.extend,g=s.merge,m=s.pick,f=s.pushUnique;function v(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function y(){var t,e,i,n,o=this.legend,r=this.navigator;if(r){e=o&&o.options,i=r.xAxis,n=r.yAxis;var s=r.scrollbarHeight,a=r.scrollButtonSize;this.inverted?(r.left=r.opposite?this.chartWidth-s-r.height:this.spacing[3]+s,r.top=this.plotTop+a):(r.left=m(i.left,this.plotLeft+a),r.top=r.navigatorOptions.top||this.chartHeight-r.height-s-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(e&&"bottom"===e.verticalAlign&&"proximate"!==e.layout&&e.enabled&&!e.floating?o.legendHeight+m(e.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),i&&n&&(this.inverted?i.options.left=n.options.left=r.left:i.options.top=n.options.top=r.top,i.setAxisSize(),n.setAxisSize())}}function b(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new a(this),m(t.redraw,!0)&&this.redraw(t.animation))}function x(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new a(this))}function A(){var t=this.options,e=t.navigator,i=t.rangeSelector;if((e&&e.enabled||i&&i.enabled)&&(!h&&"x"===this.zooming.type||h&&"x"===this.zooming.pinchType))return!1}function w(t){var e=t.navigator;if(e&&t.xAxis[0]){var i=t.xAxis[0].getExtremes();e.render(i.min,i.max)}}function C(t){var e=t.options.navigator||{},i=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(e.enabled||i.enabled)&&(g(!0,this.options.navigator,e),g(!0,this.options.scrollbar,i),delete t.options.navigator,delete t.options.scrollbar)}function E(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function t(e,r,s,h){i.compose(e),a=s,f(c,t)&&(r.prototype.callbacks.push(w),u(r,"afterAddSeries",v),u(r,"afterSetChartSize",y),u(r,"afterUpdate",b),u(r,"beforeRender",x),u(r,"beforeShowResetZoom",A),u(r,"update",C),u(h,"afterUpdate",E),p(d().prototype.symbols,o),p(l,{navigator:n}))}}}),i(e,"Core/Axis/ScrollbarAxis.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i,n=t.composed,o=e.addEvent,r=e.defined,s=e.pick,a=e.pushUnique;return function(t){var e;function i(t){var e=s(t.options&&t.options.min,t.min),i=s(t.options&&t.options.max,t.max);return{axisMin:e,axisMax:i,scrollMin:r(t.dataMin)?Math.min(e,t.min,t.dataMin,s(t.threshold,1/0)):e,scrollMax:r(t.dataMax)?Math.max(i,t.max,t.dataMax,s(t.threshold,-1/0)):i}}function l(){var t=this.scrollbar,e=t&&!t.options.opposite,i=this.horiz?2:e?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[i]+=t.size+(t.options.margin||0))}function c(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new e(t.chart.renderer,t.options.scrollbar,t.chart),o(t.scrollbar,"changed",function(e){var n,o,s=i(t),a=s.axisMin,l=s.axisMax,c=s.scrollMin,h=s.scrollMax-c;if(r(a)&&r(l)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(n=c+h*this.to,o=c+h*this.from):(n=c+h*(1-this.from),o=c+h*(1-this.to)),this.shouldUpdateExtremes(e.DOMType)){var d="mousemove"!==e.DOMType&&"touchmove"!==e.DOMType&&void 0;t.setExtremes(o,n,!0,d,e)}else this.setRange(this.from,this.to)}}))}function h(){var t,e,n,o=i(this),s=o.scrollMin,a=o.scrollMax,l=this.scrollbar,c=this.axisTitleMargin+(this.titleOffset||0),h=this.chart.scrollbarsOffsets,d=this.options.margin||0;if(l&&h){if(this.horiz)this.opposite||(h[1]+=c),l.position(this.left,this.top+this.height+2+h[1]-(this.opposite?d:0),this.width,this.height),this.opposite||(h[1]+=d),t=1;else{this.opposite&&(h[0]+=c);var u=void 0;u=l.options.opposite?this.left+this.width+2+h[0]-(this.opposite?0:d):this.opposite?0:d,l.position(u,this.top,this.width,this.height),this.opposite&&(h[0]+=d),t=0}h[t]+=l.size+(l.options.margin||0),isNaN(s)||isNaN(a)||!r(this.min)||!r(this.max)||this.min===this.max?l.setRange(0,1):(e=(this.min-s)/(a-s),n=(this.max-s)/(a-s),this.horiz&&!this.reversed||!this.horiz&&this.reversed?l.setRange(e,n):l.setRange(1-n,1-e))}}t.compose=function t(i,r){a(n,t)&&(e=r,o(i,"afterGetOffset",l),o(i,"afterInit",c),o(i,"afterRender",h))}}(i||(i={})),i}),i(e,"Stock/Scrollbar/ScrollbarDefaults.js",[e["Core/Globals.js"]],function(t){return t.isTouchDevice,{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),i(e,"Stock/Scrollbar/Scrollbar.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/ScrollbarAxis.js"],e["Stock/Scrollbar/ScrollbarDefaults.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r=t.defaultOptions,s=o.addEvent,a=o.correctFloat,l=o.defined,c=o.destroyObjectProperties,h=o.fireEvent,d=o.merge,u=o.pick,p=o.removeEvent,g=function(){function t(t,e,i){this._events=[],this.chartX=0,this.chartY=0,this.from=0,this.scrollbarButtons=[],this.scrollbarLeft=0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.trackBorderWidth=1,this.x=0,this.y=0,this.init(t,e,i)}return t.compose=function(e){i.compose(e,t)},t.swapXY=function(t,e){return e&&t.forEach(function(t){for(var e,i=t.length,n=0;n<i;n+=2)"number"==typeof(e=t[n+1])&&(t[n+1]=t[n+2],t[n+2]=e)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],i=this.scrollbarButtons,n=this.scrollbarGroup.element,o=this.track.element,r=this.mouseDownHandler.bind(this),a=this.mouseMoveHandler.bind(this),l=this.mouseUpHandler.bind(this),c=[[i[t[0]].element,"click",this.buttonToMinClick.bind(this)],[i[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[o,"click",this.trackClick.bind(this)],[n,"mousedown",r],[n.ownerDocument,"mousemove",a],[n.ownerDocument,"mouseup",l]];e.hasTouch&&c.push([n,"touchstart",r],[n.ownerDocument,"touchmove",a],[n.ownerDocument,"touchend",l]),c.forEach(function(t){s.apply(null,t)}),this._events=c},t.prototype.buttonToMaxClick=function(t){var e=(this.to-this.from)*u(this.options.step,.2);this.updatePosition(this.from+e,this.to+e),h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var e=a(this.to-this.from)*u(this.options.step,.2);this.updatePosition(a(this.from-e),a(this.to-e)),h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var e=this.options,i=e.minWidth>this.calculatedWidth?e.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-i),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-i)}},t.prototype.destroy=function(){var t=this,e=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(e){t[e]&&t[e].destroy&&(t[e]=t[e].destroy())}),e&&t===e.scrollbar&&(e.scrollbar=null,c(e.scrollbarButtons))},t.prototype.drawScrollbarButton=function(e){var i=this.renderer,n=this.scrollbarButtons,o=this.options,r=this.size,s=i.g().add(this.group);if(n.push(s),o.buttonsEnabled){var a=i.rect().addClass("highcharts-scrollbar-button").add(s);this.chart.styledMode||a.attr({stroke:o.buttonBorderColor,"stroke-width":o.buttonBorderWidth,fill:o.buttonBackgroundColor}),a.attr(a.crisp({x:-.5,y:-.5,width:r+1,height:r+1,r:o.buttonBorderRadius},a.strokeWidth()));var l=i.path(t.swapXY([["M",r/2+(e?-1:1),r/2-3],["L",r/2+(e?-1:1),r/2+3],["L",r/2+(e?2:-2),r/2]],o.vertical)).addClass("highcharts-scrollbar-arrow").add(n[e]);this.chart.styledMode||l.attr({fill:o.buttonArrowColor})}},t.prototype.init=function(t,e,i){this.scrollbarButtons=[],this.renderer=t,this.userOptions=e,this.options=d(n,r.scrollbar,e),this.options.margin=u(this.options.margin,10),this.chart=i,this.size=u(this.options.size,this.options.height),e.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var e=this.chart.pointer.normalize(t),i=this.cursorToScrollbarPosition(e);this.chartX=i.chartX,this.chartY=i.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var e,i=this.chart.pointer.normalize(t),n=this.options.vertical?"chartY":"chartX",o=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][n])&&(e=this.cursorToScrollbarPosition(i)[n]-this[n],this.hasDragged=!0,this.updatePosition(o[0]+e,o[1]+e),this.hasDragged&&h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,e,i,n){var o=this.options,r=o.buttonsEnabled,s=o.margin,a=void 0===s?0:s,l=o.vertical,c=this.rendered?"animate":"attr",h=n,d=0;this.group.show(),this.x=t,this.y=e+this.trackBorderWidth,this.width=i,this.height=n,this.xOffset=h,this.yOffset=d,l?(this.width=this.yOffset=i=d=this.size,this.xOffset=h=0,this.yOffset=d=r?this.size:0,this.barWidth=n-(r?2*i:0),this.x=t+=a):(this.height=n=this.size,this.xOffset=h=r?this.size:0,this.barWidth=i-(r?2*n:0),this.y=this.y+a),this.group[c]({translateX:t,translateY:this.y}),this.track[c]({width:i,height:n}),this.scrollbarButtons[1][c]({translateX:l?0:i-h,translateY:l?n-d:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){p.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var e=this.renderer,i=this.options,n=this.size,o=this.chart.styledMode,r=e.g("scrollbar").attr({zIndex:i.zIndex}).hide().add();this.group=r,this.track=e.rect().addClass("highcharts-scrollbar-track").attr({r:i.trackBorderRadius||0,height:n,width:n}).add(r),o||this.track.attr({fill:i.trackBackgroundColor,stroke:i.trackBorderColor,"stroke-width":i.trackBorderWidth});var s=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-s%2/2,y:-s%2/2}),this.scrollbarGroup=e.g().add(r),this.scrollbar=e.rect().addClass("highcharts-scrollbar-thumb").attr({height:n-s,width:n-s,r:i.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=e.path(t.swapXY([["M",-3,n/4],["L",-3,2*n/3],["M",0,n/4],["L",0,2*n/3],["M",3,n/4],["L",3,2*n/3]],i.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),o||(this.scrollbar.attr({fill:i.barBackgroundColor,stroke:i.barBorderColor,"stroke-width":i.barBorderWidth}),this.scrollbarRifles.attr({stroke:i.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,e){var i,n,o=this.options,r=o.vertical,s=o.minWidth,c=this.barWidth,h=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(l(c)){var d=c*Math.min(e,1);i=Math.ceil(c*(t=Math.max(t,0))),this.calculatedWidth=n=a(d-i),n<s&&(i=(c-s+n)*t,n=s);var u=Math.floor(i+this.xOffset+this.yOffset),p=n/2-.5;this.from=t,this.to=e,r?(this.scrollbarGroup[h]({translateY:u}),this.scrollbar[h]({height:n}),this.scrollbarRifles[h]({translateY:p}),this.scrollbarTop=u,this.scrollbarLeft=0):(this.scrollbarGroup[h]({translateX:u}),this.scrollbar[h]({width:n}),this.scrollbarRifles[h]({translateX:p}),this.scrollbarLeft=u,this.scrollbarTop=0),n<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===o.showFull&&(t<=0&&e>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return u(this.options.liveRedraw,e.svg&&!e.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!l(t)},t.prototype.trackClick=function(t){var e=this.chart.pointer.normalize(t),i=this.to-this.from,n=this.y+this.scrollbarTop,o=this.x+this.scrollbarLeft;this.options.vertical&&e.chartY>n||!this.options.vertical&&e.chartX>o?this.updatePosition(this.from+i,this.to+i):this.updatePosition(this.from-i,this.to-i),h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,d(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,e){e>1&&(t=a(1-a(e-t)),e=1),t<0&&(e=a(e-t),t=0),this.from=t,this.to=e},t.defaultOptions=n,t}();return r.scrollbar=d(!0,g.defaultOptions,r.scrollbar),g}),i(e,"Stock/Navigator/Navigator.js",[e["Core/Axis/Axis.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/NavigatorAxisComposition.js"],e["Stock/Navigator/NavigatorComposition.js"],e["Stock/Scrollbar/Scrollbar.js"],e["Core/Utilities.js"]],function(t,e,i,n,o,r,s){var a=e.defaultOptions,l=i.hasTouch,c=i.isTouchDevice,h=s.addEvent,d=s.clamp,u=s.correctFloat,p=s.defined,g=s.destroyObjectProperties,m=s.erase,f=s.extend,v=s.find,y=s.fireEvent,b=s.isArray,x=s.isNumber,A=s.merge,w=s.pick,C=s.removeEvent,E=s.splat;function T(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];var n=[].filter.call(e,x);if(n.length)return Math[t].apply(0,n)}return function(){function e(t){this.scrollbarHeight=0,this.init(t)}return e.compose=function(t,i,n){o.compose(t,i,e,n)},e.prototype.drawHandle=function(t,e,i,n){var o=this.navigatorOptions.handles.height;this.handles[e][n](i?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-o)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-o/2-1)})},e.prototype.drawOutline=function(t,e,i,n){var o,r,s=this.navigatorOptions.maskInside,a=this.outline.strokeWidth(),l=a/2,c=a%2/2,h=this.scrollButtonSize,d=this.size,u=this.top,p=this.height,g=u-l,m=u+p,f=this.left;i?(o=u+e+c,e=u+t+c,r=[["M",f+p,u-h-c],["L",f+p,o],["L",f,o],["M",f,e],["L",f+p,e],["L",f+p,u+d+h]],s&&r.push(["M",f+p,o-l],["L",f+p,e+l])):(f-=h,t+=f+h-c,e+=f+h-c,r=[["M",f,g],["L",t,g],["L",t,m],["M",e,m],["L",e,g],["L",f+d+2*h,u+l]],s&&r.push(["M",t-l,g],["L",e+l,g])),this.outline[n]({d:r})},e.prototype.drawMasks=function(t,e,i,n){var o,r,s,a,l=this.left,c=this.top,h=this.height;i?(s=[l,l,l],a=[c,c+t,c+e],r=[h,h,h],o=[t,e-t,this.size-e]):(s=[l,l+t,l+e],a=[c,c,c],r=[t,e-t,this.size-e],o=[h,h,h]),this.shades.forEach(function(t,e){t[n]({x:s[e],y:a[e],width:r[e],height:o[e]})})},e.prototype.renderElements=function(){var t=this,e=t.navigatorOptions,i=e.maskInside,n=t.chart,o=n.inverted,r=n.renderer,s={cursor:o?"ns-resize":"ew-resize"},a=t.navigatorGroup=r.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!i,i,!i].forEach(function(i,o){var l=r.rect().addClass("highcharts-navigator-mask"+(1===o?"-inside":"-outside")).add(a);n.styledMode||(l.attr({fill:i?e.maskFill:"rgba(0,0,0,0)"}),1===o&&l.css(s)),t.shades[o]=l}),t.outline=r.path().addClass("highcharts-navigator-outline").add(a),n.styledMode||t.outline.attr({"stroke-width":e.outlineWidth,stroke:e.outlineColor}),e.handles&&e.handles.enabled){var l=e.handles,c=l.height,h=l.width;[0,1].forEach(function(e){t.handles[e]=r.symbol(l.symbols[e],-h/2-1,0,h,c,l),n.inverted&&t.handles[e].attr({rotation:90,rotationOriginX:Math.floor(-h/2),rotationOriginY:(c+h)/2}),t.handles[e].attr({zIndex:7-e}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][e]).add(a),n.styledMode||t.handles[e].attr({fill:l.backgroundColor,stroke:l.borderColor,"stroke-width":l.lineWidth}).css(s)})}},e.prototype.update=function(t){(this.series||[]).forEach(function(t){t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy(),A(!0,this.chart.options.navigator,t),this.init(this.chart)},e.prototype.render=function(t,e,i,n){var o,r,s,a,l,c=this.chart,h=this.xAxis,g=h.pointRange||0,m=h.navigatorAxis.fake?c.xAxis[0]:h,f=this.navigatorEnabled,v=this.rendered,b=c.inverted,A=c.xAxis[0].minRange,C=c.xAxis[0].options.maxRange,E=this.scrollButtonSize,T=this.scrollbarHeight;if(!this.hasDragged||p(i)){if(t=u(t-g/2),e=u(e+g/2),!x(t)||!x(e)){if(!v)return;i=0,n=w(h.width,m.width)}this.left=w(h.left,c.plotLeft+E+(b?c.plotWidth:0));var M=this.size=a=w(h.len,(b?c.plotHeight:c.plotWidth)-2*E);o=b?T:a+2*E,i=w(i,h.toPixels(t,!0)),n=w(n,h.toPixels(e,!0)),x(i)&&Math.abs(i)!==1/0||(i=0,n=o);var S=h.toValue(i,!0),k=h.toValue(n,!0),P=Math.abs(u(k-S));P<A?this.grabbedLeft?i=h.toPixels(k-A-g,!0):this.grabbedRight&&(n=h.toPixels(S+A+g,!0)):p(C)&&u(P-g)>C&&(this.grabbedLeft?i=h.toPixels(k-C-g,!0):this.grabbedRight&&(n=h.toPixels(S+C+g,!0))),this.zoomedMax=d(Math.max(i,n),0,M),this.zoomedMin=d(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(i,n),0,M),this.range=this.zoomedMax-this.zoomedMin,M=Math.round(this.zoomedMax);var D=Math.round(this.zoomedMin);f&&(this.navigatorGroup.attr({visibility:"inherit"}),l=v&&!this.hasDragged?"animate":"attr",this.drawMasks(D,M,b,l),this.drawOutline(D,M,b,l),this.navigatorOptions.handles.enabled&&(this.drawHandle(D,0,b,l),this.drawHandle(M,1,b,l))),this.scrollbar&&(b?(s=this.top-E,r=this.left-T+(f||!m.opposite?0:(m.titleOffset||0)+m.axisTitleMargin),T=a+2*E):(s=this.top+(f?this.height:-T),r=this.left-E),this.scrollbar.position(r,s,o,T),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1))),this.rendered=!0,y(this,"afterRender")}},e.prototype.addMouseEvents=function(){var t,e,i=this,n=i.chart,o=n.container,r=[];i.mouseMoveHandler=t=function(t){i.onMouseMove(t)},i.mouseUpHandler=e=function(t){i.onMouseUp(t)},(r=i.getPartsEvents("mousedown")).push(h(n.renderTo,"mousemove",t),h(o.ownerDocument,"mouseup",e)),l&&(r.push(h(n.renderTo,"touchmove",t),h(o.ownerDocument,"touchend",e)),r.concat(i.getPartsEvents("touchstart"))),i.eventsToUnbind=r,i.series&&i.series[0]&&r.push(h(i.series[0].xAxis,"foundExtremes",function(){n.navigator.modifyNavigatorAxisExtremes()}))},e.prototype.getPartsEvents=function(t){var e=this,i=[];return["shades","handles"].forEach(function(n){e[n].forEach(function(o,r){i.push(h(o.element,t,function(t){e[n+"Mousedown"](t,r)}))})}),i},e.prototype.shadesMousedown=function(t,e){t=this.chart.pointer.normalize(t);var i,n,o,r,s=this.chart,a=this.xAxis,l=this.zoomedMin,c=this.size,h=this.range,d=this.left,u=t.chartX;s.inverted&&(u=t.chartY,d=this.top),1===e?(this.grabbedCenter=u,this.fixedWidth=h,this.dragOffset=u-l):(r=u-d-h/2,0===e?r=Math.max(0,r):2===e&&r+h>=c&&(r=c-h,this.reversedExtremes?(r-=h,n=this.getUnionExtremes().dataMin):i=this.getUnionExtremes().dataMax),r!==l&&(this.fixedWidth=h,p((o=a.navigatorAxis.toFixedRange(r,r+h,n,i)).min)&&s.xAxis[0].setExtremes(Math.min(o.min,o.max),Math.max(o.min,o.max),!0,null,{trigger:"navigator"})))},e.prototype.handlesMousedown=function(t,e){t=this.chart.pointer.normalize(t);var i=this.chart,n=i.xAxis[0],o=this.reversedExtremes;0===e?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=o?n.min:n.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=o?n.max:n.min),i.fixedRange=null},e.prototype.onMouseMove=function(t){var e,i=this,n=i.chart,o=i.navigatorSize,r=i.range,s=i.dragOffset,a=n.inverted,l=i.left;(!t.touches||0!==t.touches[0].pageX)&&(e=(t=n.pointer.normalize(t)).chartX,a&&(l=i.top,e=t.chartY),i.grabbedLeft?(i.hasDragged=!0,i.render(0,0,e-l,i.otherHandlePos)):i.grabbedRight?(i.hasDragged=!0,i.render(0,0,i.otherHandlePos,e-l)):i.grabbedCenter&&(i.hasDragged=!0,e<s?e=s:e>o+s-r&&(e=o+s-r),i.render(0,0,e-s,e-s+r)),i.hasDragged&&i.scrollbar&&w(i.scrollbar.options.liveRedraw,!c&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){i.onMouseUp(t)},0)))},e.prototype.onMouseUp=function(t){var e,i,n,o,r,s,a=this.chart,l=this.xAxis,c=this.scrollbar,h=t.DOMEvent||t,d=a.inverted,u=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!c||!c.hasDragged)||"scrollbar"===t.trigger)&&(n=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?o=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(r=this.fixedExtreme),this.zoomedMax===this.size&&(r=this.reversedExtremes?n.dataMin:n.dataMax),0===this.zoomedMin&&(o=this.reversedExtremes?n.dataMax:n.dataMin),p((s=l.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,o,r)).min)&&a.xAxis[0].setExtremes(Math.min(s.min,s.max),Math.max(s.min,s.max),!0,!this.hasDragged&&null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:h})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&x(this.zoomedMin)&&x(this.zoomedMax)&&(i=Math.round(this.zoomedMin),e=Math.round(this.zoomedMax),this.shades&&this.drawMasks(i,e,d,u),this.outline&&this.drawOutline(i,e,d,u),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(i,0,d,u),this.drawHandle(e,1,d,u)))},e.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},e.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){C(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&C(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},e.prototype.init=function(e){var i=e.options,o=i.navigator||{},s=o.enabled,a=i.scrollbar||{},l=a.enabled,c=s&&o.height||0,d=l&&a.height||0,u=a.buttonsEnabled&&d||0;this.handles=[],this.shades=[],this.chart=e,this.setBaseSeries(),this.height=c,this.scrollbarHeight=d,this.scrollButtonSize=u,this.scrollbarEnabled=l,this.navigatorEnabled=s,this.navigatorOptions=o,this.scrollbarOptions=a,this.opposite=w(o.opposite,!!(!s&&e.inverted));var p=this,g=p.baseSeries,m=e.xAxis.length,f=e.yAxis.length,v=g&&g[0]&&g[0].xAxis||e.xAxis[0]||{options:{}};if(e.isDirtyBox=!0,p.navigatorEnabled?(p.xAxis=new t(e,A({breaks:v.options.breaks,ordinal:v.options.ordinal},o.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:m,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},e.inverted?{offsets:[u,0,-u,0],width:c}:{offsets:[0,-u,0,u],height:c}),"xAxis"),p.yAxis=new t(e,A(o.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:f,isInternal:!0,reversed:w(o.yAxis&&o.yAxis.reversed,e.yAxis[0]&&e.yAxis[0].reversed,!1),zoomEnabled:!1},e.inverted?{width:c}:{height:c}),"yAxis"),g||o.series.data?p.updateNavigatorSeries(!1):0===e.series.length&&(p.unbindRedraw=h(e,"beforeRedraw",function(){e.series.length>0&&!p.series&&(p.setBaseSeries(),p.unbindRedraw())})),p.reversedExtremes=e.inverted&&!p.xAxis.reversed||!e.inverted&&p.xAxis.reversed,p.renderElements(),p.addMouseEvents()):(p.xAxis={chart:e,navigatorAxis:{fake:!0},translate:function(t,i){var n=e.xAxis[0],o=n.getExtremes(),r=n.len-2*u,s=T("min",n.options.min,o.dataMin),a=T("max",n.options.max,o.dataMax)-s;return i?t*a/r+s:r*(t-s)/a},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},p.xAxis.navigatorAxis.axis=p.xAxis,p.xAxis.navigatorAxis.toFixedRange=n.prototype.toFixedRange.bind(p.xAxis.navigatorAxis)),e.options.scrollbar.enabled){var y=A(e.options.scrollbar,{vertical:e.inverted});!x(y.margin)&&p.navigatorEnabled&&(y.margin=e.inverted?-3:3),e.scrollbar=p.scrollbar=new r(e.renderer,y,e),h(p.scrollbar,"changed",function(t){var e=p.size,i=e*this.to,n=e*this.from;p.hasDragged=p.scrollbar.hasDragged,p.render(0,0,n,i),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){p.onMouseUp(t)})})}p.addBaseSeriesEvents(),p.addChartEvents()},e.prototype.getUnionExtremes=function(t){var e,i=this.chart.xAxis[0],n=this.xAxis,o=n.options,r=i.options;return t&&null===i.dataMin||(e={dataMin:w(o&&o.min,T("min",r.min,i.dataMin,n.dataMin,n.min)),dataMax:w(o&&o.max,T("max",r.max,i.dataMax,n.dataMax,n.max))}),e},e.prototype.setBaseSeries=function(t,e){var i=this.chart,n=this.baseSeries=[];t=t||i.options&&i.options.navigator.baseSeries||(i.series.length?v(i.series,function(t){return!t.options.isInternal}).index:0),(i.series||[]).forEach(function(e,i){!e.options.isInternal&&(e.options.showInNavigator||(i===t||e.options.id===t)&&!1!==e.options.showInNavigator)&&n.push(e)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,e)},e.prototype.updateNavigatorSeries=function(t,e){var i,n,o,r=this,s=r.chart,l=r.baseSeries,c={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},h=r.series=(r.series||[]).filter(function(t){var e=t.baseSeries;return!(0>l.indexOf(e))||(e&&(C(e,"updatedData",r.updatedDataHandler),delete e.navigatorSeries),t.chart&&t.destroy(),!1)}),d=r.navigatorOptions.series;l&&l.length&&l.forEach(function(t){var u=t.navigatorSeries,p=f({color:t.color,visible:t.visible},b(d)?a.navigator.series:d);if(!u||!1!==r.navigatorOptions.adaptToUpdatedData){c.name="Navigator "+l.length,o=(i=t.options||{}).navigatorOptions||{},p.dataLabels=E(p.dataLabels),(n=A(i,c,p,o)).pointRange=w(p.pointRange,o.pointRange,a.plotOptions[n.type||"line"].pointRange);var g=o.data||p.data;r.hasNavigatorData=r.hasNavigatorData||!!g,n.data=g||i.data&&i.data.slice(0),u&&u.options?u.update(n,e):(t.navigatorSeries=s.initSeries(n),t.navigatorSeries.baseSeries=t,h.push(t.navigatorSeries))}}),(d.data&&!(l&&l.length)||b(d))&&(r.hasNavigatorData=!1,(d=E(d)).forEach(function(t,e){c.name="Navigator "+(h.length+1),(n=A(a.navigator.series,{color:s.series[e]&&!s.series[e].options.isInternal&&s.series[e].color||s.options.colors[e]||s.options.colors[0]},c,t)).data=t.data,n.data&&(r.hasNavigatorData=!0,h.push(s.initSeries(n)))})),t&&this.addBaseSeriesEvents()},e.prototype.addBaseSeriesEvents=function(){var t=this,e=this,i=e.baseSeries||[];i[0]&&i[0].xAxis&&i[0].eventsToUnbind.push(h(i[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),i.forEach(function(i){i.eventsToUnbind.push(h(i,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),i.eventsToUnbind.push(h(i,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&i.xAxis&&i.eventsToUnbind.push(h(i,"updatedData",t.updatedDataHandler)),i.eventsToUnbind.push(h(i,"remove",function(){this.navigatorSeries&&(m(e.series,this.navigatorSeries),p(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},e.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,e){return Math.min(t,e.xData&&e.xData.length?e.xData[0]:t)},t)},e.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var e=this.getUnionExtremes(!0);e&&(e.dataMin!==t.min||e.dataMax!==t.max)&&(t.min=e.dataMin,t.max=e.dataMax)}},e.prototype.modifyBaseAxisExtremes=function(){var t,e,i=this.chart.navigator,n=this.getExtremes(),o=n.min,r=n.max,s=n.dataMin,a=n.dataMax,l=r-o,c=i.stickToMin,h=i.stickToMax,d=w(this.options.overscroll,0),u=i.series&&i.series[0],p=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(c&&(t=(e=s)+l),h&&(t=a+d,c||(e=Math.max(s,t-l,i.getBaseSeriesMin(u&&u.xData?u.xData[0]:-Number.MAX_VALUE)))),p&&(c||h)&&x(e)&&(this.min=this.userMin=e,this.max=this.userMax=t)),i.stickToMin=i.stickToMax=null},e.prototype.updatedDataHandler=function(){var t=this.chart.navigator,e=this.navigatorSeries,i=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=w(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,i),t.stickToMin=t.shouldStickToMin(this,t),e&&!t.hasNavigatorData&&(e.options.pointStart=this.xData[0],e.setData(this.options.data,!1,null,!1))},e.prototype.shouldStickToMin=function(t,e){var i=e.getBaseSeriesMin(t.xData[0]),n=t.xAxis,o=n.max,r=n.min,s=n.options.range;return!!(x(o)&&x(r))&&(s&&o-i>0?o-i<s:r<=i)},e.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(h(this.chart,"redraw",function(){var t=this.navigator,e=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);e&&t.render(e.min,e.max)}),h(this.chart,"getMargins",function(){var t=this.navigator,e=t.opposite?"plotTop":"marginBottom";this.inverted&&(e=t.opposite?"marginRight":"plotLeft"),this[e]=(this[e]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}))},e.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(m(this.chart.xAxis,this.xAxis),m(this.chart.axes,this.xAxis)),this.yAxis&&(m(this.chart.yAxis,this.yAxis),m(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(e){t[e]&&t[e].destroy&&t[e].destroy(),t[e]=null}),[this.handles].forEach(function(t){g(t)})},e}()}),i(e,"Accessibility/Components/NavigatorComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/Announcer.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Stock/Navigator/Navigator.js"],e["Core/Animation/AnimationUtilities.js"],e["Core/Templating.js"],e["Core/Utilities.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/Utils/ChartUtilities.js"]],function(t,e,i,n,o,r,s,a,l){var c,h=this&&this.__extends||(c=function(t,e){return(c=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}c(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),d=o.animObject,u=r.format,p=s.clamp,g=s.pick,m=s.syncTimeout,f=a.getFakeMouseEvent,v=l.getAxisRangeDescription,y=l.fireEventOnWrappedOrUnwrappedElement;return function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return h(o,t),o.prototype.init=function(){var t=this.chart,i=this;this.announcer=new e(t,"polite"),this.addEvent(n,"afterRender",function(){this.chart===i.chart&&this.chart.renderer&&m(function(){i.proxyProvider.updateGroupProxyElementPositions("navigator"),i.updateHandleValues()},d(g(this.chart.renderer.globalAnimation,!0)).duration)})},o.prototype.onChartUpdate=function(){var t,e,i,n=this,o=this.chart,r=o.options;if(null===(t=r.navigator.accessibility)||void 0===t?void 0:t.enabled){var s=r.accessibility.landmarkVerbosity,a=null===(e=r.lang.accessibility)||void 0===e?void 0:e.navigator.groupLabel;this.proxyProvider.removeGroup("navigator"),this.proxyProvider.addGroup("navigator","div",{role:"all"===s?"region":"group","aria-label":u(a,{chart:o},o)});var l=null===(i=r.lang.accessibility)||void 0===i?void 0:i.navigator.handleLabel;[0,1].forEach(function(t){var e=n.getHandleByIx(t);if(e){var i=n.proxyProvider.addProxyElement("navigator",{click:e},"input",{type:"range","aria-label":u(l,{handleIx:t,chart:o},o)});n[t?"maxHandleProxy":"minHandleProxy"]=i.innerElement,i.innerElement.style.pointerEvents="none",i.innerElement.oninput=function(){return n.updateNavigator()}}}),this.updateHandleValues()}else this.proxyProvider.removeGroup("navigator")},o.prototype.getNavigatorHandleNavigation=function(t){var e=this,n=this,o=this.chart,r=t?this.maxHandleProxy:this.minHandleProxy,s=this.keyCodes;return new i(o,{keyCodeMap:[[[s.left,s.right,s.up,s.down],function(e){if(r){var i=e===s.left||e===s.up?-1:1;r.value=""+p(parseFloat(r.value)+i,0,100),n.updateNavigator(function(){var e=n.getHandleByIx(t);e&&o.setFocusToElement(e,r)})}return this.response.success}]],init:function(){o.setFocusToElement(e.getHandleByIx(t),r)},validate:function(){var i;return!!(e.getHandleByIx(t)&&r&&(null===(i=o.options.navigator.accessibility)||void 0===i?void 0:i.enabled))}})},o.prototype.getKeyboardNavigation=function(){return[this.getNavigatorHandleNavigation(0),this.getNavigatorHandleNavigation(1)]},o.prototype.destroy=function(){this.updateNavigatorThrottleTimer&&clearTimeout(this.updateNavigatorThrottleTimer),this.proxyProvider.removeGroup("navigator"),this.announcer&&this.announcer.destroy()},o.prototype.updateHandleValues=function(){var t=this.chart.navigator;if(t&&this.minHandleProxy&&this.maxHandleProxy){var e=t.size;this.minHandleProxy.value=""+Math.round(t.zoomedMin/e*100),this.maxHandleProxy.value=""+Math.round(t.zoomedMax/e*100)}},o.prototype.getHandleByIx=function(t){var e=this.chart.navigator;return e&&e.handles&&e.handles[t]},o.prototype.updateNavigator=function(t){var e=this;this.updateNavigatorThrottleTimer&&clearTimeout(this.updateNavigatorThrottleTimer),this.updateNavigatorThrottleTimer=setTimeout((function(t){var i,n=e.chart,o=n.navigator;if(o&&e.minHandleProxy&&e.maxHandleProxy){var r=n.pointer.getChartPosition(),s=parseFloat(e.minHandleProxy.value)/100*o.size,a=parseFloat(e.maxHandleProxy.value)/100*o.size;[[0,"mousedown",o.zoomedMin],[0,"mousemove",s],[0,"mouseup",s],[1,"mousedown",o.zoomedMax],[1,"mousemove",a],[1,"mouseup",a]].forEach(function(t){var i,n=t[0],s=t[1],a=t[2],l=null===(i=e.getHandleByIx(n))||void 0===i?void 0:i.element;l&&y(l,f(s,{x:r.left+o.left+a,y:r.top+o.top},l))}),t&&t();var l=null===(i=n.options.lang.accessibility)||void 0===i?void 0:i.navigator.changeAnnouncement,c=v(n.xAxis[0]);e.announcer.announce(u(l,{axisRangeDescription:c,chart:n},n))}}).bind(this,t),20)},o}(t)}),i(e,"Accessibility/Components/SeriesComponent/SeriesDescriber.js",[e["Accessibility/Components/AnnotationsA11y.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Core/Templating.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r=t.getPointAnnotationTexts,s=e.getAxisDescription,a=e.getSeriesFirstPointElement,l=e.getSeriesA11yElement,c=e.unhideChartElementFromAT,h=i.format,d=i.numberFormat,u=n.reverseChildNodes,p=n.stripHTMLTagsFromString,g=o.find,m=o.isNumber,f=o.isString,v=o.pick,y=o.defined;function b(t){var e=t.chart.options.accessibility.series.pointDescriptionEnabledThreshold;return!!(!1!==e&&t.points&&t.points.length>=+e)}function x(t,e){var i=t.series,n=i.chart,o=n.options.accessibility.point||{},r=i.options.accessibility&&i.options.accessibility.point||{},s=i.tooltipOptions||{},a=n.options.lang;return m(e)?d(e,r.valueDecimals||o.valueDecimals||s.valueDecimals||-1,a.decimalPoint,a.accessibility.thousandsSep||a.thousandsSep):e}function A(t,e){var i=t[e];return t.chart.langFormat("accessibility.series."+e+"Description",{name:s(i),series:t})}function w(t){var e,i,n,o,s,a,l,c,d,u,p,g,m,f,b,A,w,C,E,T,M,S,k,P,D=t.series,B=D.chart.series.length>1||D.options.name,N=(C=(w=t.series).chart,T=(E=w.options.accessibility)&&E.point&&E.point.valueDescriptionFormat||C.options.accessibility.point.valueDescriptionFormat,S=(M=v(w.xAxis&&w.xAxis.options.accessibility&&w.xAxis.options.accessibility.enabled,!C.angular&&"flowmap"!==w.type))?(m=function(t){var e=t.series,i=e.chart,n=e.options.accessibility&&e.options.accessibility.point||{},o=i.options.accessibility.point||{},r=e.xAxis&&e.xAxis.dateTime;if(r){var s=r.getXDateFormat(t.x||0,i.options.tooltip.dateTimeLabelFormats),a=n.dateFormatter&&n.dateFormatter(t)||o.dateFormatter&&o.dateFormatter(t)||n.dateFormat||o.dateFormat||s;return i.time.dateFormat(a,t.x||0,void 0)}}(t),f=(t.series.xAxis||{}).categories&&y(t.category)&&(""+t.category).replace("<br/>"," "),b=y(t.id)&&0>(""+t.id).indexOf("highcharts-"),A="x, "+t.x,t.name||m||f||(b?t.id:A)):"",h(T,{point:t,index:y(t.index)?t.index+1:"",xDescription:S,value:(a=(s=(e=t).series).chart.options.accessibility.point||{},l=s.chart.options.accessibility&&s.chart.options.accessibility.point||{},c=s.tooltipOptions||{},d=l.valuePrefix||a.valuePrefix||c.valuePrefix||"",u=l.valueSuffix||a.valueSuffix||c.valueSuffix||"",p=void 0!==e.value?"value":"y",g=x(e,e[p]),e.isNull?s.chart.langFormat("accessibility.series.nullPointValue",{point:e}):s.pointArrayMap?(i=d||"",n=u||"",o=function(t){var o=x(e,v(e[t],e.options[t]));return void 0!==o?t+": "+i+o+n:o},e.series.pointArrayMap.reduce(function(t,e){var i=o(e);return i?t+(t.length?", ":"")+i:t},"")):d+g+u),separator:M?", ":""},C)),I=t.options&&t.options.accessibility&&t.options.accessibility.description,j=B?" "+D.name+".":"",O=(k=t.series.chart,(P=r(t)).length?k.langFormat("accessibility.series.pointAnnotationsDescription",{point:t,annotations:P}):"");return t.accessibility=t.accessibility||{},t.accessibility.valueDescription=N,N+(I?" "+I:"")+j+(O?" "+O:"")}function C(t){var e,i=t.chart,n=i.types||[],o=(e=(t.options.accessibility||{}).description)&&t.chart.langFormat("accessibility.series.description",{description:e,series:t})||"",r=function(e){return i[e]&&i[e].length>1&&t[e]},s=t.index+1,a=A(t,"xAxis"),l=A(t,"yAxis"),c={seriesNumber:s,series:t,chart:i},d=n.length>1?"Combination":"",u=i.langFormat("accessibility.series.summary."+t.type+d,c)||i.langFormat("accessibility.series.summary.default"+d,c),p=(r("yAxis")?" "+l+".":"")+(r("xAxis")?" "+a+".":"");return h(v(t.options.accessibility&&t.options.accessibility.descriptionFormat,i.options.accessibility.series.descriptionFormat,""),{seriesDescription:u,authorDescription:o?" "+o:"",axisDescription:p,series:t,chart:i,seriesNumber:s},void 0)}return{defaultPointDescriptionFormatter:w,defaultSeriesDescriptionFormatter:C,describeSeries:function(t){var e,i,n,o,r,s,d,m,x,A,E,T,M,S,k=t.chart,P=a(t),D=l(t),B=k.is3d&&k.is3d();D&&((D.lastChild!==P||B||u(D),e=t.options.accessibility||{},n=!b(t)&&!e.exposeAsGroupOnly,i=t.chart.options.accessibility.keyboardNavigation.seriesNavigation,o=!!(t.points&&(t.points.length<+i.pointNavigationEnabledThreshold||!1===i.pointNavigationEnabledThreshold)),r=t.chart.options.accessibility.point.describeNull,(n||o)&&t.points.forEach(function(e){var i,o,s,a,l,c,d,u,m,b,x,A,C=e.graphic&&e.graphic.element||(o=(i=e.series)&&i.chart,s=i&&i.is("sunburst"),a=e.isNull,l=o&&o.options.accessibility.point.describeNull,a&&!s&&l&&function(t){var e,i,n=t.series,o=(e=t.index,t.series&&t.series.data&&y(e)&&g(t.series.data,function(t){return!!(t&&void 0!==t.index&&t.index>e&&t.graphic&&t.graphic.element)})||null),r=o&&o.graphic,s=r?r.parentGroup:n.graph||n.group,a=o?{x:v(t.plotX,o.plotX,0),y:v(t.plotY,o.plotY,0)}:{x:v(t.plotX,0),y:v(t.plotY,0)},l=((i=t.series.chart.renderer.rect(a.x,a.y,1,1)).attr({class:"highcharts-a11y-mock-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),i);if(s&&s.element)return t.graphic=l,t.hasMockGraphic=!0,l.add(s),s.element.insertBefore(l.element,r?r.element:null),l.element}(e)),E=e.options&&e.options.accessibility&&!1===e.options.accessibility.enabled;if(C){if(e.isNull&&!r){C.setAttribute("aria-hidden",!0);return}(C.setAttribute("tabindex","-1"),t.chart.styledMode||(C.style.outline="none"),n&&!E)?(b=(null===(c=(m=e.series).options.accessibility)||void 0===c?void 0:c.point)||{},x=m.chart.options.accessibility.point||{},A=p(f(b.descriptionFormat)&&h(b.descriptionFormat,e,m.chart)||(null===(d=b.descriptionFormatter)||void 0===d?void 0:d.call(b,e))||f(x.descriptionFormat)&&h(x.descriptionFormat,e,m.chart)||(null===(u=x.descriptionFormatter)||void 0===u?void 0:u.call(x,e))||w(e),m.chart.renderer.forExport),C.setAttribute("role","img"),C.setAttribute("aria-label",A)):C.setAttribute("aria-hidden",!0)}}),c(k,D),m=(d=(s=t.chart).options.chart).options3d&&d.options3d.enabled,x=s.series.length>1,A=s.options.accessibility.series.describeSingleSeries,E=(t.options.accessibility||{}).exposeAsGroupOnly,!(m&&x)&&(x||A||E||b(t)))?(T=t.options.accessibility||{},S=(M=t.chart.options.accessibility).landmarkVerbosity,T.exposeAsGroupOnly?D.setAttribute("role","img"):"all"===S?D.setAttribute("role","region"):D.setAttribute("role","group"),D.setAttribute("tabindex","-1"),t.chart.styledMode||(D.style.outline="none"),D.setAttribute("aria-label",p(M.series.descriptionFormatter&&M.series.descriptionFormatter(t)||C(t),t.chart.renderer.forExport))):D.removeAttribute("aria-label"))}}}),i(e,"Accessibility/Components/SeriesComponent/NewDataAnnouncer.js",[e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/Utils/Announcer.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Components/SeriesComponent/SeriesDescriber.js"]],function(t,e,i,n,o,r){var s=t.composed,a=e.addEvent,l=e.defined,c=e.pushUnique,h=n.getChartTitle,d=r.defaultPointDescriptionFormatter,u=r.defaultSeriesDescriptionFormatter;function p(t){return!!t.options.accessibility.announceNewData.enabled}var g=function(){function e(t){this.dirty={allSeries:{}},this.lastAnnouncementTime=0,this.chart=t}return e.prototype.init=function(){var t=this.chart,e=t.options.accessibility.announceNewData.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new o,this.announcer=new i(t,e),this.addEventListeners()},e.prototype.destroy=function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},e.prototype.addEventListeners=function(){var t=this,e=this.chart,i=this.eventProvider;i.addEvent(e,"afterApplyDrilldown",function(){t.lastAnnouncementTime=0}),i.addEvent(e,"afterAddSeries",function(e){t.onSeriesAdded(e.series)}),i.addEvent(e,"redraw",function(){t.announceDirtyData()})},e.prototype.onSeriesAdded=function(t){p(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[t.name+t.index]=t,this.dirty.newSeries=l(this.dirty.newSeries)?void 0:t)},e.prototype.announceDirtyData=function(){var t=this.chart,e=this;if(t.options.accessibility.announceNewData&&this.dirty.hasDirty){var i,n,o=this.dirty.newPoint;o&&(o=1===(n=(i=o).series.data.filter(function(t){return i.x===t.x&&i.y===t.y})).length?n[0]:i),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(t){return e.dirty.allSeries[t]}),this.dirty.newSeries,o),this.dirty={allSeries:{}}}},e.prototype.queueAnnouncement=function(t,e,i){var n=this,o=this.chart.options.accessibility.announceNewData;if(o.enabled){var r,s=+new Date,a=s-this.lastAnnouncementTime,l=Math.max(0,o.minAnnounceInterval-a),c=Object.keys(r=(this.queuedAnnouncement&&this.queuedAnnouncement.series||[]).concat(t||[]).reduce(function(t,e){return t[e.name+e.index]=e,t},{})).map(function(t){return r[t]}),h=this.buildAnnouncementMessage(c,e,i);h&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:s,message:h,series:c},this.queuedAnnouncementTimer=setTimeout(function(){n&&n.announcer&&(n.lastAnnouncementTime=+new Date,n.announcer.announce(n.queuedAnnouncement.message),delete n.queuedAnnouncement,delete n.queuedAnnouncementTimer)},l))}},e.prototype.buildAnnouncementMessage=function(e,i,n){var o=this.chart,r=o.options.accessibility.announceNewData;if(r.announcementFormatter){var s=r.announcementFormatter(e,i,n);if(!1!==s)return s.length?s:null}var a=t.charts&&t.charts.length>1?"Multiple":"Single",l=i?"newSeriesAnnounce"+a:n?"newPointAnnounce"+a:"newDataAnnounce",c=h(o);return o.langFormat("accessibility.announceNewData."+l,{chartTitle:c,seriesDesc:i?u(i):null,pointDesc:n?d(n):null,point:n,series:i})},e}();return function(t){function e(t){var e=this.chart,i=this.newDataAnnouncer;i&&i.chart===e&&p(e)&&(i.dirty.newPoint=l(i.dirty.newPoint)?void 0:t.point)}function i(){var t=this.chart,e=this.newDataAnnouncer;e&&e.chart===t&&p(t)&&(e.dirty.hasDirty=!0,e.dirty.allSeries[this.name+this.index]=this)}t.compose=function t(n){c(s,t)&&(a(n,"addPoint",e),a(n,"updatedData",i))}}(g||(g={})),g}),i(e,"Accessibility/ProxyElement.js",[e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o){var r=t.doc,s=e.attr,a=e.css,l=e.merge,c=n.fireEventOnWrappedOrUnwrappedElement,h=o.cloneMouseEvent,d=o.cloneTouchEvent,u=o.getFakeMouseEvent,p=o.removeElement;return function(){function t(t,e,n,o,s){void 0===n&&(n="button"),this.chart=t,this.target=e,this.eventProvider=new i;var a=this.innerElement=r.createElement(n),l=this.element=o?r.createElement(o):a;t.styledMode||this.hideElementVisually(a),o&&("li"!==o||t.styledMode||(l.style.listStyle="none"),l.appendChild(a),this.element=l),this.updateTarget(e,s)}return t.prototype.click=function(){var t=this.getTargetPosition();t.x+=t.width/2,t.y+=t.height/2;var e=u("click",t);c(this.target.click,e)},t.prototype.updateTarget=function(t,e){this.target=t,this.updateCSSClassName();var i=e||{};Object.keys(i).forEach(function(t){null===i[t]&&delete i[t]});var n=this.getTargetAttr(t.click,"aria-label");s(this.innerElement,l(n?{"aria-label":n}:{},i)),this.eventProvider.removeAddedEvents(),this.addProxyEventsToElement(this.innerElement,t.click),this.refreshPosition()},t.prototype.refreshPosition=function(){var t=this.getTargetPosition();a(this.innerElement,{width:(t.width||1)+"px",height:(t.height||1)+"px",left:(Math.round(t.x)||0)+"px",top:(Math.round(t.y)||0)+"px"})},t.prototype.remove=function(){this.eventProvider.removeAddedEvents(),p(this.element)},t.prototype.updateCSSClassName=function(){var t=function(t){return t.indexOf("highcharts-no-tooltip")>-1},e=this.chart.legend,i=e.group&&e.group.div,n=t(i&&i.className||""),o=t(this.getTargetAttr(this.target.click,"class")||"");this.innerElement.className=n||o?"highcharts-a11y-proxy-element highcharts-no-tooltip":"highcharts-a11y-proxy-element"},t.prototype.addProxyEventsToElement=function(t,e){var i=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(n){var o=0===n.indexOf("touch");i.eventProvider.addEvent(t,n,function(t){var i=o?d(t):h(t);e&&c(e,i),t.stopPropagation(),o||t.preventDefault()},{passive:!1})})},t.prototype.hideElementVisually=function(t){a(t,{borderWidth:0,backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:.001,filter:"alpha(opacity=1)",zIndex:999,overflow:"hidden",padding:0,margin:0,display:"block",position:"absolute","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"})},t.prototype.getTargetPosition=function(){var t=this.target.click,e=t.element?t.element:t,i=this.target.visual||e;if(this.chart.renderTo&&i&&i.getBoundingClientRect){var n=i.getBoundingClientRect(),o=this.chart.pointer.getChartPosition();return{x:(n.left-o.left)/o.scaleX,y:(n.top-o.top)/o.scaleY,width:n.right/o.scaleX-n.left/o.scaleX,height:n.bottom/o.scaleY-n.top/o.scaleY}}return{x:0,y:0,width:1,height:1}},t.prototype.getTargetAttr=function(t,e){return t.element?t.element.getAttribute(e):t.getAttribute(e)},t}()}),i(e,"Accessibility/ProxyProvider.js",[e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/DOMElementProvider.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/ProxyElement.js"]],function(t,e,i,n,o,r){var s=t.doc,a=e.attr,l=e.css,c=i.unhideChartElementFromAT,h=o.removeElement,d=o.removeChildNodes;return function(){function t(t){this.chart=t,this.domElementProvider=new n,this.groups={},this.groupOrder=[],this.beforeChartProxyPosContainer=this.createProxyPosContainer("before"),this.afterChartProxyPosContainer=this.createProxyPosContainer("after"),this.update()}return t.prototype.addProxyElement=function(t,e,i,n){void 0===i&&(i="button");var o=this.groups[t];if(!o)throw Error("ProxyProvider.addProxyElement: Invalid group key "+t);var s="ul"===o.type||"ol"===o.type?"li":void 0,a=new r(this.chart,e,i,s,n);return o.proxyContainerElement.appendChild(a.element),o.proxyElements.push(a),a},t.prototype.addGroup=function(t,e,i){void 0===e&&(e="div");var n,o=this.groups[t];if(o)return o.groupElement;var r=this.domElementProvider.createElement(e);return i&&i.role&&"div"!==e?(n=this.domElementProvider.createElement("div")).appendChild(r):n=r,n.className="highcharts-a11y-proxy-group highcharts-a11y-proxy-group-"+t.replace(/\W/g,"-"),this.groups[t]={proxyContainerElement:r,groupElement:n,type:e,proxyElements:[]},a(n,i||{}),"ul"===e&&r.setAttribute("role","list"),this.afterChartProxyPosContainer.appendChild(n),this.updateGroupOrder(this.groupOrder),n},t.prototype.updateGroupAttrs=function(t,e){var i=this.groups[t];if(!i)throw Error("ProxyProvider.updateGroupAttrs: Invalid group key "+t);a(i.groupElement,e)},t.prototype.updateGroupOrder=function(t){var e=this;if(this.groupOrder=t.slice(),!this.isDOMOrderGroupOrder()){var i=t.indexOf("series"),n=i>-1?t.slice(0,i):t,o=i>-1?t.slice(i+1):[],r=s.activeElement;["before","after"].forEach(function(t){var i=e["before"===t?"beforeChartProxyPosContainer":"afterChartProxyPosContainer"];d(i),("before"===t?n:o).forEach(function(t){var n=e.groups[t];n&&i.appendChild(n.groupElement)})}),(this.beforeChartProxyPosContainer.contains(r)||this.afterChartProxyPosContainer.contains(r))&&r&&r.focus&&r.focus()}},t.prototype.clearGroup=function(t){var e=this.groups[t];if(!e)throw Error("ProxyProvider.clearGroup: Invalid group key "+t);d(e.proxyContainerElement)},t.prototype.removeGroup=function(t){var e=this.groups[t];e&&(h(e.groupElement),delete this.groups[t])},t.prototype.update=function(){this.updatePosContainerPositions(),this.updateGroupOrder(this.groupOrder),this.updateProxyElementPositions()},t.prototype.updateProxyElementPositions=function(){Object.keys(this.groups).forEach(this.updateGroupProxyElementPositions.bind(this))},t.prototype.updateGroupProxyElementPositions=function(t){var e=this.groups[t];e&&e.proxyElements.forEach(function(t){return t.refreshPosition()})},t.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},t.prototype.createProxyPosContainer=function(t){var e=this.domElementProvider.createElement("div");return e.setAttribute("aria-hidden","false"),e.className="highcharts-a11y-proxy-container"+(t?"-"+t:""),l(e,{top:"0",left:"0"}),this.chart.styledMode||(e.style.whiteSpace="nowrap",e.style.position="absolute"),e},t.prototype.getCurrentGroupOrderInDOM=function(){var t=this,e=function(e){for(var i=Object.keys(t.groups),n=i.length;n--;){var o=i[n],r=t.groups[o];if(r&&e===r.groupElement)return o}},i=function(t){for(var i=[],n=t.children,o=0;o<n.length;++o){var r=e(n[o]);r&&i.push(r)}return i},n=i(this.beforeChartProxyPosContainer),o=i(this.afterChartProxyPosContainer);return n.push("series"),n.concat(o)},t.prototype.isDOMOrderGroupOrder=function(){var t=this,e=this.getCurrentGroupOrderInDOM(),i=this.groupOrder.filter(function(e){return"series"===e||!!t.groups[e]}),n=e.length;if(n!==i.length)return!1;for(;n--;)if(e[n]!==i[n])return!1;return!0},t.prototype.updatePosContainerPositions=function(){var t=this.chart;if(!t.renderer.forExport){var e=t.renderer.box;t.container.insertBefore(this.afterChartProxyPosContainer,e.nextSibling),t.container.insertBefore(this.beforeChartProxyPosContainer,e),c(this.chart,this.afterChartProxyPosContainer),c(this.chart,this.beforeChartProxyPosContainer)}},t}()}),i(e,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}}),i(e,"Stock/RangeSelector/RangeSelectorComposition.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Stock/RangeSelector/RangeSelectorDefaults.js"],e["Core/Utilities.js"]],function(t,e,i,n){var o,r=t.defaultOptions,s=e.composed,a=n.addEvent,l=n.defined,c=n.extend,h=n.find,d=n.isNumber,u=n.merge,p=n.pick,g=n.pushUnique,m=[];function f(){var t,e,i=this.range,n=i.type,o=this.max,r=this.chart.time,s=function(t,e){var i="year"===n?"FullYear":"Month",o=new r.Date(t),s=r.get(i,o);return r.set(i,o,s+e),s===r.get(i,o)&&r.set("Date",o,0),o.getTime()-t};d(i)?(t=o-i,e=i):i&&(t=o+s(o,-(i.count||1)),this.chart&&(this.chart.fixedRange=o-t));var a=p(this.dataMin,Number.MIN_VALUE);return d(t)||(t=a),t<=a&&(t=a,void 0===e&&(e=s(t,i.count)),this.newMax=Math.min(t+e,p(this.dataMax,Number.MAX_VALUE))),d(o)?!d(i)&&i&&i._offsetMin&&(t+=i._offsetMin):t=void 0,t}function v(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new o(this))}function y(){var t=this.axes,e=this.rangeSelector;if(e){d(e.deferredYTDClick)&&(e.clickButton(e.deferredYTDClick),delete e.deferredYTDClick),t.forEach(function(t){t.updateNames(),t.setScale()}),this.getAxisMargins(),e.render();var i=e.options.verticalAlign;e.options.floating||("bottom"===i?this.extraBottomMargin=!0:"middle"===i||(this.extraTopMargin=!0))}}function b(t){var e,i,n,o,r=t.rangeSelector,s=function(){r&&(e=t.xAxis[0].getExtremes(),i=t.legend,o=r&&r.options.verticalAlign,d(e.min)&&r.render(e.min,e.max),i.display&&"top"===o&&o===i.options.verticalAlign&&(n=u(t.spacingBox),"vertical"===i.options.layout?n.y=t.plotTop:n.y+=r.getHeight(),i.group.placed=!1,i.align(n)))};r&&(h(m,function(e){return e[0]===t})||m.push([t,[a(t.xAxis[0],"afterSetExtremes",function(t){r&&r.render(t.min,t.max)}),a(t,"redraw",s)]]),s())}function x(){for(var t=0,e=m.length;t<e;++t){var i=m[t];if(i[0]===this){i[1].forEach(function(t){return t()}),m.splice(t,1);return}}}function A(){var t=this.rangeSelector;if(t){var e=t.getHeight();this.extraTopMargin&&(this.plotTop+=e),this.extraBottomMargin&&(this.marginBottom+=e)}}function w(){var t=this.rangeSelector;if(t&&!t.options.floating){t.render();var e=t.options.verticalAlign;"bottom"===e?this.extraBottomMargin=!0:"middle"!==e&&(this.extraTopMargin=!0)}}function C(t){var e=t.options.rangeSelector,i=this.extraBottomMargin,n=this.extraTopMargin,r=this.rangeSelector;if(e&&e.enabled&&!l(r)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=r=new o(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,r){b(this);var s=e&&e.verticalAlign||r.options&&r.options.verticalAlign;r.options.floating||("bottom"===s?this.extraBottomMargin=!0:"middle"===s||(this.extraTopMargin=!0)),(this.extraBottomMargin!==i||this.extraTopMargin!==n)&&(this.isDirtyBox=!0)}}return{compose:function t(e,n,l){if(o=l,g(s,t)){var h=n.prototype;e.prototype.minFromRange=f,a(n,"afterGetContainer",v),a(n,"beforeRender",y),a(n,"destroy",x),a(n,"getMargins",A),a(n,"render",w),a(n,"update",C),h.callbacks.push(b),c(r,{rangeSelector:i.rangeSelector}),c(r.lang,i.lang)}}}}),i(e,"Stock/RangeSelector/RangeSelector.js",[e["Core/Axis/Axis.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Stock/RangeSelector/RangeSelectorComposition.js"],e["Core/Renderer/SVG/SVGElement.js"],e["Core/Utilities.js"]],function(t,e,i,n,o,r){var s=e.defaultOptions,a=r.addEvent,l=r.createElement,c=r.css,h=r.defined,d=r.destroyObjectProperties,u=r.discardElement,p=r.extend,g=r.fireEvent,m=r.isNumber,f=r.merge,v=r.objectEach,y=r.pad,b=r.pick,x=r.pInt,A=r.splat,w=function(){function e(t){this.buttonOptions=e.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.chart=t,this.init(t)}return e.compose=function(t,i){n.compose(t,i,e)},e.prototype.clickButton=function(e,i){var n,o,r,s,l,c,d,u=this.chart,p=this.buttonOptions[e],f=u.xAxis[0],v=u.scroller&&u.scroller.getUnionExtremes()||f||{},y=p.type,x=p.dataGrouping,w=v.dataMin,C=v.dataMax,E=f&&Math.round(Math.min(f.max,b(C,f.max))),T=p._range,M=!0;if(null!==w&&null!==C){if(u.fixedRange=T,this.setSelected(e),x&&(this.forcedDataGrouping=!0,t.prototype.setDataGrouping.call(f||{chart:this.chart},x,!1),this.frozenStates=p.preserveDataGrouping),"month"===y||"year"===y)f?(c={range:p,max:E,chart:u,dataMin:w,dataMax:C},n=f.minFromRange.call(c),m(c.newMax)&&(E=c.newMax),M=!1):T=p;else if(T)E=Math.min((n=Math.max(E-T,w))+T,C),M=!1;else if("ytd"===y){if(f)(void 0===C||void 0===w)&&(w=Number.MAX_VALUE,C=Number.MIN_VALUE,u.series.forEach(function(t){var e=t.xData;e&&(w=Math.min(e[0],w),C=Math.max(e[e.length-1],C))}),i=!1),n=r=(d=this.getYTDExtremes(C,w,u.time.useUTC)).min,E=d.max;else{this.deferredYTDClick=e;return}}else"all"===y&&f&&(u.navigator&&u.navigator.baseSeries[0]&&(u.navigator.baseSeries[0].xAxis.options.range=void 0),n=w,E=C);M&&p._offsetMin&&h(n)&&(n+=p._offsetMin),p._offsetMax&&h(E)&&(E+=p._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=e+1),f?f.setExtremes(n,E,b(i,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:p}):(l=(o=A(u.options.xAxis)[0]).range,o.range=T,s=o.min,o.min=r,a(u,"load",function(){o.range=l,o.min=s})),g(this,"afterBtnClick")}},e.prototype.setSelected=function(t){this.selected=this.options.selected=t},e.prototype.init=function(t){var e=this,i=t.options.rangeSelector,n=i.buttons||e.defaultButtons.slice(),o=i.selected,r=function(){var t=e.minInput,i=e.maxInput;t&&t.blur&&g(t,"blur"),i&&i.blur&&g(i,"blur")};e.chart=t,e.options=i,e.buttons=[],e.buttonOptions=n,this.eventsToUnbind=[],this.eventsToUnbind.push(a(t.container,"mousedown",r)),this.eventsToUnbind.push(a(t,"resize",r)),n.forEach(e.computeButtonRange),void 0!==o&&n[o]&&this.clickButton(o,!1),this.eventsToUnbind.push(a(t,"load",function(){t.xAxis&&t.xAxis[0]&&a(t.xAxis[0],"setExtremes",function(i){this.max-this.min!==t.fixedRange&&"rangeSelectorButton"!==i.trigger&&"updatedData"!==i.trigger&&e.forcedDataGrouping&&!e.frozenStates&&this.setDataGrouping(!1,!1)})}))},e.prototype.updateButtonStates=function(){var t=this,e=this.chart,i=this.dropdown,n=e.xAxis[0],o=Math.round(n.max-n.min),r=!n.hasVisibleSeries,s=24*36e5,a=e.scroller&&e.scroller.getUnionExtremes()||n,l=a.dataMin,c=a.dataMax,d=t.getYTDExtremes(c,l,e.time.useUTC),u=d.min,p=d.max,g=t.selected,f=t.options.allButtonsEnabled,v=t.buttons,y=m(g),b=!1;t.buttonOptions.forEach(function(e,a){var d=e._range,m=e.type,x=e.count||1,A=v[a],w=e._offsetMax-e._offsetMin,C=a===g,E=d>c-l,T=d<n.minRange,M=0,S=!1,k=!1,P=d===o;C&&E&&(b=!0),("month"===m||"year"===m)&&o+36e5>=({month:28,year:365})[m]*s*x-w&&o-36e5<=({month:31,year:366})[m]*s*x+w?P=!0:"ytd"===m?(P=p-u+w===o,S=!C):"all"===m&&(P=n.max-n.min>=c-l,k=!C&&y&&P);var D=!f&&!(b&&"all"===m)&&(E||T||k||r),B=b&&"all"===m||C&&P||P&&!y&&!S||C&&t.frozenStates;D?M=3:B&&(y=!0,M=2),A.state!==M&&(A.setState(M),i&&(i.options[a+1].disabled=D,2===M&&(i.selectedIndex=a+1)),0===M&&g===a?t.setSelected():(2===M&&!h(g)||b)&&t.setSelected(a))})},e.prototype.computeButtonRange=function(t){var e=t.type,i=t.count||1,n={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};n[e]?t._range=n[e]*i:("month"===e||"year"===e)&&(t._range=24*({month:30,year:365})[e]*36e5*i),t._offsetMin=b(t.offsetMin,0),t._offsetMax=b(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin},e.prototype.getInputValue=function(t){var e="min"===t?this.minInput:this.maxInput,i=this.chart.options.rangeSelector,n=this.chart.time;return e?("text"===e.type&&i.inputDateParser||this.defaultInputDateParser)(e.value,n.useUTC,n):0},e.prototype.setInputValue=function(t,e){var i=this.options,n=this.chart.time,o="min"===t?this.minInput:this.maxInput,r="min"===t?this.minDateBox:this.maxDateBox;if(o){var s=o.getAttribute("data-hc-time"),a=h(s)?Number(s):void 0;if(h(e)){var l=a;h(l)&&o.setAttribute("data-hc-time-previous",l),o.setAttribute("data-hc-time",e),a=e}o.value=n.dateFormat(this.inputTypeFormats[o.type]||i.inputEditDateFormat,a),r&&r.attr({text:n.dateFormat(i.inputDateFormat,a)})}},e.prototype.setInputExtremes=function(t,e,i){var n="min"===t?this.minInput:this.maxInput;if(n){var o=this.inputTypeFormats[n.type],r=this.chart.time;if(o){var s=r.dateFormat(o,e);n.min!==s&&(n.min=s);var a=r.dateFormat(o,i);n.max!==a&&(n.max=a)}}},e.prototype.showInput=function(t){var e="min"===t?this.minDateBox:this.maxDateBox,i="min"===t?this.minInput:this.maxInput;if(i&&e&&this.inputGroup){var n="text"===i.type,o=this.inputGroup,r=o.translateX,s=void 0===r?0:r,a=o.translateY,l=void 0===a?0:a,h=e.x,d=void 0===h?0:h,u=e.width,p=void 0===u?0:u,g=e.height,m=void 0===g?0:g,f=this.options.inputBoxWidth;c(i,{width:n?p+(f?-2:20)+"px":"auto",height:m-2+"px",border:"2px solid silver"}),n&&f?c(i,{left:s+d+"px",top:l+"px"}):c(i,{left:Math.min(Math.round(d+s-(i.offsetWidth-p)/2),this.chart.chartWidth-i.offsetWidth)+"px",top:l-(i.offsetHeight-m)/2+"px"})}},e.prototype.hideInput=function(t){var e="min"===t?this.minInput:this.maxInput;e&&c(e,{top:"-9999em",border:0,width:"1px",height:"1px"})},e.prototype.defaultInputDateParser=function(t,e,n){var o,r=t.split("/").join("-").split(" ").join("T");if(-1===r.indexOf("T")&&(r+="T00:00"),e)r+="Z";else if(i.isSafari&&!((o=r).length>6&&(o.lastIndexOf("-")===o.length-6||o.lastIndexOf("+")===o.length-6))){var s=new Date(r).getTimezoneOffset()/60;r+=s<=0?"+".concat(y(-s),":00"):"-".concat(y(s),":00")}var a=Date.parse(r);if(!m(a)){var l=t.split("-");a=Date.UTC(x(l[0]),x(l[1])-1,x(l[2]))}return n&&e&&m(a)&&(a+=n.getTimezoneOffset(a)),a},e.prototype.drawInput=function(t){var e=this.chart,n=this.div,o=this.inputGroup,r=this,a=e.renderer.style||{},h=e.renderer,d=e.options.rangeSelector,u=s.lang,g="min"===t;function v(){var i=r.maxInput,n=r.minInput,o=e.xAxis[0],s=e.scroller&&e.scroller.getUnionExtremes()||o,a=s.dataMin,l=s.dataMax,c=r.getInputValue(t);c!==Number(A.getAttribute("data-hc-time-previous"))&&m(c)&&(A.setAttribute("data-hc-time-previous",c),g&&i&&m(a)?c>Number(i.getAttribute("data-hc-time"))?c=void 0:c<a&&(c=a):n&&m(l)&&(c<Number(n.getAttribute("data-hc-time"))?c=void 0:c>l&&(c=l)),void 0!==c&&o.setExtremes(g?c:o.min,g?o.max:c,void 0,void 0,{trigger:"rangeSelectorInput"}))}var y=u[g?"rangeSelectorFrom":"rangeSelectorTo"]||"",b=h.label(y,0).addClass("highcharts-range-label").attr({padding:y?2:0,height:y?d.inputBoxHeight:0}).add(o),x=h.label("",0).addClass("highcharts-range-input").attr({padding:2,width:d.inputBoxWidth,height:d.inputBoxHeight,"text-align":"center"}).on("click",function(){r.showInput(t),r[t+"Input"].focus()});e.styledMode||x.attr({stroke:d.inputBoxBorderColor,"stroke-width":1}),x.add(o);var A=l("input",{name:t,className:"highcharts-range-selector"},void 0,n);A.setAttribute("type",function(t){if(-1!==t.indexOf("%L"))return"text";var e=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(e){return -1!==t.indexOf("%"+e)}),i=["H","k","I","l","M","S"].some(function(e){return -1!==t.indexOf("%"+e)});return e&&i?"datetime-local":e?"date":i?"time":"text"}(d.inputDateFormat||"%e %b %Y")),e.styledMode||(b.css(f(a,d.labelStyle)),x.css(f({color:"#333333"},a,d.inputStyle)),c(A,p({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:a.fontSize,fontFamily:a.fontFamily,top:"-9999em"},d.inputStyle))),A.onfocus=function(){r.showInput(t)},A.onblur=function(){A===i.doc.activeElement&&v(),r.hideInput(t),r.setInputValue(t),A.blur()};var w=!1;return A.onchange=function(){w||(v(),r.hideInput(t),A.blur())},A.onkeypress=function(t){13===t.keyCode&&v()},A.onkeydown=function(t){w=!0,(38===t.keyCode||40===t.keyCode)&&v()},A.onkeyup=function(){w=!1},{dateBox:x,input:A,label:b}},e.prototype.getPosition=function(){var t=this.chart,e=t.options.rangeSelector,i="top"===e.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:i+e.buttonPosition.y,inputTop:i+e.inputPosition.y-10}},e.prototype.getYTDExtremes=function(t,e,i){var n=this.chart.time,o=new n.Date(t),r=n.get("FullYear",o),s=i?n.Date.UTC(r,0,1):+new n.Date(r,0,1),a=o.getTime();return{max:Math.min(t||a,a),min:Math.max(e,s)}},e.prototype.render=function(t,e){var i=this.chart,n=i.renderer,o=i.container,r=i.options,s=r.rangeSelector,a=b(r.chart.style&&r.chart.style.zIndex,0)+1,c=s.inputEnabled,d=this.rendered;if(!1!==s.enabled){if(!d&&(this.group=n.g("range-selector-group").attr({zIndex:7}).add(),this.div=l("div",void 0,{position:"relative",height:0,zIndex:a}),this.buttonOptions.length&&this.renderButtons(),o.parentNode&&o.parentNode.insertBefore(this.div,o),c)){this.inputGroup=n.g("input-group").add(this.group);var u=this.drawInput("min");this.minDateBox=u.dateBox,this.minLabel=u.label,this.minInput=u.input;var p=this.drawInput("max");this.maxDateBox=p.dateBox,this.maxLabel=p.label,this.maxInput=p.input}if(c){this.setInputValue("min",t),this.setInputValue("max",e);var g=i.scroller&&i.scroller.getUnionExtremes()||i.xAxis[0]||{};if(h(g.dataMin)&&h(g.dataMax)){var m=i.xAxis[0].minRange||0;this.setInputExtremes("min",g.dataMin,Math.min(g.dataMax,this.getInputValue("max"))-m),this.setInputExtremes("max",Math.max(g.dataMin,this.getInputValue("min"))+m,g.dataMax)}if(this.inputGroup){var f=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(t){if(t){var e=t.getBBox().width;e&&(t.attr({x:f}),f+=e+s.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},e.prototype.renderButtons=function(){var t=this,e=this.buttons,n=this.chart,o=this.options,r=s.lang,c=n.renderer,h=f(o.buttonTheme),d=h&&h.states,u=h.width||28;delete h.width,delete h.states,this.buttonGroup=c.g("range-selector-buttons").add(this.group);var p=this.dropdown=l("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);a(p,"touchstart",function(){p.style.fontSize="16px"}),[[i.isMS?"mouseover":"mouseenter"],[i.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(i){var n=i[0],o=i[1];a(p,n,function(){var i=e[t.currentButtonIndex()];i&&g(i.element,o||n)})}),this.zoomText=c.label(r&&r.rangeSelectorZoom||"",0).attr({padding:o.buttonTheme.padding,height:o.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(o.labelStyle),h["stroke-width"]=b(h["stroke-width"],0)),l("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,p),this.buttonOptions.forEach(function(i,n){l("option",{textContent:i.title||i.text},void 0,p),e[n]=c.button(i.text,0,0,function(e){var o,r=i.events&&i.events.click;r&&(o=r.call(i,e)),!1!==o&&t.clickButton(n),t.isActive=!0},h,d&&d.hover,d&&d.select,d&&d.disabled).attr({"text-align":"center",width:u}).add(t.buttonGroup),i.title&&e[n].attr("title",i.title)})},e.prototype.alignElements=function(){var t=this,e=this.buttonGroup,i=this.buttons,n=this.chart,o=this.group,r=this.inputGroup,s=this.options,a=this.zoomText,l=n.options,c=l.exporting&&!1!==l.exporting.enabled&&l.navigation&&l.navigation.buttonOptions,h=s.buttonPosition,d=s.inputPosition,u=s.verticalAlign,p=function(e,i){return c&&t.titleCollision(n)&&"top"===u&&"right"===i.align&&i.y-e.getBBox().height-12<(c.y||0)+(c.height||0)+n.spacing[0]?-40:0},g=n.plotLeft;if(o&&h&&d){var m=h.x-n.spacing[3];if(e){if(this.positionButtons(),!this.initialButtonGroupWidth){var f=0;a&&(f+=a.getBBox().width+5),i.forEach(function(t,e){f+=t.width||0,e!==i.length-1&&(f+=s.buttonSpacing)}),this.initialButtonGroupWidth=f}g-=n.spacing[3],this.updateButtonStates();var v=p(e,h);this.alignButtonGroup(v),o.placed=e.placed=n.hasLoaded}var y=0;r&&(y=p(r,d),"left"===d.align?m=g:"right"===d.align&&(m=-Math.max(n.axisOffset[1],-y)),r.align({y:d.y,width:r.getBBox().width,align:d.align,x:d.x+m-2},!0,n.spacingBox),r.placed=n.hasLoaded),this.handleCollision(y),o.align({verticalAlign:u},!0,n.spacingBox);var x=o.alignAttr.translateY,A=o.getBBox().height+20,w=0;if("bottom"===u){var C=n.legend&&n.legend.options;w=x-(A=A+(C&&"bottom"===C.verticalAlign&&C.enabled&&!C.floating?n.legend.legendHeight+b(C.margin,10):0)-20)-(s.floating?0:s.y)-(n.titleOffset?n.titleOffset[2]:0)-10}"top"===u?(s.floating&&(w=0),n.titleOffset&&n.titleOffset[0]&&(w=n.titleOffset[0]),w+=n.margin[0]-n.spacing[0]||0):"middle"===u&&(d.y===h.y?w=x:(d.y||h.y)&&(d.y<0||h.y<0?w-=Math.min(d.y,h.y):w=x-A)),o.translate(s.x,s.y+Math.floor(w));var E=this.minInput,T=this.maxInput,M=this.dropdown;s.inputEnabled&&E&&T&&(E.style.marginTop=o.translateY+"px",T.style.marginTop=o.translateY+"px"),M&&(M.style.marginTop=o.translateY+"px")}},e.prototype.alignButtonGroup=function(t,e){var i=this.chart,n=this.options,o=this.buttonGroup;this.buttons;var r=n.buttonPosition,s=i.plotLeft-i.spacing[3],a=r.x-i.spacing[3];"right"===r.align?a+=t-s:"center"===r.align&&(a-=s/2),o&&o.align({y:r.y,width:b(e,this.initialButtonGroupWidth),align:r.align,x:a},!0,i.spacingBox)},e.prototype.positionButtons=function(){var t=this.buttons,e=this.chart,i=this.options,n=this.zoomText,o=e.hasLoaded?"animate":"attr",r=i.buttonPosition,s=e.plotLeft,a=s;n&&"hidden"!==n.visibility&&(n[o]({x:b(s+r.x,s)}),a+=r.x+n.getBBox().width+5);for(var l=0,c=this.buttonOptions.length;l<c;++l)"hidden"!==t[l].visibility?(t[l][o]({x:a}),a+=(t[l].width||0)+i.buttonSpacing):t[l][o]({x:s})},e.prototype.handleCollision=function(t){var e=this,i=this.chart,n=this.buttonGroup,o=this.inputGroup,r=this.options,s=r.buttonPosition,a=r.dropdown,l=r.inputPosition,c=function(){var t=0;return e.buttons.forEach(function(e){var i=e.getBBox();i.width>t&&(t=i.width)}),t},h=function(e){if(o&&n){var i=o.alignAttr.translateX+o.alignOptions.x-t+o.getBBox().x+2,r=o.alignOptions.width,a=n.alignAttr.translateX+n.getBBox().x;return a+e>i&&i+r>a&&s.y<l.y+o.getBBox().height}return!1},d=function(){o&&n&&o.attr({translateX:o.alignAttr.translateX+(i.axisOffset[1]>=-t?0:-t),translateY:o.alignAttr.translateY+n.getBBox().height+10})};if(n){if("always"===a){this.collapseButtons(t),h(c())&&d();return}"never"===a&&this.expandButtons()}o&&n?l.align===s.align||h(this.initialButtonGroupWidth+20)?"responsive"===a?(this.collapseButtons(t),h(c())&&d()):d():"responsive"===a&&this.expandButtons():n&&"responsive"===a&&(this.initialButtonGroupWidth>i.plotWidth?this.collapseButtons(t):this.expandButtons())},e.prototype.collapseButtons=function(t){var e=this.buttons,i=this.buttonOptions,n=this.chart,o=this.dropdown,r=this.options,s=this.zoomText;if(!0!==this.isCollapsed){this.isCollapsed=!0;var a=n.userOptions.rangeSelector&&n.userOptions.rangeSelector.buttonTheme||{},l=function(t){return{text:t?"".concat(t," ▾"):"▾",width:"auto",paddingLeft:b(r.buttonTheme.paddingLeft,a.padding,8),paddingRight:b(r.buttonTheme.paddingRight,a.padding,8)}};s&&s.hide();var c=!1;i.forEach(function(t,i){var n=e[i];2!==n.state?n.hide():(n.show(),n.attr(l(t.text)),c=!0)}),c||(o&&(o.selectedIndex=0),e[0].show(),e[0].attr(l(this.zoomText&&this.zoomText.textStr)));var h=r.buttonPosition.align;this.positionButtons(),("right"===h||"center"===h)&&this.alignButtonGroup(t,e[this.currentButtonIndex()].getBBox().width),this.showDropdown()}},e.prototype.expandButtons=function(){var t=this.buttons,e=this.buttonOptions,i=this.options,n=this.zoomText;this.hideDropdown(),!1!==this.isCollapsed&&(this.isCollapsed=!1,n&&n.show(),e.forEach(function(e,n){var o=t[n];o.show(),o.attr({text:e.text,width:i.buttonTheme.width||28,paddingLeft:b(i.buttonTheme.paddingLeft,"unset"),paddingRight:b(i.buttonTheme.paddingRight,"unset")}),o.state<2&&o.setState(0)}),this.positionButtons())},e.prototype.currentButtonIndex=function(){var t=this.dropdown;return t&&t.selectedIndex>0?t.selectedIndex-1:0},e.prototype.showDropdown=function(){var t=this.buttonGroup,e=this.buttons,i=this.chart,n=this.dropdown;if(t&&n){var o=t.translateX,r=t.translateY,s=e[this.currentButtonIndex()].getBBox();c(n,{left:i.plotLeft+(void 0===o?0:o)+"px",top:(void 0===r?0:r)+.5+"px",width:s.width+"px",height:s.height+"px"}),this.hasVisibleDropdown=!0}},e.prototype.hideDropdown=function(){var t=this.dropdown;t&&(c(t,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},e.prototype.getHeight=function(){var t=this.options,e=this.group,i=t.inputPosition,n=t.buttonPosition,o=t.y,r=n.y,s=i.y,a=0;return t.height?t.height:(this.alignElements(),a=e?e.getBBox(!0).height+13+o:0,(s<0&&r<0||s>0&&r>0)&&(a+=Math.abs(Math.min(s,r))),a)},e.prototype.titleCollision=function(t){return!(t.options.title.text||t.options.subtitle.text)},e.prototype.update=function(t){var e=this.chart;f(!0,e.options.rangeSelector,t),this.destroy(),this.init(e),this.render()},e.prototype.destroy=function(){var t=this,i=t.minInput,n=t.maxInput;t.eventsToUnbind&&(t.eventsToUnbind.forEach(function(t){return t()}),t.eventsToUnbind=void 0),d(t.buttons),i&&(i.onfocus=i.onblur=i.onchange=null),n&&(n.onfocus=n.onblur=n.onchange=null),v(t,function(i,n){i&&"chart"!==n&&(i instanceof o?i.destroy():i instanceof window.HTMLElement&&u(i)),i!==e.prototype[n]&&(t[n]=null)},this)},e}();return p(w.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}}),w}),i(e,"Accessibility/Components/RangeSelectorComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/Announcer.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Core/Globals.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Stock/RangeSelector/RangeSelector.js"],e["Core/Utilities.js"]],function(t,e,i,n,o,r,s){var a,l=this&&this.__extends||(a=function(t,e){return(a=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),c=i.unhideChartElementFromAT,h=i.getAxisRangeDescription,d=n.composed,u=s.addEvent,p=s.attr,g=s.pushUnique,m=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return l(i,t),i.prototype.init=function(){var t=this.chart;this.announcer=new e(t,"polite")},i.prototype.onChartUpdate=function(){var t=this.chart,e=this,i=t.rangeSelector;i&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),i.buttons&&i.buttons.length&&i.buttons.forEach(function(t){e.setRangeButtonAttrs(t)}),i.maxInput&&i.minInput&&["minInput","maxInput"].forEach(function(n,o){var r=i[n];r&&(c(t,r),e.setRangeInputAttrs(r,"accessibility.rangeSelector."+(o?"max":"min")+"InputLabel"))}))},i.prototype.updateSelectorVisibility=function(){var t=this.chart,e=t.rangeSelector,i=e&&e.dropdown,n=e&&e.buttons||[],o=function(t){return t.setAttribute("aria-hidden",!0)};e&&e.hasVisibleDropdown&&i?(c(t,i),n.forEach(function(t){return o(t.element)})):(i&&o(i),n.forEach(function(e){return c(t,e.element)}))},i.prototype.setDropdownAttrs=function(){var t=this.chart,e=t.rangeSelector&&t.rangeSelector.dropdown;if(e){var i=t.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:t.options.lang.rangeSelectorZoom});e.setAttribute("aria-label",i),e.setAttribute("tabindex",-1)}},i.prototype.setRangeButtonAttrs=function(t){p(t.element,{tabindex:-1,role:"button"})},i.prototype.setRangeInputAttrs=function(t,e){var i=this.chart;p(t,{tabindex:-1,"aria-label":i.langFormat(e,{chart:i})})},i.prototype.onButtonNavKbdArrowKey=function(t,e){var i=t.response,n=this.keyCodes,o=this.chart,r=o.options.accessibility.keyboardNavigation.wrapAround,s=e===n.left||e===n.up?-1:1;return o.highlightRangeSelectorButton(o.highlightedRangeSelectorItemIx+s)?i.success:r?(t.init(s),i.success):i[s>0?"next":"prev"]},i.prototype.onButtonNavKbdClick=function(t){var e=t.response,i=this.chart;return 3!==i.oldRangeSelectorItemState&&this.fakeClickEvent(i.rangeSelector.buttons[i.highlightedRangeSelectorItemIx].element),e.success},i.prototype.onAfterBtnClick=function(){var t=this.chart,e=h(t.xAxis[0]),i=t.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:t,axisRangeDescription:e});i&&this.announcer.announce(i)},i.prototype.onInputKbdMove=function(t){var e=this.chart,i=e.rangeSelector,n=e.highlightedInputRangeIx=(e.highlightedInputRangeIx||0)+t;if(n>1||n<0){if(e.accessibility)return e.accessibility.keyboardNavigation.exiting=!0,e.accessibility.keyboardNavigation.tabindexContainer.focus(),e.accessibility.keyboardNavigation.move(t)}else if(i){var o=i[n?"maxDateBox":"minDateBox"],r=i[n?"maxInput":"minInput"];o&&r&&e.setFocusToElement(o,r)}return!0},i.prototype.onInputNavInit=function(t){var e=this,i=this,n=this.chart,o=t>0?0:1,r=n.rangeSelector,s=r&&r[o?"maxDateBox":"minDateBox"],a=r&&r.minInput,l=r&&r.maxInput,c=o?l:a;if(n.highlightedInputRangeIx=o,s&&a&&l){n.setFocusToElement(s,c),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var h=function(t){(t.which||t.keyCode)===e.keyCodes.tab&&i.onInputKbdMove(t.shiftKey?-1:1)&&(t.preventDefault(),t.stopPropagation())},d=u(a,"keydown",h),p=u(l,"keydown",h);this.removeInputKeydownHandler=function(){d(),p()}}},i.prototype.onInputNavTerminate=function(){var t=this.chart.rangeSelector||{};t.maxInput&&t.hideInput("max"),t.minInput&&t.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},i.prototype.initDropdownNav=function(){var t=this,e=this.chart,i=e.rangeSelector,n=i&&i.dropdown;i&&n&&(e.setFocusToElement(i.buttonGroup,n),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=u(n,"keydown",function(i){var n=(i.which||i.keyCode)===t.keyCodes.tab,o=e.accessibility;n&&(i.preventDefault(),i.stopPropagation(),o&&(o.keyboardNavigation.tabindexContainer.focus(),o.keyboardNavigation.move(i.shiftKey?-1:1)))}))},i.prototype.getRangeSelectorButtonNavigation=function(){var t=this.chart,e=this.keyCodes,i=this;return new o(t,{keyCodeMap:[[[e.left,e.right,e.up,e.down],function(t){return i.onButtonNavKbdArrowKey(this,t)}],[[e.enter,e.space],function(){return i.onButtonNavKbdClick(this)}]],validate:function(){return!!(t.rangeSelector&&t.rangeSelector.buttons&&t.rangeSelector.buttons.length)},init:function(e){var n=t.rangeSelector;if(n&&n.hasVisibleDropdown)i.initDropdownNav();else if(n){var o=n.buttons.length-1;t.highlightRangeSelectorButton(e>0?0:o)}},terminate:function(){i.removeDropdownKeydownHandler&&(i.removeDropdownKeydownHandler(),delete i.removeDropdownKeydownHandler)}})},i.prototype.getRangeSelectorInputNavigation=function(){var t=this.chart,e=this;return new o(t,{keyCodeMap:[],validate:function(){return!!(t.rangeSelector&&t.rangeSelector.inputGroup&&"hidden"!==t.rangeSelector.inputGroup.element.style.visibility&&!1!==t.options.rangeSelector.inputEnabled&&t.rangeSelector.minInput&&t.rangeSelector.maxInput)},init:function(t){e.onInputNavInit(t)},terminate:function(){e.onInputNavTerminate()}})},i.prototype.getKeyboardNavigation=function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},i.prototype.destroy=function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()},i}(t);return function(t){function e(t){var e=this.rangeSelector&&this.rangeSelector.buttons||[],i=this.highlightedRangeSelectorItemIx,n=this.rangeSelector&&this.rangeSelector.selected;return void 0!==i&&e[i]&&i!==n&&e[i].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=t,!!e[t]&&(this.setFocusToElement(e[t].box,e[t].element),t!==n&&(this.oldRangeSelectorItemState=e[t].state,e[t].setState(1)),!0)}function i(){var t=this.chart.accessibility;if(t&&t.components.rangeSelector)return t.components.rangeSelector.onAfterBtnClick()}t.compose=function t(n,o){g(d,t)&&(n.prototype.highlightRangeSelectorButton=e,u(r,"afterBtnClick",i))}}(m||(m={})),m}),i(e,"Accessibility/Components/SeriesComponent/ForcedMarkers.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i,n=t.composed,o=e.addEvent,r=e.merge,s=e.pushUnique;return function(t){function e(t){r(!0,t,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function i(t){return t.marker.states&&t.marker.states.normal&&t.marker.states.normal.opacity}function a(t){return!!(t._hasPointMarkers&&t.points&&t.points.length)}function l(){this.chart.styledMode&&(this.markerGroup&&this.markerGroup[this.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),a(this)&&this.points.forEach(function(t){t.graphic&&(t.graphic[t.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),t.graphic[!1===t.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))}function c(t){this.resetA11yMarkerOptions=r(t.options.marker||{},this.userOptions.marker||{})}function h(){var t,n,o,s,l=this.options;(t=this,o=t.chart.options.accessibility.enabled,s=!1!==(t.options.accessibility&&t.options.accessibility.enabled),o&&s&&(n=t.chart.options.accessibility,t.points.length<n.series.pointDescriptionEnabledThreshold||!1===n.series.pointDescriptionEnabledThreshold))?(l.marker&&!1===l.marker.enabled&&(this.a11yMarkersForced=!0,e(this.options)),a(this)&&function(t){for(var n=t.points.length;n--;){var o=t.points[n],s=o.options,a=o.hasForcedA11yMarker;if(delete o.hasForcedA11yMarker,s.marker){var l=a&&0===i(s);s.marker.enabled&&!l?(r(!0,s.marker,{states:{normal:{opacity:i(s)||1}}}),o.hasForcedA11yMarker=!1):!1===s.marker.enabled&&(e(s),o.hasForcedA11yMarker=!0)}}}(this)):this.a11yMarkersForced&&(delete this.a11yMarkersForced,function(t){var e=t.resetA11yMarkerOptions;if(e){var i=e.states&&e.states.normal&&e.states.normal.opacity;t.userOptions&&t.userOptions.marker&&(t.userOptions.marker.enabled=!0),t.update({marker:{enabled:e.enabled,states:{normal:{opacity:i}}}})}}(this),delete this.resetA11yMarkerOptions)}t.compose=function t(e){s(n,t)&&(o(e,"afterSetOptions",c),o(e,"render",h),o(e,"afterRender",l))}}(i||(i={})),i}),i(e,"Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js",[e["Core/Series/Point.js"],e["Core/Series/Series.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Utils/ChartUtilities.js"]],function(t,e,i,n,o,r,s,a){var l=i.seriesTypes,c=n.composed,h=n.doc,d=o.defined,u=o.fireEvent,p=o.pushUnique,g=a.getPointFromXY,m=a.getSeriesFromName,f=a.scrollAxisToPoint;function v(t){var e=t.index,i=t.series.points,n=i.length;if(i[e]===t)return e;for(;n--;)if(i[n]===t)return n}function y(t){var e=t.chart.options.accessibility.keyboardNavigation.seriesNavigation,i=t.options.accessibility||{},n=i.keyboardNavigation;return n&&!1===n.enabled||!1===i.enabled||!1===t.options.enableMouseTracking||!t.visible||e.pointNavigationEnabledThreshold&&+e.pointNavigationEnabledThreshold<=t.points.length}function b(t){var e=t.series.chart.options.accessibility,i=t.options.accessibility&&!1===t.options.accessibility.enabled;return t.isNull&&e.keyboardNavigation.seriesNavigation.skipNullPoints||!1===t.visible||!1===t.isInside||i||y(t.series)}function x(t){for(var e=t.series||[],i=e.length,n=0;n<i;++n)if(!y(e[n])){var o=function(t){for(var e=t.points||[],i=e.length,n=0;n<i;++n)if(!b(e[n]))return e[n];return null}(e[n]);if(o)return o}return null}function A(t){for(var e=t.series.length,i=!1;e--&&(t.highlightedPoint=t.series[e].points[t.series[e].points.length-1],!(i=t.series[e].highlightNextValidPoint())););return i}function w(t){delete t.highlightedPoint;var e=x(t);return!!e&&e.highlight()}var C=function(){function i(t,e){this.keyCodes=e,this.chart=t}return i.prototype.init=function(){var i=this,n=this.chart,o=this.eventProvider=new s;o.addEvent(e,"destroy",function(){return i.onSeriesDestroy(this)}),o.addEvent(n,"afterApplyDrilldown",function(){var t;(t=x(this))&&t.highlight(!1)}),o.addEvent(n,"drilldown",function(t){var e=t.point,n=e.series;i.lastDrilledDownPoint={x:e.x,y:e.y,seriesName:n?n.name:""}}),o.addEvent(n,"drillupall",function(){setTimeout(function(){i.onDrillupAll()},10)}),o.addEvent(t,"afterSetState",function(){var t=this.graphic&&this.graphic.element,e=h.activeElement,i=e&&e.getAttribute("class"),o=i&&i.indexOf("highcharts-a11y-proxy-element")>-1;n.highlightedPoint===this&&e!==t&&!o&&t&&t.focus&&t.focus()})},i.prototype.onDrillupAll=function(){var t,e=this.lastDrilledDownPoint,i=this.chart,n=e&&m(i,e.seriesName);e&&n&&d(e.x)&&d(e.y)&&(t=g(n,e.x,e.y)),t=t||x(i),i.container&&i.container.focus(),t&&t.highlight&&t.highlight(!1)},i.prototype.getKeyboardNavigationHandler=function(){var t=this,e=this.keyCodes,i=this.chart,n=i.inverted;return new r(i,{keyCodeMap:[[n?[e.up,e.down]:[e.left,e.right],function(e){return t.onKbdSideways(this,e)}],[n?[e.left,e.right]:[e.up,e.down],function(e){return t.onKbdVertical(this,e)}],[[e.enter,e.space],function(t,e){var n=i.highlightedPoint;return n&&(e.point=n,u(n.series,"click",e),n.firePointEvent("click")),this.response.success}],[[e.home],function(){return w(i),this.response.success}],[[e.end],function(){return A(i),this.response.success}],[[e.pageDown,e.pageUp],function(t){return i.highlightAdjacentSeries(t===e.pageDown),this.response.success}]],init:function(){return t.onHandlerInit(this)},validate:function(){return!!x(i)},terminate:function(){return t.onHandlerTerminate()}})},i.prototype.onKbdSideways=function(t,e){var i=this.keyCodes,n=e===i.right||e===i.down;return this.attemptHighlightAdjacentPoint(t,n)},i.prototype.onHandlerInit=function(t){var e=this.chart;return e.options.accessibility.keyboardNavigation.seriesNavigation.rememberPointFocus&&e.highlightedPoint?e.highlightedPoint.highlight():w(e),t.response.success},i.prototype.onKbdVertical=function(t,e){var i=this.chart,n=this.keyCodes,o=e===n.down||e===n.right,r=i.options.accessibility.keyboardNavigation.seriesNavigation;if(r.mode&&"serialize"===r.mode)return this.attemptHighlightAdjacentPoint(t,o);var s=i.highlightedPoint&&i.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return i[s](o),t.response.success},i.prototype.onHandlerTerminate=function(){var t=this.chart,e=t.options.accessibility.keyboardNavigation;t.tooltip&&t.tooltip.hide(0);var i=t.highlightedPoint&&t.highlightedPoint.series;i&&i.onMouseOut&&i.onMouseOut(),t.highlightedPoint&&t.highlightedPoint.onMouseOut&&t.highlightedPoint.onMouseOut(),e.seriesNavigation.rememberPointFocus||delete t.highlightedPoint},i.prototype.attemptHighlightAdjacentPoint=function(t,e){var i=this.chart,n=i.options.accessibility.keyboardNavigation.wrapAround;return i.highlightAdjacentPoint(e)?t.response.success:n&&(e?w(i):A(i))?t.response.success:t.response[e?"next":"prev"]},i.prototype.onSeriesDestroy=function(t){var e=this.chart;e.highlightedPoint&&e.highlightedPoint.series===t&&(delete e.highlightedPoint,e.focusElement&&e.focusElement.removeFocusBorder())},i.prototype.destroy=function(){this.eventProvider.removeAddedEvents()},i}();return function(t){function e(t){var e,i,n=this.series,o=this.highlightedPoint,r=o&&v(o)||0,s=o&&o.series.points||[],a=this.series&&this.series[this.series.length-1],l=a&&a.points&&a.points[a.points.length-1];if(!n[0]||!n[0].points)return!1;if(o){if(e=n[o.series.index+(t?1:-1)],(i=s[r+(t?1:-1)])||!e||(i=e.points[t?0:e.points.length-1]),!i)return!1}else i=t?n[0].points[0]:l;return b(i)?(y(e=i.series)?this.highlightedPoint=t?e.points[e.points.length-1]:e.points[0]:this.highlightedPoint=i,this.highlightAdjacentPoint(t)):i.highlight()}function i(t){var e,i=this.highlightedPoint,n=1/0;return!!(d(i.plotX)&&d(i.plotY))&&(this.series.forEach(function(o){y(o)||o.points.forEach(function(r){if(d(r.plotY)&&d(r.plotX)&&r!==i){var s=r.plotY-i.plotY,a=Math.abs(r.plotX-i.plotX),l=Math.abs(s)*Math.abs(s)+a*a*4;o.yAxis&&o.yAxis.reversed&&(s*=-1),!(s<=0&&t||s>=0&&!t||l<5||b(r))&&l<n&&(n=l,e=r)}})}),!!e&&e.highlight())}function n(t){var e,i,n,o=this.highlightedPoint,r=this.series&&this.series[this.series.length-1],s=r&&r.points&&r.points[r.points.length-1];return this.highlightedPoint?!!((e=this.series[o.series.index+(t?-1:1)])&&(i=function(t,e,i,n){var o,r,s,a=1/0,l=e.points.length,c=function(t){return!(d(t.plotX)&&d(t.plotY))};if(!c(t)){for(;l--;)!c(o=e.points[l])&&(s=(t.plotX-o.plotX)*(t.plotX-o.plotX)*4+(t.plotY-o.plotY)*(t.plotY-o.plotY)*1)<a&&(a=s,r=l);return d(r)?e.points[r]:void 0}}(o,e,0)))&&(y(e)?(i.highlight(),n=this.highlightAdjacentSeries(t))?n:(o.highlight(),!1):(i.highlight(),i.series.highlightNextValidPoint())):(e=t?this.series&&this.series[0]:r,!!(i=t?e&&e.points&&e.points[0]:s)&&i.highlight())}function o(t){void 0===t&&(t=!0);var e,i,n=this.series.chart,o=null===(i=null===(e=n.tooltip)||void 0===e?void 0:e.label)||void 0===i?void 0:i.element;!this.isNull&&t?this.onMouseOver():n.tooltip&&n.tooltip.hide(0),f(this),this.graphic&&(n.setFocusToElement(this.graphic),!t&&n.focusElement&&n.focusElement.removeFocusBorder()),n.highlightedPoint=this;var r=null==o?void 0:o.getBoundingClientRect().top;if(o&&r&&r<0){var s=window.scrollY;window.scrollTo({behavior:"smooth",top:s+r})}return this}function r(){var t=this.chart.highlightedPoint,e=(t&&t.series)===this?v(t):0,i=this.points,n=i.length;if(i&&n){for(var o=e;o<n;++o)if(!b(i[o]))return i[o].highlight();for(var r=e;r>=0;--r)if(!b(i[r]))return i[r].highlight()}return!1}t.compose=function t(s,a,h){if(p(c,t)){var d=s.prototype,u=a.prototype,g=h.prototype;d.highlightAdjacentPoint=e,d.highlightAdjacentPointVertical=i,d.highlightAdjacentSeries=n,u.highlight=o,g.keyboardMoveVertical=!0,["column","gantt","pie"].forEach(function(t){l[t]&&(l[t].prototype.keyboardMoveVertical=!1)}),g.highlightNextValidPoint=r}}}(C||(C={})),C}),i(e,"Accessibility/Components/SeriesComponent/SeriesComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Components/SeriesComponent/ForcedMarkers.js"],e["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],e["Accessibility/Components/SeriesComponent/SeriesDescriber.js"],e["Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js"]],function(t,e,i,n,o,r){var s,a=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),l=e.hideSeriesFromAT,c=o.describeSeries;return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a(e,t),e.compose=function(t,e,o){n.compose(o),i.compose(o),r.compose(t,e,o)},e.prototype.init=function(){this.newDataAnnouncer=new n(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new r(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},e.prototype.hideTooltipFromATWhenShown=function(){var t=this;this.chart.tooltip&&this.addEvent(this.chart.tooltip.constructor,"refresh",function(){this.chart===t.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},e.prototype.hideSeriesLabelsFromATWhenShown=function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(t){t.labelBySeries&&t.labelBySeries.attr("aria-hidden",!0)})})},e.prototype.onChartRender=function(){this.chart.series.forEach(function(t){!1!==(t.options.accessibility&&t.options.accessibility.enabled)&&t.visible&&0!==t.data.length?c(t):l(t)})},e.prototype.getKeyboardNavigation=function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},e.prototype.destroy=function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()},e}(t)}),i(e,"Accessibility/Components/ZoomComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r,s=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),a=e.unhideChartElementFromAT,l=i.getFakeMouseEvent,c=o.attr,h=o.pick;return function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.focusedMapNavButtonIx=-1,e}return s(e,t),e.prototype.init=function(){var t=this,e=this.chart;this.proxyProvider.addGroup("zoom","div"),["afterShowResetZoom","afterApplyDrilldown","drillupall"].forEach(function(i){t.addEvent(e,i,function(){t.updateProxyOverlays()})})},e.prototype.onChartUpdate=function(){var t=this.chart,e=this;t.mapNavigation&&t.mapNavigation.navButtons.forEach(function(i,n){a(t,i.element),e.setMapNavButtonAttrs(i.element,"accessibility.zoom.mapZoom"+(n?"Out":"In"))})},e.prototype.setMapNavButtonAttrs=function(t,e){var i=this.chart;c(t,{tabindex:-1,role:"button","aria-label":i.langFormat(e,{chart:i})})},e.prototype.onChartRender=function(){this.updateProxyOverlays()},e.prototype.updateProxyOverlays=function(){var t=this.chart;if(this.proxyProvider.clearGroup("zoom"),t.resetZoomButton&&this.createZoomProxyButton(t.resetZoomButton,"resetZoomProxyButton",t.langFormat("accessibility.zoom.resetZoomButton",{chart:t})),t.drillUpButton&&t.breadcrumbs&&t.breadcrumbs.list){var e=t.breadcrumbs.list[t.breadcrumbs.list.length-1];this.createZoomProxyButton(t.drillUpButton,"drillUpProxyButton",t.langFormat("accessibility.drillUpButton",{chart:t,buttonText:t.breadcrumbs.getButtonText(e)}))}},e.prototype.createZoomProxyButton=function(t,e,i){this[e]=this.proxyProvider.addProxyElement("zoom",{click:t},"button",{"aria-label":i,tabindex:-1})},e.prototype.getMapZoomNavigation=function(){var t=this.keyCodes,e=this.chart,i=this;return new n(e,{keyCodeMap:[[[t.up,t.down,t.left,t.right],function(t){return i.onMapKbdArrow(this,t)}],[[t.tab],function(t,e){return i.onMapKbdTab(this,e)}],[[t.space,t.enter],function(){return i.onMapKbdClick(this)}]],validate:function(){return!!(e.mapView&&e.mapNavigation&&e.mapNavigation.navButtons.length)},init:function(t){return i.onMapNavInit(t)}})},e.prototype.onMapKbdArrow=function(t,e){var i=this.chart,n=this.keyCodes,o=i.container,r=e===n.up||e===n.down,s=e===n.left||e===n.up?1:-1,a=(r?i.plotHeight:i.plotWidth)/10*s,c=10*Math.random(),h={x:o.offsetLeft+i.plotLeft+i.plotWidth/2+c,y:o.offsetTop+i.plotTop+i.plotHeight/2+c},d=r?{x:h.x,y:h.y+a}:{x:h.x+a,y:h.y};return[l("mousedown",h),l("mousemove",d),l("mouseup",d)].forEach(function(t){return o.dispatchEvent(t)}),t.response.success},e.prototype.onMapKbdTab=function(t,e){var i=this.chart,n=t.response,o=e.shiftKey,r=o&&!this.focusedMapNavButtonIx||!o&&this.focusedMapNavButtonIx;if(i.mapNavigation.navButtons[this.focusedMapNavButtonIx].setState(0),r)return i.mapView&&i.mapView.zoomBy(),n[o?"prev":"next"];this.focusedMapNavButtonIx+=o?-1:1;var s=i.mapNavigation.navButtons[this.focusedMapNavButtonIx];return i.setFocusToElement(s.box,s.element),s.setState(2),n.success},e.prototype.onMapKbdClick=function(t){var e=this.chart.mapNavigation.navButtons[this.focusedMapNavButtonIx].element;return this.fakeClickEvent(e),t.response.success},e.prototype.onMapNavInit=function(t){var e=this.chart,i=e.mapNavigation.navButtons[0],n=e.mapNavigation.navButtons[1],o=t>0?i:n;e.setFocusToElement(o.box,o.element),o.setState(2),this.focusedMapNavButtonIx=t>0?0:1},e.prototype.simpleButtonNavigation=function(t,e,i){var o=this.keyCodes,r=this,s=this.chart;return new n(s,{keyCodeMap:[[[o.tab,o.up,o.down,o.left,o.right],function(t,e){var i=t===o.tab&&e.shiftKey||t===o.left||t===o.up;return this.response[i?"prev":"next"]}],[[o.space,o.enter],function(){return h(i(this,s),this.response.success)}]],validate:function(){return s[t]&&s[t].box&&r[e].innerElement},init:function(){s.setFocusToElement(s[t].box,r[e].innerElement)}})},e.prototype.getKeyboardNavigation=function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(t,e){e.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(t,e){return e.drillUp(),t.response.prev}),this.getMapZoomNavigation()]},e}(t)}),i(e,"Accessibility/HighContrastMode.js",[e["Core/Globals.js"]],function(t){var e=t.doc,i=t.isMS,n=t.win;return{isHighContrastModeActive:function(){var t=/(Edg)/.test(n.navigator.userAgent);if(n.matchMedia&&t)return n.matchMedia("(-ms-high-contrast: active)").matches;if(i&&n.getComputedStyle){var o=e.createElement("div");o.style.backgroundImage="url(".concat("data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",")"),e.body.appendChild(o);var r=(o.currentStyle||n.getComputedStyle(o)).backgroundImage;return e.body.removeChild(o),"none"===r}return n.matchMedia&&n.matchMedia("(forced-colors: active)").matches},setHighContrastTheme:function(t){t.highContrastModeActive=!0;var e=t.options.accessibility.highContrastTheme;t.update(e,!1),t.series.forEach(function(t){var i=e.plotOptions[t.type]||{};t.update({color:i.color||"windowText",colors:[i.color||"windowText"],borderColor:i.borderColor||"window"}),t.points.forEach(function(t){t.options&&t.options.color&&t.update({color:i.color||"windowText",borderColor:i.borderColor||"window"},!1)})}),t.redraw()}}}),i(e,"Accessibility/HighContrastTheme.js",[],function(){return{chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}}}),i(e,"Accessibility/Options/A11yDefaults.js",[],function(){return{accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{descriptionFormat:"{seriesDescription}{authorDescription}{axisDescription}",describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{xDescription}{separator}{value}.",describeNull:!0},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:"#334eff",lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","navigator","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1,rememberPointFocus:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}},navigator:{accessibility:{enabled:!0}}}}),i(e,"Accessibility/Options/LangDefaults.js",[],function(){return{accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{#each additionalAnnotationPoints}, also related to {this}{/each}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},navigator:{handleLabel:"{#eq handleIx 0}Start, percent{else}End, percent{/eq}",groupLabel:"Axis zoom",changeAnnouncement:"{axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#eq numPoints 1}point{else}points{/eq}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#eq numPoints 1}point{else}points{/eq}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#eq numPoints 1}point{else}points{/eq}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#eq numPoints 1}bar{else}bars{/eq}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#eq numPoints 1}bar{else}bars{/eq}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#eq numPoints 1}slice{else}slices{/eq}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#eq numPoints 1}point{else}points{/eq}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#eq numPoints 1}box{else}boxes{/eq}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#eq numPoints 1}bubbles{else}bubble{/eq}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each names}{#unless @first},{/unless}{#if @last} and{/if} {this}{/each}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each names}{#unless @first},{/unless}{#if @last} and{/if} {this}{/each}.",timeRangeDays:"Data range: {range} days.",timeRangeHours:"Data range: {range} hours.",timeRangeMinutes:"Data range: {range} minutes.",timeRangeSeconds:"Data range: {range} seconds.",rangeFromTo:"Data ranges from {rangeFrom} to {rangeTo}.",rangeCategories:"Data range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu, {chartTitle}"},series:{summary:{default:"{series.name}, series {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",defaultCombination:"{series.name}, series {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",line:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",lineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",spline:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",splineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",column:"{series.name}, bar series {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}bar{else}bars{/eq}.",columnCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bar series with {series.points.length} {#eq series.points.length 1}bar{else}bars{/eq}.",bar:"{series.name}, bar series {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}bar{else}bars{/eq}.",barCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bar series with {series.points.length} {#eq series.points.length 1}bar{else}bars{/eq}.",pie:"{series.name}, pie {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}slice{else}slices{/eq}.",pieCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Pie with {series.points.length} {#eq series.points.length 1}slice{else}slices{/eq}.",scatter:"{series.name}, scatter plot {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}point{else}points{/eq}.",scatterCombination:"{series.name}, series {seriesNumber} of {chart.series.length}, scatter plot with {series.points.length} {#eq series.points.length 1}point{else}points{/eq}.",boxplot:"{series.name}, boxplot {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}box{else}boxes{/eq}.",boxplotCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Boxplot with {series.points.length} {#eq series.points.length 1}box{else}boxes{/eq}.",bubble:"{series.name}, bubble series {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}bubble{else}bubbles{/eq}.",bubbleCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bubble series with {series.points.length} {#eq series.points.length 1}bubble{else}bubbles{/eq}.",map:"{series.name}, map {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}area{else}areas{/eq}.",mapCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Map with {series.points.length} {#eq series.points.length 1}area{else}areas{/eq}.",mapline:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",maplineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",mapbubble:"{series.name}, bubble series {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}bubble{else}bubbles{/eq}.",mapbubbleCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bubble series with {series.points.length} {#eq series.points.length 1}bubble{else}bubbles{/eq}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{#each annotations}Annotation: {this}{/each}"}}}}),i(e,"Accessibility/Options/DeprecatedOptions.js",[e["Core/Utilities.js"]],function(t){var e=t.error,i=t.pick;function n(t,e,n){for(var o,r=t,s=0;s<e.length-1;++s)r=r[o=e[s]]=i(r[o],{});r[e[e.length-1]]=n}function o(t,i,o,r){function s(t,e){return e.reduce(function(t,e){return t[e]},t)}var a=s(t.options,i),l=s(t.options,o);Object.keys(r).forEach(function(s){var c,h=a[s];void 0!==h&&(n(l,r[s],h),e(32,!1,t,((c={})[i.join(".")+"."+s]=o.join(".")+"."+r[s].join("."),c)))})}return function(t){var i,r;i=t.options.chart,r=t.options.accessibility||{},["description","typeDescription"].forEach(function(n){var o;i[n]&&(r[n]=i[n],e(32,!1,t,((o={})["chart.".concat(n)]="use accessibility.".concat(n),o)))}),function(t){t.axes.forEach(function(i){var n=i.options;n&&n.description&&(n.accessibility=n.accessibility||{},n.accessibility.description=n.description,e(32,!1,t,{"axis.description":"use axis.accessibility.description"}))})}(t),t.series&&function(t){var i={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","point","descriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"],"accessibility.pointDescriptionFormatter":["accessibility","point","descriptionFormatter"]};t.series.forEach(function(o){Object.keys(i).forEach(function(r){var s,a=o.options[r];"accessibility.pointDescriptionFormatter"===r&&(a=o.options.accessibility&&o.options.accessibility.pointDescriptionFormatter),void 0!==a&&(n(o.options,i[r],"skipKeyboardNavigation"===r?!a:a),e(32,!1,t,((s={})["series.".concat(r)]="series."+i[r].join("."),s)))})})}(t),o(t,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]}),o(t,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]}),o(t,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}}),i(e,"Accessibility/Accessibility.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/A11yI18n.js"],e["Accessibility/Components/ContainerComponent.js"],e["Accessibility/FocusBorder.js"],e["Accessibility/Components/InfoRegionsComponent.js"],e["Accessibility/KeyboardNavigation.js"],e["Accessibility/Components/LegendComponent.js"],e["Accessibility/Components/MenuComponent.js"],e["Accessibility/Components/NavigatorComponent.js"],e["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],e["Accessibility/ProxyProvider.js"],e["Accessibility/Components/RangeSelectorComponent.js"],e["Accessibility/Components/SeriesComponent/SeriesComponent.js"],e["Accessibility/Components/ZoomComponent.js"],e["Accessibility/HighContrastMode.js"],e["Accessibility/HighContrastTheme.js"],e["Accessibility/Options/A11yDefaults.js"],e["Accessibility/Options/LangDefaults.js"],e["Accessibility/Options/DeprecatedOptions.js"]],function(t,e,i,n,o,r,s,a,l,c,h,d,u,p,g,m,f,v,y,b,x,A){var w=t.defaultOptions,C=e.composed,E=e.doc,T=i.addEvent,M=i.extend,S=i.fireEvent,k=i.merge,P=i.pushUnique,D=n.removeElement,B=function(){function t(t){this.init(t)}return t.prototype.init=function(t){if(this.chart=t,!E.addEventListener){this.zombie=!0,this.components={},t.renderTo.setAttribute("aria-hidden",!0);return}A(t),this.proxyProvider=new p(this.chart),this.initComponents(),this.keyboardNavigation=new l(t,this.components)},t.prototype.initComponents=function(){var t=this.chart,e=this.proxyProvider,i=t.options.accessibility;this.components={container:new r,infoRegions:new a,legend:new c,chartMenu:new h,rangeSelector:new g,series:new m,zoom:new f,navigator:new d},i.customComponents&&M(this.components,i.customComponents);var n=this.components;this.getComponentOrder().forEach(function(i){n[i].initBase(t,e),n[i].init()})},t.prototype.getComponentOrder=function(){return this.components?this.components.series?["series"].concat(Object.keys(this.components).filter(function(t){return"series"!==t})):Object.keys(this.components):[]},t.prototype.update=function(){var t=this.components,e=this.chart,i=e.options.accessibility;S(e,"beforeA11yUpdate"),e.types=this.getChartTypes();var n=i.keyboardNavigation.order;this.proxyProvider.updateGroupOrder(n),this.getComponentOrder().forEach(function(i){t[i].onChartUpdate(),S(e,"afterA11yComponentUpdate",{name:i,component:t[i]})}),this.keyboardNavigation.update(n),!e.highContrastModeActive&&v.isHighContrastModeActive()&&v.setHighContrastTheme(e),S(e,"afterA11yUpdate",{accessibility:this})},t.prototype.destroy=function(){var t=this.chart||{},e=this.components;Object.keys(e).forEach(function(t){e[t].destroy(),e[t].destroyBase()}),this.proxyProvider&&this.proxyProvider.destroy(),t.announcerContainer&&D(t.announcerContainer),this.keyboardNavigation&&this.keyboardNavigation.destroy(),t.renderTo&&t.renderTo.setAttribute("aria-hidden",!0),t.focusElement&&t.focusElement.removeFocusBorder()},t.prototype.getChartTypes=function(){var t={};return this.chart.series.forEach(function(e){t[e.type]=1}),Object.keys(t)},t}();return function(t){function e(){this.accessibility&&this.accessibility.destroy()}function i(){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var t=this.accessibility;t&&!t.zombie&&(t.proxyProvider.updateProxyElementPositions(),t.getComponentOrder().forEach(function(e){t.components[e].onChartRender()}))}function n(t){var e=t.options.accessibility;e&&(e.customComponents&&(this.options.accessibility.customComponents=e.customComponents,delete e.customComponents),k(!0,this.options.accessibility,e),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0}function r(){var e=this.accessibility,i=this.options.accessibility;i&&i.enabled?e&&!e.zombie?e.update():(this.accessibility=e=new t(this),e&&!e.zombie&&e.update()):e?(e.destroy&&e.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)}function a(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)}t.i18nFormat=o.i18nFormat,t.compose=function t(d,p,f,v,y,b){l.compose(d),u.compose(v),c.compose(d,p),h.compose(d),m.compose(d,f,v),o.compose(d),s.compose(d,y),b&&g.compose(d,b),P(C,t)&&(d.prototype.updateA11yEnabled=r,T(d,"destroy",e),T(d,"render",i),T(d,"update",n),["addSeries","init"].forEach(function(t){T(d,t,function(){this.a11yDirty=!0})}),["afterApplyDrilldown","drillupall"].forEach(function(t){T(d,t,function(){var t=this.accessibility;t&&!t.zombie&&t.update()})}),T(f,"update",a),["update","updatedData","remove"].forEach(function(t){T(v,t,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})}))}}(B||(B={})),k(!0,w,b,{accessibility:{highContrastTheme:y},lang:x}),B}),i(e,"masters/modules/accessibility.src.js",[e["Core/Globals.js"],e["Accessibility/Accessibility.js"],e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Components/SeriesComponent/SeriesDescriber.js"]],function(t,e,i,n,o,r,s){t.i18nFormat=e.i18nFormat,t.A11yChartUtilities=n,t.A11yHTMLUtilities=o,t.AccessibilityComponent=i,t.KeyboardNavigationHandler=r,t.SeriesAccessibilityDescriber=s,e.compose(t.Chart,t.Legend,t.Point,t.Series,t.SVGElement,t.RangeSelector)})});