/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Boost module
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 *
 * */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/boost",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function i(e,t,i,o){e.hasOwnProperty(t)||(e[t]=o.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}i(t,"Extensions/Boost/Boostables.js",[],function(){return["area","areaspline","arearange","column","columnrange","bar","line","scatter","heatmap","bubble","treemap"]}),i(t,"Extensions/Boost/BoostableMap.js",[t["Extensions/Boost/Boostables.js"]],function(e){var t={};return e.forEach(function(e){t[e]=!0}),t}),i(t,"Extensions/Boost/BoostChart.js",[t["Extensions/Boost/BoostableMap.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(e,t,i){var o=t.composed,r=i.addEvent,s=i.pick,n=i.pushUnique;function a(t){var i=t.series,o=t.boost=t.boost||{},r=t.options.boost||{},n=s(r.seriesThreshold,50);if(i.length>=n)return!0;if(1===i.length)return!1;var a=r.allowForce;if(void 0===a){a=!0;for(var l=0,h=t.xAxis;l<h.length;l++){var f=h[l];if(s(f.min,-1/0)>s(f.dataMin,-1/0)||s(f.max,1/0)<s(f.dataMax,1/0)){a=!1;break}}}if(void 0!==o.forceChartBoost){if(a)return o.forceChartBoost;o.forceChartBoost=void 0}for(var d,u=0,c=0,p=0;p<i.length;p++){var g=i[p];0!==(d=g.options).boostThreshold&&!1!==g.visible&&"heatmap"!==g.type&&(e[g.type]&&++u,function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var i=-Number.MAX_VALUE;return e.forEach(function(e){if(null!=e&&void 0!==e.length&&e.length>0)return i=e.length,!0}),i}(g.processedXData,d.data,g.points)>=(d.boostThreshold||Number.MAX_VALUE)&&++c)}return o.forceChartBoost=a&&(u===i.length&&c===u||c>5),o.forceChartBoost}function l(e){function t(){e.boost&&e.boost.wgl&&a(e)&&e.boost.wgl.render(e)}r(e,"predraw",function(){e.boost=e.boost||{},e.boost.forceChartBoost=void 0,e.boosted=!1,e.boost.clear&&e.boost.clear(),e.boost.canvas&&e.boost.wgl&&a(e)&&e.boost.wgl.allocateBuffer(e),e.boost.markerGroup&&e.xAxis&&e.xAxis.length>0&&e.yAxis&&e.yAxis.length>0&&e.boost.markerGroup.translate(e.xAxis[0].pos,e.yAxis[0].pos)}),r(e,"load",t,{order:-1}),r(e,"redraw",t);var i=-1,o=-1;r(e.pointer,"afterGetHoverData",function(){var t=e.hoverSeries;if(e.boost=e.boost||{},e.boost.markerGroup&&t){var r=e.inverted?t.yAxis:t.xAxis,s=e.inverted?t.xAxis:t.yAxis;(r&&r.pos!==i||s&&s.pos!==o)&&(e.boost.markerGroup.translate(r.pos,s.pos),i=r.pos,o=s.pos)}})}return{compose:function e(t,i){return i&&n(o,e)&&t.prototype.callbacks.push(l),t},getBoostClipRect:function(e,t){var i={x:e.plotLeft,y:e.plotTop,width:e.plotWidth,height:e.navigator?e.navigator.top+e.navigator.height-e.plotTop:e.plotHeight};if(t.getClipBox){var o=t.xAxis,r=t.yAxis;if(i=t.getClipBox(),e.inverted){var s=i.width;i.width=i.height,i.height=s,i.x=r.pos,i.y=o.pos}else i.x=o.pos,i.y=r.pos}if(t===e){var n=e.inverted?e.xAxis:e.yAxis;n.length<=1&&(i.y=Math.min(n[0].pos,i.y),i.height=n[0].pos-e.plotTop+n[0].len)}return i},isChartSeriesBoosting:a}}),i(t,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}}),i(t,"Extensions/Boost/WGLShader.js",[t["Core/Utilities.js"]],function(e){var t=e.clamp,i=e.error,o=e.pick;return function(){function e(e){if(this.errors=[],this.uLocations={},this.gl=e,e&&!this.createShader())return}return e.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)},e.prototype.createShader=function(){var e=this,t=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),i=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),o=function(t){return e.gl.getUniformLocation(e.shaderProgram,t)};return t&&i?(this.shaderProgram=this.gl.createProgram(),this.gl.attachShader(this.shaderProgram,t),this.gl.attachShader(this.shaderProgram,i),this.gl.linkProgram(this.shaderProgram),this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))?(this.gl.useProgram(this.shaderProgram),this.gl.bindAttribLocation(this.shaderProgram,0,"aVertexPosition"),this.pUniform=o("uPMatrix"),this.psUniform=o("pSize"),this.fcUniform=o("fillColor"),this.isBubbleUniform=o("isBubble"),this.bubbleSizeAbsUniform=o("bubbleSizeAbs"),this.bubbleSizeAreaUniform=o("bubbleSizeByArea"),this.uSamplerUniform=o("uSampler"),this.skipTranslationUniform=o("skipTranslation"),this.isCircleUniform=o("isCircle"),this.isInverted=o("isInverted"),!0):(this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1,!1):(this.shaderProgram=!1,this.handleErrors(),!1)},e.prototype.handleErrors=function(){this.errors.length&&i("[highcharts boost] shader error - "+this.errors.join("\n"))},e.prototype.stringToProgram=function(e,t){var i=this.gl.createShader("vertex"===t?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);return(this.gl.shaderSource(i,e),this.gl.compileShader(i),this.gl.getShaderParameter(i,this.gl.COMPILE_STATUS))?i:(this.errors.push("when compiling "+t+" shader:\n"+this.gl.getShaderInfoLog(i)),!1)},e.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)},e.prototype.fillColorUniform=function(){return this.fcUniform},e.prototype.getProgram=function(){return this.shaderProgram},e.prototype.pointSizeUniform=function(){return this.psUniform},e.prototype.perspectiveUniform=function(){return this.pUniform},e.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))},e.prototype.setBubbleUniforms=function(e,i,r,s){void 0===s&&(s=1);var n=e.options,a=Number.MAX_VALUE,l=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&e.is("bubble")){var h=e.getPxExtremes();a=o(n.zMin,t(i,!1===n.displayNegative?n.zThreshold:-Number.MAX_VALUE,a)),l=o(n.zMax,Math.max(l,r)),this.gl.uniform1i(this.isBubbleUniform,1),this.gl.uniform1i(this.isCircleUniform,1),this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==e.options.sizeBy),this.gl.uniform1i(this.bubbleSizeAbsUniform,e.options.sizeByAbsoluteValue),this.setUniform("bubbleMinSize",h.minPxSize*s),this.setUniform("bubbleMaxSize",h.maxPxSize*s),this.setUniform("bubbleZMin",a),this.setUniform("bubbleZMax",l),this.setUniform("bubbleZThreshold",e.options.zThreshold)}},e.prototype.setColor=function(e){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,e[0]/255,e[1]/255,e[2]/255,e[3])},e.prototype.setDrawAsCircle=function(e){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,e?1:0)},e.prototype.setInverted=function(e){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,e)},e.prototype.setPMatrix=function(e){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,!1,e)},e.prototype.setPointSize=function(e){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,e)},e.prototype.setSkipTranslation=function(e){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===e?1:0)},e.prototype.setTexture=function(e){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,e)},e.prototype.setUniform=function(e,t){if(this.gl&&this.shaderProgram){var i=this.uLocations[e]=this.uLocations[e]||this.gl.getUniformLocation(this.shaderProgram,e);this.gl.uniform1f(i,t)}},e}()}),i(t,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function e(e,t,i){this.buffer=!1,this.iterator=0,this.preAllocated=!1,this.vertAttribute=!1,this.components=i||2,this.dataComponents=i,this.gl=e,this.shader=t}return e.prototype.allocate=function(e){this.iterator=-1,this.preAllocated=new Float32Array(4*e)},e.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)},e.prototype.build=function(e,t,i){var o;return(this.data=e||[],this.data&&0!==this.data.length||this.preAllocated)?(this.components=i||this.components,this.buffer&&this.gl.deleteBuffer(this.buffer),this.preAllocated||(o=new Float32Array(this.data)),this.buffer=this.gl.createBuffer(),this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||o,this.gl.STATIC_DRAW),this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),t),this.gl.enableVertexAttribArray(this.vertAttribute),o=!1,!0):(this.destroy(),!1)},e.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.buffer=!1,this.vertAttribute=!1),this.iterator=0,this.components=this.dataComponents||2,this.data=[]},e.prototype.push=function(e,t,i,o){this.preAllocated&&(this.preAllocated[++this.iterator]=e,this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=i,this.preAllocated[++this.iterator]=o)},e.prototype.render=function(e,t,i){var o=this.preAllocated?this.preAllocated.length:this.data.length;return!!this.buffer&&!!o&&((!e||e>o||e<0)&&(e=0),(!t||t>o)&&(t=o),!(e>=t)&&(i=i||"POINTS",this.gl.drawArrays(this.gl[i],e/this.components,(t-e)/this.components),!0))},e}()}),i(t,"Extensions/Boost/WGLRenderer.js",[t["Core/Color/Color.js"],t["Core/Globals.js"],t["Core/Utilities.js"],t["Extensions/Boost/WGLDrawMode.js"],t["Extensions/Boost/WGLShader.js"],t["Extensions/Boost/WGLVertexBuffer.js"]],function(e,t,i,o,r,s){var n=e.parse,a=t.doc,l=t.win,h=i.isNumber,f=i.isObject,d=i.merge,u=i.objectEach,c=i.pick,p={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},g={scatter:!0,bubble:!0},m=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function i(e){this.data=[],this.height=0,this.isInited=!1,this.markerData=[],this.series=[],this.textureHandles={},this.width=0,this.postRenderCallback=e,this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}return i.orthoMatrix=function(e,t){return[2/e,0,0,0,0,-(2/t),0,0,0,0,-2,0,-1,1,-1,1]},i.seriesPointCount=function(e){var t,i,o;return e.boosted?(t=!!e.options.stacking,i=e.xData||e.options.xData||e.processedXData,o=(t?e.data:i||e.options.data).length,"treemap"===e.type?o*=12:"heatmap"===e.type?o*=6:p[e.type]&&(o*=2),o):0},i.prototype.getPixelRatio=function(){return this.settings.pixelRatio||l.devicePixelRatio||1},i.prototype.setOptions=function(e){"pixelRatio"in e||(e.pixelRatio=1),d(!0,this.settings,e)},i.prototype.allocateBuffer=function(e){var t=this.vbuffer,o=0;this.settings.usePreallocated&&(e.series.forEach(function(e){e.boosted&&(o+=i.seriesPointCount(e))}),t&&t.allocate(o))},i.prototype.allocateBufferForSingleSeries=function(e){var t=this.vbuffer,o=0;this.settings.usePreallocated&&(e.boosted&&(o=i.seriesPointCount(e)),t&&t.allocate(o))},i.prototype.clear=function(){var e=this.gl;e&&e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT)},i.prototype.pushSeriesData=function(e,t){var i,o,r,s,a,l,h,d,u=this,c=this.data,g=this.settings,m=this.vbuffer,b=e.pointArrayMap&&"low,high"===e.pointArrayMap.join(","),x=e.chart,v=e.options,A=e.sorted,y=e.xAxis,P=e.yAxis,T=!!v.stacking,E=v.data,S=e.xAxis.getExtremes(),M=S.min-(e.xAxis.minPointOffset||0),C=S.max+(e.xAxis.minPointOffset||0),k=e.yAxis.getExtremes(),w=k.min-(e.yAxis.minPointOffset||0),U=k.max+(e.yAxis.minPointOffset||0),R=e.xData||v.xData||e.processedXData,D=e.yData||v.yData||e.processedYData,B=e.zData||v.zData||e.processedZData,L=!R||0===R.length,z=v.connectNulls,_=e.points||!1,N=T?e.data:R||E,I={x:Number.MAX_VALUE,y:0},G={x:-Number.MAX_VALUE,y:0},O=void 0===x.index,X=p[e.type],j=v.zoneAxis||"y",V=v.zones||!1,F=v.threshold,H=this.getPixelRatio(),W=e.chart.plotWidth,Y=!1,q=!1,Z=0,K=!1,Q=-1,J=!1,$=!1,ee=!1,et=!1,ei=!1,eo=!1,er=!0,es=!0,en=!1,ea=!1,el=0;if(!v.boostData||!(v.boostData.length>0)){v.gapSize&&(ea="value"!==v.gapUnit?v.gapSize*e.closestPointRange:v.gapSize),V&&(d=[],V.forEach(function(e,t){if(e.color){var i=n(e.color).rgba;i[0]/=255,i[1]/=255,i[2]/=255,d[t]=i,en||void 0!==e.value||(en=i)}}),en||(en=n(e.pointAttribs&&e.pointAttribs().fill||e.color).rgba,en[0]/=255,en[1]/=255,en[2]/=255)),x.inverted&&(W=e.chart.plotHeight),e.closestPointRangePx=Number.MAX_VALUE;var eh=function(e){e&&(t.colorData.push(e[0]),t.colorData.push(e[1]),t.colorData.push(e[2]),t.colorData.push(e[3]))},ef=function(e,i,o,r,s){void 0===r&&(r=1),eh(s),1!==H&&(!g.useGPUTranslations||t.skipTranslation)&&(e*=H,i*=H,r*=H),g.usePreallocated&&m?(m.push(e,i,o?1:0,r),el+=4):(c.push(e),c.push(i),c.push(o?H:0),c.push(r))},ed=function(){t.segments.length&&(t.segments[t.segments.length-1].to=c.length||el)},eu=function(){t.segments.length&&t.segments[t.segments.length-1].from===(c.length||el)||(ed(),t.segments.push({from:c.length||el}))},ec=function(e,t,i,o,r){eh(r),ef(e+i,t),eh(r),ef(e,t),eh(r),ef(e,t+o),eh(r),ef(e,t+o),eh(r),ef(e+i,t+o),eh(r),ef(e+i,t)};if(eu(),_&&_.length>0){t.skipTranslation=!0,t.drawMode="TRIANGLES",_[0].node&&_[0].node.levelDynamic&&_.sort(function(e,t){if(e.node){if(e.node.levelDynamic>t.node.levelDynamic)return 1;if(e.node.levelDynamic<t.node.levelDynamic)return -1}return 0}),_.forEach(function(t){var i,r,s=t.plotY;if(void 0!==s&&!isNaN(s)&&null!==t.y&&t.shapeArgs){var a=t.shapeArgs,l=a.x,h=void 0===l?0:l,f=a.y,d=void 0===f?0:f,u=a.width,c=void 0===u?0:u,p=a.height,g=void 0===p?0:p;i=(r=x.styledMode?t.series.colorAttribs(t):r=t.series.pointAttribs(t))["stroke-width"]||0,ei=n(r.fill).rgba,ei[0]/=255,ei[1]/=255,ei[2]/=255,e.is("treemap")&&(i=i||1,o=n(r.stroke).rgba,o[0]/=255,o[1]/=255,o[2]/=255,ec(h,d,c,g,o),i/=2),e.is("heatmap")&&x.inverted&&(h=y.len-h,d=P.len-d,c=-c,g=-g),ec(h+i,d+i,c-2*i,g-2*i,ei)}}),ed();return}for(;Q<N.length-1&&"break"!==function(){if(void 0===(a=N[++Q]))return"continue";if(O)return"break";var o,u=E&&E[Q];return(!L&&f(u,!0)&&u.color&&(ei=n(u.color).rgba,ei[0]/=255,ei[1]/=255,ei[2]/=255),L?(r=a[0],s=a[1],N[Q+1]&&($=N[Q+1][0]),N[Q-1]&&(J=N[Q-1][0]),a.length>=3&&(l=a[2],a[2]>t.zMax&&(t.zMax=a[2]),a[2]<t.zMin&&(t.zMin=a[2]))):(r=a,s=D[Q],N[Q+1]&&($=N[Q+1]),N[Q-1]&&(J=N[Q-1]),B&&B.length&&(l=B[Q],B[Q]>t.zMax&&(t.zMax=B[Q]),B[Q]<t.zMin&&(t.zMin=B[Q]))),z||null!==r&&null!==s)?($&&$>=M&&$<=C&&(ee=!0),J&&J>=M&&J<=C&&(et=!0),b?(L&&(s=a.slice(1,3)),h=s[0],s=s[1]):T&&(r=a.x,h=(s=a.stackY)-a.y),null!=w&&null!=U&&(er=s>=w&&s<=U),r>C&&G.x<C&&(G.x=r,G.y=s),r<M&&I.x>M&&(I.x=r,I.y=s),null===s&&z)?"continue":null!==s&&(er||ee||et)?(A&&($>=M||r>=M)&&(J<=C||r<=C)&&(eo=!0),eo||ee||et)?(ea&&r-J>ea&&eu(),V&&(V.some(function(e,t){var i=V[t-1];return"x"===j?void 0!==e.value&&r<=e.value&&(d[t]&&(!i||r>=i.value)&&(o=d[t]),!0):void 0!==e.value&&s<=e.value&&(d[t]&&(!i||s>=i.value)&&(o=d[t]),!0)}),ei=o||en||ei),!g.useGPUTranslations&&(t.skipTranslation=!0,r=y.toPixels(r,!0),s=P.toPixels(s,!0),r>W&&"POINTS"===t.drawMode))?"continue":(t.hasMarkers&&eo&&!1!==Y&&(e.closestPointRangePx=Math.min(e.closestPointRangePx,Math.abs(r-Y))),!g.useGPUTranslations&&!g.usePreallocated&&Y&&1>Math.abs(r-Y)&&q&&1>Math.abs(s-q))?(g.debug.showSkipSummary&&++Z,"continue"):void(X&&(i=h,(!1===h||void 0===h)&&(i=s<0?s:0),(b||T)&&!P.logarithmic||(i=Math.max(null===F?w:F,w)),g.useGPUTranslations||(i=P.toPixels(i,!0)),ef(r,i,0,0,ei)),v.step&&!es&&ef(r,q,0,2,ei),ef(r,s,0,"bubble"===e.type?l||1:2,ei),Y=r,q=s,K=!0,es=!1):"continue":(eu(),"continue"):(eu(),"continue")}(););g.debug.showSkipSummary&&console.log("skipped points:",Z);var ep=function(e,i){if(g.useGPUTranslations||(t.skipTranslation=!0,e.x=y.toPixels(e.x,!0),e.y=P.toPixels(e.y,!0)),i){u.data=[e.x,e.y,0,2].concat(u.data);return}ef(e.x,e.y,0,2)};!K&&!1!==z&&"line_strip"===e.drawMode&&(I.x<Number.MAX_VALUE&&ep(I,!0),G.x>-Number.MAX_VALUE&&ep(G)),ed()}},i.prototype.pushSeries=function(e){var t=this.markerData,i=this.series,r=this.settings;i.length>0&&i[i.length-1].hasMarkers&&(i[i.length-1].markerTo=t.length),r.debug.timeSeriesProcessing&&console.time("building "+e.type+" series");var s={segments:[],markerFrom:t.length,colorData:[],series:e,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!e.options.marker&&!1!==e.options.marker.enabled,showMarkers:!0,drawMode:o[e.type]||"LINE_STRIP"};e.index>=i.length?i.push(s):i[e.index]=s,this.pushSeriesData(e,s),r.debug.timeSeriesProcessing&&console.timeEnd("building "+e.type+" series")},i.prototype.flush=function(){var e=this.vbuffer;this.data=[],this.markerData=[],this.series=[],e&&e.destroy()},i.prototype.setXAxis=function(e){var t=this.shader;if(t){var i=this.getPixelRatio();t.setUniform("xAxisTrans",e.transA*i),t.setUniform("xAxisMin",e.min),t.setUniform("xAxisMinPad",e.minPixelPadding*i),t.setUniform("xAxisPointRange",e.pointRange),t.setUniform("xAxisLen",e.len*i),t.setUniform("xAxisPos",e.pos*i),t.setUniform("xAxisCVSCoord",!e.horiz),t.setUniform("xAxisIsLog",!!e.logarithmic),t.setUniform("xAxisReversed",!!e.reversed)}},i.prototype.setYAxis=function(e){var t=this.shader;if(t){var i=this.getPixelRatio();t.setUniform("yAxisTrans",e.transA*i),t.setUniform("yAxisMin",e.min),t.setUniform("yAxisMinPad",e.minPixelPadding*i),t.setUniform("yAxisPointRange",e.pointRange),t.setUniform("yAxisLen",e.len*i),t.setUniform("yAxisPos",e.pos*i),t.setUniform("yAxisCVSCoord",!e.horiz),t.setUniform("yAxisIsLog",!!e.logarithmic),t.setUniform("yAxisReversed",!!e.reversed)}},i.prototype.setThreshold=function(e,t){var i=this.shader;i&&(i.setUniform("hasThreshold",e),i.setUniform("translatedThreshold",t))},i.prototype.renderChart=function(o){var r=this,a=this.gl,l=this.settings,f=this.shader,d=this.vbuffer,u=this.getPixelRatio();if(!o)return!1;this.width=o.chartWidth*u,this.height=o.chartHeight*u;var p=this.height,m=this.width;if(!a||!f||!m||!p)return!1;l.debug.timeRendering&&console.time("gl rendering"),a.canvas.width=m,a.canvas.height=p,f.bind(),a.viewport(0,0,m,p),f.setPMatrix(i.orthoMatrix(m,p)),l.lineWidth>1&&!t.isMS&&a.lineWidth(l.lineWidth),d&&(d.build(this.data,"aVertexPosition",4),d.bind()),f.setInverted(o.inverted),this.series.forEach(function(t,i){var p,m,b,x=t.series.options,v=x.marker,A=void 0!==x.lineWidth?x.lineWidth:1,y=x.threshold,P=h(y),T=t.series.yAxis.getThreshold(y),E=c(x.marker?x.marker.enabled:null,!!t.series.xAxis.isRadial||null,t.series.closestPointRangePx>2*((x.marker?x.marker.radius:10)||10)),S=r.textureHandles[v&&v.symbol||t.series.symbol]||r.textureHandles.circle,M=[];if(0!==t.segments.length&&t.segments[0].from!==t.segments[0].to&&(S.isReady&&(a.bindTexture(a.TEXTURE_2D,S.handle),f.setTexture(S.handle)),o.styledMode?b=t.series.markerGroup&&t.series.markerGroup.getStyle("fill"):(b="POINTS"===t.drawMode&&t.series.pointAttribs&&t.series.pointAttribs().fill||t.series.color,x.colorByPoint&&(b=t.series.chart.options.colors[i])),t.series.fillOpacity&&x.fillOpacity&&(b=new e(b).setOpacity(c(x.fillOpacity,1)).get()),M=n(b).rgba,l.useAlpha||(M[3]=1),"LINES"===t.drawMode&&l.useAlpha&&M[3]<1&&(M[3]/=10),"add"===x.boostBlending?(a.blendFunc(a.SRC_ALPHA,a.ONE),a.blendEquation(a.FUNC_ADD)):"mult"===x.boostBlending||"multiply"===x.boostBlending?a.blendFunc(a.DST_COLOR,a.ZERO):"darken"===x.boostBlending?(a.blendFunc(a.ONE,a.ONE),a.blendEquation(a.FUNC_MIN)):a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE,a.ONE_MINUS_SRC_ALPHA),f.reset(),t.colorData.length>0?(f.setUniform("hasColor",1),(m=new s(a,f)).build(Array(t.segments[0].from).concat(t.colorData),"aColor",4),m.bind()):(f.setUniform("hasColor",0),a.disableVertexAttribArray(a.getAttribLocation(f.getProgram(),"aColor"))),f.setColor(M),r.setXAxis(t.series.xAxis),r.setYAxis(t.series.yAxis),r.setThreshold(P,T),"POINTS"===t.drawMode&&f.setPointSize(2*c(x.marker&&x.marker.radius,.5)*u),f.setSkipTranslation(t.skipTranslation),"bubble"===t.series.type&&f.setBubbleUniforms(t.series,t.zMin,t.zMax,u),f.setDrawAsCircle(g[t.series.type]||!1),d)){if(A>0||"LINE_STRIP"!==t.drawMode)for(p=0;p<t.segments.length;p++)d.render(t.segments[p].from,t.segments[p].to,t.drawMode);if(t.hasMarkers&&E)for(f.setPointSize(2*c(x.marker&&x.marker.radius,5)*u),f.setDrawAsCircle(!0),p=0;p<t.segments.length;p++)d.render(t.segments[p].from,t.segments[p].to,"POINTS")}}),l.debug.timeRendering&&console.timeEnd("gl rendering"),this.postRenderCallback&&this.postRenderCallback(this),this.flush()},i.prototype.render=function(e){var t=this;if(this.clear(),e.renderer.forExport)return this.renderChart(e);this.isInited?this.renderChart(e):setTimeout(function(){t.render(e)},1)},i.prototype.setSize=function(e,t){var o=this.shader;o&&(this.width!==e||this.height!==t)&&(this.width=e,this.height=t,o.bind(),o.setPMatrix(i.orthoMatrix(e,t)))},i.prototype.init=function(e,t){var i=this,o=this.settings;if(this.isInited=!1,!e)return!1;o.debug.timeSetup&&console.time("gl setup");for(var n=0;n<m.length&&(this.gl=e.getContext(m[n],{}),!this.gl);++n);var l=this.gl;if(!l)return!1;t||this.flush(),l.enable(l.BLEND),l.blendFunc(l.SRC_ALPHA,l.ONE_MINUS_SRC_ALPHA),l.disable(l.DEPTH_TEST),l.depthFunc(l.LESS);var h=this.shader=new r(l);if(!h)return!1;this.vbuffer=new s(l,h);var f=function(e,t){var o={isReady:!1,texture:a.createElement("canvas"),handle:l.createTexture()},r=o.texture.getContext("2d");i.textureHandles[e]=o,o.texture.width=512,o.texture.height=512,r.mozImageSmoothingEnabled=!1,r.webkitImageSmoothingEnabled=!1,r.msImageSmoothingEnabled=!1,r.imageSmoothingEnabled=!1,r.strokeStyle="rgba(255, 255, 255, 0)",r.fillStyle="#FFF",t(r);try{l.activeTexture(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,o.handle),l.texImage2D(l.TEXTURE_2D,0,l.RGBA,l.RGBA,l.UNSIGNED_BYTE,o.texture),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_WRAP_S,l.CLAMP_TO_EDGE),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_WRAP_T,l.CLAMP_TO_EDGE),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_MAG_FILTER,l.LINEAR),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_MIN_FILTER,l.LINEAR),l.bindTexture(l.TEXTURE_2D,null),o.isReady=!0}catch(e){}};return f("circle",function(e){e.beginPath(),e.arc(256,256,256,0,2*Math.PI),e.stroke(),e.fill()}),f("square",function(e){e.fillRect(0,0,512,512)}),f("diamond",function(e){e.beginPath(),e.moveTo(256,0),e.lineTo(512,256),e.lineTo(256,512),e.lineTo(0,256),e.lineTo(256,0),e.fill()}),f("triangle",function(e){e.beginPath(),e.moveTo(0,512),e.lineTo(256,0),e.lineTo(512,512),e.lineTo(0,512),e.fill()}),f("triangle-down",function(e){e.beginPath(),e.moveTo(0,0),e.lineTo(256,512),e.lineTo(512,0),e.lineTo(0,0),e.fill()}),this.isInited=!0,o.debug.timeSetup&&console.timeEnd("gl setup"),!0},i.prototype.destroy=function(){var e=this.gl,t=this.shader,i=this.vbuffer;this.flush(),i&&i.destroy(),t&&t.destroy(),e&&(u(this.textureHandles,function(t){t.handle&&e.deleteTexture(t.handle)}),e.canvas.width=1,e.canvas.height=1)},i}()}),i(t,"Extensions/Boost/BoostSeries.js",[t["Extensions/Boost/BoostableMap.js"],t["Extensions/Boost/Boostables.js"],t["Extensions/Boost/BoostChart.js"],t["Core/Defaults.js"],t["Core/Globals.js"],t["Core/Utilities.js"],t["Extensions/Boost/WGLRenderer.js"]],function(e,t,i,o,r,s,n){var a,l,h=i.getBoostClipRect,f=i.isChartSeriesBoosting,d=o.getOptions,u=r.composed,c=r.doc,p=r.noop,g=r.win,m=s.addEvent,b=s.destroyObjectProperties,x=s.error,v=s.extend,A=s.fireEvent,y=s.isArray,P=s.isNumber,T=s.pick,E=s.pushUnique,S=s.wrap,M=s.defined;function C(e,t){var i=t.boost;e&&i&&i.target&&i.canvas&&!f(t.chart)&&e.allocateBufferForSingleSeries(t)}function k(e){return T(e&&e.options&&e.options.boost&&e.options.boost.enabled,!0)}function w(e,t){var i=e.constructor,o=e.seriesGroup||t.group,r=e.chartWidth,s=e.chartHeight,a=e,d="undefined"!=typeof SVGForeignObjectElement,u=(a=f(e)?e:t).boost=a.boost||{};return d=!1,l||(l=c.createElement("canvas")),!u.target&&(u.canvas=l,e.renderer.forExport||!d?(a.renderTarget=u.target=e.renderer.image("",0,0,r,s).addClass("highcharts-boost-canvas").add(o),u.clear=function(){u.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},u.copy=function(){u.resize(),u.target.attr({href:u.canvas.toDataURL("image/png")})}):(u.targetFo=e.renderer.createElement("foreignObject").add(o),a.renderTarget=u.target=c.createElement("canvas"),u.targetCtx=u.target.getContext("2d"),u.targetFo.element.appendChild(u.target),u.clear=function(){u.target.width=u.canvas.width,u.target.height=u.canvas.height},u.copy=function(){u.target.width=u.canvas.width,u.target.height=u.canvas.height,u.targetCtx.drawImage(u.canvas,0,0)}),u.resize=function(){r=e.chartWidth,s=e.chartHeight,(u.targetFo||u.target).attr({x:0,y:0,width:r,height:s}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1}),a instanceof i&&a.boost.markerGroup.translate(e.plotLeft,e.plotTop)},u.clipRect=e.renderer.clipRect(),(u.targetFo||u.target).attr({zIndex:t.options.zIndex}).clip(u.clipRect),a instanceof i&&(a.boost.markerGroup=a.renderer.g().add(o).translate(t.xAxis.pos,t.yAxis.pos))),u.canvas.width=r,u.canvas.height=s,u.clipRect&&u.clipRect.attr(h(e,a)),u.resize(),u.clear(),!u.wgl&&(u.wgl=new n(function(e){e.settings.debug.timeBufferCopy&&console.time("buffer copy"),u.copy(),e.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),u.wgl.init(u.canvas)||x("[highcharts boost] - unable to init WebGL renderer"),u.wgl.setOptions(e.options.boost||{}),a instanceof i&&u.wgl.allocateBuffer(e)),u.wgl.setSize(r,s),u.wgl}function U(e){var t=e.points;if(t){var i=void 0,o=void 0;for(o=0;o<t.length;o+=1)(i=t[o])&&i.destroyElements&&i.destroyElements()}["graph","area","tracker"].forEach(function(t){var i=e[t];i&&(e[t]=i.destroy())}),e.zones.forEach(b)}function R(e,t,i,o,r,s){for(var n=(r=r||0)+(o=o||3e3),a=!0;a&&r<n&&r<e.length;)a=t(e[r],r),++r;a&&(r<e.length?s?R(e,t,i,o,r,s):g.requestAnimationFrame?g.requestAnimationFrame(function(){R(e,t,i,o,r)}):setTimeout(R,0,e,t,i,o,r):i&&i())}function D(e,t){var i=e.options,o=i.data,r=e.xAxis&&e.xAxis.options,s=e.yAxis&&e.yAxis.options,n=e.colorAxis&&e.colorAxis.options;return o.length>(i.boostThreshold||Number.MAX_VALUE)&&P(s.min)&&P(s.max)&&(!t||P(r.min)&&P(r.max))&&(!n||P(n.min)&&P(n.max))}var B=function(e,t){return!e.forceCrop&&(f(e.chart)||(t?t.length:0)>=(e.options.boostThreshold||Number.MAX_VALUE))};function L(){var e=this,t=e.chart;t.boost&&t.boost.markerGroup===e.markerGroup&&(e.markerGroup=null),t.hoverPoints&&(t.hoverPoints=t.hoverPoints.filter(function(t){return t.series===e})),t.hoverPoint&&t.hoverPoint.series===e&&(t.hoverPoint=null)}function z(){var e=this.boost;e&&e.canvas&&e.target&&(e.wgl&&e.wgl.clear(),e.clear&&e.clear())}function _(e){var t=e.boost;t&&t.canvas&&t.target&&t.wgl&&!f(e.chart)&&t.wgl.render(e.chart)}function N(e,t){var i=e.options,o=e.xAxis,r=e.pointClass;if(t instanceof r)return t;var s=e.xData||i.xData||e.processedXData||!1,n=new r(e,(e.options.data||[])[t.i],s?s[t.i]:void 0);return n.category=T(o.categories?o.categories[n.x]:n.x,n.x),n.dist=t.dist,n.distX=t.distX,n.plotX=t.plotX,n.plotY=t.plotY,n.index=t.i,n.percentage=t.percentage,n.isInside=e.isPointInside(n),n}function I(e){var t=this.options,i=this.xAxis,o=this.yAxis;if(!this.isDirty&&!i.isDirty&&!o.isDirty&&!e)return!1;this.yAxis.setTickInterval();var r=t.boostThreshold||0,s=t.cropThreshold,n=t.data||this.data,a=this.xData,l=i.getExtremes(),h=l.max,f=l.min,d=this.yData,u=o.getExtremes(),c=u.max,p=u.min;if(!this.boosted&&i.old&&o.old&&f>=(null!==(g=i.old.min)&&void 0!==g?g:-Number.MAX_VALUE)&&h<=(null!==(m=i.old.max)&&void 0!==m?m:Number.MAX_VALUE)&&p>=(null!==(b=o.old.min)&&void 0!==b?b:-Number.MAX_VALUE)&&c<=(null!==(x=o.old.max)&&void 0!==x?x:Number.MAX_VALUE))return null!==(v=this.processedXData)&&void 0!==v||(this.processedXData=a),null!==(A=this.processedYData)&&void 0!==A||(this.processedYData=d),!0;if(!r||n.length<r||s&&!this.forceCrop&&!this.getExtremesFromAll&&!t.getExtremesFromAll&&n.length<s)return this.processedXData=a,this.processedYData=d,!0;for(var g,m,b,x,v,A,y,P,T=[],E=[],S=[],M=!1,C=0,k=a.length;C<k;++C)y=a[C],P=d[C],y>=f&&y<=h&&P>=p&&P<=c?(T.push({x:y,y:P}),E.push(y),S.push(P)):M=!0;return this.cropped=M,this.cropStart=0,this.processedXData=E,this.processedYData=S,B(this,E)||(this.processedData=T),!0}function G(){var e,t,i,o,r,s=this,n=this.options||{},l=this.chart,h=this.xAxis,d=this.yAxis,u=n.xData||this.processedXData,c=n.yData||this.processedYData,g=this.processedData||n.data,m=h.getExtremes(),b=m.min-(h.minPointOffset||0),x=m.max+(h.minPointOffset||0),v=d.getExtremes(),y=v.min-(d.minPointOffset||0),P=v.max+(d.minPointOffset||0),T={},E=!!this.sampling,S=n.enableMouseTracking,k=n.threshold,D=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),B=!!n.stacking,L=this.cropStart||0,z=this.requireSorting,N=!u,I="x"===n.findNearestPointBy,G=this.xData||this.options.xData||this.processedXData||!1,O=!1,X=d.getThreshold(k);if(O=w(l,this),l.boosted=!0,this.visible){(this.points||this.graph)&&U(this),f(l)?(this.markerGroup&&this.markerGroup!==l.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=l.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(l.boost&&this.markerGroup===l.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,l.seriesGroup));var j=this.points=[],V=function(e,t,i,o){var r=!!G&&G[L+i],s=function(e){l.inverted&&(e=h.len-e,t=d.len-t),j.push({destroy:p,x:r,clientX:e,plotX:e,plotY:t,i:L+i,percentage:o})};e=Math.ceil(e),a=I?e:e+","+t,S&&(T[a]?r===G[G.length-1]&&(j.length--,s(e)):(T[a]=!0,s(e)))};this.buildKDTree=p,O&&(C(O,this),O.pushSeries(this),_(this));var F=O.settings;l.renderer.forExport||(F.debug.timeKDTree&&console.time("kd tree building"),R(B?this.data.slice(L):u||g,function(s,n){var a,f,u,p,g,m=void 0===l.index,v=!1,A=!0;return!M(s)||(!m&&(N?(a=s[0],f=s[1]):(a=s,f=c[n]),D?(N&&(f=s.slice(1,3)),v=f[0],f=f[1]):B&&(a=s.x,v=(f=s.stackY)-s.y,g=s.percentage),z||(A=(f||0)>=y&&f<=P),null!==f&&a>=b&&a<=x&&A&&(u=h.toPixels(a,!0),E?((void 0===o||u===e)&&(D||(v=f),(void 0===r||f>i)&&(i=f,r=n),(void 0===o||v<t)&&(t=v,o=n)),I&&u===e||(void 0!==o&&(p=d.toPixels(i,!0),X=d.toPixels(t,!0),V(u,p,r,g),X!==p&&V(u,X,o,g)),o=r=void 0,e=u)):V(u,p=Math.ceil(d.toPixels(f,!0)),n,g))),!m)},function(){A(s,"renderedCanvas"),delete s.buildKDTree,s.options&&s.buildKDTree(),F.debug.timeKDTree&&console.timeEnd("kd tree building")}))}}function O(e){var t=!0;if(this.chart.options&&this.chart.options.boost&&(t=void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled),!t||!this.boosted)return e.call(this);this.chart.boosted=!0;var i=w(this.chart,this);i&&(C(i,this),i.pushSeries(this)),_(this)}function X(e){return this.boosted&&D(this)?{}:e.apply(this,[].slice.call(arguments,1))}function j(t){var i=this.options.data;if(k(this.chart)&&e[this.type]){var o,r,s=this.is("scatter")&&!this.is("bubble");if((!B(this,i)||s||this.options.stacking||!D(this,!0))&&(s&&!this.yAxis.treeGrid?I.call(this,arguments[1]):t.apply(this,[].slice.call(arguments,1)),i=this.processedXData),this.boosted=B(this,i),this.boosted){var n=void 0;this.options.data&&this.options.data.length&&!P(n=this.getFirstValidPoint(this.options.data))&&!y(n)&&x(12,!1,this.chart),function(e){e.boost=e.boost||{getPoint:function(t){return N(e,t)}};var t,i=e.boost.altered=[];if(["allowDG","directTouch","stickyTracking"].forEach(function(t){i.push({prop:t,val:e[t],own:Object.hasOwnProperty.call(e,t)})}),e.allowDG=!1,e.directTouch=!1,e.stickyTracking=!0,e.finishedAnimating=!0,e.labelBySeries&&(e.labelBySeries=e.labelBySeries.destroy()),e.is("scatter")&&e.data.length){for(var o=0,r=e.data;o<r.length;o++){var s=r[o];null===(t=null==s?void 0:s.destroy)||void 0===t||t.call(s)}e.data.length=0,e.points.length=0,delete e.processedData}}(this)}else o=this,(r=o.boost)&&((r.altered||[]).forEach(function(e){e.own?o[e.prop]=e.val:delete o[e.prop]}),r.clear&&r.clear())}else t.apply(this,[].slice.call(arguments,1))}function V(e){var t=e.apply(this,[].slice.call(arguments,1));return this.boost&&t?this.boost.getPoint(t):t}return{compose:function i(o,r,s){if(E(u,i)){var n=d().plotOptions,a=o.prototype;if(m(o,"destroy",L),m(o,"hide",z),s&&(a.renderCanvas=G),S(a,"getExtremes",X),S(a,"processData",j),S(a,"searchPoint",V),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(t){return function(t,i,o){function r(t){var i=this.options.stacking&&("translate"===o||"generatePoints"===o);this.boosted&&!i&&k(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&e[this.type]&&0!==this.options.boostThreshold?"render"===o&&this.renderCanvas&&this.renderCanvas():t.call(this)}if(S(t,o,r),"translate"===o)for(var s=0,n=["column","arearange","columnrange","heatmap","treemap"];s<n.length;s++){var a=n[s];i[a]&&S(i[a].prototype,o,r)}}(a,r,t)}),t.forEach(function(e){var t=n[e];t&&(t.boostThreshold=5e3,t.boostData=[],r[e].prototype.fillOpacity=!0)}),s){var l=r.area,h=r.areaspline,f=r.bubble,c=r.column,p=r.heatmap,g=r.scatter,b=r.treemap;if(l&&v(l.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),h&&v(h.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),f){var x=f.prototype;delete x.buildKDTree,S(x,"markerAttribs",function(e){return!this.boosted&&e.apply(this,[].slice.call(arguments,1))})}c&&v(c.prototype,{fill:!0,sampling:!0}),g&&(g.prototype.fill=!0),[p,b].forEach(function(e){e&&S(e.prototype,"drawPoints",O)})}}return o},destroyGraphics:U,eachAsync:R,getPoint:N}}),i(t,"Extensions/Boost/NamedColors.js",[],function(){return{defaultHTMLColorMap:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",feldspar:"#d19275",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslateblue:"#8470ff",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",violetred:"#d02090",wheat:"#f5deb3",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"}}}),i(t,"Extensions/Boost/Boost.js",[t["Extensions/Boost/BoostChart.js"],t["Extensions/Boost/BoostSeries.js"],t["Core/Globals.js"],t["Extensions/Boost/NamedColors.js"],t["Core/Utilities.js"]],function(e,t,i,o,r){var s=this&&this.__assign||function(){return(s=Object.assign||function(e){for(var t,i=1,o=arguments.length;i<o;i++)for(var r in t=arguments[i])Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);return e}).apply(this,arguments)},n=i.composed,a=i.doc,l=i.win,h=r.error,f=r.pushUnique,d=["webgl","experimental-webgl","moz-webgl","webkit-3d"];function u(){var e;if(void 0!==l.WebGLRenderingContext){e=a.createElement("canvas");for(var t=0;t<d.length;++t)try{if(null!=e.getContext(d[t]))return!0}catch(e){}}return!1}return{compose:function r(a,l,d,c){var p=u();p||(void 0!==i.initCanvasBoost?i.initCanvasBoost():h(26)),c&&f(n,r)&&(c.names=s(s({},c.names),o.defaultHTMLColorMap)),e.compose(a,p),t.compose(l,d,p)},hasWebGLSupport:u}}),i(t,"masters/modules/boost.src.js",[t["Core/Globals.js"],t["Extensions/Boost/Boost.js"]],function(e,t){e.hasWebGLSupport=t.hasWebGLSupport,t.compose(e.Chart,e.Series,e.seriesTypes,e.Color)})});