/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * ColorAxis module
 *
 * (c) 2012-2024 Pawel Potaczek
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/color-axis",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function o(t,e,o,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}o(e,"Core/Axis/Color/ColorAxisComposition.js",[e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,o){var i,s=t.parse,r=e.composed,n=o.addEvent,l=o.extend,a=o.merge,h=o.pick,c=o.pushUnique,d=o.splat;return function(t){var e;function o(){var t=this,o=this.userOptions;this.colorAxis=[],o.colorAxis&&(o.colorAxis=d(o.colorAxis),o.colorAxis.map(function(o){return new e(t,o)}))}function i(t){var e,o,i=this,s=this.chart.colorAxis||[],r=function(e){var o=t.allItems.indexOf(e);-1!==o&&(i.destroyItem(t.allItems[o]),t.allItems.splice(o,1))},n=[];for(s.forEach(function(t){(e=t.options)&&e.showInLegend&&(e.dataClasses&&e.visible?n=n.concat(t.getDataClassLegendSymbols()):e.visible&&n.push(t),t.series.forEach(function(t){(!t.options.showInLegend||e.dataClasses)&&("point"===t.options.legendType?t.points.forEach(function(t){r(t)}):r(t))}))}),o=n.length;o--;)t.allItems.unshift(n[o])}function p(t){t.visible&&t.item.legendColor&&t.item.legendItem.symbol.attr({fill:t.item.legendColor})}function u(t){var e;null===(e=this.chart.colorAxis)||void 0===e||e.forEach(function(e){e.update({},t.redraw)})}function f(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function g(){var t=this.axisTypes;t?-1===t.indexOf("colorAxis")&&t.push("colorAxis"):this.axisTypes=["colorAxis"]}function m(t){var e=this,o=t?"show":"hide";e.visible=e.options.visible=!!t,["graphic","dataLabel"].forEach(function(t){e[t]&&e[t][o]()}),this.series.buildKDTree()}function y(){var t=this,e=this.data.length?this.data:this.points,o=this.options.nullColor,i=this.colorAxis,s=this.colorKey;e.forEach(function(e){var r=e.getNestedProperty(s),n=e.options.color||(e.isNull||null===e.value?o:i&&void 0!==r?i.toColor(r,e):e.color||t.color);n&&e.color!==n&&(e.color=n,"point"===t.options.legendType&&e.legendItem&&e.legendItem.label&&t.chart.legend.colorizeItem(e,e.visible))})}function x(){this.elem.attr("fill",s(this.start).tweenTo(s(this.end),this.pos),void 0,!0)}function C(){this.elem.attr("stroke",s(this.start).tweenTo(s(this.end),this.pos),void 0,!0)}t.compose=function t(s,d,v,b,A){if(c(r,t)){e=s;var L,I=d.prototype,w=v.prototype,j=A.prototype;I.collectionsWithUpdate.push("colorAxis"),I.collectionsWithInit.colorAxis=[I.addColorAxis],n(d,"afterGetAxes",o),L=d.prototype.createAxis,d.prototype.createAxis=function(t,o){if("colorAxis"!==t)return L.apply(this,arguments);var i=new e(this,a(o.axis,{index:this[t].length,isX:!1}));return this.isDirtyLegend=!0,this.axes.forEach(function(t){t.series=[]}),this.series.forEach(function(t){t.bindAxes(),t.isDirtyData=!0}),h(o.redraw,!0)&&this.redraw(o.animation),i},w.fillSetter=x,w.strokeSetter=C,n(b,"afterGetAllItems",i),n(b,"afterColorizeItem",p),n(b,"afterUpdate",u),l(j,{optionalAxis:"colorAxis",translateColors:y}),l(j.pointClass.prototype,{setVisible:m}),n(A,"afterTranslate",f,{order:1}),n(A,"bindAxes",g)}},t.pointSetVisible=m}(i||(i={})),i}),o(e,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,minPadding:0,maxPadding:0,gridLineColor:"#ffffff",gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{distance:8,overflow:"justify",rotation:0},minColor:"#e6e9ff",maxColor:"#0022ff",tickLength:5,showInLegend:!0}}),o(e,"Core/Axis/Color/ColorAxisLike.js",[e["Core/Color/Color.js"],e["Core/Utilities.js"]],function(t,e){var o,i,s=t.parse,r=e.merge;return(o=i||(i={})).initDataClasses=function(t){var e,o,i,n=this.chart,l=this.legendItem=this.legendItem||{},a=this.options,h=t.dataClasses||[],c=n.options.chart.colorCount,d=0;this.dataClasses=o=[],l.labels=[];for(var p=0,u=h.length;p<u;++p)e=r(e=h[p]),o.push(e),(n.styledMode||!e.color)&&("category"===a.dataClassColor?(n.styledMode||(c=(i=n.options.colors||[]).length,e.color=i[d]),e.colorIndex=d,++d===c&&(d=0)):e.color=s(a.minColor).tweenTo(s(a.maxColor),u<2?.5:p/(u-1)))},o.initStops=function(){for(var t=this.options,e=this.stops=t.stops||[[0,t.minColor||""],[1,t.maxColor||""]],o=0,i=e.length;o<i;++o)e[o].color=s(e[o][1])},o.normalizedValue=function(t){var e=this.max||0,o=this.min||0;return this.logarithmic&&(t=this.logarithmic.log2lin(t)),1-(e-t)/(e-o||1)},o.toColor=function(t,e){var o,i,s,r,n,l,a=this.dataClasses,h=this.stops;if(a){for(l=a.length;l--;)if(i=(n=a[l]).from,s=n.to,(void 0===i||t>=i)&&(void 0===s||t<=s)){r=n.color,e&&(e.dataClass=l,e.colorIndex=n.colorIndex);break}}else{for(o=this.normalizedValue(t),l=h.length;l--&&!(o>h[l][0]););i=h[l]||h[l+1],o=1-((s=h[l+1]||i)[0]-o)/(s[0]-i[0]||1),r=i.color.tweenTo(s.color,o)}return r},i}),o(e,"Core/Axis/Color/ColorAxis.js",[e["Core/Axis/Axis.js"],e["Core/Axis/Color/ColorAxisComposition.js"],e["Core/Axis/Color/ColorAxisDefaults.js"],e["Core/Axis/Color/ColorAxisLike.js"],e["Core/Defaults.js"],e["Core/Legend/LegendSymbol.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,i,s,r,n,l){var a,h=this&&this.__extends||(a=function(t,e){return(a=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),c=s.defaultOptions,d=n.series,p=l.defined,u=l.extend,f=l.fireEvent,g=l.isArray,m=l.isNumber,y=l.merge,x=l.pick,C=l.relativeLength;c.colorAxis=y(c.xAxis,o);var v=function(t){function o(e,o){var i=t.call(this,e,o)||this;return i.coll="colorAxis",i.visible=!0,i.init(e,o),i}return h(o,t),o.compose=function(t,i,s,r){e.compose(o,t,i,s,r)},o.prototype.init=function(e,o){var i=e.options.legend||{},s=o.layout?"vertical"!==o.layout:"vertical"!==i.layout;this.side=o.side||s?2:1,this.reversed=o.reversed||!s,this.opposite=!s,t.prototype.init.call(this,e,o,"colorAxis"),this.userOptions=o,g(e.userOptions.colorAxis)&&(e.userOptions.colorAxis[this.index]=o),o.dataClasses&&this.initDataClasses(o),this.initStops(),this.horiz=s,this.zoomEnabled=!1},o.prototype.hasData=function(){return!!(this.tickPositions||[]).length},o.prototype.setTickPositions=function(){if(!this.dataClasses)return t.prototype.setTickPositions.call(this)},o.prototype.setOptions=function(e){var o=y(c.colorAxis,e,{showEmpty:!1,title:null,visible:this.chart.options.legend.enabled&&!1!==e.visible});t.prototype.setOptions.call(this,o),this.options.crosshair=this.options.marker},o.prototype.setAxisSize=function(){var t,e=this.chart,i=null===(t=this.legendItem)||void 0===t?void 0:t.symbol,s=this.getSize(),r=s.width,n=s.height;i&&(this.left=+i.attr("x"),this.top=+i.attr("y"),this.width=r=+i.attr("width"),this.height=n=+i.attr("height"),this.right=e.chartWidth-this.left-r,this.bottom=e.chartHeight-this.top-n,this.pos=this.horiz?this.left:this.top),this.len=(this.horiz?r:n)||o.defaultLegendLength},o.prototype.getOffset=function(){var e,i=null===(e=this.legendItem)||void 0===e?void 0:e.group,s=this.chart.axisOffset[this.side];if(i){this.axisParent=i,t.prototype.getOffset.call(this);var r=this.chart.legend;r.allItems.forEach(function(t){t instanceof o&&t.drawLegendSymbol(r,t)}),r.render(),this.chart.getMargins(!0),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=s}},o.prototype.setLegendColor=function(){var t=this.horiz,e=this.reversed,o=e?1:0,i=e?0:1,s=t?[o,0,i,0]:[0,i,0,o];this.legendColor={linearGradient:{x1:s[0],y1:s[1],x2:s[2],y2:s[3]},stops:this.stops}},o.prototype.drawLegendSymbol=function(t,e){var o,i=e.legendItem||{},s=t.padding,r=t.options,n=this.options.labels,l=x(r.itemDistance,10),a=this.horiz,h=this.getSize(),c=h.width,d=h.height,p=x(r.labelPadding,a?16:30);this.setLegendColor(),i.symbol||(i.symbol=this.chart.renderer.symbol("roundedRect").attr({r:null!==(o=r.symbolRadius)&&void 0!==o?o:3,zIndex:1}).add(i.group)),i.symbol.attr({x:0,y:(t.baseline||0)-11,width:c,height:d}),i.labelWidth=c+s+(a?l:x(n.x,n.distance)+this.maxLabelLength),i.labelHeight=d+s+(a?p:0)},o.prototype.setState=function(t){this.series.forEach(function(e){e.setState(t)})},o.prototype.setVisible=function(){},o.prototype.getSeriesExtremes=function(){var t,e,o,i,s,r,n,l,a=this.series,h=a.length;for(this.dataMin=1/0,this.dataMax=-1/0;h--;){if(e=(r=a[h]).colorKey=x(r.options.colorKey,r.colorKey,r.pointValKey,r.zoneAxis,"y"),i=r.pointArrayMap,s=r[e+"Min"]&&r[e+"Max"],r[e+"Data"])t=r[e+"Data"];else if(i){if(t=[],o=i.indexOf(e),n=r.yData,o>=0&&n)for(l=0;l<n.length;l++)t.push(x(n[l][o],n[l]))}else t=r.yData;if(s)r.minColorValue=r[e+"Min"],r.maxColorValue=r[e+"Max"];else{var c=d.prototype.getExtremes.call(r,t);r.minColorValue=c.dataMin,r.maxColorValue=c.dataMax}p(r.minColorValue)&&p(r.maxColorValue)&&(this.dataMin=Math.min(this.dataMin,r.minColorValue),this.dataMax=Math.max(this.dataMax,r.maxColorValue)),s||d.prototype.applyExtremes.call(r)}},o.prototype.drawCrosshair=function(e,o){var i,s=this.legendItem||{},r=o&&o.plotX,n=o&&o.plotY,l=this.pos,a=this.len;o&&((i=this.toPixels(o.getNestedProperty(o.series.colorKey)))<l?i=l-2:i>l+a&&(i=l+a+2),o.plotX=i,o.plotY=this.len-i,t.prototype.drawCrosshair.call(this,e,o),o.plotX=r,o.plotY=n,this.cross&&!this.cross.addedToColorAxis&&s.group&&(this.cross.addClass("highcharts-coloraxis-marker").add(s.group),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!=typeof this.crosshair||this.cross.attr({fill:this.crosshair.color})))},o.prototype.getPlotLinePath=function(e){var o=this.left,i=e.translatedValue,s=this.top;return m(i)?this.horiz?[["M",i-4,s-6],["L",i+4,s-6],["L",i,s],["Z"]]:[["M",o,i],["L",o-6,i+6],["L",o-6,i-6],["Z"]]:t.prototype.getPlotLinePath.call(this,e)},o.prototype.update=function(e,o){var i=this.chart.legend;this.series.forEach(function(t){t.isDirtyData=!0}),(e.dataClasses&&i.allItems||this.dataClasses)&&this.destroyItems(),t.prototype.update.call(this,e,o),this.legendItem&&this.legendItem.label&&(this.setLegendColor(),i.colorizeItem(this,!0))},o.prototype.destroyItems=function(){var t=this.chart,e=this.legendItem||{};if(e.label)t.legend.destroyItem(this);else if(e.labels)for(var o=0,i=e.labels;o<i.length;o++){var s=i[o];t.legend.destroyItem(s)}t.isDirtyLegend=!0},o.prototype.destroy=function(){this.chart.isDirtyLegend=!0,this.destroyItems(),t.prototype.destroy.apply(this,[].slice.call(arguments))},o.prototype.remove=function(e){this.destroyItems(),t.prototype.remove.call(this,e)},o.prototype.getDataClassLegendSymbols=function(){var t,e=this,o=e.chart,i=e.legendItem&&e.legendItem.labels||[],s=o.options.legend,n=x(s.valueDecimals,-1),l=x(s.valueSuffix,""),a=function(t){return e.series.reduce(function(e,o){return e.push.apply(e,o.points.filter(function(e){return e.dataClass===t})),e},[])};return i.length||e.dataClasses.forEach(function(s,h){var c=s.from,d=s.to,p=o.numberFormatter,g=!0;t="",void 0===c?t="< ":void 0===d&&(t="> "),void 0!==c&&(t+=p(c,n)+l),void 0!==c&&void 0!==d&&(t+=" - "),void 0!==d&&(t+=p(d,n)+l),i.push(u({chart:o,name:t,options:{},drawLegendSymbol:r.rectangle,visible:!0,isDataClass:!0,setState:function(t){for(var e=0,o=a(h);e<o.length;e++)o[e].setState(t)},setVisible:function(){this.visible=g=e.visible=!g;for(var t=[],i=0,s=a(h);i<s.length;i++){var r=s[i];r.setVisible(g),-1===t.indexOf(r.series)&&t.push(r.series)}o.legend.colorizeItem(this,g),t.forEach(function(t){f(t,"afterDataClassLegendClick")})}},s))}),i},o.prototype.getSize=function(){var t=this.chart,e=this.horiz,i=this.options,s=i.legend,r=i.height,n=i.width;return{width:x(p(n)?C(n,t.chartWidth):void 0,null==s?void 0:s.symbolWidth,e?o.defaultLegendLength:12),height:x(p(r)?C(r,t.chartHeight):void 0,null==s?void 0:s.symbolHeight,e?12:o.defaultLegendLength)}},o.defaultLegendLength=200,o.keepProps=["legendItem"],o}(t);return u(v.prototype,i),Array.prototype.push.apply(t.keepProps,v.keepProps),v}),o(e,"masters/modules/coloraxis.src.js",[e["Core/Globals.js"],e["Core/Axis/Color/ColorAxis.js"]],function(t,e){t.ColorAxis=e,e.compose(t.Chart,t.Fx,t.Legend,t.Series)})});