/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Highcharts cylinder module
 *
 * (c) 2010-2024 Kacper Madej
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/cylinder",["highcharts","highcharts/highcharts-3d"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function r(e,t,r,n){e.hasOwnProperty(t)||(e[t]=n.apply(null,r),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}r(t,"Series/Cylinder/SVGElement3DCylinder.js",[t["Core/Color/Color.js"],t["Core/Renderer/RendererRegistry.js"]],function(e,t){var r,n=this&&this.__extends||(r=function(e,t){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r])})(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),o=e.parse;return function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t.parts=["top","bottom","front","back"],t.pathType="cylinder",t}return n(t,e),t.prototype.fillSetter=function(e){return this.singleSetterForParts("fill",null,{front:e,back:e,top:o(e).brighten(.1).get(),bottom:o(e).brighten(-.1).get()}),this.color=this.fill=e,this},t}(t.getRendererType().prototype.Element3D)}),r(t,"Series/Cylinder/CylinderComposition.js",[t["Core/Globals.js"],t["Core/Math3D.js"],t["Series/Cylinder/SVGElement3DCylinder.js"],t["Core/Utilities.js"]],function(e,t,r,n){var o=e.charts,i=e.composed,s=e.deg2rad,u=t.perspective,p=n.extend,l=n.pick,c=n.pushUnique;function y(e){return!e.some(function(e){return"C"===e[0]})}function a(e){return this.element3d("cylinder",e)}function h(e){var t=o[this.chartIndex],r=this.cuboidPath(e),n=!r.isTop,i=!r.isFront,s=this.getCylinderEnd(t,e),u=this.getCylinderEnd(t,e,!0);return{front:this.getCylinderFront(s,u),back:this.getCylinderBack(s,u),top:s,bottom:u,zIndexes:{top:n?3:0,bottom:n?0:3,front:i?2:1,back:i?1:2,group:r.zIndexes.group}}}function d(e){for(var t=[["M",e[0].x,e[0].y]],r=e.length-2,n=1;n<r;n+=3)t.push(["C",e[n].x,e[n].y,e[n+1].x,e[n+1].y,e[n+2].x,e[n+2].y]);return t}function f(e,t){var r=[];if(y(e)){var n=e[0],o=e[2];"M"===n[0]&&"L"===o[0]&&(r.push(["M",o[1],o[2]]),r.push(e[3]),r.push(["L",n[1],n[2]]))}else"C"===e[2][0]&&r.push(["M",e[2][5],e[2][6]]),r.push(e[3],e[4]);if(y(t)){var n=t[0];"M"===n[0]&&(r.push(["L",n[1],n[2]]),r.push(t[3]),r.push(t[2]))}else{var i=t[2],s=t[3],u=t[4];"C"===i[0]&&"C"===s[0]&&"C"===u[0]&&(r.push(["L",u[5],u[6]]),r.push(["C",u[3],u[4],u[1],u[2],s[5],s[6]]),r.push(["C",s[3],s[4],s[1],s[2],i[5],i[6]]))}return r.push(["Z"]),r}function C(e,t,r){for(var n,o,i=t.width,p=void 0===i?0:i,c=t.height,y=t.alphaCorrection,a=l(t.depth,p,0),h=Math.min(p,a)/2,d=s*(e.options.chart.options3d.beta-90+(void 0===y?0:y)),f=(t.y||0)+(r?void 0===c?0:c:0),C=.5519*h,g=p/2+(t.x||0),v=a/2+(t.z||0),x=[{x:0,y:f,z:h},{x:C,y:f,z:h},{x:h,y:f,z:C},{x:h,y:f,z:0},{x:h,y:f,z:-C},{x:C,y:f,z:-h},{x:0,y:f,z:-h},{x:-C,y:f,z:-h},{x:-h,y:f,z:-C},{x:-h,y:f,z:0},{x:-h,y:f,z:C},{x:-C,y:f,z:h},{x:0,y:f,z:h}],m=Math.cos(d),j=Math.sin(d),_=0;_<x.length;_++){var S=x[_];n=S.x,o=S.z,S.x=n*m-o*j+g,S.z=o*m+n*j+v}var b=u(x,e,!0);return 2.5>Math.abs(b[3].y-b[9].y)&&2.5>Math.abs(b[0].y-b[6].y)?this.toLinePath([b[0],b[3],b[6],b[9]],!0):this.getCurvedPath(b)}function g(e,t){var r=e.slice(0,3);if(y(t)){var n=t[0];"M"===n[0]&&(r.push(t[2]),r.push(t[1]),r.push(["L",n[1],n[2]]))}else{var n=t[0],o=t[1],i=t[2];"M"===n[0]&&"C"===o[0]&&"C"===i[0]&&(r.push(["L",i[5],i[6]]),r.push(["C",i[3],i[4],i[1],i[2],o[5],o[6]]),r.push(["C",o[3],o[4],o[1],o[2],n[1],n[2]]))}return r.push(["Z"]),r}return{compose:function e(t){if(c(i,e)){var n=t.prototype;n.Element3D.types.cylinder=r,p(n,{cylinder:a,cylinderPath:h,getCurvedPath:d,getCylinderBack:f,getCylinderEnd:C,getCylinderFront:g})}}}}),r(t,"Series/Cylinder/CylinderPoint.js",[t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t){var r,n=this&&this.__extends||(r=function(e,t){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r])})(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),o=e.seriesTypes.column.prototype.pointClass,i=t.extend,s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n(t,e),t}(o);return i(s.prototype,{shapeType:"cylinder"}),s}),r(t,"Series/Cylinder/CylinderSeriesDefaults.js",[],function(){return{}}),r(t,"Series/Cylinder/CylinderSeries.js",[t["Series/Cylinder/CylinderComposition.js"],t["Series/Cylinder/CylinderPoint.js"],t["Series/Cylinder/CylinderSeriesDefaults.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t,r,n,o){var i,s=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r])})(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw TypeError("Class extends value "+String(t)+" is not a constructor or null");function r(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}),u=n.seriesTypes.column,p=o.extend,l=o.merge,c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return s(n,t),n.compose=e.compose,n.defaultOptions=l(u.defaultOptions,r),n}(u);return p(c.prototype,{pointClass:t}),n.registerSeriesType("cylinder",c),c}),r(t,"masters/modules/cylinder.src.js",[t["Series/Cylinder/CylinderSeries.js"],t["Core/Renderer/RendererRegistry.js"]],function(e,t){e.compose(t.getRendererType())})});