/**
 * Highstock JS v11.3.0 (2024-01-10)
 *
 * Data grouping module
 *
 * (c) 2010-2024 Torstein Hønsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/datagrouping",["highcharts"],function(o){return t(o),t.Highcharts=o,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var o=t?t._modules:{};function i(t,o,i,a){t.hasOwnProperty(o)||(t[o]=a.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:o,module:t[o]}})))}i(o,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),i(o,"Extensions/DataGrouping/ApproximationDefaults.js",[o["Extensions/DataGrouping/ApproximationRegistry.js"],o["Core/Utilities.js"]],function(t,o){var i=o.arrayMax,a=o.arrayMin,e=o.correctFloat,n=o.extend,r=o.isNumber;function s(t){var o=t.length,i=p(t);return r(i)&&o&&(i=e(i/o)),i}function p(t){var o,i=t.length;if(!i&&t.hasNulls)o=null;else if(i)for(o=0;i--;)o+=t[i];return o}var u={average:s,averages:function(){var t=[];return[].forEach.call(arguments,function(o){t.push(s(o))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?i(t):t.hasNulls?null:void 0},hlc:function(o,i,a){if(o=t.high(o),i=t.low(i),a=t.close(a),r(o)||r(i)||r(a))return[o,i,a]},low:function(t){return t.length?a(t):t.hasNulls?null:void 0},ohlc:function(o,i,a,e){if(o=t.open(o),i=t.high(i),a=t.low(a),e=t.close(e),r(o)||r(i)||r(a)||r(e))return[o,i,a,e]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(o,i){return(o=t.low(o),i=t.high(i),r(o)||r(i))?[o,i]:null===o&&null===i?null:void 0},sum:p};return n(t,u),u}),i(o,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),i(o,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[o["Extensions/DataGrouping/DataGroupingDefaults.js"],o["Core/Globals.js"],o["Core/Utilities.js"]],function(t,o,i){var a,e=o.composed,n=i.addEvent,r=i.extend,s=i.merge,p=i.pick,u=i.pushUnique;function l(t){var o=this,i=o.series;i.forEach(function(t){t.groupPixelWidth=void 0}),i.forEach(function(i){i.groupPixelWidth=o.getGroupPixelWidth&&o.getGroupPixelWidth(),i.groupPixelWidth&&(i.hasProcessed=!0),i.applyGrouping(!!t.hasExtremesChanged)})}function h(){for(var o,i,a=this.series,e=a.length,n=0,r=!1;e--;)(i=a[e].options.dataGrouping)&&(n=Math.max(n,p(i.groupPixelWidth,t.common.groupPixelWidth)),o=(a[e].processedXData||a[e].data).length,(a[e].groupPixelWidth||o>this.chart.plotSizeX/n||o&&i.forced)&&(r=!0));return r?n:0}function d(){this.series.forEach(function(t){t.hasProcessed=!1})}function g(t,o){var i;if(o=p(o,!0),t||(t={forced:!1,units:null}),this instanceof a)for(i=this.series.length;i--;)this.series[i].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(o){o.dataGrouping="boolean"==typeof t?t:s(t,o.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),o&&this.chart.redraw()}return{compose:function t(o){a=o,u(e,t)&&(n(o,"afterSetScale",d),n(o,"postProcessData",l),r(o.prototype,{applyGrouping:l,getGroupPixelWidth:h,setDataGrouping:g}))}}}),i(o,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[o["Extensions/DataGrouping/ApproximationRegistry.js"],o["Extensions/DataGrouping/DataGroupingDefaults.js"],o["Core/Axis/DateTimeAxis.js"],o["Core/Defaults.js"],o["Core/Globals.js"],o["Core/Series/SeriesRegistry.js"],o["Core/Utilities.js"]],function(t,o,i,a,e,n,r){var s=e.composed,p=n.series.prototype,u=r.addEvent,l=r.defined,h=r.error,d=r.extend,g=r.isNumber,c=r.merge,f=r.pick,m=r.pushUnique,x=p.generatePoints;function D(t){var a,e,n,r,s=this.chart,u=this.options.dataGrouping,d=!1!==this.allowDG&&u&&f(u.enabled,s.options.isStock),c=this.reserveSpace(),m=this.currentDataGrouping,x=!1;d&&!this.requireSorting&&(this.requireSorting=x=!0);var D=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!d;if(x&&(this.requireSorting=!1),!D){this.destroyGroupedData();var G=u.groupAll?this.xData:this.processedXData,v=u.groupAll?this.yData:this.processedYData,y=s.plotSizeX,M=this.xAxis,A=M.options.ordinal,S=this.groupPixelWidth;if(S&&G&&G.length&&y){e=!0,this.isDirty=!0,this.points=null;var b,j=M.getExtremes(),E=j.min,P=j.max,C=A&&M.ordinal&&M.ordinal.getGroupIntervalFactor(E,P,this)||1,W=S*(P-E)/y*C,k=M.getTimeTicks(i.Additions.prototype.normalizeTimeTickInterval(W,u.units||o.units),Math.min(E,G[0]),Math.max(P,G[G.length-1]),M.options.startOfWeek,G,this.closestPointRange),H=p.groupData.apply(this,[G,v,k,u.approximation]),F=H.groupedXData,T=H.groupedYData,Y=0;for(u&&u.smoothed&&F.length&&(u.firstAnchor="firstPoint",u.anchor="middle",u.lastAnchor="lastPoint",h(32,!1,s,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),a=1;a<k.length;a++)k.info.segmentStarts&&-1!==k.info.segmentStarts.indexOf(a)||(Y=Math.max(k[a]-k[a-1],Y));(n=k.info).gapSize=Y,this.closestPointRange=k.info.totalRange,this.groupMap=H.groupMap,this.currentDataGrouping=n,function(t,o,i){var a=t.options.dataGrouping,e=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(a&&t.xData&&e&&t.groupMap){var n=o.length-1,r=a.anchor,s=a.firstAnchor,p=a.lastAnchor,u=o.length-1,l=0;if(s&&t.xData[0]>=o[0]){l++;var h=t.groupMap[0].start,d=t.groupMap[0].length,c=void 0;g(h)&&g(d)&&(c=h+(d-1)),o[0]=({start:o[0],middle:o[0]+.5*e,end:o[0]+e,firstPoint:t.xData[0],lastPoint:c&&t.xData[c]})[s]}if(n>0&&p&&e&&o[n]>=i-e){u--;var f=t.groupMap[t.groupMap.length-1].start;o[n]=({start:o[n],middle:o[n]+.5*e,end:o[n]+e,firstPoint:f&&t.xData[f],lastPoint:t.xData[t.xData.length-1]})[p]}if(r&&"start"!==r)for(var m=e*({middle:.5,end:1})[r];u>=l;)o[u]+=m,u--}}(this,F,P),c&&(l((b=F)[0])&&g(M.min)&&g(M.dataMin)&&b[0]<M.min&&((!l(M.options.min)&&M.min<=M.dataMin||M.min===M.dataMin)&&(M.min=Math.min(b[0],M.min)),M.dataMin=Math.min(b[0],M.dataMin)),l(b[b.length-1])&&g(M.max)&&g(M.dataMax)&&b[b.length-1]>M.max&&((!l(M.options.max)&&g(M.dataMax)&&M.max>=M.dataMax||M.max===M.dataMax)&&(M.max=Math.max(b[b.length-1],M.max)),M.dataMax=Math.max(b[b.length-1],M.dataMax))),u.groupAll&&(this.allGroupedData=T,F=(r=this.cropData(F,T,M.min,M.max)).xData,T=r.yData,this.cropStart=r.start),this.processedXData=F,this.processedYData=T}else this.groupMap=null;this.hasGroupedData=e,this.preventGraphAnimation=(m&&m.totalRange)!==(n&&n.totalRange)}}function G(){this.groupedData&&(this.groupedData.forEach(function(t,o){t&&(this.groupedData[o]=t.destroy?t.destroy():null)},this),this.groupedData.length=0,delete this.allGroupedData)}function v(){x.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function y(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function M(o,i,a,e){var n,r,s,p=this,u=p.data,h=p.options&&p.options.data,d=[],f=[],m=[],x=o.length,D=!!i,G=[],v=p.pointArrayMap,y=v&&v.length,M=["x"].concat(v||["y"]),A=this.options.dataGrouping&&this.options.dataGrouping.groupAll,S=0,b=0,j="function"==typeof e?e:e&&t[e]?t[e]:t[p.getDGApproximation&&p.getDGApproximation()||"average"];if(y)for(var E=v.length;E--;)G.push([]);else G.push([]);for(var P=y||1,C=0;C<=x;C++)if(!(o[C]<a[0])){for(;void 0!==a[S+1]&&o[C]>=a[S+1]||C===x;){n=a[S],p.dataGroupInfo={start:A?b:p.cropStart+b,length:G[0].length,groupStart:n},s=j.apply(p,G),p.pointClass&&!l(p.dataGroupInfo.options)&&(p.dataGroupInfo.options=c(p.pointClass.prototype.optionsToObject.call({series:p},p.options.data[p.cropStart+b])),M.forEach(function(t){delete p.dataGroupInfo.options[t]})),void 0!==s&&(d.push(n),f.push(s),m.push(p.dataGroupInfo)),b=C;for(var W=0;W<P;W++)G[W].length=0,G[W].hasNulls=!1;if(S+=1,C===x)break}if(C===x)break;if(v)for(var k=p.options.dataGrouping&&p.options.dataGrouping.groupAll?C:p.cropStart+C,H=u&&u[k]||p.pointClass.prototype.applyOptions.apply({series:p},[h[k]]),F=void 0,W=0;W<y;W++)g(F=H[v[W]])?G[W].push(F):null===F&&(G[W].hasNulls=!0);else g(r=D?i[C]:null)?G[0].push(r):null===r&&(G[0].hasNulls=!0)}return{groupedXData:d,groupedYData:f,groupMap:m}}function A(t){var i=t.options,e=this.type,n=this.chart.options.plotOptions,r=this.useCommonDataGrouping&&o.common,s=o.seriesSpecific,p=a.defaultOptions.plotOptions[e].dataGrouping;if(n&&(s[e]||r)){var u=this.chart.rangeSelector;p||(p=c(o.common,s[e])),i.dataGrouping=c(r,p,n.series&&n.series.dataGrouping,n[e].dataGrouping,this.userOptions.dataGrouping,!i.isInternal&&u&&g(u.selected)&&u.buttonOptions[u.selected].dataGrouping)}}return{compose:function t(o){var i=o.prototype.pointClass;m(s,t)&&(u(i,"update",function(){if(this.dataGroup)return h(24,!1,this.series.chart),!1}),u(o,"afterSetOptions",A),u(o,"destroy",G),d(o.prototype,{applyGrouping:D,destroyGroupedData:G,generatePoints:v,getDGApproximation:y,groupData:M}))},groupData:M}}),i(o,"Extensions/DataGrouping/DataGrouping.js",[o["Extensions/DataGrouping/DataGroupingAxisComposition.js"],o["Extensions/DataGrouping/DataGroupingDefaults.js"],o["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],o["Core/Templating.js"],o["Core/Globals.js"],o["Core/Utilities.js"]],function(t,o,i,a,e,n){var r=a.format,s=e.composed,p=n.addEvent,u=n.extend,l=n.isNumber,h=n.pick,d=n.pushUnique;function g(t){var i,a,e,n,s,p,d=this.chart,g=d.time,c=t.labelConfig,f=c.series,m=c.point,x=f.options,D=f.tooltipOptions,G=x.dataGrouping,v=f.xAxis,y=D.xDateFormat,M=D[t.isFooter?"footerFormat":"headerFormat"];if(v&&"datetime"===v.options.type&&G&&l(c.key)){e=f.currentDataGrouping,n=G.dateTimeLabelFormats||o.common.dateTimeLabelFormats,e?(s=n[e.unitName],1===e.count?y=s[0]:(y=s[1],a=s[2])):!y&&n&&v.dateTime&&(y=v.dateTime.getXDateFormat(c.x,D.dateTimeLabelFormats));var A=h(null===(i=f.groupMap)||void 0===i?void 0:i[m.index].groupStart,c.key),S=A+(null==e?void 0:e.totalRange)-1;p=g.dateFormat(y,A),a&&(p+=g.dateFormat(a,S)),f.chart.styledMode&&(M=this.styledModeFormat(M)),t.text=r(M,{point:u(c.point,{key:p}),series:f},d),t.preventDefault()}}return{compose:function o(a,e,n){t.compose(a),i.compose(e),n&&d(s,o)&&p(n,"headerFormatter",g)},groupData:i.groupData}}),i(o,"masters/modules/datagrouping.src.js",[o["Core/Globals.js"],o["Extensions/DataGrouping/ApproximationDefaults.js"],o["Extensions/DataGrouping/ApproximationRegistry.js"],o["Extensions/DataGrouping/DataGrouping.js"]],function(t,o,i,a){t.dataGrouping={approximationDefaults:o,approximations:i},a.compose(t.Axis,t.Series,t.Tooltip)})});