/**
 * Highstock JS v11.3.0 (2024-01-10)
 *
 * Drag-panes module
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Kacper Madej
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/drag-panes",["highcharts","highcharts/modules/stock"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function s(e,t,s,i){e.hasOwnProperty(t)||(e[t]=i.apply(null,s),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}s(t,"Extensions/DragPanes/AxisResizerDefaults.js",[],function(){return{minLength:"10%",maxLength:"100%",resize:{controlledAxis:{next:[],prev:[]},enabled:!1,cursor:"ns-resize",lineColor:"#cccccc",lineDashStyle:"Solid",lineWidth:4,x:0,y:0}}}),s(t,"Extensions/DragPanes/AxisResizer.js",[t["Extensions/DragPanes/AxisResizerDefaults.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(e,t,s){var i=t.hasTouch,o=s.addEvent,n=s.clamp,r=s.isNumber,a=s.relativeLength;return function(){function t(e){this.init(e)}return t.prototype.init=function(e,t){this.axis=e,this.options=e.options.resize||{},this.render(),t||this.addMouseEvents()},t.prototype.render=function(){var e=this.axis,t=e.chart,s=this.options,i=s.x||0,o=s.y,r=n(e.top+e.height+o,t.plotTop,t.plotTop+t.plotHeight),a={};t.styledMode||(a={cursor:s.cursor,stroke:s.lineColor,"stroke-width":s.lineWidth,dashstyle:s.lineDashStyle}),this.lastPos=r-o,this.controlLine||(this.controlLine=t.renderer.path().addClass("highcharts-axis-resizer")),this.controlLine.add(e.axisGroup);var h=t.styledMode?this.controlLine.strokeWidth():s.lineWidth;a.d=t.renderer.crispLine([["M",e.left+i,r],["L",e.left+e.width+i,r]],h),this.controlLine.attr(a)},t.prototype.addMouseEvents=function(){var e,t,s,n=this,r=n.controlLine.element,a=n.axis.chart.container,h=[];n.mouseMoveHandler=e=function(e){return n.onMouseMove(e)},n.mouseUpHandler=t=function(e){return n.onMouseUp(e)},n.mouseDownHandler=s=function(e){return n.onMouseDown(e)},h.push(o(a,"mousemove",e),o(a.ownerDocument,"mouseup",t),o(r,"mousedown",s)),i&&h.push(o(a,"touchmove",e),o(a.ownerDocument,"touchend",t),o(r,"touchstart",s)),n.eventsToUnbind=h},t.prototype.onMouseMove=function(e){(!e.touches||0!==e.touches[0].pageX)&&this.grabbed&&(this.hasDragged=!0,this.updateAxes(this.axis.chart.pointer.normalize(e).chartY-this.options.y))},t.prototype.onMouseUp=function(e){this.hasDragged&&this.updateAxes(this.axis.chart.pointer.normalize(e).chartY-this.options.y),this.grabbed=this.hasDragged=this.axis.chart.activeResizer=void 0},t.prototype.onMouseDown=function(e){this.axis.chart.pointer.reset(!1,0),this.grabbed=this.axis.chart.activeResizer=!0},t.prototype.updateAxes=function(e){var t=this.axis.chart,s=this.options.controlledAxis,i=0===s.next.length?[t.yAxis.indexOf(this.axis)+1]:s.next,o=[this.axis].concat(s.prev),h=[],u=t.plotTop,c=t.plotHeight,d=u+c,p=function(e){return 100*e/c+"%"},l=function(e,t,s){return Math.round(n(e,t,s))};e=n(e,u,d);var f=!1,x=e-this.lastPos;if(!(x*x<1)){for(var g=!0,v=0,y=[o,i];v<y.length;v++)for(var m=y[v],z=0;z<m.length;z++){var D=m[z],M=r(D)?t.yAxis[D]:g?D:t.get(D),b=M&&M.options,j={},A=void 0,E=void 0;if(!b||"navigator-y-axis"===b.id){g=!1;continue}E=M.top;var P=Math.round(a(b.minLength||NaN,c)),w=Math.round(a(b.maxLength||NaN,c));if(g)(A=l(e-E,P,w))===w&&(f=!0),e=E+A,h.push({axis:M,options:{height:p(A)}});else{if(x=e-this.lastPos,A=l(M.len-x,P,w),(E=M.top+x)+A>d){var L=d-A-E;e+=L,E+=L}E<u&&(E=u)+A>d&&(A=c),A===P&&(f=!0),h.push({axis:M,options:{top:p(E-u),height:p(A)}})}g=!1,j.height=A}if(!f){for(var C=0;C<h.length;C++){var R=h[C];R.axis.update(R.options,!1)}t.redraw(!1)}}},t.prototype.destroy=function(){var e=this.axis;delete e.resizer,this.eventsToUnbind&&this.eventsToUnbind.forEach(function(e){return e()}),this.controlLine.destroy();for(var t=0,s=Object.keys(this);t<s.length;t++)this[s[t]]=null},t.resizerOptions=e,t}()}),s(t,"Extensions/DragPanes/DragPanes.js",[t["Extensions/DragPanes/AxisResizer.js"],t["Core/Defaults.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(e,t,s,i){var o=t.defaultOptions,n=s.composed,r=i.addEvent,a=i.merge,h=i.pushUnique,u=i.wrap;function c(){var t=this.resizer,s=this.options.resize;if(s){var i=!1!==s.enabled;t?i?t.init(this,!0):t.destroy():i&&(this.resizer=new e(this))}}function d(e){!e.keepEvents&&this.resizer&&this.resizer.destroy()}function p(e){this.chart.activeResizer||e.apply(this,[].slice.call(arguments,1))}function l(e){this.chart.activeResizer||e.apply(this,[].slice.call(arguments,1))}return{compose:function t(s,i){h(n,t)&&(a(!0,o.yAxis,e.resizerOptions),s.keepProps.push("resizer"),r(s,"afterRender",c),r(s,"destroy",d),u(i.prototype,"runPointActions",l),u(i.prototype,"drag",p))}}}),s(t,"masters/modules/drag-panes.src.js",[t["Core/Globals.js"],t["Extensions/DragPanes/AxisResizer.js"],t["Extensions/DragPanes/DragPanes.js"]],function(e,t,s){e.AxisResizer=t,s.compose(e.Axis,e.Pointer)})});