/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Force directed graph module
 *
 * (c) 2010-2024 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/networkgraph",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function o(t,e,o,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}o(e,"Series/DragNodesComposition.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var o=t.composed,i=e.addEvent,s=e.pushUnique;function r(){var t,e,o,s=this;s.container&&(t=i(s.container,"mousedown",function(t){var r=s.hoverPoint;r&&r.series&&r.series.hasDraggableNodes&&r.series.options.draggable&&(r.series.onMouseDown(r,t),e=i(s.container,"mousemove",function(t){return r&&r.series&&r.series.onMouseMove(r,t)}),o=i(s.container.ownerDocument,"mouseup",function(t){return e(),o(),r&&r.series&&r.series.onMouseUp(r,t)}))})),i(s,"destroy",function(){t()})}return{compose:function t(e){s(o,t)&&i(e,"load",r)},onMouseDown:function(t,e){var o=this.chart.pointer.normalize(e);t.fixedPosition={chartX:o.chartX,chartY:o.chartY,plotX:t.plotX,plotY:t.plotY},t.inDragMode=!0},onMouseMove:function(t,e){if(t.fixedPosition&&t.inDragMode){var o=this.chart,i=o.pointer.normalize(e),s=t.fixedPosition.chartX-i.chartX,r=t.fixedPosition.chartY-i.chartY,n=o.graphLayoutsLookup,a=void 0,h=void 0;(Math.abs(s)>5||Math.abs(r)>5)&&(a=t.fixedPosition.plotX-s,h=t.fixedPosition.plotY-r,o.isInsidePlot(a,h)&&(t.plotX=a,t.plotY=h,t.hasDragged=!0,this.redrawHalo(t),n.forEach(function(t){t.restartSimulation()})))}},onMouseUp:function(t,e){t.fixedPosition&&(t.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),t.inDragMode=t.hasDragged=!1,this.options.fixedDraggable||delete t.fixedPosition)},redrawHalo:function(t){t&&this.halo&&this.halo.attr({d:t.haloPath(this.options.states.hover.halo.size)})}}}),o(e,"Series/GraphLayoutComposition.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,o){var i=t.setAnimation,s=e.composed,r=o.addEvent,n=o.pushUnique;function a(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(t){t.updateSimulation()}),this.redraw())}function h(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(t){t.updateSimulation(!1)}),this.redraw())}function p(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(t){t.stop()})}function l(){var t,e=!1,o=function(o){o.maxIterations--&&isFinite(o.temperature)&&!o.isStable()&&!o.enableSimulation&&(o.beforeStep&&o.beforeStep(),o.step(),t=!1,e=!0)};if(this.graphLayoutsLookup){for(i(!1,this),this.graphLayoutsLookup.forEach(function(t){return t.start()});!t;)t=!0,this.graphLayoutsLookup.forEach(o);e&&this.series.forEach(function(t){t&&t.layout&&t.render()})}}return{compose:function t(e){n(s,t)&&(r(e,"afterPrint",a),r(e,"beforePrint",h),r(e,"predraw",p),r(e,"render",l))},integrations:{},layouts:{}}}),o(e,"Series/NodesComposition.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,i=t.series,s=i.prototype,r=i.prototype.pointClass.prototype,n=e.defined,a=e.extend,h=e.find,p=e.merge,l=e.pick;return function(t){function e(){return this.data=[].concat(this.points||[],this.nodes),s.destroy.apply(this,arguments)}function o(){this.nodes&&(this.nodes.forEach(function(t){t.destroy()}),this.nodes.length=0),s.setData.apply(this,arguments)}function i(t){var e=arguments,o=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];"select"!==t&&o.forEach(function(t){t&&t.series&&(r.setState.apply(t,e),!t.isNode&&(t.fromNode.graphic&&r.setState.apply(t.fromNode,e),t.toNode&&t.toNode.graphic&&r.setState.apply(t.toNode,e)))}),r.setState.apply(this,e)}function d(t,e,o,i){var s=this,n=this.series.options.nodes,a=this.series.options.data,h=a&&a.length||0,d=a&&a[this.index];if(r.update.call(this,t,!this.isNode&&e,o,i),this.isNode){var u=(n||[]).reduce(function(t,e,o){return s.id===e.id?o:t},-1),c=p(n&&n[u]||{},a&&a[this.index]||{});a&&(d?a[this.index]=d:a.length=h),n?u>=0?n[u]=c:n.push(c):this.series.options.nodes=[c],l(e,!0)&&this.series.chart.redraw(o)}}t.compose=function(t,s){var r=t.prototype,n=s.prototype;return r.setNodeState=i,r.setState=i,r.update=d,n.destroy=e,n.setData=o,s},t.createNode=function(t){var e,o=this.pointClass,i=function(t,e){return h(t,function(t){return t.id===e})},s=i(this.nodes,t);if(!s){e=this.options.nodes&&i(this.options.nodes,t);var r=new o(this,a({className:"highcharts-node",isNode:!0,id:t,y:1},e));r.linksTo=[],r.linksFrom=[],r.getSum=function(){var t=0,e=0;return r.linksTo.forEach(function(e){t+=e.weight||0}),r.linksFrom.forEach(function(t){e+=t.weight||0}),Math.max(t,e)},r.offset=function(t,e){for(var o=0,i=0;i<r[e].length;i++){if(r[e][i]===t)return o;o+=r[e][i].weight}},r.hasShape=function(){var t=0;return r.linksTo.forEach(function(e){e.outgoing&&t++}),!r.linksTo.length||t!==r.linksTo.length},r.index=this.nodes.push(r)-1,s=r}return s.formatPrefix="node",s.name=s.name||s.options.id||"",s.mass=l(s.options.mass,s.options.marker&&s.options.marker.radius,this.options.marker&&this.options.marker.radius,4),s},t.destroy=e,t.generatePoints=function(){var t=this,e=this.chart,o={};s.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(function(t){t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(function(i){n(i.from)&&(o[i.from]||(o[i.from]=t.createNode(i.from)),o[i.from].linksFrom.push(i),i.fromNode=o[i.from],e.styledMode?i.colorIndex=l(i.options.colorIndex,o[i.from].colorIndex):i.color=i.options.color||o[i.from].color),n(i.to)&&(o[i.to]||(o[i.to]=t.createNode(i.to)),o[i.to].linksTo.push(i),i.toNode=o[i.to]),i.name=i.name||i.id},this),this.nodeLookup=o},t.setNodeState=i,t.updateNode=d}(o||(o={})),o}),o(e,"Series/Networkgraph/NetworkgraphPoint.js",[e["Series/NodesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var i,s=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),r=e.series,n=r.prototype,a=r.prototype.pointClass,h=o.addEvent,p=o.css,l=o.defined,d=o.extend,u=o.pick,c=function(t){function e(e,o,i){var s=t.call(this,e,o,i)||this;return s.series.options.draggable&&!s.series.chart.styledMode&&(h(s,"mouseOver",function(){p(this.series.chart.container,{cursor:"move"})}),h(s,"mouseOut",function(){p(this.series.chart.container,{cursor:"default"})})),s}return s(e,t),e.prototype.destroy=function(){return this.isNode&&this.linksFrom.concat(this.linksTo).forEach(function(t){t.destroyElements&&t.destroyElements()}),this.series.layout.removeElementFromCollection(this,this.series.layout[this.isNode?"nodes":"links"]),a.prototype.destroy.apply(this,arguments)},e.prototype.getDegree=function(){var t=this.isNode?this.linksFrom.length+this.linksTo.length:0;return 0===t?1:t},e.prototype.getLinkAttributes=function(){var t=this.series.options.link,e=this.options;return{"stroke-width":u(e.width,t.width),stroke:e.color||t.color,dashstyle:e.dashStyle||t.dashStyle,opacity:u(e.opacity,t.opacity,1)}},e.prototype.getLinkPath=function(){var t=this.fromNode,e=this.toNode;return t.plotX>e.plotX&&(t=this.toNode,e=this.fromNode),[["M",t.plotX||0,t.plotY||0],["L",e.plotX||0,e.plotY||0]]},e.prototype.getMass=function(){var t=this.fromNode.mass,e=this.toNode.mass,o=t+e;return{fromNode:1-t/o,toNode:1-e/o}},e.prototype.isValid=function(){return!this.isNode||l(this.id)},e.prototype.redrawLink=function(){var t,e=this.getLinkPath();if(this.graphic){this.shapeArgs={d:e},this.series.chart.styledMode||(t=this.series.pointAttribs(this),this.graphic.attr(t),(this.dataLabels||[]).forEach(function(e){e&&e.attr({opacity:t.opacity})})),this.graphic.animate(this.shapeArgs);var o=e[0],i=e[1];"M"===o[0]&&"L"===i[0]&&(this.plotX=(o[1]+i[1])/2,this.plotY=(o[2]+i[2])/2)}},e.prototype.remove=function(t,e){var o,i=this.series,s=i.options.nodes||[],r=s.length;if(this.isNode){for(i.points=[],[].concat(this.linksFrom).concat(this.linksTo).forEach(function(t){(o=t.fromNode.linksFrom.indexOf(t))>-1&&t.fromNode.linksFrom.splice(o,1),(o=t.toNode.linksTo.indexOf(t))>-1&&t.toNode.linksTo.splice(o,1),n.removePoint.call(i,i.data.indexOf(t),!1,!1)}),i.points=i.data.slice(),i.nodes.splice(i.nodes.indexOf(this),1);r--;)if(s[r].id===this.options.id){i.options.nodes.splice(r,1);break}this&&this.destroy(),i.isDirty=!0,i.isDirtyData=!0,t&&i.chart.redraw(t)}else i.removePoint(i.data.indexOf(this),t,e)},e.prototype.renderLink=function(){var t;this.graphic||(this.graphic=this.series.chart.renderer.path(this.getLinkPath()).addClass(this.getClassName(),!0).add(this.series.group),this.series.chart.styledMode||(t=this.series.pointAttribs(this),this.graphic.attr(t),(this.dataLabels||[]).forEach(function(e){e&&e.attr({opacity:t.opacity})})))},e}(a);return d(c.prototype,{setState:t.setNodeState}),c}),o(e,"Series/Networkgraph/NetworkgraphSeriesDefaults.js",[],function(){return{stickyTracking:!1,inactiveOtherPoints:!0,marker:{enabled:!0,states:{inactive:{opacity:.3,animation:{duration:50}}}},states:{inactive:{linkOpacity:.3,animation:{duration:50}}},dataLabels:{formatter:function(){return this.key},linkFormatter:function(){return this.point.fromNode.name+"<br>"+this.point.toNode.name},linkTextPath:{enabled:!0},textPath:{enabled:!1},style:{transition:"opacity 2000ms"},defer:!0,animation:{defer:1e3}},link:{color:"rgba(100, 100, 100, 0.5)",width:1},draggable:!0,layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:1,enableSimulation:!1,theta:.5,maxSpeed:10,approximation:"none",type:"reingold-fruchterman",integration:"euler",maxIterations:1e3,gravitationalConstant:.0625,friction:-.981},showInLegend:!1}}),o(e,"Series/Networkgraph/EulerIntegration.js",[],function(){return{attractive:function(t,e,o,i){var s=t.getMass(),r=o.x/i*e,n=o.y/i*e;t.fromNode.fixedPosition||(t.fromNode.dispX-=r*s.fromNode/t.fromNode.degree,t.fromNode.dispY-=n*s.fromNode/t.fromNode.degree),t.toNode.fixedPosition||(t.toNode.dispX+=r*s.toNode/t.toNode.degree,t.toNode.dispY+=n*s.toNode/t.toNode.degree)},attractiveForceFunction:function(t,e){return t*t/e},barycenter:function(){var t=this.options.gravitationalConstant,e=this.barycenter.xFactor,o=this.barycenter.yFactor;this.nodes.forEach(function(i){if(!i.fixedPosition){var s=i.getDegree(),r=s*(1+s/2);i.dispX+=(e-i.plotX)*t*r/i.degree,i.dispY+=(o-i.plotY)*t*r/i.degree}})},getK:function(t){return Math.pow(t.box.width*t.box.height/t.nodes.length,.3)},integrate:function(t,e){var o;e.dispX+=e.dispX*t.options.friction,e.dispY+=e.dispY*t.options.friction,0!==(o=e.temperature=t.vectorLength({x:e.dispX,y:e.dispY}))&&(e.plotX+=e.dispX/o*Math.min(Math.abs(e.dispX),t.temperature),e.plotY+=e.dispY/o*Math.min(Math.abs(e.dispY),t.temperature))},repulsive:function(t,e,o,i){t.dispX+=o.x/i*e/t.degree,t.dispY+=o.y/i*e/t.degree},repulsiveForceFunction:function(t,e){return e*e/t}}}),o(e,"Series/Networkgraph/QuadTreeNode.js",[],function(){return function(){function t(t){this.body=!1,this.isEmpty=!1,this.isInternal=!1,this.nodes=[],this.box=t,this.boxSize=Math.min(t.width,t.height)}return t.prototype.divideBox=function(){var e=this.box.width/2,o=this.box.height/2;this.nodes[0]=new t({left:this.box.left,top:this.box.top,width:e,height:o}),this.nodes[1]=new t({left:this.box.left+e,top:this.box.top,width:e,height:o}),this.nodes[2]=new t({left:this.box.left+e,top:this.box.top+o,width:e,height:o}),this.nodes[3]=new t({left:this.box.left,top:this.box.top+o,width:e,height:o})},t.prototype.getBoxPosition=function(t){var e=t.plotX<this.box.left+this.box.width/2,o=t.plotY<this.box.top+this.box.height/2;return e?o?0:3:o?1:2},t.prototype.insert=function(e,o){var i;this.isInternal?this.nodes[this.getBoxPosition(e)].insert(e,o-1):(this.isEmpty=!1,this.body?o?(this.isInternal=!0,this.divideBox(),!0!==this.body&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,o-1),this.body=!0),this.nodes[this.getBoxPosition(e)].insert(e,o-1)):((i=new t({top:e.plotX||NaN,left:e.plotY||NaN,width:.1,height:.1})).body=e,i.isInternal=!1,this.nodes.push(i)):(this.isInternal=!1,this.body=e))},t.prototype.updateMassAndCenter=function(){var t=0,e=0,o=0;if(this.isInternal){for(var i=0,s=this.nodes;i<s.length;i++){var r=s[i];r.isEmpty||(t+=r.mass,e+=r.plotX*r.mass,o+=r.plotY*r.mass)}e/=t,o/=t}else this.body&&(t=this.body.mass,e=this.body.plotX,o=this.body.plotY);this.mass=t,this.plotX=e,this.plotY=o},t}()}),o(e,"Series/Networkgraph/QuadTree.js",[e["Series/Networkgraph/QuadTreeNode.js"]],function(t){return function(){function e(e,o,i,s){this.box={left:e,top:o,width:i,height:s},this.maxDepth=25,this.root=new t(this.box),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()}return e.prototype.calculateMassAndCenter=function(){this.visitNodeRecursive(null,null,function(t){t.updateMassAndCenter()})},e.prototype.insertNodes=function(t){for(var e=0;e<t.length;e++){var o=t[e];this.root.insert(o,this.maxDepth)}},e.prototype.visitNodeRecursive=function(t,e,o){var i;if(t||(t=this.root),t===this.root&&e&&(i=e(t)),!1!==i){for(var s=0,r=t.nodes;s<r.length;s++){var n=r[s];if(n.isInternal){if(e&&(i=e(n)),!1===i)continue;this.visitNodeRecursive(n,e,o)}else n.body&&e&&e(n.body);o&&o(n)}t===this.root&&o&&o(t)}},e}()}),o(e,"Series/Networkgraph/VerletIntegration.js",[],function(){return{attractive:function(t,e,o){var i=t.getMass(),s=-o.x*e*this.diffTemperature,r=-o.y*e*this.diffTemperature;t.fromNode.fixedPosition||(t.fromNode.plotX-=s*i.fromNode/t.fromNode.degree,t.fromNode.plotY-=r*i.fromNode/t.fromNode.degree),t.toNode.fixedPosition||(t.toNode.plotX+=s*i.toNode/t.toNode.degree,t.toNode.plotY+=r*i.toNode/t.toNode.degree)},attractiveForceFunction:function(t,e){return(e-t)/t},barycenter:function(){var t=this.options.gravitationalConstant,e=this.barycenter.xFactor,o=this.barycenter.yFactor;e=(e-(this.box.left+this.box.width)/2)*t,o=(o-(this.box.top+this.box.height)/2)*t,this.nodes.forEach(function(t){t.fixedPosition||(t.plotX-=e/t.mass/t.degree,t.plotY-=o/t.mass/t.degree)})},getK:function(t){return Math.pow(t.box.width*t.box.height/t.nodes.length,.5)},integrate:function(t,e){var o=-t.options.friction,i=t.options.maxSpeed,s=e.prevX,r=e.prevY,n=(e.plotX+e.dispX-s)*o,a=(e.plotY+e.dispY-r)*o,h=Math.abs,p=h(n)/(n||1),l=h(a)/(a||1);n=p*Math.min(i,Math.abs(n)),a=l*Math.min(i,Math.abs(a)),e.prevX=e.plotX+e.dispX,e.prevY=e.plotY+e.dispY,e.plotX+=n,e.plotY+=a,e.temperature=t.vectorLength({x:n,y:a})},repulsive:function(t,e,o){var i=e*this.diffTemperature/t.mass/t.degree;t.fixedPosition||(t.plotX+=o.x*i,t.plotY+=o.y*i)},repulsiveForceFunction:function(t,e){return(e-t)/t*(e>t?1:0)}}}),o(e,"Series/Networkgraph/ReingoldFruchtermanLayout.js",[e["Series/Networkgraph/EulerIntegration.js"],e["Core/Globals.js"],e["Series/GraphLayoutComposition.js"],e["Series/Networkgraph/QuadTree.js"],e["Core/Utilities.js"],e["Series/Networkgraph/VerletIntegration.js"]],function(t,e,o,i,s,r){var n=e.win,a=s.clamp,h=s.defined,p=s.isFunction,l=s.fireEvent,d=s.pick;return function(){function e(){this.box={},this.currentStep=0,this.initialRendering=!0,this.links=[],this.nodes=[],this.series=[],this.simulation=!1}return e.compose=function(i){o.compose(i),o.integrations.euler=t,o.integrations.verlet=r,o.layouts["reingold-fruchterman"]=e},e.prototype.init=function(t){this.options=t,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=o.integrations[t.integration],this.enableSimulation=t.enableSimulation,this.attractiveForce=d(t.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=d(t.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=t.approximation},e.prototype.updateSimulation=function(t){this.enableSimulation=d(t,this.options.enableSimulation)},e.prototype.start=function(){var t=this.series,e=this.options;this.currentStep=0,this.forces=t[0]&&t[0].forces||[],this.chart=t[0]&&t[0].chart,this.initialRendering&&(this.initPositions(),t.forEach(function(t){t.finishedAnimating=!0,t.render()})),this.setK(),this.resetSimulation(e),this.enableSimulation&&this.step()},e.prototype.step=function(){var t=this,e=this.series;this.currentStep++,"barnes-hut"===this.approximation&&(this.createQuadTree(),this.quadTree.calculateMassAndCenter());for(var o=0,i=this.forces||[];o<i.length;o++)this[i[o]+"Forces"](this.temperature);if(this.applyLimits(),this.temperature=this.coolDown(this.startTemperature,this.diffTemperature,this.currentStep),this.prevSystemTemperature=this.systemTemperature,this.systemTemperature=this.getSystemTemperature(),this.enableSimulation){for(var s=0;s<e.length;s++){var r=e[s];r.chart&&r.render()}this.maxIterations--&&isFinite(this.temperature)&&!this.isStable()?(this.simulation&&n.cancelAnimationFrame(this.simulation),this.simulation=n.requestAnimationFrame(function(){return t.step()})):(this.simulation=!1,this.series.forEach(function(t){l(t,"afterSimulation")}))}},e.prototype.stop=function(){this.simulation&&n.cancelAnimationFrame(this.simulation)},e.prototype.setArea=function(t,e,o,i){this.box={left:t,top:e,width:o,height:i}},e.prototype.setK=function(){this.k=this.options.linkLength||this.integration.getK(this)},e.prototype.addElementsToCollection=function(t,e){for(var o=0;o<t.length;o++){var i=t[o];-1===e.indexOf(i)&&e.push(i)}},e.prototype.removeElementFromCollection=function(t,e){var o=e.indexOf(t);-1!==o&&e.splice(o,1)},e.prototype.clear=function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},e.prototype.resetSimulation=function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},e.prototype.restartSimulation=function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},e.prototype.setMaxIterations=function(t){this.maxIterations=d(t,this.options.maxIterations)},e.prototype.setTemperature=function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},e.prototype.setDiffTemperature=function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},e.prototype.setInitialRendering=function(t){this.initialRendering=t},e.prototype.createQuadTree=function(){this.quadTree=new i(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},e.prototype.initPositions=function(){var t=this.options.initialPositions;if(p(t)){t.call(this);for(var e=0,o=this.nodes;e<o.length;e++){var i=o[e];h(i.prevX)||(i.prevX=i.plotX),h(i.prevY)||(i.prevY=i.plotY),i.dispX=0,i.dispY=0}}else"circle"===t?this.setCircularPositions():this.setRandomPositions()},e.prototype.setCircularPositions=function(){for(var t,e=this.box,o=this.nodes,i=2*Math.PI/(o.length+1),s=o.filter(function(t){return 0===t.linksTo.length}),r={},n=this.options.initialPositionRadius,a=function(t){for(var e=0,o=t.linksFrom||[];e<o.length;e++){var i=o[e];r[i.toNode.id]||(r[i.toNode.id]=!0,h.push(i.toNode),a(i.toNode))}},h=[],p=0;p<s.length;p++){var l=s[p];h.push(l),a(l)}if(h.length)for(var u=0;u<o.length;u++){var c=o[u];-1===h.indexOf(c)&&h.push(c)}else h=o;for(var f=0,m=h.length;f<m;++f)(t=h[f]).plotX=t.prevX=d(t.plotX,e.width/2+n*Math.cos(f*i)),t.plotY=t.prevY=d(t.plotY,e.height/2+n*Math.sin(f*i)),t.dispX=0,t.dispY=0},e.prototype.setRandomPositions=function(){for(var t,e=this.box,o=this.nodes,i=o.length+1,s=function(t){var e=t*t/Math.PI;return e-Math.floor(e)},r=0,n=o.length;r<n;++r)(t=o[r]).plotX=t.prevX=d(t.plotX,e.width*s(r)),t.plotY=t.prevY=d(t.plotY,e.height*s(i+r)),t.dispX=0,t.dispY=0},e.prototype.force=function(t){for(var e=[],o=1;o<arguments.length;o++)e[o-1]=arguments[o];this.integration[t].apply(this,e)},e.prototype.barycenterForces=function(){this.getBarycenter(),this.force("barycenter")},e.prototype.getBarycenter=function(){for(var t=0,e=0,o=0,i=0,s=this.nodes;i<s.length;i++){var r=s[i];e+=r.plotX*r.mass,o+=r.plotY*r.mass,t+=r.mass}return this.barycenter={x:e,y:o,xFactor:e/t,yFactor:o/t},this.barycenter},e.prototype.barnesHutApproximation=function(t,e){var o,i,s=this.getDistXY(t,e),r=this.vectorLength(s);return t!==e&&0!==r&&(e.isInternal?e.boxSize/r<this.options.theta&&0!==r?(i=this.repulsiveForce(r,this.k),this.force("repulsive",t,i*e.mass,s,r),o=!1):o=!0:(i=this.repulsiveForce(r,this.k),this.force("repulsive",t,i*e.mass,s,r))),o},e.prototype.repulsiveForces=function(){var t=this;if("barnes-hut"===this.approximation)for(var e=function(e){o.quadTree.visitNodeRecursive(null,function(o){return t.barnesHutApproximation(e,o)})},o=this,i=0,s=this.nodes;i<s.length;i++){var r=s[i];e(r)}else for(var n=void 0,a=void 0,h=void 0,p=0,l=this.nodes;p<l.length;p++)for(var r=l[p],d=0,u=this.nodes;d<u.length;d++){var c=u[d];r===c||r.fixedPosition||(h=this.getDistXY(r,c),0!==(a=this.vectorLength(h))&&(n=this.repulsiveForce(a,this.k),this.force("repulsive",r,n*c.mass,h,a)))}},e.prototype.attractiveForces=function(){for(var t,e,o,i=0,s=this.links;i<s.length;i++){var r=s[i];r.fromNode&&r.toNode&&(t=this.getDistXY(r.fromNode,r.toNode),0!==(e=this.vectorLength(t))&&(o=this.attractiveForce(e,this.k),this.force("attractive",r,o,t,e)))}},e.prototype.applyLimits=function(){for(var t=this.nodes,e=0;e<t.length;e++){var o=t[e];if(o.fixedPosition)return;this.integration.integrate(this,o),this.applyLimitBox(o,this.box),o.dispX=0,o.dispY=0}},e.prototype.applyLimitBox=function(t,e){var o=t.radius;t.plotX=a(t.plotX,e.left+o,e.width-o),t.plotY=a(t.plotY,e.top+o,e.height-o)},e.prototype.coolDown=function(t,e,o){return t-e*o},e.prototype.isStable=function(){return 1e-5>Math.abs(this.systemTemperature-this.prevSystemTemperature)||this.temperature<=0},e.prototype.getSystemTemperature=function(){for(var t=0,e=0,o=this.nodes;e<o.length;e++)t+=o[e].temperature;return t},e.prototype.vectorLength=function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},e.prototype.getDistR=function(t,e){var o=this.getDistXY(t,e);return this.vectorLength(o)},e.prototype.getDistXY=function(t,e){var o=t.plotX-e.plotX,i=t.plotY-e.plotY;return{x:o,y:i,absX:Math.abs(o),absY:Math.abs(i)}},e}()}),o(e,"Series/SimulationSeriesUtilities.js",[e["Core/Utilities.js"],e["Core/Animation/AnimationUtilities.js"]],function(t,e){var o=t.merge,i=t.syncTimeout,s=e.animObject;return{initDataLabels:function(){var t=this.options.dataLabels;if(!this.dataLabelsGroup){var e=this.initDataLabelsGroup();return!this.chart.styledMode&&(null==t?void 0:t.style)&&e.css(t.style),e.attr({opacity:0}),this.visible&&e.show(),e}return this.dataLabelsGroup.attr(o({opacity:1},this.getPlotBox("data-labels"))),this.dataLabelsGroup},initDataLabelsDefer:function(){var t,e=this,o=this.options.dataLabels;(null==o?void 0:o.defer)&&(null===(t=this.options.layoutAlgorithm)||void 0===t?void 0:t.enableSimulation)?i(function(){e.deferDataLabels=!1},o?s(o.animation).defer:0):this.deferDataLabels=!1}}}),o(e,"Series/Networkgraph/NetworkgraphSeries.js",[e["Series/DragNodesComposition.js"],e["Series/GraphLayoutComposition.js"],e["Core/Globals.js"],e["Series/Networkgraph/NetworkgraphPoint.js"],e["Series/Networkgraph/NetworkgraphSeriesDefaults.js"],e["Series/NodesComposition.js"],e["Series/Networkgraph/ReingoldFruchtermanLayout.js"],e["Core/Series/SeriesRegistry.js"],e["Series/SimulationSeriesUtilities.js"],e["Core/Utilities.js"]],function(t,e,o,i,s,r,n,a,h,p){var l,d=this&&this.__extends||(l=function(t,e){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}l(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),u=o.noop,c=a.series,f=a.seriesTypes,m=f.column.prototype,y=f.line.prototype,g=h.initDataLabels,v=h.initDataLabelsDefer,b=p.addEvent,x=p.defined,k=p.extend,N=p.merge,w=p.pick,S=function(o){function i(){var t=null!==o&&o.apply(this,arguments)||this;return t.deferDataLabels=!0,t}return d(i,o),i.compose=function(e){t.compose(e),n.compose(e)},i.prototype.deferLayout=function(){var t,o=this.options.layoutAlgorithm,i=this.chart.graphLayoutsStorage,s=this.chart.graphLayoutsLookup,r=this.chart.options.chart;this.visible&&(i||(this.chart.graphLayoutsStorage=i={},this.chart.graphLayoutsLookup=s=[]),(t=i[o.type])||(o.enableSimulation=x(r.forExport)?!r.forExport:o.enableSimulation,i[o.type]=t=new e.layouts[o.type],t.init(o),s.splice(t.index,0,t)),this.layout=t,t.setArea(0,0,this.chart.plotWidth,this.chart.plotHeight),t.addElementsToCollection([this],t.series),t.addElementsToCollection(this.nodes,t.nodes),t.addElementsToCollection(this.points,t.links))},i.prototype.destroy=function(){this.layout&&this.layout.removeElementFromCollection(this,this.layout.series),r.destroy.call(this)},i.prototype.drawDataLabels=function(){if(!this.deferDataLabels){var t,e=this.options.dataLabels;(null==e?void 0:e.textPath)&&(t=e.textPath),c.prototype.drawDataLabels.call(this,this.nodes),(null==e?void 0:e.linkTextPath)&&(e.textPath=e.linkTextPath),c.prototype.drawDataLabels.call(this,this.data),(null==e?void 0:e.textPath)&&(e.textPath=t)}},i.prototype.generatePoints=function(){var t,e;for(r.generatePoints.apply(this,arguments),this.options.nodes&&this.options.nodes.forEach(function(t){this.nodeLookup[t.id]||(this.nodeLookup[t.id]=this.createNode(t.id))},this),e=this.nodes.length-1;e>=0;e--)(t=this.nodes[e]).degree=t.getDegree(),t.radius=w(t.marker&&t.marker.radius,this.options.marker&&this.options.marker.radius,0),this.nodeLookup[t.id]||t.remove();this.data.forEach(function(t){t.formatPrefix="link"}),this.indexateNodes()},i.prototype.getPointsCollection=function(){return this.nodes||[]},i.prototype.indexateNodes=function(){this.nodes.forEach(function(t,e){t.index=e})},i.prototype.init=function(t,e){var i=this;return o.prototype.init.call(this,t,e),v.call(this),b(this,"updatedData",function(){i.layout&&i.layout.stop()}),b(this,"afterUpdate",function(){i.nodes.forEach(function(t){t&&t.series&&t.resolveColor()})}),b(this,"afterSimulation",function(){this.deferDataLabels=!1,this.drawDataLabels()}),this},i.prototype.markerAttribs=function(t,e){var o=c.prototype.markerAttribs.call(this,t,e);return x(t.plotY)||(o.y=0),o.x=(t.plotX||0)-(o.width||0)/2,o},i.prototype.pointAttribs=function(t,e){var o=e||t&&t.state||"normal",i=c.prototype.pointAttribs.call(this,t,o),s=this.options.states[o];return t&&!t.isNode&&(i=t.getLinkAttributes(),s&&(i={stroke:s.linkColor||i.stroke,dashstyle:s.linkDashStyle||i.dashstyle,opacity:w(s.linkOpacity,i.opacity),"stroke-width":s.linkColor||i["stroke-width"]})),i},i.prototype.render=function(){var t=this.points,e=this.chart.hoverPoint,o=[];this.points=this.nodes,y.render.call(this),this.points=t,t.forEach(function(t){t.fromNode&&t.toNode&&(t.renderLink(),t.redrawLink())}),e&&e.series===this&&this.redrawHalo(e),this.chart.hasRendered&&!this.options.dataLabels.allowOverlap&&(this.nodes.concat(this.points).forEach(function(t){t.dataLabel&&o.push(t.dataLabel)}),this.chart.hideOverlappingLabels(o))},i.prototype.setState=function(t,e){e?(this.points=this.nodes.concat(this.data),c.prototype.setState.apply(this,arguments),this.points=this.data):c.prototype.setState.apply(this,arguments),this.layout.simulation||t||this.render()},i.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints(),this.deferLayout(),this.nodes.forEach(function(t){t.isInside=!0,t.linksFrom.forEach(function(t){t.shapeType="path",t.y=1})})},i.defaultOptions=N(c.defaultOptions,s),i}(c);return k(S.prototype,{pointClass:i,animate:void 0,directTouch:!0,drawGraph:void 0,forces:["barycenter","repulsive","attractive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,pointArrayMap:["from","to"],requireSorting:!1,trackerGroups:["group","markerGroup","dataLabelsGroup"],initDataLabels:g,buildKDTree:u,createNode:r.createNode,drawTracker:m.drawTracker,onMouseDown:t.onMouseDown,onMouseMove:t.onMouseMove,onMouseUp:t.onMouseUp,redrawHalo:t.redrawHalo}),a.registerSeriesType("networkgraph",S),S}),o(e,"masters/modules/networkgraph.src.js",[e["Core/Globals.js"],e["Series/Networkgraph/NetworkgraphSeries.js"]],function(t,e){e.compose(t.Chart)})});