/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Module for adding patterns and images as point fills.
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Torstein Hønsi, Øystein Moseng
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pattern-fill",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function r(t,e,r,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,r),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}r(e,"Extensions/PatternFill.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,r,i){var a=t.animObject,n=e.getOptions,o=r.composed,s=i.addEvent,h=i.defined,l=i.erase,d=i.extend,p=i.merge,c=i.pick,f=i.pushUnique,u=i.removeEvent,g=i.wrap,m=function(){for(var t=[],e=n().colors,r=0,i=0,a=["M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5","M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5","M 2 0 L 2 5 M 4 0 L 4 5","M 0 2 L 5 2 M 0 4 L 5 4","M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5"];i<a.length;i++){var o=a[i];t.push({path:o,color:e[r++],width:5,height:5,patternTransform:"scale(1.4 1.4)"})}r=5;for(var s=0,h=["M 0 0 L 5 10 L 10 0","M 3 3 L 8 3 L 8 8 L 3 8 Z","M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0","M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11","M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9"];s<h.length;s++){var o=h[s];t.push({path:o,color:e[r],width:10,height:10}),r+=5}return t}();function v(t,e){var r,i=JSON.stringify(t),a=i.length||0,n=0,o=0;if(e){r=Math.max(Math.floor(a/500),1);for(var s=0;s<a;s+=r)n+=i.charCodeAt(s);n&=n}for(;o<a;++o)n=(n<<5)-n+i.charCodeAt(o),n&=n;return n.toString(16).replace("-","1")}function y(){if(this.renderer&&(this.renderer.defIds||[]).filter(function(t){return t&&t.indexOf&&0===t.indexOf("highcharts-pattern-")}).length){for(var t=0,e=this.series;t<e.length;t++){var r=e[t];if(r.visible)for(var i=0,a=r.points;i<a.length;i++){var n=a[i],o=n.options&&n.options.color;o&&o.pattern&&(o.pattern._width="defer",o.pattern._height="defer")}}this.redraw(!1)}}function x(){var t={},e=this.renderer,r=(e.defIds||[]).filter(function(t){return t.indexOf&&0===t.indexOf("highcharts-pattern-")});if(r.length){[].forEach.call(this.renderTo.querySelectorAll('[color^="url("], [fill^="url("], [stroke^="url("]'),function(r){var i=r.getAttribute("fill")||r.getAttribute("color")||r.getAttribute("stroke");i&&(t[i.replace(e.url,"").replace("url(#","").replace(")","")]=!0)});for(var i=0;i<r.length;i++){var a=r[i];!t[a]&&(l(e.defIds,a),e.patternElements[a]&&(e.patternElements[a].destroy(),delete e.patternElements[a]))}}}function w(){var t=this.options.color;t&&t.pattern&&("string"==typeof t.pattern.path&&(t.pattern.path={d:t.pattern.path}),this.color=this.options.color=p(this.series.options.color,t))}function M(t){var e=t.args[0],r=t.args[1],i=t.args[2],a=this.chartIndex||0,n=e.pattern,o="#333333";if(void 0!==e.patternIndex&&m&&(n=m[e.patternIndex]),!n)return!0;if(n.image||"string"==typeof n.path||n.path&&n.path.d){var s=i.parentNode&&i.parentNode.getAttribute("class");s=s&&s.indexOf("highcharts-legend")>-1,("defer"===n._width||"defer"===n._height)&&b.call({graphic:{element:i}},n),(s||!n.id)&&((n=p({},n)).id="highcharts-pattern-"+a+"-"+v(n)+v(n,!0)),this.addPattern(n,!this.forExport&&c(n.animation,this.globalAnimation,{duration:100})),o="url(".concat(this.url,"#").concat(n.id+(this.forExport?"-export":""),")")}else o=n.color||o;return i.setAttribute(r,o),e.toString=function(){return o},!1}function L(){var t=this.chart.isResizing;if(this.isDirtyData||t||!this.chart.hasRendered)for(var e=0,r=this.points;e<r.length;e++){var i=r[e],a=i.options&&i.options.color;a&&a.pattern&&(t&&!(i.shapeArgs&&i.shapeArgs.width&&i.shapeArgs.height)?(a.pattern._width="defer",a.pattern._height="defer"):i.calculatePatternDimensions(a.pattern))}}function b(t){if(!t.width||!t.height){var e=this.graphic&&(this.graphic.getBBox&&this.graphic.getBBox(!0)||this.graphic.element&&this.graphic.element.getBBox())||{},r=this.shapeArgs;if(r&&(e.width=r.width||e.width,e.height=r.height||e.height,e.x=r.x||e.x,e.y=r.y||e.y),t.image){if(!e.width||!e.height){t._width="defer",t._height="defer";var i=this.series.chart.mapView&&this.series.chart.mapView.getSVGTransform().scaleY;h(i)&&i<0&&(t._inverted=!0);return}t.aspectRatio&&(e.aspectRatio=e.width/e.height,t.aspectRatio>e.aspectRatio?e.aspectWidth=e.height*t.aspectRatio:e.aspectHeight=e.width/t.aspectRatio),t._width=t.width||Math.ceil(e.aspectWidth||e.width),t._height=t.height||Math.ceil(e.aspectHeight||e.height)}t.width||(t._x=t.x||0,t._x+=e.x-Math.round(e.aspectWidth?Math.abs(e.aspectWidth-e.width)/2:0)),t.height||(t._y=t.y||0,t._y+=e.y-Math.round(e.aspectHeight?Math.abs(e.aspectHeight-e.height)/2:0))}}function _(t,e){var r,n,o,s=c(e,!0),h=a(s),l=t.color||"#333333",d=t.height||("number"==typeof t._height?t._height:0)||32,p=t.width||("number"==typeof t._width?t._width:0)||32,f=t.id;if(!f&&(this.idCounter=this.idCounter||0,f="highcharts-pattern-"+this.idCounter+"-"+(this.chartIndex||0),++this.idCounter),this.forExport&&(f+="-export"),this.defIds=this.defIds||[],!(this.defIds.indexOf(f)>-1)){this.defIds.push(f);var g={id:f,patternUnits:"userSpaceOnUse",patternContentUnits:t.patternContentUnits||"userSpaceOnUse",width:p,height:d,x:t._x||t.x||0,y:t._y||t.y||0};t._inverted&&(g.patternTransform="scale(1, -1)",t.patternTransform&&(t.patternTransform+=" scale(1, -1)")),t.patternTransform&&(g.patternTransform=t.patternTransform);var m=this.createElement("pattern").attr(g).add(this.defs);return(m.id=f,t.path)?(o=i.isObject(t.path)?t.path:{d:t.path},t.backgroundColor&&(r=t.backgroundColor,this.rect(0,0,p,d).attr({fill:r}).add(m)),n={d:o.d},this.styledMode||(n.stroke=o.stroke||l,n["stroke-width"]=c(o.strokeWidth,2),n.fill=o.fill||"none"),o.transform&&(n.transform=o.transform),this.createElement("path").attr(n).add(m),m.color=l):t.image&&(s?this.image(t.image,0,0,p,d,function(){this.animate({opacity:c(t.opacity,1)},h),u(this.element,"load")}).attr({opacity:0}).add(m):this.image(t.image,0,0,p,d).add(m)),t.image&&s||void 0===t.opacity||[].forEach.call(m.element.childNodes,function(e){e.setAttribute("opacity",t.opacity)}),this.patternElements=this.patternElements||{},this.patternElements[f]=m,m}}function A(t){var e=this.options.color;e&&e.pattern&&!e.pattern.color?(delete this.options.color,t.apply(this,[].slice.call(arguments,1)),e.pattern.color=this.color,this.color=this.options.color=e):t.apply(this,[].slice.call(arguments,1))}function C(){if(null===(t=this.chart)||void 0===t?void 0:t.mapView){var t,e,r=this.chart.renderer,i=r.patternElements;(null===(e=r.defIds)||void 0===e?void 0:e.length)&&i&&this.points.filter(function(t){var e,r,i,a;return!!t.graphic&&(t.graphic.element.hasAttribute("fill")||t.graphic.element.hasAttribute("color")||t.graphic.element.hasAttribute("stroke"))&&!(null===(r=null===(e=t.options.color)||void 0===e?void 0:e.pattern)||void 0===r?void 0:r.image)&&!!(null===(i=t.group)||void 0===i?void 0:i.scaleX)&&!!(null===(a=t.group)||void 0===a?void 0:a.scaleY)}).map(function(t){var e,i,a,n,o;return[((null===(e=t.graphic)||void 0===e?void 0:e.element.getAttribute("fill"))||(null===(i=t.graphic)||void 0===i?void 0:i.element.getAttribute("color"))||(null===(a=t.graphic)||void 0===a?void 0:a.element.getAttribute("stroke"))||"").replace(r.url,"").replace("url(#","").replace(")",""),{x:(null===(n=t.group)||void 0===n?void 0:n.scaleX)||1,y:(null===(o=t.group)||void 0===o?void 0:o.scaleY)||1}]}).filter(function(t,e,r){var i=t[0];return t[1],""!==i&&-1!==i.indexOf("highcharts-pattern-")&&!r.some(function(t,r){var a=t[0];return t[1],a===i&&r<e})}).forEach(function(t){var e=t[0],r=t[1];i[e].scaleX=1/r.x,i[e].scaleY=1/r.y,i[e].updateTransform("patternTransform")})}}return{compose:function t(e,r,i){var a=r.prototype.pointClass;f(o,t)&&(s(e,"endResize",y),s(e,"redraw",x),d(a.prototype,{calculatePatternDimensions:b}),s(a,"afterInit",w),s(r,"render",L),g(r.prototype,"getColor",A),s(r,"afterRender",C),s(r,"mapZoomComplete",C),d(i.prototype,{addPattern:_}),s(i,"complexColor",M))},patterns:m}}),r(e,"masters/modules/pattern-fill.src.js",[e["Core/Globals.js"],e["Extensions/PatternFill.js"]],function(t,e){t.patterns=e.patterns,e.compose(t.Chart,t.Series,t.SVGRenderer)})});