/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Pictorial graph series type for Highcharts
 *
 * (c) 2010-2024 Torstein Honsi, Magdalena Gut
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pictorial",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,r){t.hasOwnProperty(e)||(t[e]=r.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/PatternFill.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,r){var o=t.animObject,a=e.getOptions,n=i.composed,s=r.addEvent,h=r.defined,l=r.erase,p=r.extend,c=r.merge,d=r.pick,f=r.pushUnique,u=r.removeEvent,g=r.wrap,m=function(){for(var t=[],e=a().colors,i=0,r=0,o=["M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5","M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5","M 2 0 L 2 5 M 4 0 L 4 5","M 0 2 L 5 2 M 0 4 L 5 4","M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5"];r<o.length;r++){var n=o[r];t.push({path:n,color:e[i++],width:5,height:5,patternTransform:"scale(1.4 1.4)"})}i=5;for(var s=0,h=["M 0 0 L 5 10 L 10 0","M 3 3 L 8 3 L 8 8 L 3 8 Z","M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0","M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11","M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9"];s<h.length;s++){var n=h[s];t.push({path:n,color:e[i],width:10,height:10}),i+=5}return t}();function v(t,e){var i,r=JSON.stringify(t),o=r.length||0,a=0,n=0;if(e){i=Math.max(Math.floor(o/500),1);for(var s=0;s<o;s+=i)a+=r.charCodeAt(s);a&=a}for(;n<o;++n)a=(a<<5)-a+r.charCodeAt(n),a&=a;return a.toString(16).replace("-","1")}function y(){if(this.renderer&&(this.renderer.defIds||[]).filter(function(t){return t&&t.indexOf&&0===t.indexOf("highcharts-pattern-")}).length){for(var t=0,e=this.series;t<e.length;t++){var i=e[t];if(i.visible)for(var r=0,o=i.points;r<o.length;r++){var a=o[r],n=a.options&&a.options.color;n&&n.pattern&&(n.pattern._width="defer",n.pattern._height="defer")}}this.redraw(!1)}}function x(){var t={},e=this.renderer,i=(e.defIds||[]).filter(function(t){return t.indexOf&&0===t.indexOf("highcharts-pattern-")});if(i.length){[].forEach.call(this.renderTo.querySelectorAll('[color^="url("], [fill^="url("], [stroke^="url("]'),function(i){var r=i.getAttribute("fill")||i.getAttribute("color")||i.getAttribute("stroke");r&&(t[r.replace(e.url,"").replace("url(#","").replace(")","")]=!0)});for(var r=0;r<i.length;r++){var o=i[r];!t[o]&&(l(e.defIds,o),e.patternElements[o]&&(e.patternElements[o].destroy(),delete e.patternElements[o]))}}}function w(){var t=this.options.color;t&&t.pattern&&("string"==typeof t.pattern.path&&(t.pattern.path={d:t.pattern.path}),this.color=this.options.color=c(this.series.options.color,t))}function b(t){var e=t.args[0],i=t.args[1],r=t.args[2],o=this.chartIndex||0,a=e.pattern,n="#333333";if(void 0!==e.patternIndex&&m&&(a=m[e.patternIndex]),!a)return!0;if(a.image||"string"==typeof a.path||a.path&&a.path.d){var s=r.parentNode&&r.parentNode.getAttribute("class");s=s&&s.indexOf("highcharts-legend")>-1,("defer"===a._width||"defer"===a._height)&&A.call({graphic:{element:r}},a),(s||!a.id)&&((a=c({},a)).id="highcharts-pattern-"+o+"-"+v(a)+v(a,!0)),this.addPattern(a,!this.forExport&&d(a.animation,this.globalAnimation,{duration:100})),n="url(".concat(this.url,"#").concat(a.id+(this.forExport?"-export":""),")")}else n=a.color||n;return r.setAttribute(i,n),e.toString=function(){return n},!1}function C(){var t=this.chart.isResizing;if(this.isDirtyData||t||!this.chart.hasRendered)for(var e=0,i=this.points;e<i.length;e++){var r=i[e],o=r.options&&r.options.color;o&&o.pattern&&(t&&!(r.shapeArgs&&r.shapeArgs.width&&r.shapeArgs.height)?(o.pattern._width="defer",o.pattern._height="defer"):r.calculatePatternDimensions(o.pattern))}}function A(t){if(!t.width||!t.height){var e=this.graphic&&(this.graphic.getBBox&&this.graphic.getBBox(!0)||this.graphic.element&&this.graphic.element.getBBox())||{},i=this.shapeArgs;if(i&&(e.width=i.width||e.width,e.height=i.height||e.height,e.x=i.x||e.x,e.y=i.y||e.y),t.image){if(!e.width||!e.height){t._width="defer",t._height="defer";var r=this.series.chart.mapView&&this.series.chart.mapView.getSVGTransform().scaleY;h(r)&&r<0&&(t._inverted=!0);return}t.aspectRatio&&(e.aspectRatio=e.width/e.height,t.aspectRatio>e.aspectRatio?e.aspectWidth=e.height*t.aspectRatio:e.aspectHeight=e.width/t.aspectRatio),t._width=t.width||Math.ceil(e.aspectWidth||e.width),t._height=t.height||Math.ceil(e.aspectHeight||e.height)}t.width||(t._x=t.x||0,t._x+=e.x-Math.round(e.aspectWidth?Math.abs(e.aspectWidth-e.width)/2:0)),t.height||(t._y=t.y||0,t._y+=e.y-Math.round(e.aspectHeight?Math.abs(e.aspectHeight-e.height)/2:0))}}function _(t,e){var i,a,n,s=d(e,!0),h=o(s),l=t.color||"#333333",p=t.height||("number"==typeof t._height?t._height:0)||32,c=t.width||("number"==typeof t._width?t._width:0)||32,f=t.id;if(!f&&(this.idCounter=this.idCounter||0,f="highcharts-pattern-"+this.idCounter+"-"+(this.chartIndex||0),++this.idCounter),this.forExport&&(f+="-export"),this.defIds=this.defIds||[],!(this.defIds.indexOf(f)>-1)){this.defIds.push(f);var g={id:f,patternUnits:"userSpaceOnUse",patternContentUnits:t.patternContentUnits||"userSpaceOnUse",width:c,height:p,x:t._x||t.x||0,y:t._y||t.y||0};t._inverted&&(g.patternTransform="scale(1, -1)",t.patternTransform&&(t.patternTransform+=" scale(1, -1)")),t.patternTransform&&(g.patternTransform=t.patternTransform);var m=this.createElement("pattern").attr(g).add(this.defs);return(m.id=f,t.path)?(n=r.isObject(t.path)?t.path:{d:t.path},t.backgroundColor&&(i=t.backgroundColor,this.rect(0,0,c,p).attr({fill:i}).add(m)),a={d:n.d},this.styledMode||(a.stroke=n.stroke||l,a["stroke-width"]=d(n.strokeWidth,2),a.fill=n.fill||"none"),n.transform&&(a.transform=n.transform),this.createElement("path").attr(a).add(m),m.color=l):t.image&&(s?this.image(t.image,0,0,c,p,function(){this.animate({opacity:d(t.opacity,1)},h),u(this.element,"load")}).attr({opacity:0}).add(m):this.image(t.image,0,0,c,p).add(m)),t.image&&s||void 0===t.opacity||[].forEach.call(m.element.childNodes,function(e){e.setAttribute("opacity",t.opacity)}),this.patternElements=this.patternElements||{},this.patternElements[f]=m,m}}function M(t){var e=this.options.color;e&&e.pattern&&!e.pattern.color?(delete this.options.color,t.apply(this,[].slice.call(arguments,1)),e.pattern.color=this.color,this.color=this.options.color=e):t.apply(this,[].slice.call(arguments,1))}function S(){if(null===(t=this.chart)||void 0===t?void 0:t.mapView){var t,e,i=this.chart.renderer,r=i.patternElements;(null===(e=i.defIds)||void 0===e?void 0:e.length)&&r&&this.points.filter(function(t){var e,i,r,o;return!!t.graphic&&(t.graphic.element.hasAttribute("fill")||t.graphic.element.hasAttribute("color")||t.graphic.element.hasAttribute("stroke"))&&!(null===(i=null===(e=t.options.color)||void 0===e?void 0:e.pattern)||void 0===i?void 0:i.image)&&!!(null===(r=t.group)||void 0===r?void 0:r.scaleX)&&!!(null===(o=t.group)||void 0===o?void 0:o.scaleY)}).map(function(t){var e,r,o,a,n;return[((null===(e=t.graphic)||void 0===e?void 0:e.element.getAttribute("fill"))||(null===(r=t.graphic)||void 0===r?void 0:r.element.getAttribute("color"))||(null===(o=t.graphic)||void 0===o?void 0:o.element.getAttribute("stroke"))||"").replace(i.url,"").replace("url(#","").replace(")",""),{x:(null===(a=t.group)||void 0===a?void 0:a.scaleX)||1,y:(null===(n=t.group)||void 0===n?void 0:n.scaleY)||1}]}).filter(function(t,e,i){var r=t[0];return t[1],""!==r&&-1!==r.indexOf("highcharts-pattern-")&&!i.some(function(t,i){var o=t[0];return t[1],o===r&&i<e})}).forEach(function(t){var e=t[0],i=t[1];r[e].scaleX=1/i.x,r[e].scaleY=1/i.y,r[e].updateTransform("patternTransform")})}}return{compose:function t(e,i,r){var o=i.prototype.pointClass;f(n,t)&&(s(e,"endResize",y),s(e,"redraw",x),p(o.prototype,{calculatePatternDimensions:A}),s(o,"afterInit",w),s(i,"render",C),g(i.prototype,"getColor",M),s(i,"afterRender",S),s(i,"mapZoomComplete",S),p(r.prototype,{addPattern:_}),s(r,"complexColor",b))},patterns:m}}),i(e,"Series/Pictorial/PictorialUtilities.js",[e["Core/Utilities.js"]],function(t){var e=t.defined;return{rescalePatternFill:function(t,e,i,r,o){void 0===o&&(o=1);var a=t&&t.attr("fill"),n=a&&a.match(/url\(([^)]+)\)/);if(n){var s=document.querySelector("".concat(n[1]," path"));if(s){var h=s.getBBox();if(0===h.width){var l=s.parentElement;t.renderer.box.appendChild(s),h=s.getBBox(),l.appendChild(s)}var p=1/(h.width+o),c=e/r/h.height,d=h.width/h.height,f=i/e,u=-h.width/2;d<f&&(p=p*d/f),s.setAttribute("stroke-width",o/(i*p)),s.setAttribute("transform","translate(0.5, 0)"+"scale(".concat(p," ").concat(c,") ")+"translate(".concat(u+o*p/2,", ").concat(-h.y,")"))}}},invertShadowGroup:function(t,e){var i=e.chart.inverted;i&&t.attr({rotation:i?90:0,scaleX:i?-1:1})},getStackMetrics:function(t,i){var r=t.len,o=0;return i&&e(i.max)&&(o=t.toPixels(i.max,!0),r=t.len-o),{height:r,y:o}}}}),i(e,"Series/Pictorial/PictorialPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Series/Pictorial/PictorialUtilities.js"]],function(t,e){var i,r=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),o=t.seriesTypes.column.prototype.pointClass,a=e.rescalePatternFill,n=e.getStackMetrics;return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.setState=function(){t.prototype.setState.apply(this,arguments);var e=this.series,i=e.options.paths;if(this.graphic&&this.shapeArgs&&i){var r=i[this.index%i.length];a(this.graphic,n(e.yAxis,r).height,this.shapeArgs.width||0,this.shapeArgs.height||1/0,this.series.options.borderWidth||0)}},e}(o)}),i(e,"Series/Pictorial/PictorialSeries.js",[e["Extensions/PatternFill.js"],e["Core/Animation/AnimationUtilities.js"],e["Core/Chart/Chart.js"],e["Series/Pictorial/PictorialPoint.js"],e["Series/Pictorial/PictorialUtilities.js"],e["Core/Series/Series.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Axis/Stacking/StackItem.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,i,r,o,a,n,s,h,l){var p,c=this&&this.__extends||(p=function(t,e){return(p=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}p(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),d=n.seriesTypes.column;t.compose(i,a,h);var f=e.animObject,u=o.getStackMetrics,g=o.invertShadowGroup,m=o.rescalePatternFill,v=l.addEvent,y=l.defined,x=l.merge,w=l.objectEach,b=l.pick,C=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return c(e,t),e.prototype.animate=function(t){var e=this.chart,i=this.group,r=f(this.options.animation),o=[this.getSharedClipKey(),r.duration,r.easing,r.defer].join(","),a=e.sharedClips[o];if(t&&i){var n=this.getClipBox();a||(n.y=n.height,n.height=0,a=e.renderer.clipRect(n),e.sharedClips[o]=a),i.clip(a)}else if(a&&!a.hasClass("highcharts-animating")){var s=this.getClipBox();a.addClass("highcharts-animating").animate(s,r)}},e.prototype.animateDrilldown=function(){},e.prototype.animateDrillupFrom=function(){},e.prototype.pointAttribs=function(e){var i=t.prototype.pointAttribs.apply(this,arguments),r=this.options.paths;if(e&&e.shapeArgs&&r){var o=r[e.index%r.length],a=u(this.yAxis,o),n=a.y,s=a.height,h=o.definition;h!==e.pathDef?(e.pathDef=h,i.fill={pattern:{path:{d:h,fill:i.fill,strokeWidth:i["stroke-width"],stroke:i.stroke},x:e.shapeArgs.x,y:n,width:e.shapeArgs.width||0,height:s,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#ff0000"}}):e.pathDef&&e.graphic&&delete i.fill}return delete i.stroke,delete i.strokeWidth,i},e.prototype.getExtremes=function(){var e=t.prototype.getExtremes.apply(this,arguments),i=this.options.paths;return i&&i.forEach(function(t){y(t.max)&&y(e.dataMax)&&t.max>e.dataMax&&(e.dataMax=t.max)}),e},e.defaultOptions=x(d.defaultOptions,{borderWidth:0}),e}(d);function A(t){var e=Object.keys(t.points).filter(function(t){return t.split(",").length>1}),i=t.axis.chart.series,r=e.map(function(t){return parseFloat(t.split(",")[0])}),o=-1;r.forEach(function(t){i[t]&&i[t].visible&&(o=t)});var a=t.axis.chart.series[o];if(a&&a.is("pictorial")&&t.axis.hasData()&&a.xAxis.hasData()){var n=a.xAxis,s=t.axis.options,h=t.axis.chart,l=t.shadow,p=n.toPixels(t.x,!0),c=h.inverted?n.len-p:p,d=a.options.paths||[],f=t.x%d.length,v=d[f],y=a.getColumnMetrics&&a.getColumnMetrics().width,x=u(a.yAxis,v),w=x.height,C=x.y,A=s.stackShadow,_=b(A&&A.borderWidth,a.options.borderWidth,1);if(!l&&A&&A.enabled&&v)t.shadowGroup||(t.shadowGroup=h.renderer.g("shadow-group").add()),t.shadowGroup.attr({translateX:h.inverted?t.axis.pos:n.pos,translateY:h.inverted?n.pos:t.axis.pos}),t.shadow=h.renderer.rect(c,C,y,w).attr({fill:{pattern:{path:{d:v.definition,fill:A.color||"#dedede",strokeWidth:_,stroke:A.borderColor||"transparent"},x:c,y:C,width:y,height:w,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#dedede"}}}).add(t.shadowGroup),g(t.shadowGroup,t.axis),m(t.shadow,w,y,w,_),t.setOffset(a.pointXOffset||0,a.barW||0);else if(l&&t.shadowGroup){l.animate({x:c,y:C,width:y,height:w});var M=l.attr("fill"),S=M&&M.match(/url\(([^)]+)\)/);S&&h.renderer.patternElements&&h.renderer.patternElements[S[1].slice(1)].animate({x:c,y:C,width:y,height:w}),t.shadowGroup.animate({translateX:h.inverted?t.axis.pos:n.pos,translateY:h.inverted?n.pos:t.axis.pos}),g(t.shadowGroup,t.axis),m(l,w,y,w,_),t.setOffset(a.pointXOffset||0,a.barW||0)}}else t.shadow&&t.shadowGroup&&(t.shadow.destroy(),t.shadow=void 0,t.shadowGroup.destroy(),t.shadowGroup=void 0)}function _(t,e){t.axes&&t.axes.forEach(function(t){t.stacking&&w(t.stacking.stacks,function(t){w(t,function(t){e(t)})})})}function M(t){_(t,function(t){t.shadow&&t.shadowGroup&&(t.shadow.destroy(),t.shadowGroup.destroy(),delete t.shadow,delete t.shadowGroup)})}return v(C,"afterRender",function(){var t=this,e=t.options.paths,i=/url\(([^)]+)\)/;t.points.forEach(function(r){if(r.graphic&&r.shapeArgs&&e){var o=e[r.index%e.length],a=r.graphic.attr("fill"),n=a&&a.match(i),s=u(t.yAxis,o),h=s.y,l=s.height;if(n&&t.chart.renderer.patternElements){var p=t.chart.renderer.patternElements[n[1].slice(1)];p&&p.animate({x:r.shapeArgs.x,y:h,width:r.shapeArgs.width||0,height:l})}m(r.graphic,u(t.yAxis,o).height,r.shapeArgs.width||0,r.shapeArgs.height||1/0,t.options.borderWidth||0)}})}),v(i,"render",function(){_(this,A)}),v(s,"afterSetOffset",function(t){if(this.shadow){var e=this.axis,i=e.chart,r=e.len,o=t.xOffset,a=t.width,n=i.inverted?o-i.xAxis[0].len:o,s=i.inverted?-r:0;this.shadow.attr({translateX:n,translateY:s}),this.shadow.animate({width:a})}}),v(i,"afterDrilldown",function(t){M(this)}),v(i,"afterDrillUp",function(t){M(this)}),C.prototype.pointClass=r,n.registerSeriesType("pictorial",C),C}),i(e,"masters/modules/pictorial.src.js",[],function(){})});