/**
 * Highcharts Gantt JS v11.3.0 (2024-01-10)
 *
 * Tree Grid
 *
 * (c) 2016-2024 Jon Arild Nygard
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/treegrid",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Core/Axis/BrokenAxis.js",[e["Core/Globals.js"],e["Core/Axis/Stacking/StackItem.js"],e["Core/Utilities.js"]],function(t,e,i){var s,o=t.composed,r=i.addEvent,n=i.find,a=i.fireEvent,l=i.isArray,d=i.isNumber,h=i.pick,c=i.pushUnique;return function(t){function i(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function s(){var t;(null===(t=this.brokenAxis)||void 0===t?void 0:t.hasBreaks)&&(this.options.ordinal=!1)}function p(){var t=this.brokenAxis;if(null==t?void 0:t.hasBreaks){for(var e=this.tickPositions,i=this.tickPositions.info,s=[],o=0;o<e.length;o++)t.isInAnyBreak(e[o])||s.push(e[o]);this.tickPositions=s,this.tickPositions.info=i}}function f(){this.brokenAxis||(this.brokenAxis=new k(this))}function u(){var t,e,i=this.isDirty,s=this.options.connectNulls,o=this.points,r=this.xAxis,n=this.yAxis;if(i)for(var a=o.length;a--;){var l=o[a],d=!(null===l.y&&!1===s)&&((null===(t=null==r?void 0:r.brokenAxis)||void 0===t?void 0:t.isInAnyBreak(l.x,!0))||(null===(e=null==n?void 0:n.brokenAxis)||void 0===e?void 0:e.isInAnyBreak(l.y,!0)));l.visible=!d&&!1!==l.options.visible}}function v(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,h(this.pointArrayMap,["y"]))}function m(t,e){var i,s,o,r,n=this,l=n.points;if(null===(i=null==t?void 0:t.brokenAxis)||void 0===i?void 0:i.hasBreaks){var c=t.brokenAxis;e.forEach(function(e){s=(null==c?void 0:c.breakArray)||[],o=t.isXAxis?t.min:h(n.options.threshold,t.min);var i,p,f=null===(p=null===(i=null==t?void 0:t.options)||void 0===i?void 0:i.breaks)||void 0===p?void 0:p.filter(function(t){for(var e=!0,i=0;i<s.length;i++){var o=s[i];if(o.from===t.from&&o.to===t.to){e=!1;break}}return e});l.forEach(function(i){r=h(i["stack"+e.toUpperCase()],i[e]),s.forEach(function(e){if(d(o)&&d(r)){var s="";o<e.from&&r>e.to||o>e.from&&r<e.from?s="pointBreak":(o<e.from&&r>e.from&&r<e.to||o>e.from&&r>e.to&&r<e.from)&&(s="pointInBreak"),s&&a(t,s,{point:i,brk:e})}}),null==f||f.forEach(function(e){a(t,"pointOutsideOfBreak",{point:i,brk:e})})})})}}function g(){var t=this.currentDataGrouping,i=null==t?void 0:t.gapSize,s=this.points.slice(),o=this.yAxis,r=this.options.gapSize,n=s.length-1;if(r&&n>0){"value"!==this.options.gapUnit&&(r*=this.basePointRange),i&&i>r&&i>=this.basePointRange&&(r=i);for(var a=void 0,l=void 0;n--;)if(l&&!1!==l.visible||(l=s[n+1]),a=s[n],!1!==l.visible&&!1!==a.visible){if(l.x-a.x>r){var d=(a.x+l.x)/2;s.splice(n+1,0,{isNull:!0,x:d}),o.stacking&&this.options.stacking&&((o.stacking.stacks[this.stackKey][d]=new e(o,o.options.stackLabels,!1,d,this.stack)).total=0)}l=a}}return this.getGraphPath(s)}t.compose=function t(e,n){if(c(o,t)){e.keepProps.push("brokenAxis"),r(e,"init",f),r(e,"afterInit",i),r(e,"afterSetTickPositions",p),r(e,"afterSetOptions",s);var a=n.prototype;a.drawBreaks=m,a.gappedPath=g,r(n,"afterGeneratePoints",u),r(n,"afterRender",v)}return e};var k=function(){function t(t){this.hasBreaks=!1,this.axis=t}return t.isInBreak=function(t,e){var i=t.repeat||1/0,s=t.from,o=t.to-t.from,r=e>=s?(e-s)%i:i-(s-e)%i;return t.inclusive?r<=o:r<o&&0!==r},t.lin2Val=function(e){var i=this.brokenAxis,s=i&&i.breakArray;if(!s||!d(e))return e;var o,r,n=e;for(r=0;r<s.length&&!((o=s[r]).from>=n);r++)o.to<n?n+=o.len:t.isInBreak(o,n)&&(n+=o.len);return n},t.val2Lin=function(e){var i=this.brokenAxis,s=i&&i.breakArray;if(!s||!d(e))return e;var o,r,n=e;for(r=0;r<s.length;r++)if((o=s[r]).to<=e)n-=o.len;else if(o.from>=e)break;else if(t.isInBreak(o,e)){n-=e-o.from;break}return n},t.prototype.findBreakAt=function(t,e){return n(e,function(e){return e.from<t&&t<e.to})},t.prototype.isInAnyBreak=function(e,i){var s,o,r,n=this.axis,a=n.options.breaks||[],l=a.length;if(l&&d(e)){for(;l--;)t.isInBreak(a[l],e)&&(s=!0,o||(o=h(a[l].showPoints,!n.isXAxis)));r=s&&i?s&&!o:s}return r},t.prototype.setBreaks=function(e,i){var s=this,o=s.axis,r=l(e)&&!!e.length&&!!Object.keys(e[0]).length;o.isDirty=s.hasBreaks!==r,s.hasBreaks=r,e!==o.options.breaks&&(o.options.breaks=o.userOptions.breaks=e),o.forceRedraw=!0,o.series.forEach(function(t){t.isDirty=!0}),r||o.val2lin!==t.val2Lin||(delete o.val2lin,delete o.lin2val),r&&(o.userOptions.ordinal=!1,o.lin2val=t.lin2Val,o.val2lin=t.val2Lin,o.setExtremes=function(t,e,i,r,n){if(s.hasBreaks){for(var a=this.options.breaks||[],l=void 0;l=s.findBreakAt(t,a);)t=l.to;for(;l=s.findBreakAt(e,a);)e=l.from;e<t&&(e=t)}o.constructor.prototype.setExtremes.call(this,t,e,i,r,n)},o.setAxisTranslation=function(){if(o.constructor.prototype.setAxisTranslation.call(this),s.unitLength=void 0,s.hasBreaks){var e,i,r,n,l=o.options.breaks||[],c=[],p=[],f=h(o.pointRangePadding,0),u=0,v=o.userMin||o.min,m=o.userMax||o.max;l.forEach(function(e){i=e.repeat||1/0,d(v)&&d(m)&&(t.isInBreak(e,v)&&(v+=e.to%i-v%i),t.isInBreak(e,m)&&(m-=m%i-e.from%i))}),l.forEach(function(t){if(r=t.from,i=t.repeat||1/0,d(v)&&d(m)){for(;r-i>v;)r-=i;for(;r<v;)r+=i;for(n=r;n<m;n+=i)c.push({value:n,move:"in"}),c.push({value:n+t.to-t.from,move:"out",size:t.breakSize})}}),c.sort(function(t,e){return t.value===e.value?("in"===t.move?0:1)-("in"===e.move?0:1):t.value-e.value}),e=0,r=v,c.forEach(function(t){1===(e+="in"===t.move?1:-1)&&"in"===t.move&&(r=t.value),0===e&&d(r)&&(p.push({from:r,to:t.value,len:t.value-r-(t.size||0)}),u+=t.value-r-(t.size||0))}),s.breakArray=p,d(v)&&d(m)&&d(o.min)&&(s.unitLength=m-v-u+f,a(o,"afterBreaks"),o.staticScale?o.transA=o.staticScale:s.unitLength&&(o.transA*=(m-o.min+f)/s.unitLength),f&&(o.minPixelPadding=o.transA*(o.minPointOffset||0)),o.min=v,o.max=m)}}),h(i,!0)&&o.chart.redraw()},t}();t.Additions=k}(s||(s={})),s}),i(e,"Core/Axis/GridAxis.js",[e["Core/Axis/Axis.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i){var s,o,r=e.composed,n=e.dateFormats,a=i.addEvent,l=i.defined,d=i.erase,h=i.find,c=i.isArray,p=i.isNumber,f=i.merge,u=i.pick,v=i.pushUnique,m=i.timeUnits,g=i.wrap;function k(t){return i.isObject(t,!0)}function x(t,e){var i={width:0,height:0};if(e.forEach(function(e){var s,o=t[e],r=0,n=0;k(o)&&(r=(s=k(o.label)?o.label:{}).getBBox?s.getBBox().height:0,s.textStr&&!p(s.textPxLength)&&(s.textPxLength=s.getBBox().width),n=p(s.textPxLength)?Math.round(s.textPxLength):0,s.textStr&&(n=Math.round(s.getBBox().width)),i.height=Math.max(r,i.height),i.width=Math.max(n,i.width))}),"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode){var s=this.treeGrid.mapOfPosToGridNode[-1].height||0;i.width+=this.options.labels.indentation*(s-1)}return i}function b(t){var e=this.grid,i=3===this.side;if(i||t.apply(this),!(null==e?void 0:e.isColumn)){var s=(null==e?void 0:e.columns)||[];i&&(s=s.slice().reverse()),s.forEach(function(t){t.getOffset()})}i&&t.apply(this)}function y(t){if(!0===(this.options.grid||{}).enabled){var e=this.axisTitle,i=this.height,s=this.horiz,r=this.left,n=this.offset,a=this.opposite,l=this.options,d=this.top,h=this.width,c=this.tickSize(),p=e&&e.getBBox().width,f=l.title.x,v=l.title.y,m=u(l.title.margin,s?5:10),g=e?this.chart.renderer.fontMetrics(e).f:0,k=(s?d+i:r)+(s?1:-1)*(a?-1:1)*(c?c[0]/2:0)+(this.side===o.bottom?g:0);t.titlePosition.x=s?r-(p||0)/2-m+f:k+(a?h:0)+n+f,t.titlePosition.y=s?k-(a?i:0)+(a?g:-g)/2+n+v:d-m+v}}function P(){var e,i=this.chart,s=this.options.grid,o=void 0===s?{}:s,r=this.userOptions;if(o.enabled&&((e=this.options).labels.align=u(e.labels.align,"center"),this.categories||(e.showLastLabel=!1),this.labelRotation=0,e.labels.rotation=0,e.minTickInterval=1),o.columns)for(var n=this.grid.columns=[],a=this.grid.columnIndex=0;++a<o.columns.length;){var l=f(r,o.columns[a],{isInternal:!0,linkedTo:0,scrollbar:{enabled:!1}},{grid:{columns:void 0}}),h=new t(this.chart,l,"yAxis");h.grid.isColumn=!0,h.grid.columnIndex=a,d(i.axes,h),d(i[this.coll]||[],h),n.push(h)}}function G(){var t=this.axisTitle,e=this.grid,i=this.options;if(!0===(i.grid||{}).enabled){var s=this.min||0,r=this.max||0,n=this.ticks[this.tickPositions[0]];if(t&&!this.chart.styledMode&&(null==n?void 0:n.slotWidth)&&!this.options.title.style.width&&t.css({width:"".concat(n.slotWidth,"px")}),this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions),this.rightWall&&this.rightWall.destroy(),this.grid&&this.grid.isOuterAxis()&&this.axisLine){var a=i.lineWidth;if(a){var l=this.getLinePath(a),d=l[0],h=l[1],c=((this.tickSize("tick")||[1])[0]-1)*(this.side===o.top||this.side===o.left?-1:1);if("M"===d[0]&&"L"===h[0]&&(this.horiz?(d[2]+=c,h[2]+=c):(d[1]+=c,h[1]+=c)),!this.horiz&&this.chart.marginRight){var p=["L",this.left,d[2]||0],f=[d,p],u=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(r+this.tickmarkOffset)],v=[["M",h[1]||0,this.toPixels(r+this.tickmarkOffset)],u];this.grid.upperBorder||s%1==0||(this.grid.upperBorder=this.grid.renderBorder(f)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.upperBorder.animate({d:f})),this.grid.lowerBorder||r%1==0||(this.grid.lowerBorder=this.grid.renderBorder(v)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.lowerBorder.animate({d:v}))}this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.axisLineExtra.animate({d:l})):this.grid.axisLineExtra=this.grid.renderBorder(l),this.axisLine[this.showAxis?"show":"hide"]()}}if((e&&e.columns||[]).forEach(function(t){return t.render()}),!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)&&this.tickPositions.length){for(var m=this.tickmarkOffset,g=this.tickPositions[this.tickPositions.length-1],k=this.tickPositions[0],x=void 0,b=void 0;(x=this.hiddenLabels.pop())&&x.element;)x.show();for(;(b=this.hiddenMarks.pop())&&b.element;)b.show();(x=this.ticks[k].label)&&(s-k>m?this.hiddenLabels.push(x.hide()):x.show()),(x=this.ticks[g].label)&&(g-r>m?this.hiddenLabels.push(x.hide()):x.show());var y=this.ticks[g].mark;y&&g-r<m&&g-r>0&&this.ticks[g].isLast&&this.hiddenMarks.push(y.hide())}}}function A(){var t=this.tickPositions&&this.tickPositions.info,e=this.options,i=e.grid||{},s=this.userOptions.labels||{};i.enabled&&(this.horiz?(this.series.forEach(function(t){t.options.pointRange=0}),t&&e.dateTimeLabelFormats&&e.labels&&!l(s.align)&&(!1===e.dateTimeLabelFormats[t.unitName].range||t.count>1)&&(e.labels.align="left",l(s.x)||(e.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function O(t){var e,i=this.options,s=t.userOptions,o=i&&k(i.grid)?i.grid:{};!0===o.enabled&&(e=f(!0,{className:"highcharts-grid-axis "+(s.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,style:{fontSize:"0.9em"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0,style:{textOverflow:"ellipsis"}},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},s),"xAxis"!==this.coll||(l(s.linkedTo)&&!l(s.tickPixelInterval)&&(e.tickPixelInterval=350),!(!l(s.tickPixelInterval)&&l(s.linkedTo))||l(s.tickPositioner)||l(s.tickInterval)||l(s.units)||(e.tickPositioner=function(t,i){var s=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;if(s){for(var o=e.units||[],r=void 0,n=1,a="year",l=0;l<o.length;l++){var d=o[l];if(d&&d[0]===s.unitName){r=l;break}}var h=p(r)&&o[r+1];if(h){a=h[0]||"year";var c=h[1];n=c&&c[0]||1}else"year"===s.unitName&&(n=10*s.count);var f=m[a];return this.tickInterval=f*n,this.chart.time.getTimeTicks({unitRange:f,count:n,unitName:a},t,i,this.options.startOfWeek)}})),f(!0,this.options,e),this.horiz&&(i.minPadding=u(s.minPadding,0),i.maxPadding=u(s.maxPadding,0)),p(i.grid.borderWidth)&&(i.tickWidth=i.lineWidth=o.borderWidth))}function T(t){var e=t.userOptions,i=e&&e.grid||{},s=i.columns;i.enabled&&s&&f(!0,this.options,s[0])}function C(){(this.grid.columns||[]).forEach(function(t){return t.setScale()})}function w(t){var e=this.horiz,i=this.maxLabelDimensions,s=this.options.grid,o=void 0===s?{}:s;if(o.enabled&&i){var r=2*this.options.labels.distance,n=e?o.cellHeight||r+i.height:r+i.width;c(t.tickSize)?t.tickSize[0]=n:t.tickSize=[n,0]}}function B(){this.axes.forEach(function(t){(t.grid&&t.grid.columns||[]).forEach(function(t){t.setAxisSize(),t.setAxisTranslation()})})}function E(t){var e=this.grid;(e.columns||[]).forEach(function(e){return e.destroy(t.keepEvents)}),e.columns=void 0}function I(t){var e=t.userOptions||{},i=e.grid||{};i.enabled&&l(i.borderColor)&&(e.tickColor=e.lineColor=i.borderColor),this.grid||(this.grid=new j(this)),this.hiddenLabels=[],this.hiddenMarks=[]}function N(t){var e=this.label,i=this.axis,s=i.reversed,r=i.chart,n=i.options.grid||{},a=i.options.labels,l=a.align,d=o[i.side],h=t.tickmarkOffset,c=i.tickPositions,f=this.pos-h,u=p(c[t.index+1])?c[t.index+1]-h:(i.max||0)+h,v=i.tickSize("tick"),m=v?v[0]:0,g=v?v[1]/2:0;if(!0===n.enabled){var k,x=void 0,b=void 0,y=void 0;if("top"===d?k=(x=i.top+i.offset)-m:"bottom"===d?x=(k=r.chartHeight-i.bottom+i.offset)+m:(x=i.top+i.len-(i.translate(s?u:f)||0),k=i.top+i.len-(i.translate(s?f:u)||0)),"right"===d?y=(b=r.chartWidth-i.right+i.offset)+m:"left"===d?b=(y=i.left+i.offset)-m:(b=Math.round(i.left+(i.translate(s?u:f)||0))-g,y=Math.min(Math.round(i.left+(i.translate(s?f:u)||0))-g,i.left+i.len)),this.slotWidth=y-b,t.pos.x="left"===l?b:"right"===l?y:b+(y-b)/2,t.pos.y=k+(x-k)/2,e){var P=r.renderer.fontMetrics(e),G=e.getBBox().height;if(a.useHTML)t.pos.y+=P.b+-(G/2);else{var A=Math.round(G/P.h);t.pos.y+=(P.b-(P.h-P.f))/2+-((A-1)*P.h/2)}}t.pos.x+=i.horiz&&a.x||0}}function L(t){var i=t.axis,s=t.value;if(i.options.grid&&i.options.grid.enabled){var o=i.tickPositions,r=(i.linkedParent||i).series[0],n=s===o[0],a=s===o[o.length-1],l=r&&h(r.options.data,function(t){return t[i.isXAxis?"x":"y"]===s}),d=void 0;l&&r.is("gantt")&&(d=f(l),e.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(d)),t.isFirst=n,t.isLast=a,t.point=d}}function S(){this.chart;var t=this.options,e=t.grid||{},i=this.categories,s=this.tickPositions,o=s[0],r=s[1],n=s[s.length-1],a=s[s.length-2],l=this.linkedParent&&this.linkedParent.min,d=this.linkedParent&&this.linkedParent.max,h=l||this.min,c=d||this.max,f=this.tickInterval,u=p(h)&&h>=o+f&&h<r,v=p(h)&&o<h&&o+f>h,m=p(c)&&n>c&&n-f<c,g=p(c)&&c<=n-f&&c>a;!0===e.enabled&&!i&&(this.isXAxis||this.isLinked)&&((v||u)&&!t.startOnTick&&(s[0]=h),(m||g)&&!t.endOnTick&&(s[s.length-1]=c))}function M(t){var e,i=this.options.grid;return!0===(void 0===i?{}:i).enabled&&this.categories?this.tickInterval:t.apply(this,(e=arguments,Array.prototype.slice.call(e,1)))}(s=o||(o={}))[s.top=0]="top",s[s.right=1]="right",s[s.bottom=2]="bottom",s[s.left=3]="left";var j=function(){function t(t){this.axis=t}return t.prototype.isOuterAxis=function(){var t,e=this.axis,i=e.chart,s=e.grid.columnIndex,o=(null===(t=e.linkedParent)||void 0===t?void 0:t.grid.columns)||e.grid.columns||[],r=s?e.linkedParent:e,n=-1,a=0;return 3===e.side&&!i.inverted&&o.length?!e.linkedParent:((i[e.coll]||[]).forEach(function(t,i){t.side!==e.side||t.options.isInternal||(a=i,t!==r||(n=i))}),a===n&&(!p(s)||o.length===s))},t.prototype.renderBorder=function(t){var e=this.axis,i=e.chart.renderer,s=e.options,o=i.path(t).addClass("highcharts-axis-line").add(e.axisGroup);return i.styledMode||o.attr({stroke:s.lineColor,"stroke-width":s.lineWidth,zIndex:7}),o},t}();return n.E=function(t){return this.dateFormat("%a",t,!0).charAt(0)},n.W=function(t){var e=this,i=new this.Date(t);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(t){e.set(t,i,0)});var s=(this.get("Day",i)+6)%7,o=new this.Date(i.valueOf());this.set("Date",o,this.get("Date",i)-s+3);var r=new this.Date(this.get("FullYear",o),0,1);return 4!==this.get("Day",r)&&(this.set("Month",i,0),this.set("Date",i,1+(11-this.get("Day",r))%7)),(1+Math.floor((o.valueOf()-r.valueOf())/6048e5)).toString()},{compose:function t(e,i,s){return v(r,t)&&(e.keepProps.push("grid"),e.prototype.getMaxLabelDimensions=x,g(e.prototype,"unsquish",M),g(e.prototype,"getOffset",b),a(e,"init",I),a(e,"afterGetTitlePosition",y),a(e,"afterInit",P),a(e,"afterRender",G),a(e,"afterSetAxisTranslation",A),a(e,"afterSetOptions",O),a(e,"afterSetOptions",T),a(e,"afterSetScale",C),a(e,"afterTickSize",w),a(e,"trimTicks",S),a(e,"destroy",E),a(i,"afterSetChartSize",B),a(s,"afterGetLabelPosition",N),a(s,"labelFormat",L)),e}}}),i(e,"Gantt/Tree.js",[e["Core/Utilities.js"]],function(t){var e=this&&this.__rest||function(t,e){var i={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&0>e.indexOf(s)&&(i[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols)for(var o=0,s=Object.getOwnPropertySymbols(t);o<s.length;o++)0>e.indexOf(s[o])&&Object.prototype.propertyIsEnumerable.call(t,s[o])&&(i[s[o]]=t[s[o]]);return i},i=t.extend,s=t.isNumber,o=t.pick;function r(t,e,n,a,l,d){var h,c,p=d&&d.after,f=d&&d.before,u={data:a,depth:n-1,id:t,level:n,parent:e||""},v=0,m=0;"function"==typeof f&&f(u,d);var g=(l[t]||[]).map(function(e){var i=r(e.id,t,n+1,e,l,d),o=e.start||NaN,a=!0===e.milestone?o:e.end||NaN;return h=!s(h)||o<h?o:h,c=!s(c)||a>c?a:c,v=v+1+i.descendants,m=Math.max(i.height+1,m),i});return a&&(a.start=o(a.start,h),a.end=o(a.end,c)),i(u,{children:g,descendants:v,height:m}),"function"==typeof p&&p(u,d),u}return{getNode:r,getTree:function(t,i){var s,o;return r("",null,1,null,(s=[],Object.keys(o=t.reduce(function(t,e){var i=e.parent,o=void 0===i?"":i,r=e.id;return void 0===t[o]&&(t[o]=[]),t[o].push(e),r&&s.push(r),t},{})).forEach(function(t){var i;if(""!==t&&-1===s.indexOf(t)){var r=o[t].map(function(t){return t.parent,e(t,["parent"])});(i=o[""]).push.apply(i,r),delete o[t]}}),o),i)}}}),i(e,"Core/Axis/TreeGrid/TreeGridTick.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=t.composed,s=e.addEvent,o=e.removeEvent,r=e.isObject,n=e.isNumber,a=e.pick,l=e.pushUnique,d=e.wrap;function h(){this.treeGrid||(this.treeGrid=new f(this))}function c(t,e,i,s,o,l,d,h,c){var p,f,u,v=a(this.options&&this.options.labels,l),m=this.pos,g=this.axis,k="treegrid"===g.options.type,x=t.apply(this,[e,i,s,o,v,d,h,c]);if(k){var b=v&&r(v.symbol,!0)?v.symbol:{},y=b.width,P=b.padding,G=void 0===P?g.linkedParent?0:5:P,A=v&&n(v.indentation)?v.indentation:0;u=(f=(p=g.treeGrid.mapOfPosToGridNode)&&p[m])&&f.depth||1,x.x+=(void 0===y?0:y)+2*G+(u-1)*A}return x}function p(t){var e,i,l,d,h,c,p,f,u,v,m,g,k,x,b,y=this.pos,P=this.axis,G=this.label,A=this.treeGrid,O=this.options,T=null==A?void 0:A.labelIcon,C=null==G?void 0:G.element,w=P.treeGrid,B=P.options,E=P.chart,I=P.tickPositions,N=w.mapOfPosToGridNode,L=a(null==O?void 0:O.labels,null==B?void 0:B.labels),S=L&&r(L.symbol,!0)?L.symbol:{},M=N&&N[y],j=M||{},D=j.descendants,W=j.depth,z=M&&D&&D>0,R="treegrid"===B.type&&C,U=I.indexOf(y)>-1,H="highcharts-treegrid-node-",q=H+"level-",F=E.styledMode;(R&&M&&G.removeClass(RegExp(q+".*")).addClass(q+W),t.apply(this,Array.prototype.slice.call(arguments,1)),R&&z)?(b=w.isCollapsed(M),e={color:!F&&G.styles&&G.styles.color||"",collapsed:b,group:G.parentGroup,options:S,renderer:G.renderer,show:U,xy:G.xy},d=!(l=this.treeGrid).labelIcon,h=e.renderer,c=e.xy,f=(p=e.options).width||0,u=p.height||0,v=(null!==(i=p.padding)&&void 0!==i?i:this.axis.linkedParent)?0:5,m={x:c.x-f/2-v,y:c.y-u/2},g=e.collapsed?90:180,k=e.show&&n(m.y),(x=l.labelIcon)||(l.labelIcon=x=h.path(h.symbols[p.type](p.x||0,p.y||0,f,u)).addClass("highcharts-label-icon").add(e.group)),x[k?"show":"hide"](),h.styledMode||x.attr({cursor:"pointer",fill:a(e.color,"#666666"),"stroke-width":1,stroke:p.lineColor,strokeWidth:p.lineWidth||0}),x[d?"attr":"animate"]({translateX:m.x,translateY:m.y,rotation:g}),G.addClass(H+(b?"collapsed":"expanded")).removeClass(H+(b?"expanded":"collapsed")),F||G.css({cursor:"pointer"}),[G,T].forEach(function(t){t&&!t.attachedTreeGridEvents&&(s(t.element,"mouseover",function(){G.addClass("highcharts-treegrid-node-active"),G.renderer.styledMode||G.css({textDecoration:"underline"})}),s(t.element,"mouseout",function(){var t;t=r(L.style)?L.style:{},G.removeClass("highcharts-treegrid-node-active"),G.renderer.styledMode||G.css({textDecoration:t.textDecoration||"none"})}),s(t.element,"click",function(){A.toggleCollapse()}),t.attachedTreeGridEvents=!0)})):T&&(o(C),null==G||G.css({cursor:"default"}),T.destroy())}var f=function(){function t(t){this.tick=t}return t.compose=function(t){if(l(i,this.compose)){var e=t.prototype;s(t,"init",h),d(e,"getLabelPosition",c),d(e,"renderLabel",p),e.collapse=function(t){this.treeGrid.collapse(t)},e.expand=function(t){this.treeGrid.expand(t)},e.toggleCollapse=function(t){this.treeGrid.toggleCollapse(t)}}},t.prototype.collapse=function(t){var e=this.tick,i=e.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){var o=e.pos,r=i.treeGrid.mapOfPosToGridNode[o],n=i.treeGrid.collapse(r);s.setBreaks(n,a(t,!0))}},t.prototype.destroy=function(){this.labelIcon&&this.labelIcon.destroy()},t.prototype.expand=function(t){var e=this.tick,i=e.pos,s=e.axis,o=s.treeGrid,r=s.brokenAxis,n=o.mapOfPosToGridNode;if(r&&n){var l=n[i],d=o.expand(l);r.setBreaks(d,a(t,!0))}},t.prototype.toggleCollapse=function(t){var e=this.tick,i=e.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){var o=e.pos,r=i.treeGrid.mapOfPosToGridNode[o],n=i.treeGrid.toggleCollapse(r);s.setBreaks(n,a(t,!0))}},t}();return f}),i(e,"Series/TreeUtilities.js",[e["Core/Color/Color.js"],e["Core/Utilities.js"]],function(t,e){var i=e.extend,s=e.isArray,o=e.isNumber,r=e.isObject,n=e.merge,a=e.pick;return{getColor:function(e,i){var s,o,r,n,l,d,h,c=i.index,p=i.mapOptionsToLevel,f=i.parentColor,u=i.parentColorIndex,v=i.series,m=i.colors,g=i.siblings,k=v.points,x=v.chart.options.chart;return e&&(o=k[e.i],r=p[e.level]||{},o&&r.colorByPoint&&(l=o.index%(m?m.length:x.colorCount),n=m&&m[l]),v.chart.styledMode||(d=a(o&&o.options.color,r&&r.color,n,f&&((s=r&&r.colorVariation)&&"brightness"===s.key&&c&&g?t.parse(f).brighten(s.to*(c/g)).get():f),v.color)),h=a(o&&o.options.colorIndex,r&&r.colorIndex,l,u,i.colorIndex)),{color:d,colorIndex:h}},getLevelOptions:function(t){var e,i,l,d,h,c,p={};if(r(t))for(d=o(t.from)?t.from:1,c=t.levels,i={},e=r(t.defaults)?t.defaults:{},s(c)&&(i=c.reduce(function(t,i){var s,l,h;return r(i)&&o(i.level)&&(l=a((h=n({},i)).levelIsConstant,e.levelIsConstant),delete h.levelIsConstant,delete h.level,r(t[s=i.level+(l?0:d-1)])?n(!0,t[s],h):t[s]=h),t},{})),h=o(t.to)?t.to:1,l=0;l<=h;l++)p[l]=n({},e,r(i[l])?i[l]:{});return p},setTreeValues:function t(e,s){var o=s.before,r=s.idRoot,n=s.mapIdToNode[r],l=!1!==s.levelIsConstant,d=s.points[e.i],h=d&&d.options||{},c=[],p=0;e.levelDynamic=e.level-(l?0:n.level),e.name=a(d&&d.name,""),e.visible=r===e.id||!0===s.visible,"function"==typeof o&&(e=o(e,s)),e.children.forEach(function(o,r){var n=i({},s);i(n,{index:r,siblings:e.children.length,visible:e.visible}),o=t(o,n),c.push(o),o.visible&&(p+=o.val)});var f=a(h.value,p);return e.visible=f>=0&&(p>0||e.visible),e.children=c,e.childrenTotal=p,e.isLeaf=e.visible&&!p,e.val=f,e},updateRootId:function(t){var e,i;return r(t)&&(i=r(t.options)?t.options:{},e=a(t.rootNode,i.rootId,""),r(t.userOptions)&&(t.userOptions.rootId=e),t.rootNode=e),e}}}),i(e,"Core/Axis/TreeGrid/TreeGridAxis.js",[e["Core/Axis/BrokenAxis.js"],e["Core/Axis/GridAxis.js"],e["Core/Globals.js"],e["Gantt/Tree.js"],e["Core/Axis/TreeGrid/TreeGridTick.js"],e["Series/TreeUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,n){var a,l=i.composed,d=r.getLevelOptions,h=n.addEvent,c=n.find,p=n.fireEvent,f=n.isArray,u=n.isObject,v=n.isString,m=n.merge,g=n.pick,k=n.pushUnique,x=n.removeEvent,b=n.wrap;function y(t,e){var i=t.collapseEnd||0,s=t.collapseStart||0;return i>=e&&(s-=.5),{from:s,to:i,showPoints:!1}}function P(t,e,i){var o,r,n=[],a=[],l={},d="boolean"==typeof e&&e,h={},p=-1,f=s.getTree(t,{after:function(t){var e=h[t.pos],i=0,s=0;e.children.forEach(function(t){s+=(t.descendants||0)+1,i=Math.max((t.height||0)+1,i)}),e.descendants=s,e.height=i,e.collapsed&&a.push(e)},before:function(t){var e,i,s=u(t.data,!0)?t.data:{},o=v(s.name)?s.name:"",r=l[t.parent],a=u(r,!0)?h[r.pos]:null;d&&u(a,!0)&&(e=c(a.children,function(t){return t.name===o}))?(i=e.pos,e.nodes.push(t)):i=p++,!h[i]&&(h[i]=e={depth:a?a.depth+1:0,name:o,id:s.id,nodes:[t],children:[],pos:i},-1!==i&&n.push(o),u(a,!0)&&a.children.push(e)),v(t.id)&&(l[t.id]=t),e&&!0===s.collapsed&&(e.collapsed=!0),t.pos=i}});return o=h,{categories:n,mapOfIdToNode:l,mapOfPosToGridNode:h=(r=function(t,e,s){var o=t.nodes,n=e+(-1===e?0:i-1),a=(n-e)/2,l=e+a;return o.forEach(function(t){var i=t.data;u(i,!0)&&(i.y=e+(i.seriesIndex||0),delete i.seriesIndex),t.pos=l}),s[l]=t,t.pos=l,t.tickmarkOffset=a+.5,t.collapseStart=n+.5,t.children.forEach(function(t){r(t,n+1,s),n=(t.collapseEnd||0)-.5}),t.collapseEnd=n+.5,s})(o["-1"],-1,{}),collapsedNodes:a,tree:f}}function G(t){t.target.axes.filter(function(t){return"treegrid"===t.options.type}).forEach(function(e){var i,s,o=e.options||{},r=o.labels,n=o.uniqueNames,a=o.max,l=!e.treeGrid.mapOfPosToGridNode||e.series.some(function(t){return!t.hasRendered||t.isDirtyData||t.isDirty}),h=0;if(l){if(i=e.series.reduce(function(t,e){return e.visible&&((e.options.data||[]).forEach(function(i){e.options.keys&&e.options.keys.length&&(i=e.pointClass.prototype.optionsToObject.call({series:e},i),e.pointClass.setGanttPointAliases(i)),u(i,!0)&&(i.seriesIndex=h,t.push(i))}),!0===n&&h++),t},[]),a&&i.length<a)for(var c=i.length;c<=a;c++)i.push({name:c+"​"});s=P(i,n||!1,!0===n?h:1),e.categories=s.categories,e.treeGrid.mapOfPosToGridNode=s.mapOfPosToGridNode,e.hasNames=!0,e.treeGrid.tree=s.tree,e.series.forEach(function(t){var e=(t.options.data||[]).map(function(e){return f(e)&&t.options.keys&&t.options.keys.length&&i.forEach(function(t){e.indexOf(t.x)>=0&&e.indexOf(t.x2)>=0&&(e=t)}),u(e,!0)?m(e):e});t.visible&&t.setData(e,!1)}),e.treeGrid.mapOptionsToLevel=d({defaults:r,from:1,levels:r&&r.levels,to:e.treeGrid.tree&&e.treeGrid.tree.height}),"beforeRender"===t.type&&(e.treeGrid.collapsedNodes=s.collapsedNodes)}})}function A(t,e){var i,s,o,r=this.treeGrid.mapOptionsToLevel||{},n="treegrid"===this.options.type,l=this.ticks,d=l[e];n&&this.treeGrid.mapOfPosToGridNode?((i=r[(o=this.treeGrid.mapOfPosToGridNode[e]).depth])&&(s={labels:i}),!d&&a?l[e]=d=new a(this,e,void 0,void 0,{category:o.name,tickmarkOffset:o.tickmarkOffset,options:s}):(d.parameters.category=o.name,d.options=s,d.addLabel())):t.apply(this,Array.prototype.slice.call(arguments,1))}function O(t,e,i,s){var o=this,r="treegrid"===i.type;o.treeGrid||(o.treeGrid=new w(o)),r&&(h(e,"beforeRender",G),h(e,"beforeRedraw",G),h(e,"addSeries",function(t){if(t.options.data){var e=P(t.options.data,i.uniqueNames||!1,1);o.treeGrid.collapsedNodes=(o.treeGrid.collapsedNodes||[]).concat(e.collapsedNodes)}}),h(o,"foundExtremes",function(){o.treeGrid.collapsedNodes&&o.treeGrid.collapsedNodes.forEach(function(t){var e=o.treeGrid.collapse(t);o.brokenAxis&&(o.brokenAxis.setBreaks(e,!1),o.treeGrid.collapsedNodes&&(o.treeGrid.collapsedNodes=o.treeGrid.collapsedNodes.filter(function(e){return t.collapseStart!==e.collapseStart||t.collapseEnd!==e.collapseEnd})))})}),h(o,"afterBreaks",function(){"yAxis"===o.coll&&!o.staticScale&&o.chart.options.chart.height&&(o.isDirty=!0)}),i=m({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10}},uniqueNames:!1},i,{reversed:!0})),t.apply(o,[e,i,s]),r&&(o.hasNames=!0,o.options.showLastLabel=!0)}function T(t){var e,i=this.options,s="number"==typeof i.linkedTo?null===(e=this.chart[this.coll])||void 0===e?void 0:e[i.linkedTo]:void 0;if("treegrid"===i.type){if(this.min=g(this.userMin,i.min,this.dataMin),this.max=g(this.userMax,i.max,this.dataMax),p(this,"foundExtremes"),this.setAxisTranslation(),this.tickInterval=1,this.tickmarkOffset=.5,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[],s){var o=s.getExtremes();this.min=g(o.min,o.dataMin),this.max=g(o.max,o.dataMax),this.tickPositions=s.tickPositions}this.linkedParent=s}else t.apply(this,Array.prototype.slice.call(arguments,1))}function C(t){var e=this;"treegrid"===e.options.type&&e.visible&&e.tickPositions.forEach(function(t){var i=e.ticks[t];i.label&&i.label.attachedTreeGridEvents&&(x(i.label.element),i.label.attachedTreeGridEvents=!1)}),t.apply(e,Array.prototype.slice.call(arguments,1))}var w=function(){function i(t){this.axis=t}return i.compose=function(i,r,n,d){if(k(l,this.compose)){var h=i.prototype;-1===i.keepProps.indexOf("treeGrid")&&i.keepProps.push("treeGrid"),b(h,"generateTick",A),b(h,"init",O),b(h,"setTickInterval",T),b(h,"redraw",C),h.utils={getNode:s.getNode},a||(a=d)}return e.compose(i,r,d),t.compose(i,n),o.compose(d),i},i.prototype.setCollapsedStatus=function(t){var e=this.axis,i=e.chart;e.series.forEach(function(e){var s=e.options.data;if(t.id&&s){var o=i.get(t.id),r=s[e.data.indexOf(o)];o&&r&&(o.collapsed=t.collapsed,r.collapsed=t.collapsed)}})},i.prototype.collapse=function(t){var e=this.axis,i=e.options.breaks||[],s=y(t,e.max);return i.push(s),t.collapsed=!0,e.treeGrid.setCollapsedStatus(t),i},i.prototype.expand=function(t){var e=this.axis,i=e.options.breaks||[],s=y(t,e.max);return t.collapsed=!1,e.treeGrid.setCollapsedStatus(t),i.reduce(function(t,e){return(e.to!==s.to||e.from!==s.from)&&t.push(e),t},[])},i.prototype.getTickPositions=function(){var t=this.axis,e=Math.floor(t.min/t.tickInterval)*t.tickInterval,i=Math.ceil(t.max/t.tickInterval)*t.tickInterval;return Object.keys(t.treeGrid.mapOfPosToGridNode||{}).reduce(function(s,o){var r=+o;return r>=e&&r<=i&&!(t.brokenAxis&&t.brokenAxis.isInAnyBreak(r))&&s.push(r),s},[])},i.prototype.isCollapsed=function(t){var e=this.axis,i=e.options.breaks||[],s=y(t,e.max);return i.some(function(t){return t.from===s.from&&t.to===s.to})},i.prototype.toggleCollapse=function(t){return this.isCollapsed(t)?this.expand(t):this.collapse(t)},i}();return w}),i(e,"masters/modules/treegrid.src.js",[e["Core/Globals.js"],e["Core/Axis/TreeGrid/TreeGridAxis.js"]],function(t,e){e.compose(t.Axis,t.Chart,t.Series,t.Tick)})});