/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Variable Pie module for Highcharts
 *
 * (c) 2010-2024 Grzegorz Blachliński
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/variable-pie",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,n){t.hasOwnProperty(e)||(t[e]=n.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Series/VariablePie/VariablePieSeriesDefaults.js",[],function(){return{minPointSize:"10%",maxPointSize:"100%",zMin:void 0,zMax:void 0,sizeBy:"area",tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}<br/>Value: {point.y}<br/>Size: {point.z}<br/>'}}}),i(e,"Series/VariablePie/VariablePieSeries.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Series/VariablePie/VariablePieSeriesDefaults.js"]],function(t,e,i){var n,a=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),r=t.seriesTypes.pie,o=e.arrayMax,s=e.arrayMin,l=e.clamp,h=e.extend,p=e.fireEvent,c=e.merge,u=e.pick,f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a(e,t),e.prototype.calculateExtremes=function(){for(var t,e,i=this.chart,n=i.plotWidth,a=i.plotHeight,r=this.options,h=2*(r.slicedOffset||0),p=this.zData,c=Math.min(n,a)-h,f={},d=this.center||this.getCenter(),y=0,M=["minPointSize","maxPointSize"];y<M.length;y++){var g=M[y],m=r[g],P=/%$/.test(m);m=parseInt(m,10),f[g]=P?c*m/100:2*m}this.minPxSize=d[3]+f.minPointSize,this.maxPxSize=l(d[2],d[3]+f.minPointSize,f.maxPointSize),p.length&&(t=u(r.zMin,s(p.filter(this.zValEval))),e=u(r.zMax,o(p.filter(this.zValEval))),this.getRadii(t,e,this.minPxSize,this.maxPxSize))},e.prototype.getRadii=function(t,e,i,n){for(var a,r,o,s=this.zData,l=[],h="radius"!==this.options.sizeBy,p=e-t,c=0;c<s.length;c++)(r=this.zValEval(s[c])?s[c]:t)<=t?o=i/2:r>=e?o=n/2:(a=p>0?(r-t)/p:.5,h&&(a=Math.sqrt(a)),o=Math.ceil(i+a*(n-i))/2),l.push(o);this.radii=l},e.prototype.redraw=function(){this.center=null,t.prototype.redraw.call(this)},e.prototype.getDataLabelPosition=function(t,e){var i=this.center,n=this.options,a=t.angle||0,r=this.radii[t.index],o=i[0]+Math.cos(a)*r,s=i[1]+Math.sin(a)*r,l=Math.min((n.slicedOffset||0)+(n.borderWidth||0),e/5);return{distance:e,natural:{x:o+Math.cos(a)*e,y:s+Math.sin(a)*e},computed:{},alignment:t.half?"right":"left",connectorPosition:{breakAt:{x:o+Math.cos(a)*l,y:s+Math.sin(a)*l},touchingSliceAt:{x:o,y:s}}}},e.prototype.translate=function(t){this.generatePoints();var e,i,n,a,r,o,s,l=this.options,h=l.slicedOffset,c=l.startAngle||0,f=Math.PI/180*(c-90),d=Math.PI/180*(u(l.endAngle,c+360)-90),y=d-f,M=this.points,g=l.ignoreHiddenPoint,m=0;this.startAngleRad=f,this.endAngleRad=d,this.calculateExtremes(),t||(this.center=t=this.getCenter());for(var P=0;P<M.length;P++)o=M[P],s=this.radii[P],e=f+m*y,(!g||o.visible)&&(m+=o.percentage/100),i=f+m*y,o.shapeType="arc",o.shapeArgs={x:t[0],y:t[1],r:s,innerR:t[3]/2,start:Math.round(1e3*e)/1e3,end:Math.round(1e3*i)/1e3},(n=(i+e)/2)>1.5*Math.PI?n-=2*Math.PI:n<-Math.PI/2&&(n+=2*Math.PI),o.slicedTranslation={translateX:Math.round(Math.cos(n)*h),translateY:Math.round(Math.sin(n)*h)},a=Math.cos(n)*t[2]/2,r=Math.sin(n)*t[2]/2,o.tooltipPos=[t[0]+.7*a,t[1]+.7*r],o.half=n<-Math.PI/2||n>Math.PI/2?1:0,o.angle=n;p(this,"afterTranslate")},e.prototype.zValEval=function(t){return!("number"!=typeof t||isNaN(t))||null},e.defaultOptions=c(r.defaultOptions,i),e}(r);return h(f.prototype,{pointArrayMap:["y","z"],parallelArrays:["x","y","z"]}),t.registerSeriesType("variablepie",f),f}),i(e,"masters/modules/variable-pie.src.js",[],function(){})});