/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Marker clusters module for Highcharts
 *
 * (c) 2010-2024 Wojciech Chmiel
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/marker-clusters",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/MarkerClusters/MarkerClusterDefaults.js",[],function(){return{cluster:{enabled:!1,allowOverlap:!0,animation:{duration:500},drillToCluster:!0,minimumClusterSize:2,layoutAlgorithm:{gridSize:50,distance:40,kmeansThreshold:100},marker:{symbol:"cluster",radius:15,lineWidth:0,lineColor:"#ffffff"},dataLabels:{enabled:!0,format:"{point.clusterPointsAmount}",verticalAlign:"middle",align:"center",style:{color:"contrast"},inside:!0}},tooltip:{clusterFormat:"<span>Clustered points: {point.clusterPointsAmount}</span><br/>"}}}),i(e,"Extensions/MarkerClusters/MarkerClusterScatter.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Extensions/MarkerClusters/MarkerClusterDefaults.js"],e["Core/Utilities.js"]],function(t,e,i,s){let a;let{animObject:r}=t,{composed:o}=e,{cluster:n}=i,{addEvent:l,defined:p,error:u,isArray:d,isFunction:h,isObject:c,isNumber:f,merge:m,objectEach:g,pushUnique:x,relativeLength:y,syncTimeout:C}=s,k={grid:function(t,e,i,s){let a,r,o,n,l;let p={},u=this.getGridOffset(),d=this.getScaledGridSize(s);for(l=0;l<t.length;l++){let s=U(this,{x:t[l],y:e[l]});a=s.x-u.plotLeft,r=s.y-u.plotTop,o=Math.floor(a/d),p[n=Math.floor(r/d)+"-"+o]||(p[n]=[]),p[n].push({dataIndex:i[l],x:t[l],y:e[l]})}return p},kmeans:function(t,e,i,s){let a=[],r=[],o={},l=s.processedDistance||n.layoutAlgorithm.distance,p=s.iterations,u=0,d=!0,h=0,c=0,f,m=[];s.processedGridSize=s.processedDistance;let g=this.markerClusterAlgorithms?this.markerClusterAlgorithms.grid.call(this,t,e,i,s):{};for(let t in g)g[t].length>1&&(f=X(g[t]),a.push({posX:f.x,posY:f.y,oldX:0,oldY:0,startPointsLen:g[t].length,points:[]}));for(;d;){for(let t of a)t.points.length=0;r.length=0;for(let s=0;s<t.length;s++)h=t[s],c=e[s],(m=this.getClusterDistancesFromPoint(a,h,c)).length&&m[0].distance<l?a[m[0].clusterIndex].points.push({x:h,y:c,dataIndex:i[s]}):r.push({x:h,y:c,dataIndex:i[s]});for(let t=0;t<a.length;t++)1===a[t].points.length&&(m=this.getClusterDistancesFromPoint(a,a[t].points[0].x,a[t].points[0].y))[1].distance<l&&(a[m[1].clusterIndex].points.push(a[t].points[0]),a[m[0].clusterIndex].points.length=0);d=!1;for(let t=0;t<a.length;t++)f=X(a[t].points),a[t].oldX=a[t].posX,a[t].oldY=a[t].posY,a[t].posX=f.x,a[t].posY=f.y,(a[t].posX>a[t].oldX+1||a[t].posX<a[t].oldX-1||a[t].posY>a[t].oldY+1||a[t].posY<a[t].oldY-1)&&(d=!0);p&&(d=u<p-1),u++}for(let t=0,e=a.length;t<e;++t)o["cluster"+t]=a[t].points;for(let t=0,e=r.length;t<e;++t)o["noise"+t]=[r[t]];return o},optimizedKmeans:function(t,e,i,s){let a=s.processedDistance||n.layoutAlgorithm.gridSize,r=this.getRealExtremes(),o=(this.options.cluster||{}).marker,l,u={},d,h;if(!this.markerClusterInfo||this.initMaxX&&this.initMaxX<r.maxX||this.initMinX&&this.initMinX>r.minX||this.initMaxY&&this.initMaxY<r.maxY||this.initMinY&&this.initMinY>r.minY)this.initMaxX=r.maxX,this.initMinX=r.minX,this.initMaxY=r.maxY,this.initMinY=r.minY,u=this.markerClusterAlgorithms?this.markerClusterAlgorithms.kmeans.call(this,t,e,i,s):{},this.baseClusters=null;else{for(let t of(this.baseClusters||(this.baseClusters={clusters:this.markerClusterInfo.clusters,noise:this.markerClusterInfo.noise}),this.baseClusters.clusters)){for(let e of(t.pointsOutside=[],t.pointsInside=[],t.data)){let i=U(this,e),s=U(this,t);l=Math.sqrt(Math.pow(i.x-s.x,2)+Math.pow(i.y-s.y,2)),d=a-(h=t.clusterZone&&t.clusterZone.marker&&t.clusterZone.marker.radius?t.clusterZone.marker.radius:o&&o.radius?o.radius:n.marker.radius)>=0?a-h:h,l>h+d&&p(t.pointsOutside)?t.pointsOutside.push(e):p(t.pointsInside)&&t.pointsInside.push(e)}t.pointsInside.length&&(u[t.id]=t.pointsInside);let e=0;for(let i of t.pointsOutside)u[t.id+"_noise"+e++]=[i]}for(let t of this.baseClusters.noise)u[t.id]=t.data}return u}},M=[],I=0;function S(t,e,i){t.attr({opacity:e}).animate({opacity:1},i)}function b(t,e,i,s){for(let a of(A(t,s,i,!0,!0),e))a.point&&a.point.destroy&&a.point.destroy()}function A(t,e,i,s,a){t.point&&(s&&t.point.graphic&&(t.point.graphic.show(),S(t.point.graphic,e,i)),a&&t.point.dataLabel&&(t.point.dataLabel.show(),S(t.point.dataLabel,e,i)))}function X(t){let e=t.length,i=0,s=0;for(let a=0;a<e;a++)i+=t[a].x,s+=t[a].y;return{x:i/e,y:s/e}}function Y(t,e){let i=[];return i.length=e,t.clusters.forEach(function(t){t.data.forEach(function(t){i[t.dataIndex]=t})}),t.noise.forEach(function(t){i[t.data[0].dataIndex]=t.data[0]}),i}function D(){return Math.random().toString(36).substring(2,7)+"-"+I++}function L(t,e,i){t.point&&(e&&t.point.graphic&&t.point.graphic.hide(),i&&t.point.dataLabel&&t.point.dataLabel.hide())}function z(t){let e=t.point||t.target;e.firePointEvent("drillToCluster",t,function(t){let e=t.point||t.target,i=e.series,s=e.series.xAxis,a=e.series.yAxis,r=e.series.chart,o=r.mapView,n=i.options.cluster,l=(n||{}).drillToCluster;if(l&&e.clusteredData){let i=e.clusteredData.map(t=>t.x).sort((t,e)=>t-e),n=e.clusteredData.map(t=>t.y).sort((t,e)=>t-e),l=i[0],p=i[i.length-1],u=n[0],d=n[n.length-1],h=Math.abs((p-l)*.1),c=Math.abs((d-u)*.1),f=Math.min(l,p)-h,m=Math.max(l,p)+h,g=Math.min(u,d)-c,x=Math.max(u,d)+c;o?o.fitToBounds({x1:f,x2:m,y1:g,y2:x}):s&&a&&(r.pointer.zoomX=!0,r.pointer.zoomY=!0,r.zoom({originalEvent:t,xAxis:[{axis:s,min:f,max:m}],yAxis:[{axis:a,min:g,max:x}]}))}})}function P(t,e){let{chart:i,xAxis:s,yAxis:a}=t;return i.mapView?i.mapView.pixelsToProjectedUnits(e):{x:s?s.toValue(e.x):0,y:a?a.toValue(e.y):0}}function w(t){let e=this.chart,i=e.mapView,s=this.options.cluster,a=r((s||{}).animation),o=a.duration||500,n=(this.markerClusterInfo||{}).pointsState,l=(n||{}).newState,p=(n||{}).oldState,u=[],d,h,c,f=0,m=0,g=0,x=!1,y=!1;if(p&&l){h=l[t.stateId];let s=U(this,h);m=s.x-(i?0:e.plotLeft),g=s.y-(i?0:e.plotTop),1===h.parentsId.length?(d=p[(l||{})[t.stateId].parentsId[0]],h.point&&h.point.graphic&&d&&d.point&&d.point.plotX&&d.point.plotY&&d.point.plotX!==h.point.plotX&&d.point.plotY!==h.point.plotY&&(c=h.point.graphic.getBBox(),f=h.point.graphic&&h.point.graphic.isImg?0:c.width/2,h.point.graphic.attr({x:d.point.plotX-f,y:d.point.plotY-f}),h.point.graphic.animate({x:m-(h.point.graphic.radius||0),y:g-(h.point.graphic.radius||0)},a,function(){y=!0,d.point&&d.point.destroy&&d.point.destroy()}),h.point.dataLabel&&h.point.dataLabel.alignAttr&&d.point.dataLabel&&d.point.dataLabel.alignAttr&&(h.point.dataLabel.attr({x:d.point.dataLabel.alignAttr.x,y:d.point.dataLabel.alignAttr.y}),h.point.dataLabel.animate({x:h.point.dataLabel.alignAttr.x,y:h.point.dataLabel.alignAttr.y},a)))):0===h.parentsId.length?(L(h,!0,!0),C(function(){A(h,.1,a,!0,!0)},o/2)):(L(h,!0,!0),h.parentsId.forEach(function(t){p&&p[t]&&(d=p[t],u.push(d),d.point&&d.point.graphic&&(x=!0,d.point.graphic.show(),d.point.graphic.animate({x:m-(d.point.graphic.radius||0),y:g-(d.point.graphic.radius||0),opacity:.4},a,function(){y=!0,b(h,u,a,.7)}),d.point.dataLabel&&-9999!==d.point.dataLabel.y&&h.point&&h.point.dataLabel&&h.point.dataLabel.alignAttr&&(d.point.dataLabel.show(),d.point.dataLabel.animate({x:h.point.dataLabel.alignAttr.x,y:h.point.dataLabel.alignAttr.y,opacity:.4},a))))}),C(function(){y||b(h,u,a,.85)},o),x||C(function(){b(h,u,a,.1)},o/2))}}function E(){let t=this.markerClusterSeriesData;(t||[]).forEach(function(t){t&&t.destroy&&t.destroy()}),this.markerClusterSeriesData=null}function j(){let t,e,i,s,r,o,u,d,c,m,g,x,C,k,M,I;let S=this,b=S.chart,A=b.mapView,X=S.xData,Y=S.yData,D=S.options.cluster,L=S.getRealExtremes(),w=[],E=[],j=[];if(A&&S.is("mappoint")&&X&&Y&&(S.options.data||[]).forEach((t,e)=>{let i=S.projectPoint(t);i&&(X[e]=i.x,Y[e]=i.y)}),D&&D.enabled&&X&&X.length&&Y&&Y.length&&!b.polar){g=D.layoutAlgorithm.type,(k=D.layoutAlgorithm).processedGridSize=y(k.gridSize||n.layoutAlgorithm.gridSize,b.plotWidth),k.processedDistance=y(k.distance||n.layoutAlgorithm.distance,b.plotWidth),s=k.kmeansThreshold||n.layoutAlgorithm.kmeansThreshold;let A=k.processedGridSize/2,O=P(S,{x:0,y:0}),V=P(S,{x:A,y:A});for(I=0,r=Math.abs(O.x-V.x),o=Math.abs(O.y-V.y);I<X.length;I++)!S.dataMaxX&&(p(d)&&p(u)&&p(m)&&p(c)?f(Y[I])&&f(m)&&f(c)&&(d=Math.max(X[I],d),u=Math.min(X[I],u),m=Math.max(Y[I]||m,m),c=Math.min(Y[I]||c,c)):(d=u=X[I],m=c=Y[I])),X[I]>=L.minX-r&&X[I]<=L.maxX+r&&(Y[I]||L.minY)>=L.minY-o&&(Y[I]||L.maxY)<=L.maxY+o&&(w.push(X[I]),E.push(Y[I]),j.push(I));p(d)&&p(u)&&f(m)&&f(c)&&(S.dataMaxX=d,S.dataMinX=u,S.dataMaxY=m,S.dataMinY=c),x=(C=(h(g)?g:S.markerClusterAlgorithms?g&&S.markerClusterAlgorithms[g]?S.markerClusterAlgorithms[g]:w.length<s?S.markerClusterAlgorithms.kmeans:S.markerClusterAlgorithms.grid:function(){return!1}).call(this,w,E,j,k))?S.getClusteredData(C,D):C,D.animation&&S.markerClusterInfo&&S.markerClusterInfo.pointsState&&S.markerClusterInfo.pointsState.oldState?(function(t){if(t){let e;for(let i of Object.keys(t))(e=t[i]).point&&e.point.destroy&&e.point.destroy()}}(S.markerClusterInfo.pointsState.oldState),t=S.markerClusterInfo.pointsState.newState):t={},e=X.length,i=S.markerClusterInfo,x&&(S.processedXData=x.groupedXData,S.processedYData=x.groupedYData,S.hasGroupedData=!0,S.markerClusterInfo=x,S.groupMap=x.groupMap),a.apply(this),x&&S.markerClusterInfo&&((S.markerClusterInfo.clusters||[]).forEach(function(t){(M=S.points[t.index]).isCluster=!0,M.clusteredData=t.data,M.clusterPointsAmount=t.data.length,t.point=M,l(M,"click",z)}),(S.markerClusterInfo.noise||[]).forEach(function(t){t.point=S.points[t.index]}),D.animation&&S.markerClusterInfo&&(S.markerClusterInfo.pointsState={oldState:t,newState:S.getPointsState(x,i,e)}),D.animation?this.hideClusteredData():this.destroyClusteredData(),this.markerClusterSeriesData=this.hasGroupedData?this.points:null)}else a.apply(this)}function O(t,e,i){let s=[];for(let a=0;a<t.length;a++){let r=U(this,{x:e,y:i}),o=U(this,{x:t[a].posX,y:t[a].posY}),n=Math.sqrt(Math.pow(r.x-o.x,2)+Math.pow(r.y-o.y,2));s.push({clusterIndex:a,distance:n})}return s.sort((t,e)=>t.distance-e.distance)}function V(t,e){let i=[],s=[],a=[],r=[],o=[],l=Math.max(2,e.minimumClusterSize||2),p=0,f,g,x,y,C,k,M,I,S,b,A,Y,L,z;if(h(e.layoutAlgorithm.type)&&!this.isValidGroupedDataObject(t))return u("Highcharts marker-clusters module: The custom algorithm result is not valid!",!1,this.chart),!1;for(z in t)if(t[z].length>=l){if(x=t[z],f=D(),C=x.length,e.zones)for(L=0;L<e.zones.length;L++)C>=e.zones[L].from&&C<=e.zones[L].to&&((A=e.zones[L]).zoneIndex=L,b=e.zones[L].marker,Y=e.zones[L].className);for(S=X(x),"grid"!==e.layoutAlgorithm.type||e.allowOverlap?M={x:S.x,y:S.y}:(k=this.options.marker||{},M=this.preventClusterCollisions({x:S.x,y:S.y,key:z,groupedData:t,gridSize:this.getScaledGridSize(e.layoutAlgorithm),defaultRadius:k.radius||3+(k.lineWidth||0),clusterRadius:b&&b.radius?b.radius:(e.marker||{}).radius||n.marker.radius})),L=0;L<C;L++)x[L].parentStateId=f;if(a.push({x:M.x,y:M.y,id:z,stateId:f,index:p,data:x,clusterZone:A,clusterZoneClassName:Y}),i.push(M.x),s.push(M.y),o.push({options:{formatPrefix:"cluster",dataLabels:e.dataLabels,marker:m(e.marker,{states:e.states},b||{})}}),this.options.data&&this.options.data.length)for(L=0;L<C;L++)c(this.options.data[x[L].dataIndex])&&(x[L].options=this.options.data[x[L].dataIndex]);p++,b=null}else for(L=0;L<t[z].length;L++)g=t[z][L],f=D(),I=null,y=((this.options||{}).data||[])[g.dataIndex],i.push(g.x),s.push(g.y),g.parentStateId=f,r.push({x:g.x,y:g.y,id:z,stateId:f,index:p,data:t[z]}),I=y&&"object"==typeof y&&!d(y)?m(y,{x:g.x,y:g.y}):{userOptions:y,x:g.x,y:g.y},o.push({options:I}),p++;return{clusters:a,noise:r,groupedXData:i,groupedYData:s,groupMap:o}}function T(){let t=this.chart,e=this.xAxis,i=this.yAxis,s=0;return{plotLeft:e&&this.dataMinX&&this.dataMaxX?e.reversed?e.toPixels(this.dataMaxX):e.toPixels(this.dataMinX):t.plotLeft,plotTop:i&&this.dataMinY&&this.dataMaxY?i.reversed?i.toPixels(this.dataMinY):i.toPixels(this.dataMaxY):t.plotTop}}function G(t,e,i){let s,a;let r=e?Y(e,i):[],o=Y(t,i),n={};M=[],t.clusters.forEach(function(t){n[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}}),t.noise.forEach(function(t){n[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}});for(let t=0;t<o.length;t++)s=o[t],a=r[t],s&&a&&s.parentStateId&&a.parentStateId&&n[s.parentStateId]&&-1===n[s.parentStateId].parentsId.indexOf(a.parentStateId)&&(n[s.parentStateId].parentsId.push(a.parentStateId),-1===M.indexOf(a.parentStateId)&&M.push(a.parentStateId));return n}function v(){let t=this.chart,e=t.mapView?0:t.plotLeft,i=t.mapView?0:t.plotTop,s=P(this,{x:e,y:i}),a=P(this,{x:e+t.plotWidth,y:e+t.plotHeight}),r=s.x,o=a.x,n=s.y,l=a.y;return{minX:Math.min(r,o),maxX:Math.max(r,o),minY:Math.min(n,l),maxY:Math.max(n,l)}}function R(t){let e=this.xAxis,i=this.chart.mapView,s=t.processedGridSize||n.layoutAlgorithm.gridSize,a=!0,r=1,o=1;this.gridValueSize||(i?this.gridValueSize=s/i.getScale():this.gridValueSize=Math.abs(e.toValue(s)-e.toValue(0)));let l=i?this.gridValueSize*i.getScale():e.toPixels(this.gridValueSize)-e.toPixels(0),p=+(s/l).toFixed(14);for(;a&&1!==p;){let t=Math.pow(2,r);p>.75&&p<1.25?a=!1:p>=1/t&&p<2*(1/t)?(a=!1,o=t):p<=t&&p>t/2&&(a=!1,o=1/t),r++}return s/o/p}function Z(){let t=this.markerClusterSeriesData,e=((this.markerClusterInfo||{}).pointsState||{}).oldState||{},i=M.map(t=>(e[t].point||{}).id||"");(t||[]).forEach(function(t){t&&-1!==i.indexOf(t.id)?(t.graphic&&t.graphic.hide(),t.dataLabel&&t.dataLabel.hide()):t&&t.destroy&&t.destroy()})}function F(t){let e=!1,i;return!!c(t)&&(g(t,function(t){if(e=!0,!d(t)||!t.length){e=!1;return}for(i=0;i<t.length;i++)if(!c(t[i])||!t[i].x||!t[i].y){e=!1;return}}),e)}function H(t){let[e,i]=t.key.split("-").map(parseFloat),s=t.gridSize,a=t.groupedData,r=t.defaultRadius,o=t.clusterRadius,l=i*s,u=e*s,d=U(this,t),h=[],c=(this.options.cluster||{}).marker,f=(this.options.cluster||{}).zones,m=this.getGridOffset(),g=d.x,x=d.y,y=0,C=0,k,M,I,S,b,A,Y,D,L,z,w,E,j;for(g-=m.plotLeft,x-=m.plotTop,Y=1;Y<5;Y++)for(D=0,I=Y%2?-1:1,S=Y<3?-1:1,b=Math.floor((g+I*o)/s),j=[(A=Math.floor((x+S*o)/s))+"-"+b,A+"-"+i,e+"-"+b];D<j.length;D++)-1===h.indexOf(j[D])&&j[D]!==t.key&&h.push(j[D]);for(let t of h)if(a[t]){a[t].posX||(w=X(a[t]),a[t].posX=w.x,a[t].posY=w.y);let d=U(this,{x:a[t].posX||0,y:a[t].posY||0});if(k=d.x-m.plotLeft,M=d.y-m.plotTop,[z,L]=t.split("-").map(parseFloat),f)for(Y=0,y=a[t].length;Y<f.length;Y++)y>=f[Y].from&&y<=f[Y].to&&(C=p((f[Y].marker||{}).radius)?f[Y].marker.radius||0:c&&c.radius?c.radius:n.marker.radius);a[t].length>1&&0===C&&c&&c.radius?C=c.radius:1===a[t].length&&(C=r),E=o+C,C=0,L!==i&&Math.abs(g-k)<E&&(g=L-i<0?l+o:l+s-o),z!==e&&Math.abs(x-M)<E&&(x=z-e<0?u+o:u+s-o)}let O=P(this,{x:g+m.plotLeft,y:x+m.plotTop});return a[t.key].posX=O.x,a[t.key].posY=O.y,O}function U(t,e){let{chart:i,xAxis:s,yAxis:a}=t;return i.mapView?i.mapView.projectedUnitsToPixels(e):{x:s?s.toPixels(e.x):0,y:a?a.toPixels(e.y):0}}return{compose:function t(e,s){if(x(o,t)){let t=s.prototype;a=t.generatePoints,t.markerClusterAlgorithms=k,t.animateClusterPoint=w,t.destroyClusteredData=E,t.generatePoints=j,t.getClusterDistancesFromPoint=O,t.getClusteredData=V,t.getGridOffset=T,t.getPointsState=G,t.getRealExtremes=v,t.getScaledGridSize=R,t.hideClusteredData=Z,t.isValidGroupedDataObject=F,t.preventClusterCollisions=H,l(s,"destroy",t.destroyClusteredData),(e.plotOptions||{}).series=m((e.plotOptions||{}).series,i)}}}}),i(e,"Extensions/MarkerClusters/MarkerClusters.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Extensions/MarkerClusters/MarkerClusterDefaults.js"],e["Extensions/MarkerClusters/MarkerClusterScatter.js"],e["Core/Utilities.js"]],function(t,e,i,s,a,r){let{animObject:o}=t,{defaultOptions:n}=e,{composed:l}=i,{addEvent:p,defined:u,error:d,isFunction:h,merge:c,pushUnique:f,syncTimeout:m}=r;function g(){let t=this.chart,e=0;for(let i of t.series)i.markerClusterInfo&&(e=o((i.options.cluster||{}).animation).duration||0);m(()=>{t.tooltip&&t.tooltip.destroy()},e)}function x(){for(let t of this.series||[])if(t.markerClusterInfo){let e=t.options.cluster,i=(t.markerClusterInfo||{}).pointsState,s=(i||{}).oldState;if((e||{}).animation&&t.markerClusterInfo&&0===t.chart.pointer.pinchDown.length&&"pan"!==((t.xAxis||{}).eventArgs||{}).trigger&&s&&Object.keys(s).length){for(let e of t.markerClusterInfo.clusters)t.animateClusterPoint(e);for(let e of t.markerClusterInfo.noise)t.animateClusterPoint(e)}}}function y(t){let e=t.point||t.target,i=e.series,s=i.options.cluster,a=((s||{}).events||{}).drillToCluster;h(a)&&a.call(this,t)}function C(){if(this.dataGroup)return d("Highcharts marker-clusters module: Running `Point.update` when point belongs to clustered series is not supported.",!1,this.series.chart),!1}function k(){let t=(this.options.cluster||{}).drillToCluster;if(this.markerClusterInfo&&this.markerClusterInfo.clusters)for(let e of this.markerClusterInfo.clusters)e.point&&e.point.graphic&&(e.point.graphic.addClass("highcharts-cluster-point"),t&&e.point&&(e.point.graphic.css({cursor:"pointer"}),e.point.dataLabel&&e.point.dataLabel.css({cursor:"pointer"})),u(e.clusterZone)&&e.point.graphic.addClass(e.clusterZoneClassName||"highcharts-cluster-zone-"+e.clusterZone.zoneIndex))}return(n.plotOptions||{}).series=c((n.plotOptions||{}).series,s),{compose:function t(e,i,s,r){if(f(l,t)){let t=r.prototype.pointClass,{scatter:o}=r.types;p(e,"setExtremes",g),p(i,"render",x),p(t,"drillToCluster",y),p(t,"update",C),p(r,"afterRender",k),o&&a.compose(s,o)}}}}),i(e,"Extensions/MarkerClusters/MarkerClusterSymbols.js",[e["Core/Utilities.js"]],function(t){let e;let{pushUnique:i}=t,s=[];function a(t,i,s,a){let r=s/2,o=a/2,n=e.arc(t+r,i+o,r-4,o-4,{start:.5*Math.PI,end:2.5*Math.PI,open:!1}),l=e.arc(t+r,i+o,r-3,o-3,{start:.5*Math.PI,end:2.5*Math.PI,innerR:r-2,open:!1}),p=e.arc(t+r,i+o,r-1,o-1,{start:.5*Math.PI,end:2.5*Math.PI,innerR:r,open:!1});return p.concat(l,n)}return{compose:function t(r){i(s,t)&&((e=r.prototype.symbols).cluster=a)}}}),i(e,"masters/modules/marker-clusters.src.js",[e["Core/Globals.js"],e["Extensions/MarkerClusters/MarkerClusters.js"],e["Extensions/MarkerClusters/MarkerClusterSymbols.js"]],function(t,e,i){e.compose(t.Axis,t.Chart,t.defaultOptions,t.Series),i.compose(t.SVGRenderer)})});