/**
 * Highcharts JS v11.3.0 (2024-01-10)
 * Organization chart series type
 *
 * (c) 2019-2024 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/organization",["highcharts","highcharts/modules/sankey"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,n){t.hasOwnProperty(e)||(t[e]=n.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Series/Organization/OrganizationPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{sankey:{prototype:{pointClass:i}}}=t.seriesTypes,{defined:n,find:s,pick:o}=e;return class extends i{constructor(t,e,i){super(t,e,i),this.isNode||(this.dataLabelOnNull=!0,this.formatPrefix="link")}getSum(){return 1}setNodeColumn(){super.setNodeColumn();let t=this,e=t.getFromNode().fromNode;if(!n(t.options.column)&&0!==t.linksTo.length&&e&&"hanging"===e.options.layout){let i=-1,n;t.options.layout=o(t.options.layout,"hanging"),t.hangsFrom=e,s(e.linksFrom,(e,n)=>{let s=e.toNode===t;return s&&(i=n),s});for(let s=0;s<e.linksFrom.length;++s)(n=e.linksFrom[s]).toNode.id===t.id?s=e.linksFrom.length:i+=function t(e){let i=e.linksFrom.length;return e.linksFrom.forEach(e=>{e.id===e.toNode.linksTo[0].id?i+=t(e.toNode):i--}),i}(n.toNode);t.column=(t.column||0)+i}}}}),i(e,"Series/Organization/OrganizationSeriesDefaults.js",[],function(){return{borderColor:"#666666",borderRadius:3,link:{color:"#666666",lineWidth:1,radius:10,type:"default"},borderWidth:1,dataLabels:{nodeFormatter:function(){let t={width:"100%",height:"100%",display:"flex","flex-direction":"row","align-items":"center","justify-content":"center"},e={"max-height":"100%","border-radius":"50%"},i={width:"100%",padding:0,"text-align":"center","white-space":"normal"};function n(t){return Object.keys(t).reduce(function(e,i){return e+i+":"+t[i]+";"},'style="')+'"'}let{description:s,image:o,title:r}=this.point;o&&(e["max-width"]="30%",i.width="70%"),this.series.chart.renderer.forExport&&(t.display="block",i.position="absolute",i.left=o?"30%":0,i.top=0);let a="<div "+n(t)+">";return o&&(a+='<img src="'+o+'" '+n(e)+">"),a+="<div "+n(i)+">",this.point.name&&(a+="<h4 "+n({margin:0})+">"+this.point.name+"</h4>"),r&&(a+="<p "+n({margin:0})+">"+(r||"")+"</p>"),s&&(a+="<p "+n({opacity:.75,margin:"5px"})+">"+s+"</p>"),a+="</div></div>"},style:{fontWeight:"normal",fontSize:"0.9em"},useHTML:!0,linkTextPath:{attributes:{startOffset:"95%",textAnchor:"end"}}},hangingIndent:20,hangingIndentTranslation:"inherit",minNodeLength:10,nodeWidth:50,tooltip:{nodeFormat:"{point.name}<br>{point.title}<br>{point.description}"}}}),i(e,"Series/PathUtilities.js",[],function(){function t(t,e){let i=[];for(let n=0;n<t.length;n++){let s=t[n][1],o=t[n][2];if("number"==typeof s&&"number"==typeof o){if(0===n)i.push(["M",s,o]);else if(n===t.length-1)i.push(["L",s,o]);else if(e){let r=t[n-1],a=t[n+1];if(r&&a){let t=r[1],n=r[2],h=a[1],l=a[2];if("number"==typeof t&&"number"==typeof h&&"number"==typeof n&&"number"==typeof l&&t!==h&&n!==l){let r=t<h?1:-1,a=n<l?1:-1;i.push(["L",s-r*Math.min(Math.abs(s-t),e),o-a*Math.min(Math.abs(o-n),e)],["C",s,o,s,o,s+r*Math.min(Math.abs(s-h),e),o+a*Math.min(Math.abs(o-l),e)])}}}else i.push(["L",s,o])}}return i}return{applyRadius:t,getLinkPath:{default:function(e){let{x1:i,y1:n,x2:s,y2:o,width:r=0,inverted:a=!1,radius:h,parentVisible:l}=e,d=[["M",i,n],["L",i,n],["C",i,n,i,o,i,o],["L",i,o],["C",i,n,i,o,i,o],["L",i,o]];return l?t([["M",i,n],["L",i+r*(a?-.5:.5),n],["L",i+r*(a?-.5:.5),o],["L",s,o]],h):d},straight:function(t){let{x1:e,y1:i,x2:n,y2:s,width:o=0,inverted:r=!1,parentVisible:a}=t;return a?[["M",e,i],["L",e+o*(r?-1:1),s],["L",n,s]]:[["M",e,i],["L",e,s],["L",e,s]]},curved:function(t){let{x1:e,y1:i,x2:n,y2:s,offset:o=0,width:r=0,inverted:a=!1,parentVisible:h}=t;return h?[["M",e,i],["C",e+o,i,e-o+r*(a?-1:1),s,e+r*(a?-1:1),s],["L",n,s]]:[["M",e,i],["C",e,i,e,s,e,s],["L",n,s]]}}}}),i(e,"Series/Organization/OrganizationSeries.js",[e["Series/Organization/OrganizationPoint.js"],e["Series/Organization/OrganizationSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Series/PathUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,s){let{sankey:o}=i.seriesTypes,{css:r,extend:a,isNumber:h,merge:l,pick:d}=s;class p extends o{alignDataLabel(t,e,i){let n=t.shapeArgs;if(i.useHTML&&n){let t=this.options.borderWidth+2*this.options.dataLabels.padding,i=n.width||0,s=n.height||0;this.chart.inverted&&(i=s,s=n.width||0),s-=t,i-=t;let o=e.text;o&&(r(o.element.parentNode,{width:i+"px",height:s+"px"}),r(o.element,{left:0,top:0,width:"100%",height:"100%",overflow:"hidden"})),e.getBBox=()=>({width:i,height:s,x:0,y:0}),e.width=i,e.height=s}super.alignDataLabel.apply(this,arguments)}createNode(t){let e=super.createNode.call(this,t);return e.getSum=()=>1,e}pointAttribs(t,e){let i=o.prototype.pointAttribs.call(this,t,e),n=t.isNode?t.level:t.fromNode.level,s=this.mapOptionsToLevel[n||0]||{},r=t.options,a=s.states&&s.states[e]||{},l=d(a.borderRadius,r.borderRadius,s.borderRadius,this.options.borderRadius),p=d(a.linkColor,r.linkColor,s.linkColor,this.options.linkColor,a.link&&a.link.color,r.link&&r.link.color,s.link&&s.link.color,this.options.link&&this.options.link.color),g=d(a.linkLineWidth,r.linkLineWidth,s.linkLineWidth,this.options.linkLineWidth,a.link&&a.link.lineWidth,r.link&&r.link.lineWidth,s.link&&s.link.lineWidth,this.options.link&&this.options.link.lineWidth),u=d(a.linkOpacity,r.linkOpacity,s.linkOpacity,this.options.linkOpacity,a.link&&a.link.linkOpacity,r.link&&r.link.linkOpacity,s.link&&s.link.linkOpacity,this.options.link&&this.options.link.linkOpacity);return t.isNode?h(l)&&(i.r=l):(i.stroke=p,i["stroke-width"]=g,i.opacity=u,delete i.fill),i}translateLink(t){let e=this.chart,i=this.options,s=t.fromNode,o=t.toNode,r=d(i.linkLineWidth,i.link.lineWidth),a=Math.round(r)%2/2,h=d(i.link.offset,.5),l=d(t.options.link&&t.options.link.type,i.link.type);if(s.shapeArgs&&o.shapeArgs){let p=i.hangingIndent,g=o.options.offset,u=/%$/.test(g)&&parseInt(g,10),f=e.inverted,c=Math.floor((s.shapeArgs.x||0)+(s.shapeArgs.width||0))+a,k=Math.floor((s.shapeArgs.y||0)+(s.shapeArgs.height||0)/2)+a,m=Math.floor(o.shapeArgs.x||0)+a,y=Math.floor((o.shapeArgs.y||0)+(o.shapeArgs.height||0)/2)+a,L;if(f&&(c-=s.shapeArgs.width||0,m+=o.shapeArgs.width||0),L=this.colDistance?Math.floor(m+(f?1:-1)*(this.colDistance-this.nodeWidth)/2)+a:Math.floor((m+c)/2)+a,u&&(u>=50||u<=-50)&&(L=m=Math.floor(m+(f?-.5:.5)*(o.shapeArgs.width||0))+a,y=o.shapeArgs.y||0,u>0&&(y+=o.shapeArgs.height||0)),o.hangsFrom===s&&(e.inverted?(k=Math.floor((s.shapeArgs.y||0)+(s.shapeArgs.height||0)-p/2)+a,y=(o.shapeArgs.y||0)+(o.shapeArgs.height||0)):k=Math.floor((s.shapeArgs.y||0)+p/2)+a,L=m=Math.floor((o.shapeArgs.x||0)+(o.shapeArgs.width||0)/2)+a),t.plotX=L,t.plotY=(k+y)/2,t.shapeType="path","straight"===l)t.shapeArgs={d:[["M",c,k],["L",m,y]]};else if("curved"===l){let e=Math.abs(m-c)*h*(f?-1:1);t.shapeArgs={d:[["M",c,k],["C",c+e,k,m-e,y,m,y]]}}else t.shapeArgs={d:n.applyRadius([["M",c,k],["L",L,k],["L",L,y],["L",m,y]],d(i.linkRadius,i.link.radius))};t.dlBox={x:(c+m)/2,y:(k+y)/2,height:r,width:0}}}translateNode(t,e){super.translateNode(t,e);let i=this.chart,n=this.options,s=this.translationFactor,o=t.getSum(),r=Math.max(Math.round(o*s),this.options.minLinkWidth||0),a=Math.round(this.nodeWidth),h=n.hangingIndent||0,d=i.inverted?-1:1,p=t.shapeArgs,g=n.hangingIndentTranslation,u=n.minNodeLength||10,f=t.hangsFrom;if(f){if("cumulative"===g)for(p.height-=h,p.y-=d*h;f;)p.y+=d*h,f=f.hangsFrom;else if("shrink"===g)for(;f&&p.height>h+u;)p.height-=h,f=f.hangsFrom;else p.height-=h,i.inverted||(p.y+=h)}t.nodeHeight=i.inverted?p.width:p.height,t.shapeArgs&&!t.hangsFrom&&(t.shapeArgs=l(t.shapeArgs,{x:(t.shapeArgs.x||0)+a/2-(t.shapeArgs.width||0)/2,y:(t.shapeArgs.y||0)+r/2-(t.shapeArgs.height||0)/2}))}drawDataLabels(){let t=this.options.dataLabels;if(t.linkTextPath&&t.linkTextPath.enabled)for(let t of this.points)t.options.dataLabels=l(t.options.dataLabels,{useHTML:!1});super.drawDataLabels()}}return p.defaultOptions=l(o.defaultOptions,e),a(p.prototype,{pointClass:t}),i.registerSeriesType("organization",p),p}),i(e,"masters/modules/organization.src.js",[],function(){})});