/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Support for parallel coordinates in Highcharts
 *
 * (c) 2010-2024 Pawel Fus
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/parallel-coordinates",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function s(t,e,s,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,s),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}s(e,"Extensions/ParallelCoordinates/ParallelCoordinatesDefaults.js",[],function(){return{chart:{parallelCoordinates:!1,parallelAxes:{lineWidth:1,title:{text:"",reserveSpace:!1},labels:{x:0,y:4,align:"center",reserveSpace:!1},offset:0}},xAxis:{lineWidth:0,tickLength:0,opposite:!0,type:"category"}}}),s(e,"Extensions/ParallelCoordinates/ParallelAxis.js",[e["Core/Globals.js"],e["Extensions/ParallelCoordinates/ParallelCoordinatesDefaults.js"],e["Core/Utilities.js"]],function(t,e,s){var i;let{composed:l}=t,{addEvent:o,arrayMax:a,arrayMin:r,isNumber:n,merge:h,pick:p,pushUnique:c,splat:d}=s;class f{constructor(t){this.axis=t}setPosition(t,e){let s=this.axis,i=s.chart,l=((this.position||0)+.5)/(i.parallelInfo.counter+1);i.polar?e.angle=360*l:(e[t[0]]=100*l+"%",s[t[1]]=e[t[1]]=0,s[t[2]]=e[t[2]]=null,s[t[3]]=e[t[3]]=null)}}return function(t){function s(t){let s=this.chart,i=this.parallelCoordinates,l=["left","width","height","top"];if(s.hasParallelCoordinates){if(s.inverted&&(l=l.reverse()),this.isXAxis)this.options=h(this.options,e.xAxis,t.userOptions);else{let e=s.yAxis.indexOf(this);this.options=h(this.options,this.chart.options.chart.parallelAxes,t.userOptions),i.position=p(i.position,e>=0?e:s.yAxis.length),i.setPosition(l,this.options)}}}function i(t){let e=this.chart,s=this.parallelCoordinates;if(s&&e&&e.hasParallelCoordinates&&!this.isXAxis){let e=s.position,i=[];this.series.forEach(function(t){if(t.yData&&t.visible&&n(e)){let s=t.yData[e];i.push.apply(i,d(s))}}),i=i.filter(n),this.dataMin=r(i),this.dataMax=a(i),t.preventDefault()}}function u(){this.parallelCoordinates||(this.parallelCoordinates=new f(this))}t.compose=function t(e){c(l,t)&&(e.keepProps.push("parallel"),o(e,"init",u),o(e,"afterSetOptions",s),o(e,"getSeriesExtremes",i))}}(i||(i={})),i}),s(e,"Extensions/ParallelCoordinates/ParallelSeries.js",[e["Core/Globals.js"],e["Core/Templating.js"],e["Core/Utilities.js"]],function(t,e,s){var i;let{composed:l}=t,{format:o}=e,{addEvent:a,defined:r,erase:n,extend:h,insertItem:p,isArray:c,isNumber:d,pick:f,pushUnique:u,wrap:x}=s;return function(t){function e(){let t=this.chart,e=this.points,s=e&&e.length,i=Number.MAX_VALUE,l,o;if(this.chart.hasParallelCoordinates){for(let a=0;a<s;a++)r((o=e[a]).y)?(t.polar?o.plotX=t.yAxis[a].angleRad||0:t.inverted?o.plotX=t.plotHeight-t.yAxis[a].top+t.plotTop:o.plotX=t.yAxis[a].left-t.plotLeft,o.clientX=o.plotX,o.plotY=t.yAxis[a].translate(o.y,!1,!0,void 0,!0),d(o.high)&&(o.plotHigh=t.yAxis[a].translate(o.high,!1,!0,void 0,!0)),void 0!==l&&(i=Math.min(i,Math.abs(o.plotX-l))),l=o.plotX,o.isInside=t.isInsidePlot(o.plotX,o.plotY,{inverted:t.inverted})):o.isNull=!0;this.closestPointRangePx=i}}function s(t){let e=this.chart;if(e.hasParallelCoordinates){for(let t of e.axes)p(this,t.series),t.isDirty=!0;this.xAxis=e.xAxis[0],this.yAxis=e.yAxis[0],t.preventDefault()}}function i(){let t=this.chart;if(t.hasParallelCoordinates)for(let e of t.axes||[])e&&e.series&&(n(e.series,this),e.isDirty=e.forceRedraw=!0)}function C(t){let e,s,i,l;let a=this.series&&this.series.chart,n=t.apply(this,[].slice.call(arguments,1));return a&&a.hasParallelCoordinates&&!r(n.formattedValue)&&(e=(i=f((s=(l=a.yAxis[this.x]).options).tooltipValueFormat,s.labels.format))?o(i,h(this,{value:this.y}),a):l.dateTime?a.time.dateFormat(a.time.resolveDTLFormat(s.dateTimeLabelFormats[l.tickPositions.info.unitName]).main,this.y):c(s.categories)?s.categories[this.y]:this.y,n.formattedValue=n.point.formattedValue=e),n}t.compose=function t(o){if(u(l,t)){let{line:{prototype:{pointClass:t}},spline:{prototype:{pointClass:l}}}=o.types;a(o,"afterTranslate",e,{order:1}),a(o,"bindAxes",s),a(o,"destroy",i),t&&x(t.prototype,"getLabelConfig",C),l&&x(l.prototype,"getLabelConfig",C)}}}(i||(i={})),i}),s(e,"Extensions/ParallelCoordinates/ParallelCoordinates.js",[e["Core/Globals.js"],e["Extensions/ParallelCoordinates/ParallelAxis.js"],e["Extensions/ParallelCoordinates/ParallelCoordinatesDefaults.js"],e["Extensions/ParallelCoordinates/ParallelSeries.js"],e["Core/Utilities.js"]],function(t,e,s,i,l){var o;let{composed:a}=t,{addEvent:r,defined:n,merge:h,pushUnique:p,splat:c}=l;class d{constructor(t){this.chart=t}setParallelInfo(t){let e=this.chart||this,s=t.series;for(let t of(e.parallelInfo={counter:0},s))t.data&&(e.parallelInfo.counter=Math.max(e.parallelInfo.counter,t.data.length-1))}}return function(t){function l(t){let e=t.args[0],i=c(e.yAxis||{}),l=[],o=i.length;if(this.hasParallelCoordinates=e.chart&&e.chart.parallelCoordinates,this.hasParallelCoordinates){for(this.setParallelInfo(e);o<=this.parallelInfo.counter;o++)l.push({});e.legend||(e.legend={}),void 0===e.legend.enabled&&(e.legend.enabled=!1),h(!0,e,{boost:{seriesThreshold:Number.MAX_VALUE},plotOptions:{series:{boostThreshold:Number.MAX_VALUE}}}),e.yAxis=i.concat(l),e.xAxis=h(s.xAxis,c(e.xAxis||{})[0])}}function o(t){let e=t.options;if(e.chart&&(n(e.chart.parallelCoordinates)&&(this.hasParallelCoordinates=e.chart.parallelCoordinates),this.options.chart.parallelAxes=h(this.options.chart.parallelAxes,e.chart.parallelAxes)),this.hasParallelCoordinates)for(let t of(e.series&&this.setParallelInfo(e),this.yAxis))t.update({},!1)}t.compose=function t(n,c,f,u){if(e.compose(n),i.compose(u),p(a,t)){let t=d.prototype,e=c.prototype;e.setParallelInfo=t.setParallelInfo,r(c,"init",l),r(c,"update",o),h(!0,f.chart,s.chart)}}}(o||(o={})),o}),s(e,"masters/modules/parallel-coordinates.src.js",[e["Core/Globals.js"],e["Extensions/ParallelCoordinates/ParallelCoordinates.js"]],function(t,e){e.compose(t.Axis,t.Chart,t.defaultOptions,t.Series)})});