/**
 * Highcharts Gantt JS v11.3.0 (2024-01-10)
 *
 * Pathfinder
 *
 * (c) 2016-2024 Øystein Moseng
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pathfinder",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function n(t,e,n,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,n),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}n(e,"Gantt/Connection.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){let{defined:n,error:i,merge:r,objectEach:o}=e,a=t.deg2rad,s=Math.max,h=Math.min;return class{constructor(t,e,n){this.init(t,e,n)}init(t,e,n){this.fromPoint=t,this.toPoint=e,this.options=n,this.chart=t.series.chart,this.pathfinder=this.chart.pathfinder}renderPath(t,e){let n=this.chart,i=n.styledMode,r=this.pathfinder,o={},a=this.graphics&&this.graphics.path;r.group||(r.group=n.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(n.seriesGroup)),r.group.translate(n.plotLeft,n.plotTop),a&&a.renderer||(a=n.renderer.path().add(r.group),i||a.attr({opacity:0})),a.attr(e),o.d=t,i||(o.opacity=1),a.animate(o),this.graphics=this.graphics||{},this.graphics.path=a}addMarker(t,e,n){let i,r,o,s,h,c,l,x;let M=this.fromPoint.series.chart,d=M.pathfinder,y=M.renderer,f="start"===t?this.fromPoint:this.toPoint,u=f.getPathfinderAnchorPoint(e);e.enabled&&((x="start"===t?n[1]:n[n.length-2])&&"M"===x[0]||"L"===x[0])&&(l={x:x[1],y:x[2]},r=f.getRadiansToVector(l,u),i=f.getMarkerVector(r,e.radius,u),o=-r/a,e.width&&e.height?(h=e.width,c=e.height):h=c=2*e.radius,this.graphics=this.graphics||{},s={x:i.x-h/2,y:i.y-c/2,width:h,height:c,rotation:o,rotationOriginX:i.x,rotationOriginY:i.y},this.graphics[t]?this.graphics[t].animate(s):(this.graphics[t]=y.symbol(e.symbol).addClass("highcharts-point-connecting-path-"+t+"-marker highcharts-color-"+this.fromPoint.colorIndex).attr(s).add(d.group),y.styledMode||this.graphics[t].attr({fill:e.color||this.fromPoint.color,stroke:e.lineColor,"stroke-width":e.lineWidth,opacity:0}).animate({opacity:1},f.series.options.animation)))}getPath(t){let e=this.pathfinder,n=this.chart,o=e.algorithms[t.type],a=e.chartObstacles;return"function"!=typeof o?(i('"'+t.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]}):(o.requiresObstacles&&!a&&(a=e.chartObstacles=e.getChartObstacles(t),n.options.connectors.algorithmMargin=t.algorithmMargin,e.chartObstacleMetrics=e.getObstacleMetrics(a)),o(this.fromPoint.getPathfinderAnchorPoint(t.startMarker),this.toPoint.getPathfinderAnchorPoint(t.endMarker),r({chartObstacles:a,lineObstacles:e.lineObstacles||[],obstacleMetrics:e.chartObstacleMetrics,hardBounds:{xMin:0,xMax:n.plotWidth,yMin:0,yMax:n.plotHeight},obstacleOptions:{margin:t.algorithmMargin},startDirectionX:e.getAlgorithmStartDirection(t.startMarker)},t)))}render(){let t=this.fromPoint,e=t.series,i=e.chart,o=i.pathfinder,a={},c=r(i.options.connectors,e.options.connectors,t.options.connectors,this.options);!i.styledMode&&(a.stroke=c.lineColor||t.color,a["stroke-width"]=c.lineWidth,c.dashStyle&&(a.dashstyle=c.dashStyle)),a.class="highcharts-point-connecting-path highcharts-color-"+t.colorIndex,n((c=r(a,c)).marker.radius)||(c.marker.radius=h(s(Math.ceil((c.algorithmMargin||8)/2)-1,1),5));let l=this.getPath(c),x=l.path;l.obstacles&&(o.lineObstacles=o.lineObstacles||[],o.lineObstacles=o.lineObstacles.concat(l.obstacles)),this.renderPath(x,a),this.addMarker("start",r(c.marker,c.startMarker),x),this.addMarker("end",r(c.marker,c.endMarker),x)}destroy(){this.graphics&&(o(this.graphics,function(t){t.destroy()}),delete this.graphics)}}}),n(e,"Series/PathUtilities.js",[],function(){function t(t,e){let n=[];for(let i=0;i<t.length;i++){let r=t[i][1],o=t[i][2];if("number"==typeof r&&"number"==typeof o){if(0===i)n.push(["M",r,o]);else if(i===t.length-1)n.push(["L",r,o]);else if(e){let a=t[i-1],s=t[i+1];if(a&&s){let t=a[1],i=a[2],h=s[1],c=s[2];if("number"==typeof t&&"number"==typeof h&&"number"==typeof i&&"number"==typeof c&&t!==h&&i!==c){let a=t<h?1:-1,s=i<c?1:-1;n.push(["L",r-a*Math.min(Math.abs(r-t),e),o-s*Math.min(Math.abs(o-i),e)],["C",r,o,r,o,r+a*Math.min(Math.abs(r-h),e),o+s*Math.min(Math.abs(o-c),e)])}}}else n.push(["L",r,o])}}return n}return{applyRadius:t,getLinkPath:{default:function(e){let{x1:n,y1:i,x2:r,y2:o,width:a=0,inverted:s=!1,radius:h,parentVisible:c}=e,l=[["M",n,i],["L",n,i],["C",n,i,n,o,n,o],["L",n,o],["C",n,i,n,o,n,o],["L",n,o]];return c?t([["M",n,i],["L",n+a*(s?-.5:.5),i],["L",n+a*(s?-.5:.5),o],["L",r,o]],h):l},straight:function(t){let{x1:e,y1:n,x2:i,y2:r,width:o=0,inverted:a=!1,parentVisible:s}=t;return s?[["M",e,n],["L",e+o*(a?-1:1),r],["L",i,r]]:[["M",e,n],["L",e,r],["L",e,r]]},curved:function(t){let{x1:e,y1:n,x2:i,y2:r,offset:o=0,width:a=0,inverted:s=!1,parentVisible:h}=t;return h?[["M",e,n],["C",e+o,n,e-o+a*(s?-1:1),r,e+a*(s?-1:1),r],["L",i,r]]:[["M",e,n],["C",e,n,e,r,e,r],["L",i,r]]}}}}),n(e,"Gantt/PathfinderAlgorithms.js",[e["Series/PathUtilities.js"],e["Core/Utilities.js"]],function(t,e){let{pick:n}=e,{min:i,max:r,abs:o}=Math;function a(t,e,n){let i=e-1e-7,r=n||0,o=t.length-1,a,s;for(;r<=o;)if((s=i-t[a=o+r>>1].xMin)>0)r=a+1;else{if(!(s<0))return a;o=a-1}return r>0?r-1:0}function s(t,e){let n=a(t,e.x+1)+1;for(;n--;){var i;if(t[n].xMax>=e.x&&(i=t[n],e.x<=i.xMax&&e.x>=i.xMin&&e.y<=i.yMax&&e.y>=i.yMin))return n}return -1}function h(t){let e=[];if(t.length){e.push(["M",t[0].start.x,t[0].start.y]);for(let n=0;n<t.length;++n)e.push(["L",t[n].end.x,t[n].end.y])}return e}function c(t,e){t.yMin=r(t.yMin,e.yMin),t.yMax=i(t.yMax,e.yMax),t.xMin=r(t.xMin,e.xMin),t.xMax=i(t.xMax,e.xMax)}let l=function(e,i,r){let a=[],c=r.chartObstacles,l=s(c,e),x=s(c,i),M,d=n(r.startDirectionX,o(i.x-e.x)>o(i.y-e.y))?"x":"y",y,f,u,p;function g(t,e,n,i,r){let o={x:t.x,y:t.y};return o[e]=n[i||e]+(r||0),o}function m(t,e,n){let i=o(e[n]-t[n+"Min"])>o(e[n]-t[n+"Max"]);return g(e,n,t,n+(i?"Max":"Min"),i?1:-1)}x>-1?(M={start:f=m(c[x],i,d),end:i},p=f):p=i,l>-1&&(f=m(y=c[l],e,d),a.push({start:e,end:f}),f[d]>=e[d]==f[d]>=p[d]&&(u=e[d="y"===d?"x":"y"]<i[d],a.push({start:f,end:g(f,d,y,d+(u?"Max":"Min"),u?1:-1)}),d="y"===d?"x":"y"));let b=a.length?a[a.length-1].end:e;f=g(b,d,p),a.push({start:b,end:f}),d="y"===d?"x":"y";let P=g(f,d,p);a.push({start:f,end:P}),a.push(M);let C=t.applyRadius(h(a),r.radius);return{path:C,obstacles:a}};function x(t,e,l){let x=n(l.startDirectionX,o(e.x-t.x)>o(e.y-t.y)),M=x?"x":"y",d=[],y=l.obstacleMetrics,f=i(t.x,e.x)-y.maxWidth-10,u=r(t.x,e.x)+y.maxWidth+10,p=i(t.y,e.y)-y.maxHeight-10,g=r(t.y,e.y)+y.maxHeight+10,m,b,P,C=!1,v=l.chartObstacles,j=a(v,u),k=a(v,f);function w(t,e,n){let r,o,s,h;let c=t.x<e.x?1:-1;t.x<e.x?(r=t,o=e):(r=e,o=t),t.y<e.y?(h=t,s=e):(h=e,s=t);let l=c<0?i(a(v,o.x),v.length-1):0;for(;v[l]&&(c>0&&v[l].xMin<=o.x||c<0&&v[l].xMax>=r.x);){if(v[l].xMin<=o.x&&v[l].xMax>=r.x&&v[l].yMin<=s.y&&v[l].yMax>=h.y){if(n)return{y:t.y,x:t.x<e.x?v[l].xMin-1:v[l].xMax+1,obstacle:v[l]};return{x:t.x,y:t.y<e.y?v[l].yMin-1:v[l].yMax+1,obstacle:v[l]}}l+=c}return e}function O(t,e,n,i,r){let a=r.soft,s=r.hard,h=i?"x":"y",c={x:e.x,y:e.y},l={x:e.x,y:e.y},x=t[h+"Max"]>=a[h+"Max"],M=t[h+"Min"]<=a[h+"Min"],d=t[h+"Max"]>=s[h+"Max"],y=t[h+"Min"]<=s[h+"Min"],f=o(t[h+"Min"]-e[h]),u=o(t[h+"Max"]-e[h]),p=10>o(f-u)?e[h]<n[h]:u<f;l[h]=t[h+"Min"],c[h]=t[h+"Max"];let g=w(e,l,i)[h]!==l[h],m=w(e,c,i)[h]!==c[h];return p=g?!m||p:!m&&p,p=M?!x||p:!x&&p,p=y?!d||p:!d&&p}for((j=s(v=v.slice(k,j+1),e))>-1&&(P=function(t,e,n){let r=i(t.xMax-e.x,e.x-t.xMin)<i(t.yMax-e.y,e.y-t.yMin),o={soft:l.hardBounds,hard:l.hardBounds},a=O(t,e,n,r,o);return r?{y:e.y,x:t[a?"xMax":"xMin"]+(a?1:-1)}:{x:e.x,y:t[a?"yMax":"yMin"]+(a?1:-1)}}(v[j],e,t),d.push({end:e,start:P}),e=P);(j=s(v,e))>-1;)b=e[M]-t[M]<0,(P={x:e.x,y:e.y})[M]=v[j][b?M+"Max":M+"Min"]+(b?1:-1),d.push({end:e,start:P}),e=P;return{path:h(m=(m=function t(e,n,o){let a,h,x,M,d,y,m;if(e.x===n.x&&e.y===n.y)return[];let b=o?"x":"y",P=l.obstacleOptions.margin,j={soft:{xMin:f,xMax:u,yMin:p,yMax:g},hard:l.hardBounds};return(d=s(v,e))>-1?(M=O(d=v[d],e,n,o,j),c(d,l.hardBounds),m=o?{y:e.y,x:d[M?"xMax":"xMin"]+(M?1:-1)}:{x:e.x,y:d[M?"yMax":"yMin"]+(M?1:-1)},(y=s(v,m))>-1&&(c(y=v[y],l.hardBounds),m[b]=M?r(d[b+"Max"]-P+1,(y[b+"Min"]+d[b+"Max"])/2):i(d[b+"Min"]+P-1,(y[b+"Max"]+d[b+"Min"])/2),e.x===m.x&&e.y===m.y?(C&&(m[b]=M?r(d[b+"Max"],y[b+"Max"])+1:i(d[b+"Min"],y[b+"Min"])-1),C=!C):C=!1),h=[{start:e,end:m}]):(a=w(e,{x:o?n.x:e.x,y:o?e.y:n.y},o),h=[{start:e,end:{x:a.x,y:a.y}}],a[o?"x":"y"]!==n[o?"x":"y"]&&(M=O(a.obstacle,a,n,!o,j),c(a.obstacle,l.hardBounds),x={x:o?a.x:a.obstacle[M?"xMax":"xMin"]+(M?1:-1),y:o?a.obstacle[M?"yMax":"yMin"]+(M?1:-1):a.y},o=!o,h=h.concat(t({x:a.x,y:a.y},x,o)))),h=h.concat(t(h[h.length-1].end,n,!o))}(t,e,x)).concat(d.reverse())),obstacles:m}}return l.requiresObstacles=!0,x.requiresObstacles=!0,{fastAvoid:x,straight:function(t,e){return{path:[["M",t.x,t.y],["L",e.x,e.y]],obstacles:[{start:t,end:e}]}},simpleConnect:l}}),n(e,"Gantt/ConnectorsDefaults.js",[],function(){return{connectors:{type:"straight",radius:0,lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}}}),n(e,"Gantt/PathfinderComposition.js",[e["Gantt/ConnectorsDefaults.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,n,i){var r;let{setOptions:o}=e,{composed:a}=n,{defined:s,error:h,merge:c,pushUnique:l}=i;function x(t){let e=t.shapeArgs;if(e)return{xMin:e.x||0,xMax:(e.x||0)+(e.width||0),yMin:e.y||0,yMax:(e.y||0)+(e.height||0)};let n=t.graphic&&t.graphic.getBBox();return n?{xMin:t.plotX-n.width/2,xMax:t.plotX+n.width/2,yMin:t.plotY-n.height/2,yMax:t.plotY+n.height/2}:null}return function(e){function n(t){let e,n;let i=x(this);switch(t.align){case"right":e="xMax";break;case"left":e="xMin"}switch(t.verticalAlign){case"top":n="yMin";break;case"bottom":n="yMax"}return{x:e?i[e]:(i.xMin+i.xMax)/2,y:n?i[n]:(i.yMin+i.yMax)/2}}function i(t,e){let n;return!s(e)&&(n=x(this))&&(e={x:(n.xMin+n.xMax)/2,y:(n.yMin+n.yMax)/2}),Math.atan2(e.y-t.y,t.x-e.x)}function r(t,e,n){let i=2*Math.PI,r=x(this),o=r.xMax-r.xMin,a=r.yMax-r.yMin,s=Math.atan2(a,o),h=o/2,c=a/2,l=r.xMin+h,M=r.yMin+c,d={x:l,y:M},y=t,f=1,u=!1,p=1,g=1;for(;y<-Math.PI;)y+=i;for(;y>Math.PI;)y-=i;return f=Math.tan(y),y>-s&&y<=s?(g=-1,u=!0):y>s&&y<=Math.PI-s?g=-1:y>Math.PI-s||y<=-(Math.PI-s)?(p=-1,u=!0):p=-1,u?(d.x+=p*h,d.y+=g*h*f):(d.x+=p*(a/(2*f)),d.y+=g*c),n.x!==l&&(d.x=n.x),n.y!==M&&(d.y=n.y),{x:d.x+e*Math.cos(y),y:d.y-e*Math.sin(y)}}e.compose=function e(s,x,M){if(l(a,e)){let e=M.prototype;s.prototype.callbacks.push(function(t){let e=t.options;!1!==e.connectors.enabled&&((t.options.pathfinder||t.series.reduce(function(t,e){return e.options&&c(!0,e.options.connectors=e.options.connectors||{},e.options.pathfinder),t||e.options&&e.options.pathfinder},!1))&&(c(!0,t.options.connectors=t.options.connectors||{},t.options.pathfinder),h('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')),this.pathfinder=new x(this),this.pathfinder.update(!0))}),e.getMarkerVector=r,e.getPathfinderAnchorPoint=n,e.getRadiansToVector=i,o(t)}}}(r||(r={})),r}),n(e,"Gantt/Pathfinder.js",[e["Gantt/Connection.js"],e["Gantt/PathfinderAlgorithms.js"],e["Gantt/PathfinderComposition.js"],e["Core/Series/Point.js"],e["Core/Utilities.js"]],function(t,e,n,i,r){let{addEvent:o,defined:a,pick:s,splat:h}=r,c=Math.max,l=Math.min;class x{static compose(t,e){n.compose(t,x,e)}constructor(t){this.init(t)}init(t){this.chart=t,this.connections=[],o(t,"redraw",function(){this.pathfinder.update()})}update(e){let n=this.chart,r=this,o=r.connections;r.connections=[],n.series.forEach(function(e){e.visible&&!e.options.isInternal&&e.points.forEach(function(e){let o;let a=e.options;a&&a.dependency&&(a.connect=a.dependency);let s=e.options?.connect&&h(e.options.connect);e.visible&&!1!==e.isInside&&s&&s.forEach(function(a){(o=n.get("string"==typeof a?a:a.to))instanceof i&&o.series.visible&&o.visible&&!1!==o.isInside&&r.connections.push(new t(e,o,"string"==typeof a?{}:a))})})});for(let t=0,e,n,i=o.length,a=r.connections.length;t<i;++t){n=!1;let i=o[t];for(e=0;e<a;++e){let t=r.connections[e];if((i.options&&i.options.type)===(t.options&&t.options.type)&&i.fromPoint===t.fromPoint&&i.toPoint===t.toPoint){t.graphics=i.graphics,n=!0;break}}n||i.destroy()}delete this.chartObstacles,delete this.lineObstacles,r.renderConnections(e)}renderConnections(t){t?this.chart.series.forEach(function(t){let e=function(){let e=t.chart.pathfinder,n=e&&e.connections||[];n.forEach(function(e){e.fromPoint&&e.fromPoint.series===t&&e.render()}),t.pathfinderRemoveRenderEvent&&(t.pathfinderRemoveRenderEvent(),delete t.pathfinderRemoveRenderEvent)};!1===t.options.animation?e():t.pathfinderRemoveRenderEvent=o(t,"afterAnimate",e)}):this.connections.forEach(function(t){t.render()})}getChartObstacles(t){let e=this.chart.series,n=s(t.algorithmMargin,0),i=[],r;for(let t=0,r=e.length;t<r;++t)if(e[t].visible&&!e[t].options.isInternal)for(let r=0,o=e[t].points.length,a,s;r<o;++r)(s=e[t].points[r]).visible&&(a=function(t){let e=t.shapeArgs;if(e)return{xMin:e.x||0,xMax:(e.x||0)+(e.width||0),yMin:e.y||0,yMax:(e.y||0)+(e.height||0)};let n=t.graphic&&t.graphic.getBBox();return n?{xMin:t.plotX-n.width/2,xMax:t.plotX+n.width/2,yMin:t.plotY-n.height/2,yMax:t.plotY+n.height/2}:null}(s))&&i.push({xMin:a.xMin-n,xMax:a.xMax+n,yMin:a.yMin-n,yMax:a.yMax+n});return i=i.sort(function(t,e){return t.xMin-e.xMin}),a(t.algorithmMargin)||(r=t.algorithmMargin=function(t){let e;let n=t.length,i=[];for(let r=0;r<n;++r)for(let o=r+1;o<n;++o)(e=function t(e,n,i){let r=s(i,10),o=e.yMax+r>n.yMin-r&&e.yMin-r<n.yMax+r,a=e.xMax+r>n.xMin-r&&e.xMin-r<n.xMax+r,h=o?e.xMin>n.xMax?e.xMin-n.xMax:n.xMin-e.xMax:1/0,c=a?e.yMin>n.yMax?e.yMin-n.yMax:n.yMin-e.yMax:1/0;return a&&o?r?t(e,n,Math.floor(r/2)):1/0:l(h,c)}(t[r],t[o]))<80&&i.push(e);return i.push(80),c(Math.floor(i.sort(function(t,e){return t-e})[Math.floor(i.length/10)]/2-1),1)}(i),i.forEach(function(t){t.xMin-=r,t.xMax+=r,t.yMin-=r,t.yMax+=r})),i}getObstacleMetrics(t){let e=0,n=0,i,r,o=t.length;for(;o--;)i=t[o].xMax-t[o].xMin,r=t[o].yMax-t[o].yMin,e<i&&(e=i),n<r&&(n=r);return{maxHeight:n,maxWidth:e}}getAlgorithmStartDirection(t){let e="left"!==t.align&&"right"!==t.align,n="top"!==t.verticalAlign&&"bottom"!==t.verticalAlign;return e?!!n&&void 0:!!n||void 0}}return x.prototype.algorithms=e,x}),n(e,"Extensions/ArrowSymbols.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){let{composed:n}=t,{pushUnique:i}=e;function r(t,e,n,i){return[["M",t,e+i/2],["L",t+n,e],["L",t,e+i/2],["L",t+n,e+i]]}function o(t,e,n,i){return r(t,e,n/2,i)}function a(t,e,n,i){return[["M",t+n,e],["L",t,e+i/2],["L",t+n,e+i],["Z"]]}function s(t,e,n,i){return a(t,e,n/2,i)}return{compose:function t(e){if(i(n,t)){let t=e.prototype.symbols;t.arrow=r,t["arrow-filled"]=a,t["arrow-filled-half"]=s,t["arrow-half"]=o,t["triangle-left"]=a,t["triangle-left-half"]=s}}}}),n(e,"masters/modules/pathfinder.src.js",[e["Core/Globals.js"],e["Gantt/Pathfinder.js"],e["Extensions/ArrowSymbols.js"]],function(t,e,n){t.Pathfinder=e,n.compose(t.SVGRenderer),e.compose(t.Chart,t.Point)})});