/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Module for adding patterns and images as point fills.
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Torstein Hønsi, Øystein Moseng
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pattern-fill",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function r(t,e,r,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,r),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}r(e,"Extensions/PatternFill.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,r,i){let{animObject:a}=t,{getOptions:o}=e,{composed:n}=r,{addEvent:s,defined:h,erase:l,extend:p,merge:c,pick:d,pushUnique:f,removeEvent:u,wrap:g}=i,m=function(){let t=[],e=o().colors,r=0;for(let i of["M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5","M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5","M 2 0 L 2 5 M 4 0 L 4 5","M 0 2 L 5 2 M 0 4 L 5 4","M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5"])t.push({path:i,color:e[r++],width:5,height:5,patternTransform:"scale(1.4 1.4)"});for(let i of(r=5,["M 0 0 L 5 10 L 10 0","M 3 3 L 8 3 L 8 8 L 3 8 Z","M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0","M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11","M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9"]))t.push({path:i,color:e[r],width:10,height:10}),r+=5;return t}();function y(t,e){let r=JSON.stringify(t),i=r.length||0,a=0,o=0,n;if(e){n=Math.max(Math.floor(i/500),1);for(let t=0;t<i;t+=n)a+=r.charCodeAt(t);a&=a}for(;o<i;++o)a=(a<<5)-a+r.charCodeAt(o),a&=a;return a.toString(16).replace("-","1")}function x(){if(this.renderer&&(this.renderer.defIds||[]).filter(t=>t&&t.indexOf&&0===t.indexOf("highcharts-pattern-")).length){for(let t of this.series)if(t.visible)for(let e of t.points){let t=e.options&&e.options.color;t&&t.pattern&&(t.pattern._width="defer",t.pattern._height="defer")}this.redraw(!1)}}function w(){let t={},e=this.renderer,r=(e.defIds||[]).filter(t=>t.indexOf&&0===t.indexOf("highcharts-pattern-"));if(r.length)for(let i of([].forEach.call(this.renderTo.querySelectorAll('[color^="url("], [fill^="url("], [stroke^="url("]'),r=>{let i=r.getAttribute("fill")||r.getAttribute("color")||r.getAttribute("stroke");if(i){let r=i.replace(e.url,"").replace("url(#","").replace(")","");t[r]=!0}}),r))!t[i]&&(l(e.defIds,i),e.patternElements[i]&&(e.patternElements[i].destroy(),delete e.patternElements[i]))}function M(){let t=this.options.color;t&&t.pattern&&("string"==typeof t.pattern.path&&(t.pattern.path={d:t.pattern.path}),this.color=this.options.color=c(this.series.options.color,t))}function L(t){let e=t.args[0],r=t.args[1],i=t.args[2],a=this.chartIndex||0,o=e.pattern,n="#333333";if(void 0!==e.patternIndex&&m&&(o=m[e.patternIndex]),!o)return!0;if(o.image||"string"==typeof o.path||o.path&&o.path.d){let t=i.parentNode&&i.parentNode.getAttribute("class");t=t&&t.indexOf("highcharts-legend")>-1,("defer"===o._width||"defer"===o._height)&&_.call({graphic:{element:i}},o),(t||!o.id)&&((o=c({},o)).id="highcharts-pattern-"+a+"-"+y(o)+y(o,!0)),this.addPattern(o,!this.forExport&&d(o.animation,this.globalAnimation,{duration:100})),n=`url(${this.url}#${o.id+(this.forExport?"-export":"")})`}else n=o.color||n;return i.setAttribute(r,n),e.toString=function(){return n},!1}function b(){let t=this.chart.isResizing;if(this.isDirtyData||t||!this.chart.hasRendered)for(let e of this.points){let r=e.options&&e.options.color;r&&r.pattern&&(t&&!(e.shapeArgs&&e.shapeArgs.width&&e.shapeArgs.height)?(r.pattern._width="defer",r.pattern._height="defer"):e.calculatePatternDimensions(r.pattern))}}function _(t){if(t.width&&t.height)return;let e=this.graphic&&(this.graphic.getBBox&&this.graphic.getBBox(!0)||this.graphic.element&&this.graphic.element.getBBox())||{},r=this.shapeArgs;if(r&&(e.width=r.width||e.width,e.height=r.height||e.height,e.x=r.x||e.x,e.y=r.y||e.y),t.image){if(!e.width||!e.height){t._width="defer",t._height="defer";let e=this.series.chart.mapView&&this.series.chart.mapView.getSVGTransform().scaleY;h(e)&&e<0&&(t._inverted=!0);return}t.aspectRatio&&(e.aspectRatio=e.width/e.height,t.aspectRatio>e.aspectRatio?e.aspectWidth=e.height*t.aspectRatio:e.aspectHeight=e.width/t.aspectRatio),t._width=t.width||Math.ceil(e.aspectWidth||e.width),t._height=t.height||Math.ceil(e.aspectHeight||e.height)}t.width||(t._x=t.x||0,t._x+=e.x-Math.round(e.aspectWidth?Math.abs(e.aspectWidth-e.width)/2:0)),t.height||(t._y=t.y||0,t._y+=e.y-Math.round(e.aspectHeight?Math.abs(e.aspectHeight-e.height)/2:0))}function A(t,e){let r=d(e,!0),o=a(r),n=t.color||"#333333",s=t.height||("number"==typeof t._height?t._height:0)||32,h=t.width||("number"==typeof t._width?t._width:0)||32,l,p=t.id,c;if(!p&&(this.idCounter=this.idCounter||0,p="highcharts-pattern-"+this.idCounter+"-"+(this.chartIndex||0),++this.idCounter),this.forExport&&(p+="-export"),this.defIds=this.defIds||[],this.defIds.indexOf(p)>-1)return;this.defIds.push(p);let f={id:p,patternUnits:"userSpaceOnUse",patternContentUnits:t.patternContentUnits||"userSpaceOnUse",width:h,height:s,x:t._x||t.x||0,y:t._y||t.y||0};t._inverted&&(f.patternTransform="scale(1, -1)",t.patternTransform&&(t.patternTransform+=" scale(1, -1)")),t.patternTransform&&(f.patternTransform=t.patternTransform);let g=this.createElement("pattern").attr(f).add(this.defs);if(g.id=p,t.path){if(c=i.isObject(t.path)?t.path:{d:t.path},t.backgroundColor){var m;m=t.backgroundColor,this.rect(0,0,h,s).attr({fill:m}).add(g)}l={d:c.d},this.styledMode||(l.stroke=c.stroke||n,l["stroke-width"]=d(c.strokeWidth,2),l.fill=c.fill||"none"),c.transform&&(l.transform=c.transform),this.createElement("path").attr(l).add(g),g.color=n}else t.image&&(r?this.image(t.image,0,0,h,s,function(){this.animate({opacity:d(t.opacity,1)},o),u(this.element,"load")}).attr({opacity:0}).add(g):this.image(t.image,0,0,h,s).add(g));return t.image&&r||void 0===t.opacity||[].forEach.call(g.element.childNodes,e=>{e.setAttribute("opacity",t.opacity)}),this.patternElements=this.patternElements||{},this.patternElements[p]=g,g}function C(t){let e=this.options.color;e&&e.pattern&&!e.pattern.color?(delete this.options.color,t.apply(this,[].slice.call(arguments,1)),e.pattern.color=this.color,this.color=this.options.color=e):t.apply(this,[].slice.call(arguments,1))}function E(){if(!this.chart?.mapView)return;let t=this.chart,e=t.renderer,r=e.patternElements;e.defIds?.length&&r&&this.points.filter(function(t){return!!t.graphic&&(t.graphic.element.hasAttribute("fill")||t.graphic.element.hasAttribute("color")||t.graphic.element.hasAttribute("stroke"))&&!t.options.color?.pattern?.image&&!!t.group?.scaleX&&!!t.group?.scaleY}).map(function(t){let r=(t.graphic?.element.getAttribute("fill")||t.graphic?.element.getAttribute("color")||t.graphic?.element.getAttribute("stroke")||"").replace(e.url,"").replace("url(#","").replace(")","");return[r,{x:t.group?.scaleX||1,y:t.group?.scaleY||1}]}).filter(function([t,e],r,i){return""!==t&&-1!==t.indexOf("highcharts-pattern-")&&!i.some(function([e,i],a){return e===t&&a<r})}).forEach(function([t,e]){r[t].scaleX=1/e.x,r[t].scaleY=1/e.y,r[t].updateTransform("patternTransform")})}return{compose:function t(e,r,i){let a=r.prototype.pointClass;f(n,t)&&(s(e,"endResize",x),s(e,"redraw",w),p(a.prototype,{calculatePatternDimensions:_}),s(a,"afterInit",M),s(r,"render",b),g(r.prototype,"getColor",C),s(r,"afterRender",E),s(r,"mapZoomComplete",E),p(i.prototype,{addPattern:A}),s(i,"complexColor",L))},patterns:m}}),r(e,"masters/modules/pattern-fill.src.js",[e["Core/Globals.js"],e["Extensions/PatternFill.js"]],function(t,e){t.patterns=e.patterns,e.compose(t.Chart,t.Series,t.SVGRenderer)})});