/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * Pictorial graph series type for Highcharts
 *
 * (c) 2010-2024 Torstein Honsi, Magdalena Gut
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pictorial",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,r){t.hasOwnProperty(e)||(t[e]=r.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/PatternFill.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,r){let{animObject:s}=t,{getOptions:a}=e,{composed:o}=i,{addEvent:n,defined:h,erase:l,extend:p,merge:d,pick:c,pushUnique:f,removeEvent:u,wrap:g}=r,m=function(){let t=[],e=a().colors,i=0;for(let r of["M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5","M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5","M 2 0 L 2 5 M 4 0 L 4 5","M 0 2 L 5 2 M 0 4 L 5 4","M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5"])t.push({path:r,color:e[i++],width:5,height:5,patternTransform:"scale(1.4 1.4)"});for(let r of(i=5,["M 0 0 L 5 10 L 10 0","M 3 3 L 8 3 L 8 8 L 3 8 Z","M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0","M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11","M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9"]))t.push({path:r,color:e[i],width:10,height:10}),i+=5;return t}();function x(t,e){let i=JSON.stringify(t),r=i.length||0,s=0,a=0,o;if(e){o=Math.max(Math.floor(r/500),1);for(let t=0;t<r;t+=o)s+=i.charCodeAt(t);s&=s}for(;a<r;++a)s=(s<<5)-s+i.charCodeAt(a),s&=s;return s.toString(16).replace("-","1")}function w(){if(this.renderer&&(this.renderer.defIds||[]).filter(t=>t&&t.indexOf&&0===t.indexOf("highcharts-pattern-")).length){for(let t of this.series)if(t.visible)for(let e of t.points){let t=e.options&&e.options.color;t&&t.pattern&&(t.pattern._width="defer",t.pattern._height="defer")}this.redraw(!1)}}function y(){let t={},e=this.renderer,i=(e.defIds||[]).filter(t=>t.indexOf&&0===t.indexOf("highcharts-pattern-"));if(i.length)for(let r of([].forEach.call(this.renderTo.querySelectorAll('[color^="url("], [fill^="url("], [stroke^="url("]'),i=>{let r=i.getAttribute("fill")||i.getAttribute("color")||i.getAttribute("stroke");if(r){let i=r.replace(e.url,"").replace("url(#","").replace(")","");t[i]=!0}}),i))!t[r]&&(l(e.defIds,r),e.patternElements[r]&&(e.patternElements[r].destroy(),delete e.patternElements[r]))}function C(){let t=this.options.color;t&&t.pattern&&("string"==typeof t.pattern.path&&(t.pattern.path={d:t.pattern.path}),this.color=this.options.color=d(this.series.options.color,t))}function A(t){let e=t.args[0],i=t.args[1],r=t.args[2],s=this.chartIndex||0,a=e.pattern,o="#333333";if(void 0!==e.patternIndex&&m&&(a=m[e.patternIndex]),!a)return!0;if(a.image||"string"==typeof a.path||a.path&&a.path.d){let t=r.parentNode&&r.parentNode.getAttribute("class");t=t&&t.indexOf("highcharts-legend")>-1,("defer"===a._width||"defer"===a._height)&&M.call({graphic:{element:r}},a),(t||!a.id)&&((a=d({},a)).id="highcharts-pattern-"+s+"-"+x(a)+x(a,!0)),this.addPattern(a,!this.forExport&&c(a.animation,this.globalAnimation,{duration:100})),o=`url(${this.url}#${a.id+(this.forExport?"-export":"")})`}else o=a.color||o;return r.setAttribute(i,o),e.toString=function(){return o},!1}function b(){let t=this.chart.isResizing;if(this.isDirtyData||t||!this.chart.hasRendered)for(let e of this.points){let i=e.options&&e.options.color;i&&i.pattern&&(t&&!(e.shapeArgs&&e.shapeArgs.width&&e.shapeArgs.height)?(i.pattern._width="defer",i.pattern._height="defer"):e.calculatePatternDimensions(i.pattern))}}function M(t){if(t.width&&t.height)return;let e=this.graphic&&(this.graphic.getBBox&&this.graphic.getBBox(!0)||this.graphic.element&&this.graphic.element.getBBox())||{},i=this.shapeArgs;if(i&&(e.width=i.width||e.width,e.height=i.height||e.height,e.x=i.x||e.x,e.y=i.y||e.y),t.image){if(!e.width||!e.height){t._width="defer",t._height="defer";let e=this.series.chart.mapView&&this.series.chart.mapView.getSVGTransform().scaleY;h(e)&&e<0&&(t._inverted=!0);return}t.aspectRatio&&(e.aspectRatio=e.width/e.height,t.aspectRatio>e.aspectRatio?e.aspectWidth=e.height*t.aspectRatio:e.aspectHeight=e.width/t.aspectRatio),t._width=t.width||Math.ceil(e.aspectWidth||e.width),t._height=t.height||Math.ceil(e.aspectHeight||e.height)}t.width||(t._x=t.x||0,t._x+=e.x-Math.round(e.aspectWidth?Math.abs(e.aspectWidth-e.width)/2:0)),t.height||(t._y=t.y||0,t._y+=e.y-Math.round(e.aspectHeight?Math.abs(e.aspectHeight-e.height)/2:0))}function S(t,e){let i=c(e,!0),a=s(i),o=t.color||"#333333",n=t.height||("number"==typeof t._height?t._height:0)||32,h=t.width||("number"==typeof t._width?t._width:0)||32,l,p=t.id,d;if(!p&&(this.idCounter=this.idCounter||0,p="highcharts-pattern-"+this.idCounter+"-"+(this.chartIndex||0),++this.idCounter),this.forExport&&(p+="-export"),this.defIds=this.defIds||[],this.defIds.indexOf(p)>-1)return;this.defIds.push(p);let f={id:p,patternUnits:"userSpaceOnUse",patternContentUnits:t.patternContentUnits||"userSpaceOnUse",width:h,height:n,x:t._x||t.x||0,y:t._y||t.y||0};t._inverted&&(f.patternTransform="scale(1, -1)",t.patternTransform&&(t.patternTransform+=" scale(1, -1)")),t.patternTransform&&(f.patternTransform=t.patternTransform);let g=this.createElement("pattern").attr(f).add(this.defs);if(g.id=p,t.path){if(d=r.isObject(t.path)?t.path:{d:t.path},t.backgroundColor){var m;m=t.backgroundColor,this.rect(0,0,h,n).attr({fill:m}).add(g)}l={d:d.d},this.styledMode||(l.stroke=d.stroke||o,l["stroke-width"]=c(d.strokeWidth,2),l.fill=d.fill||"none"),d.transform&&(l.transform=d.transform),this.createElement("path").attr(l).add(g),g.color=o}else t.image&&(i?this.image(t.image,0,0,h,n,function(){this.animate({opacity:c(t.opacity,1)},a),u(this.element,"load")}).attr({opacity:0}).add(g):this.image(t.image,0,0,h,n).add(g));return t.image&&i||void 0===t.opacity||[].forEach.call(g.element.childNodes,e=>{e.setAttribute("opacity",t.opacity)}),this.patternElements=this.patternElements||{},this.patternElements[p]=g,g}function E(t){let e=this.options.color;e&&e.pattern&&!e.pattern.color?(delete this.options.color,t.apply(this,[].slice.call(arguments,1)),e.pattern.color=this.color,this.color=this.options.color=e):t.apply(this,[].slice.call(arguments,1))}function k(){if(!this.chart?.mapView)return;let t=this.chart,e=t.renderer,i=e.patternElements;e.defIds?.length&&i&&this.points.filter(function(t){return!!t.graphic&&(t.graphic.element.hasAttribute("fill")||t.graphic.element.hasAttribute("color")||t.graphic.element.hasAttribute("stroke"))&&!t.options.color?.pattern?.image&&!!t.group?.scaleX&&!!t.group?.scaleY}).map(function(t){let i=(t.graphic?.element.getAttribute("fill")||t.graphic?.element.getAttribute("color")||t.graphic?.element.getAttribute("stroke")||"").replace(e.url,"").replace("url(#","").replace(")","");return[i,{x:t.group?.scaleX||1,y:t.group?.scaleY||1}]}).filter(function([t,e],i,r){return""!==t&&-1!==t.indexOf("highcharts-pattern-")&&!r.some(function([e,r],s){return e===t&&s<i})}).forEach(function([t,e]){i[t].scaleX=1/e.x,i[t].scaleY=1/e.y,i[t].updateTransform("patternTransform")})}return{compose:function t(e,i,r){let s=i.prototype.pointClass;f(o,t)&&(n(e,"endResize",w),n(e,"redraw",y),p(s.prototype,{calculatePatternDimensions:M}),n(s,"afterInit",C),n(i,"render",b),g(i.prototype,"getColor",E),n(i,"afterRender",k),n(i,"mapZoomComplete",k),p(r.prototype,{addPattern:S}),n(r,"complexColor",A))},patterns:m}}),i(e,"Series/Pictorial/PictorialUtilities.js",[e["Core/Utilities.js"]],function(t){let{defined:e}=t;return{rescalePatternFill:function(t,e,i,r,s=1){let a=t&&t.attr("fill"),o=a&&a.match(/url\(([^)]+)\)/);if(o){let a=document.querySelector(`${o[1]} path`);if(a){let o=a.getBBox();if(0===o.width){let e=a.parentElement;t.renderer.box.appendChild(a),o=a.getBBox(),e.appendChild(a)}let n=1/(o.width+s),h=e/r/o.height,l=o.width/o.height,p=i/e,d=-o.width/2;l<p&&(n=n*l/p),a.setAttribute("stroke-width",s/(i*n)),a.setAttribute("transform",`translate(0.5, 0)scale(${n} ${h}) translate(${d+s*n/2}, ${-o.y})`)}}},invertShadowGroup:function(t,e){let i=e.chart.inverted;i&&t.attr({rotation:i?90:0,scaleX:i?-1:1})},getStackMetrics:function(t,i){let r=t.len,s=0;return i&&e(i.max)&&(s=t.toPixels(i.max,!0),r=t.len-s),{height:r,y:s}}}}),i(e,"Series/Pictorial/PictorialPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Series/Pictorial/PictorialUtilities.js"]],function(t,e){let i=t.seriesTypes.column.prototype.pointClass,{rescalePatternFill:r,getStackMetrics:s}=e;return class extends i{setState(){super.setState.apply(this,arguments);let t=this.series,e=t.options.paths;if(this.graphic&&this.shapeArgs&&e){let i=e[this.index%e.length];r(this.graphic,s(t.yAxis,i).height,this.shapeArgs.width||0,this.shapeArgs.height||1/0,this.series.options.borderWidth||0)}}}}),i(e,"Series/Pictorial/PictorialSeries.js",[e["Extensions/PatternFill.js"],e["Core/Animation/AnimationUtilities.js"],e["Core/Chart/Chart.js"],e["Series/Pictorial/PictorialPoint.js"],e["Series/Pictorial/PictorialUtilities.js"],e["Core/Series/Series.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Axis/Stacking/StackItem.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,i,r,s,a,o,n,h,l){let p=o.seriesTypes.column;t.compose(i,a,h);let{animObject:d}=e,{getStackMetrics:c,invertShadowGroup:f,rescalePatternFill:u}=s,{addEvent:g,defined:m,merge:x,objectEach:w,pick:y}=l;class C extends p{animate(t){let{chart:e,group:i}=this,r=d(this.options.animation),s=[this.getSharedClipKey(),r.duration,r.easing,r.defer].join(","),a=e.sharedClips[s];if(t&&i){let t=this.getClipBox();a||(t.y=t.height,t.height=0,a=e.renderer.clipRect(t),e.sharedClips[s]=a),i.clip(a)}else if(a&&!a.hasClass("highcharts-animating")){let t=this.getClipBox();a.addClass("highcharts-animating").animate(t,r)}}animateDrilldown(){}animateDrillupFrom(){}pointAttribs(t){let e=super.pointAttribs.apply(this,arguments),i=this.options,r=i.paths;if(t&&t.shapeArgs&&r){let i=r[t.index%r.length],{y:s,height:a}=c(this.yAxis,i),o=i.definition;o!==t.pathDef?(t.pathDef=o,e.fill={pattern:{path:{d:o,fill:e.fill,strokeWidth:e["stroke-width"],stroke:e.stroke},x:t.shapeArgs.x,y:s,width:t.shapeArgs.width||0,height:a,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#ff0000"}}):t.pathDef&&t.graphic&&delete e.fill}return delete e.stroke,delete e.strokeWidth,e}getExtremes(){let t=super.getExtremes.apply(this,arguments),e=this.options.paths;return e&&e.forEach(function(e){m(e.max)&&m(t.dataMax)&&e.max>t.dataMax&&(t.dataMax=e.max)}),t}}function A(t){let e=Object.keys(t.points).filter(t=>t.split(",").length>1),i=t.axis.chart.series,r=e.map(t=>parseFloat(t.split(",")[0])),s=-1;r.forEach(t=>{i[t]&&i[t].visible&&(s=t)});let a=t.axis.chart.series[s];if(a&&a.is("pictorial")&&t.axis.hasData()&&a.xAxis.hasData()){let e=a.xAxis,i=t.axis.options,r=t.axis.chart,s=t.shadow,o=e.toPixels(t.x,!0),n=r.inverted?e.len-o:o,h=a.options.paths||[],l=t.x%h.length,p=h[l],d=a.getColumnMetrics&&a.getColumnMetrics().width,{height:g,y:m}=c(a.yAxis,p),x=i.stackShadow,w=y(x&&x.borderWidth,a.options.borderWidth,1);if(!s&&x&&x.enabled&&p)t.shadowGroup||(t.shadowGroup=r.renderer.g("shadow-group").add()),t.shadowGroup.attr({translateX:r.inverted?t.axis.pos:e.pos,translateY:r.inverted?e.pos:t.axis.pos}),t.shadow=r.renderer.rect(n,m,d,g).attr({fill:{pattern:{path:{d:p.definition,fill:x.color||"#dedede",strokeWidth:w,stroke:x.borderColor||"transparent"},x:n,y:m,width:d,height:g,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#dedede"}}}).add(t.shadowGroup),f(t.shadowGroup,t.axis),u(t.shadow,g,d,g,w),t.setOffset(a.pointXOffset||0,a.barW||0);else if(s&&t.shadowGroup){s.animate({x:n,y:m,width:d,height:g});let i=s.attr("fill"),o=i&&i.match(/url\(([^)]+)\)/);o&&r.renderer.patternElements&&r.renderer.patternElements[o[1].slice(1)].animate({x:n,y:m,width:d,height:g}),t.shadowGroup.animate({translateX:r.inverted?t.axis.pos:e.pos,translateY:r.inverted?e.pos:t.axis.pos}),f(t.shadowGroup,t.axis),u(s,g,d,g,w),t.setOffset(a.pointXOffset||0,a.barW||0)}}else t.shadow&&t.shadowGroup&&(t.shadow.destroy(),t.shadow=void 0,t.shadowGroup.destroy(),t.shadowGroup=void 0)}function b(t,e){t.axes&&t.axes.forEach(function(t){if(!t.stacking)return;let i=t.stacking.stacks;w(i,function(t){w(t,function(t){e(t)})})})}function M(t){b(t,function(t){t.shadow&&t.shadowGroup&&(t.shadow.destroy(),t.shadowGroup.destroy(),delete t.shadow,delete t.shadowGroup)})}return C.defaultOptions=x(p.defaultOptions,{borderWidth:0}),g(C,"afterRender",function(){let t=this,e=t.options.paths,i=/url\(([^)]+)\)/;t.points.forEach(function(r){if(r.graphic&&r.shapeArgs&&e){let s=e[r.index%e.length],a=r.graphic.attr("fill"),o=a&&a.match(i),{y:n,height:h}=c(t.yAxis,s);if(o&&t.chart.renderer.patternElements){let e=t.chart.renderer.patternElements[o[1].slice(1)];e&&e.animate({x:r.shapeArgs.x,y:n,width:r.shapeArgs.width||0,height:h})}u(r.graphic,c(t.yAxis,s).height,r.shapeArgs.width||0,r.shapeArgs.height||1/0,t.options.borderWidth||0)}})}),g(i,"render",function(){b(this,A)}),g(n,"afterSetOffset",function(t){if(this.shadow){let{chart:e,len:i}=this.axis,{xOffset:r,width:s}=t,a=e.inverted?r-e.xAxis[0].len:r,o=e.inverted?-i:0;this.shadow.attr({translateX:a,translateY:o}),this.shadow.animate({width:s})}}),g(i,"afterDrilldown",function(t){M(this)}),g(i,"afterDrillUp",function(t){M(this)}),C.prototype.pointClass=r,o.registerSeriesType("pictorial",C),C}),i(e,"masters/modules/pictorial.src.js",[],function(){})});