/**
 * Highcharts JS v11.3.0 (2024-01-10)
 *
 * (c) 2009-2024
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/tiledwebmap",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function o(e,t,o,i){e.hasOwnProperty(t)||(e[t]=i.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}o(t,"Maps/TilesProviders/OpenStreetMap.js",[],function(){return class{constructor(){this.defaultCredits='Map data &copy2023 <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a>',this.initialProjectionName="WebMercator",this.subdomains=["a","b","c"],this.themes={Standard:{url:"https://tile.openstreetmap.org/{zoom}/{x}/{y}.png",minZoom:0,maxZoom:19},Hot:{url:"https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png",minZoom:0,maxZoom:19},OpenTopoMap:{url:"https://{s}.tile.opentopomap.org/{z}/{x}/{y}.png",minZoom:0,maxZoom:17,credits:`Map data: &copy; <a href="https://www.openstreetmap.org/copyright">
                        OpenStreetMap</a> contributors, <a href="https://viewfinderpanoramas.org">SRTM</a> 
                        | Map style: &copy; <a href="https://opentopomap.org">OpenTopoMap</a> 
                        (<a href="https://creativecommons.org/licenses/by-sa/3.0/">CC-BY-SA</a>)`}}}}}),o(t,"Maps/TilesProviders/Stamen.js",[],function(){return class{constructor(){this.defaultCredits='&copy; Map tiles by <a href="https://stamen.com">Stamen Design</a>, under <a href="https://creativecommons.org/licenses/by/3.0">CC BY 3.0</a>. Data by <a href="https://openstreetmap.org">OpenStreetMap</a>, under <a href="https://www.openstreetmap.org/copyright">ODbL</a>',this.initialProjectionName="WebMercator",this.subdomains=["a","b","c","d"],this.themes={Toner:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/toner/{z}/{x}/{y}.png",minZoom:0,maxZoom:20},TonerBackground:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/toner-background/{z}/{x}/{y}.png",minZoom:0,maxZoom:20},TonerLite:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/toner-lite/{z}/{x}/{y}.png",minZoom:0,maxZoom:20},Terrain:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/terrain/{z}/{x}/{y}.png",minZoom:0,maxZoom:18},TerrainBackground:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/terrain-background/{z}/{x}/{y}.png",minZoom:0,maxZoom:18},Watercolor:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/watercolor/{z}/{x}/{y}.png",minZoom:1,maxZoom:16,credits:'&copy Map tiles by <a href="https://stamen.com">Stamen Design</a>, under <a href="https://creativecommons.org/licenses/by/3.0">CC BY 3.0</a>. Data by <a href="https://openstreetmap.org">OpenStreetMap</a>, under <a href="https://creativecommons.org/licenses/by-sa/3.0">CC BY SA</a>'}}}}}),o(t,"Maps/TilesProviders/LimaLabs.js",[],function(){return class{constructor(){this.defaultCredits='Map data &copy;2023 <a href="https://maps.lima-labs.com/">LimaLabs</a>',this.initialProjectionName="WebMercator",this.requiresApiKey=!0,this.themes={Standard:{url:"https://cdn.lima-labs.com/{zoom}/{x}/{y}.png?api={apikey}",minZoom:0,maxZoom:20}}}}}),o(t,"Maps/TilesProviders/Thunderforest.js",[],function(){return class{constructor(){this.defaultCredits='Maps &copy <a href="https://www.thunderforest.com">Thunderforest</a>, Data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap contributors</a>',this.initialProjectionName="WebMercator",this.requiresApiKey=!0,this.subdomains=["a","b","c"],this.themes={OpenCycleMap:{url:"https://{s}.tile.thunderforest.com/cycle/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Transport:{url:"https://{s}.tile.thunderforest.com/transport/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},TransportDark:{url:"https://{s}.tile.thunderforest.com/transport-dark/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},SpinalMap:{url:"https://{s}.tile.thunderforest.com/spinal-map/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Landscape:{url:"https://{s}.tile.thunderforest.com/landscape/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Outdoors:{url:"https://{s}.tile.thunderforest.com/outdoors/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Pioneer:{url:"https://{s}.tile.thunderforest.com/pioneer/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},MobileAtlas:{url:"https://{s}.tile.thunderforest.com/mobile-atlas/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Neighbourhood:{url:"https://{s}.tile.thunderforest.com/neighbourhood/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22}}}}}),o(t,"Maps/TilesProviders/Esri.js",[],function(){return class{constructor(){this.defaultCredits="Tiles &copy; Esri &mdash; Source: Esri, DeLorme, NAVTEQ, USGS,  Intermap, iPC, NRCAN, Esri Japan, METI, Esri China (Hong Kong), Esri (Thailand), TomTom, 2012",this.initialProjectionName="WebMercator",this.themes={WorldStreetMap:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20},DeLorme:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/Specialty/DeLorme_World_Base_Map/MapServer/tile/{z}/{y}/{x}",minZoom:1,maxZoom:11,credits:"Tiles &copy; Esri &mdash; Copyright: &copy;2012 DeLorme"},WorldTopoMap:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20,credits:"Tiles &copy; Esri &mdash; Esri, DeLorme, NAVTEQ, TomTom, Intermap, iPC, USGS, FAO, NPS, NRCAN, GeoBase, Kadaster NL, Ordnance Survey, Esri Japan, METI, Esri China (Hong Kong), and the GIS User Community"},WorldImagery:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20,credits:"Tiles &copy; Esri &mdash; Source: Esri, i-cubed, USDA, USGS, AEX, GeoEye, Getmapping, Aerogrid, IGN, IGP, UPR-EGP, and the GIS User Community"},WorldTerrain:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Terrain_Base/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:13,credits:"Tiles &copy; Esri &mdash; Source: USGS, Esri, TANA, DeLorme, and NPS"},WorldShadedRelief:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Shaded_Relief/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:13,credits:"Tiles &copy; Esri &mdash; Source: Esri"},WorldPhysical:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Physical_Map/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:8,credits:"Tiles &copy; Esri &mdash; Source: US National Park Service"},NatGeoWorldMap:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/NatGeo_World_Map/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:16,credits:"Tiles &copy; Esri &mdash; National Geographic, Esri, DeLorme, NAVTEQ, UNEP-WCMC, USGS, NASA, ESA, METI, NRCAN, GEBCO, NOAA, iPC"},WorldGrayCanvas:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Light_Gray_Base/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:16,credits:"Tiles &copy; Esri &mdash; Esri, DeLorme, NAVTEQ"}}}}}),o(t,"Maps/TilesProviders/USGS.js",[],function(){return class{constructor(){this.defaultCredits='Tiles courtesy of the <a href="https://usgs.gov/">U.S. GeologicalSurvey</a>',this.initialProjectionName="WebMercator",this.themes={USTopo:{url:"https://basemap.nationalmap.gov/arcgis/rest/services/USGSTopo/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20},USImagery:{url:"https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryOnly/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20},USImageryTopo:{url:"https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryTopo/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20}}}}}),o(t,"Maps/TilesProviders/TilesProviderRegistry.js",[t["Maps/TilesProviders/OpenStreetMap.js"],t["Maps/TilesProviders/Stamen.js"],t["Maps/TilesProviders/LimaLabs.js"],t["Maps/TilesProviders/Thunderforest.js"],t["Maps/TilesProviders/Esri.js"],t["Maps/TilesProviders/USGS.js"]],function(e,t,o,i,r,s){return{Esri:r,LimaLabs:o,OpenStreetMap:e,Stamen:t,Thunderforest:i,USGS:s}}),o(t,"Series/TiledWebMap/TiledWebMapSeriesDefaults.js",[],function(){return{states:{inactive:{enabled:!1}}}}),o(t,"Series/TiledWebMap/TiledWebMapSeries.js",[t["Core/Globals.js"],t["Core/Series/SeriesRegistry.js"],t["Maps/TilesProviders/TilesProviderRegistry.js"],t["Series/TiledWebMap/TiledWebMapSeriesDefaults.js"],t["Core/Utilities.js"]],function(e,t,o,i,r){let{composed:s}=e,{map:a}=t.seriesTypes,{addEvent:n,defined:l,error:p,merge:m,pick:c,pushUnique:h}=r;function d(e){let t=(this.options.series||[]).filter(e=>"tiledwebmap"===e.type)[0],{geoBounds:i}=e;if(t&&t.provider&&t.provider.type&&!t.provider.url){let e=o[t.provider.type];if(l(e)){let t=new e,{initialProjectionName:o}=t;if(this.options.mapView){if(i){let{x1:e,y1:t,x2:r,y2:s}=i;this.options.mapView.recommendedMapView={projection:{name:o,parallels:[t,s],rotation:[-(e+r)/2]}}}else this.options.mapView.recommendedMapView={projection:{name:o},minZoom:0}}return!1}p("Highcharts warning: Tiles Provider not defined in the Provider Registry.",!1)}return!0}class u extends a{constructor(){super(...arguments),this.redrawTiles=!1,this.isAnimating=!1}static compose(e){h(s,this.compose)&&n(e,"beforeMapViewInit",d)}lonLatToTile(e,t){let{lon:o,lat:i}=e;return{x:Math.floor((o+180)/360*Math.pow(2,t)),y:Math.floor((1-Math.log(Math.tan(i*Math.PI/180)+1/Math.cos(i*Math.PI/180))/Math.PI)/2*Math.pow(2,t))}}tileToLonLat(e,t,o){let i=Math.PI-2*Math.PI*t/Math.pow(2,o);return{lon:e/Math.pow(2,o)*360-180,lat:180/Math.PI*Math.atan(.5*(Math.exp(i)-Math.exp(-i)))}}drawPoints(){let e=this.chart,t=e.mapView;if(!t)return;let i=this.tiles=this.tiles||{},r=this.transformGroups=this.transformGroups||[],s=this,a=this.options,n=a.provider,{zoom:m}=t,h=c(t.projection.options.rotation&&t.projection.options.rotation[0],0),d=e.renderer.forExport?0:200,u=e=>{for(let o of Object.keys(i))parseFloat(o)===(t.zoom<0?0:Math.floor(t.zoom))||s.minZoom&&(t.zoom<0?0:Math.floor(t.zoom))<s.minZoom&&parseFloat(o)===s.minZoom||s.maxZoom&&(t.zoom<0?0:Math.floor(t.zoom))>s.maxZoom&&parseFloat(o)===s.maxZoom?Object.keys(i[o].tiles).forEach((t,r)=>{i[o].tiles[t].animate({opacity:1},{duration:e},()=>{r===Object.keys(i[o].tiles).length-1&&(i[o].isActive=!0)})}):Object.keys(i[o].tiles).forEach((t,r)=>{i[o].tiles[t].animate({opacity:0},{duration:e,defer:e/2},()=>{i[o].tiles[t].destroy(),delete i[o].tiles[t],r===Object.keys(i[o].tiles).length-1&&(i[o].isActive=!1,i[o].loaded=!1)})})},y=m<0?0:Math.floor(m),f=Math.pow(2,y),g=.638436911716859*Math.pow(2,m)/(.638436911716859*Math.pow(2,y)),M=256*g;if(n&&(n.type||n.url)){if(n.type&&!n.url){let i=o[n.type];if(!l(i)){p("Highcharts warning: Tiles Provider '"+n.type+"' not defined in the ProviderRegistry.",!1);return}let r=new i,s=r.initialProjectionName,a,m="";if(n.theme&&l(r.themes[n.theme]))a=r.themes[n.theme];else{let e=Object.keys(r.themes)[0];a=r.themes[e],p("Highcharts warning: The Tiles Provider's Theme '"+n.theme+"' is not defined in the Provider definition - falling back to '"+e+"'.",!1)}n.subdomain&&r.subdomains&&-1!==r.subdomains.indexOf(n.subdomain)?m=n.subdomain:l(r.subdomains)&&-1!==a.url.indexOf("{s}")&&(m=c(r.subdomains&&r.subdomains[0],""),p("Highcharts warning: The Tiles Provider's Subdomain '"+n.subdomain+"' is not defined in the Provider definition - falling back to '"+m+"'.",!1)),r.requiresApiKey&&(n.apiKey?a.url=a.url.replace("{apikey}",n.apiKey):(p("Highcharts warning: The Tiles Provider requires API Key to use tiles, use provider.apiKey to provide a token.",!1),a.url=a.url.replace("?apikey={apikey}",""))),n.url=a.url.replace("{s}",m),this.minZoom=a.minZoom,this.maxZoom=a.maxZoom;let h=c(e.userOptions.credits&&e.userOptions.credits.text,"Highcharts.com "+c(a.credits,r.defaultCredits));e.credits?e.credits.update({text:h}):e.addCredits({text:h,style:c(e.options.credits?.style,{})}),t.projection.options.name!==s&&p("Highcharts warning: The set projection is different than supported by Tiles Provider.",!1)}else t.projection.options.name||p("Highcharts warning: The set projection is different than supported by Tiles Provider.",!1);if(l(this.minZoom)&&y<this.minZoom?(f=Math.pow(2,y=this.minZoom),M=256*(g=.638436911716859*Math.pow(2,m)/(.638436911716859*Math.pow(2,y)))):l(this.maxZoom)&&y>this.maxZoom&&(f=Math.pow(2,y=this.maxZoom),M=256*(g=.638436911716859*Math.pow(2,m)/(.638436911716859*Math.pow(2,y)))),t.projection&&t.projection.def){t.projection.hasCoordinates=!0,r[y]||(r[y]=e.renderer.g().add(this.group));let o=(e,t,o,i)=>e.replace("{x}",t.toString()).replace("{y}",o.toString()).replace("{zoom}",i.toString()).replace("{z}",i.toString()),a=(a,l,p,m,c)=>{let h=a%f,y=l%f,g=h<0?h+f:h,T=y<0?y+f:y;if(!i[`${p}`].tiles[`${a},${l}`]&&n.url){let h=o(n.url,g,T,p);i[p].loaded=!1,i[`${p}`].tiles[`${a},${l}`]=e.renderer.image(h,a*M-m,l*M-c,M,M).attr({zIndex:2,opacity:0}).on("load",function(){n.onload&&n.onload.apply(this),(p===(t.zoom<0?0:Math.floor(t.zoom))||p===s.minZoom)&&(i[`${p}`].actualTilesCount++,i[`${p}`].howManyTiles===i[`${p}`].actualTilesCount&&(i[p].loaded=!0,s.isAnimating?s.redrawTiles=!0:(s.redrawTiles=!1,u(d)),i[`${p}`].actualTilesCount=0))}).add(r[p]),i[`${p}`].tiles[`${a},${l}`].posX=a,i[`${p}`].tiles[`${a},${l}`].posY=l,i[`${p}`].tiles[`${a},${l}`].originalURL=h}},l=t.pixelsToProjectedUnits({x:0,y:0}),p=t.projection.def.inverse([l.x,l.y]),m={lon:p[0]-h,lat:p[1]},c=t.pixelsToProjectedUnits({x:e.plotWidth,y:e.plotHeight}),g=t.projection.def.inverse([c.x,c.y]),T={lon:g[0]-h,lat:g[1]};(m.lat>t.projection.maxLatitude||T.lat<-1*t.projection.maxLatitude)&&(m.lat=t.projection.maxLatitude,T.lat=-1*t.projection.maxLatitude);let x=this.lonLatToTile(m,y),S=this.lonLatToTile(T,y),v=this.tileToLonLat(x.x,x.y,y),b=t.projection.def.forward([v.lon+h,v.lat]),Z=t.projectedUnitsToPixels({x:b[0],y:b[1]}),w=x.x*M-Z.x,j=x.y*M-Z.y;i[`${y}`]||(i[`${y}`]={tiles:{},isActive:!1,howManyTiles:0,actualTilesCount:0,loaded:!1}),i[`${y}`].howManyTiles=(S.x-x.x+1)*(S.y-x.y+1),i[`${y}`].actualTilesCount=0;for(let e=x.x;e<=S.x;e++)for(let t=x.y;t<=S.y;t++)a(e,t,y,w,j)}for(let o of Object.keys(i))for(let r of Object.keys(i[o].tiles))if(t.projection&&t.projection.def){let a=.638436911716859*Math.pow(2,m)/(.638436911716859*Math.pow(2,parseFloat(o))),n=256*a,p=i[o].tiles[Object.keys(i[o].tiles)[0]],{posX:c,posY:f}=i[o].tiles[r];if(l(c)&&l(f)&&l(p.posX)&&l(p.posY)){let a=this.tileToLonLat(p.posX,p.posY,parseFloat(o)),l=t.projection.def.forward([a.lon+h,a.lat]),m=t.projectedUnitsToPixels({x:l[0],y:l[1]}),g=p.posX*n-m.x,M=p.posY*n-m.y;if(e.renderer.globalAnimation&&e.hasRendered){let e=Number(i[o].tiles[r].attr("x")),t=Number(i[o].tiles[r].attr("y")),a=Number(i[o].tiles[r].attr("width")),l=Number(i[o].tiles[r].attr("height")),p=(s,p)=>{i[o].tiles[r].attr({x:e+(c*n-g-e)*p.pos,y:t+(f*n-M-t)*p.pos,width:a+(Math.ceil(n)+1-a)*p.pos,height:l+(Math.ceil(n)+1-l)*p.pos})};s.isAnimating=!0,i[o].tiles[r].attr({animator:0}).animate({animator:1},{step:p},function(){s.isAnimating=!1,s.redrawTiles&&(s.redrawTiles=!1,u(d))})}else(s.redrawTiles||parseFloat(o)!==y||(i[o].isActive||parseFloat(o)===y)&&Object.keys(i[o].tiles).map(e=>i[o].tiles[e]).some(e=>0===e.opacity))&&(s.redrawTiles=!1,u(d)),i[o].tiles[r].attr({x:c*n-g,y:f*n-M,width:Math.ceil(n)+1,height:Math.ceil(n)+1})}}}else p("Highcharts warning: Tiles Provider not defined in the Provider Registry.",!1)}update(){let{transformGroups:e}=this,t=this.chart,i=t.mapView,r=arguments[0],{provider:s}=r;if(e&&(e.forEach(e=>{0!==Object.keys(e).length&&e.destroy()}),this.transformGroups=[]),i&&!l(i.options.projection)&&s&&s.type){let e=o[s.type];if(e){let t=new e,{initialProjectionName:o}=t;i.update({projection:{name:o}})}}super.update.apply(this,arguments)}}return u.defaultOptions=m(a.defaultOptions,i),t.registerSeriesType("tiledwebmap",u),u}),o(t,"masters/modules/tiledwebmap.src.js",[t["Core/Globals.js"],t["Series/TiledWebMap/TiledWebMapSeries.js"],t["Maps/TilesProviders/TilesProviderRegistry.js"]],function(e,t,o){e.TilesProviderRegistry=o,t.compose(e.Chart)})});