/**
 * Highcharts Gantt JS v11.3.0 (2024-01-10)
 *
 * Tree Grid
 *
 * (c) 2016-2024 Jon Arild Nygard
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/treegrid",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function i(e,t,i,s){e.hasOwnProperty(t)||(e[t]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}i(t,"Core/Axis/BrokenAxis.js",[t["Core/Globals.js"],t["Core/Axis/Stacking/StackItem.js"],t["Core/Utilities.js"]],function(e,t,i){var s;let{composed:o}=e,{addEvent:r,find:n,fireEvent:l,isArray:a,isNumber:d,pick:h,pushUnique:c}=i;return function(e){function i(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function s(){this.brokenAxis?.hasBreaks&&(this.options.ordinal=!1)}function p(){let e=this.brokenAxis;if(e?.hasBreaks){let t=this.tickPositions,i=this.tickPositions.info,s=[];for(let i=0;i<t.length;i++)e.isInAnyBreak(t[i])||s.push(t[i]);this.tickPositions=s,this.tickPositions.info=i}}function f(){this.brokenAxis||(this.brokenAxis=new x(this))}function u(){let{isDirty:e,options:{connectNulls:t},points:i,xAxis:s,yAxis:o}=this;if(e){let e=i.length;for(;e--;){let r=i[e],n=null===r.y&&!1===t,l=!n&&(s?.brokenAxis?.isInAnyBreak(r.x,!0)||o?.brokenAxis?.isInAnyBreak(r.y,!0));r.visible=!l&&!1!==r.options.visible}}}function g(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,h(this.pointArrayMap,["y"]))}function m(e,t){let i,s,o;let r=this,n=r.points;if(e?.brokenAxis?.hasBreaks){let a=e.brokenAxis;t.forEach(function(t){i=a?.breakArray||[],s=e.isXAxis?e.min:h(r.options.threshold,e.min);let c=e?.options?.breaks?.filter(function(e){let t=!0;for(let s=0;s<i.length;s++){let o=i[s];if(o.from===e.from&&o.to===e.to){t=!1;break}}return t});n.forEach(function(r){o=h(r["stack"+t.toUpperCase()],r[t]),i.forEach(function(t){if(d(s)&&d(o)){let i="";s<t.from&&o>t.to||s>t.from&&o<t.from?i="pointBreak":(s<t.from&&o>t.from&&o<t.to||s>t.from&&o>t.to&&o<t.from)&&(i="pointInBreak"),i&&l(e,i,{point:r,brk:t})}}),c?.forEach(function(t){l(e,"pointOutsideOfBreak",{point:r,brk:t})})})})}}function k(){let e=this.currentDataGrouping,i=e?.gapSize,s=this.points.slice(),o=this.yAxis,r=this.options.gapSize,n=s.length-1;if(r&&n>0){let e,l;for("value"!==this.options.gapUnit&&(r*=this.basePointRange),i&&i>r&&i>=this.basePointRange&&(r=i);n--;)if(l&&!1!==l.visible||(l=s[n+1]),e=s[n],!1!==l.visible&&!1!==e.visible){if(l.x-e.x>r){let i=(e.x+l.x)/2;s.splice(n+1,0,{isNull:!0,x:i}),o.stacking&&this.options.stacking&&((o.stacking.stacks[this.stackKey][i]=new t(o,o.options.stackLabels,!1,i,this.stack)).total=0)}l=e}}return this.getGraphPath(s)}e.compose=function e(t,n){if(c(o,e)){t.keepProps.push("brokenAxis"),r(t,"init",f),r(t,"afterInit",i),r(t,"afterSetTickPositions",p),r(t,"afterSetOptions",s);let e=n.prototype;e.drawBreaks=m,e.gappedPath=k,r(n,"afterGeneratePoints",u),r(n,"afterRender",g)}return t};class x{static isInBreak(e,t){let i=e.repeat||1/0,s=e.from,o=e.to-e.from,r=t>=s?(t-s)%i:i-(s-t)%i;return e.inclusive?r<=o:r<o&&0!==r}static lin2Val(e){let t=this.brokenAxis,i=t&&t.breakArray;if(!i||!d(e))return e;let s=e,o,r;for(r=0;r<i.length&&!((o=i[r]).from>=s);r++)o.to<s?s+=o.len:x.isInBreak(o,s)&&(s+=o.len);return s}static val2Lin(e){let t=this.brokenAxis,i=t&&t.breakArray;if(!i||!d(e))return e;let s=e,o,r;for(r=0;r<i.length;r++)if((o=i[r]).to<=e)s-=o.len;else if(o.from>=e)break;else if(x.isInBreak(o,e)){s-=e-o.from;break}return s}constructor(e){this.hasBreaks=!1,this.axis=e}findBreakAt(e,t){return n(t,function(t){return t.from<e&&e<t.to})}isInAnyBreak(e,t){let i=this.axis,s=i.options.breaks||[],o=s.length,r,n,l;if(o&&d(e)){for(;o--;)x.isInBreak(s[o],e)&&(r=!0,n||(n=h(s[o].showPoints,!i.isXAxis)));l=r&&t?r&&!n:r}return l}setBreaks(e,t){let i=this,s=i.axis,o=a(e)&&!!e.length&&!!Object.keys(e[0]).length;s.isDirty=i.hasBreaks!==o,i.hasBreaks=o,e!==s.options.breaks&&(s.options.breaks=s.userOptions.breaks=e),s.forceRedraw=!0,s.series.forEach(function(e){e.isDirty=!0}),o||s.val2lin!==x.val2Lin||(delete s.val2lin,delete s.lin2val),o&&(s.userOptions.ordinal=!1,s.lin2val=x.lin2Val,s.val2lin=x.val2Lin,s.setExtremes=function(e,t,o,r,n){if(i.hasBreaks){let s;let o=this.options.breaks||[];for(;s=i.findBreakAt(e,o);)e=s.to;for(;s=i.findBreakAt(t,o);)t=s.from;t<e&&(t=e)}s.constructor.prototype.setExtremes.call(this,e,t,o,r,n)},s.setAxisTranslation=function(){if(s.constructor.prototype.setAxisTranslation.call(this),i.unitLength=void 0,i.hasBreaks){let e=s.options.breaks||[],t=[],o=[],r=h(s.pointRangePadding,0),n=0,a,c,p=s.userMin||s.min,f=s.userMax||s.max,u,g;e.forEach(function(e){c=e.repeat||1/0,d(p)&&d(f)&&(x.isInBreak(e,p)&&(p+=e.to%c-p%c),x.isInBreak(e,f)&&(f-=f%c-e.from%c))}),e.forEach(function(e){if(u=e.from,c=e.repeat||1/0,d(p)&&d(f)){for(;u-c>p;)u-=c;for(;u<p;)u+=c;for(g=u;g<f;g+=c)t.push({value:g,move:"in"}),t.push({value:g+e.to-e.from,move:"out",size:e.breakSize})}}),t.sort(function(e,t){return e.value===t.value?("in"===e.move?0:1)-("in"===t.move?0:1):e.value-t.value}),a=0,u=p,t.forEach(function(e){1===(a+="in"===e.move?1:-1)&&"in"===e.move&&(u=e.value),0===a&&d(u)&&(o.push({from:u,to:e.value,len:e.value-u-(e.size||0)}),n+=e.value-u-(e.size||0))}),i.breakArray=o,d(p)&&d(f)&&d(s.min)&&(i.unitLength=f-p-n+r,l(s,"afterBreaks"),s.staticScale?s.transA=s.staticScale:i.unitLength&&(s.transA*=(f-s.min+r)/i.unitLength),r&&(s.minPixelPadding=s.transA*(s.minPointOffset||0)),s.min=p,s.max=f)}}),h(t,!0)&&s.chart.redraw()}}e.Additions=x}(s||(s={})),s}),i(t,"Core/Axis/GridAxis.js",[t["Core/Axis/Axis.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(e,t,i){var s,o;let{composed:r,dateFormats:n}=t,{addEvent:l,defined:a,erase:d,find:h,isArray:c,isNumber:p,merge:f,pick:u,pushUnique:g,timeUnits:m,wrap:k}=i;function x(e){return i.isObject(e,!0)}function b(e,t){let i={width:0,height:0};if(t.forEach(function(t){let s=e[t],o=0,r=0,n;x(s)&&(o=(n=x(s.label)?s.label:{}).getBBox?n.getBBox().height:0,n.textStr&&!p(n.textPxLength)&&(n.textPxLength=n.getBBox().width),r=p(n.textPxLength)?Math.round(n.textPxLength):0,n.textStr&&(r=Math.round(n.getBBox().width)),i.height=Math.max(o,i.height),i.width=Math.max(r,i.width))}),"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode){let e=this.treeGrid.mapOfPosToGridNode[-1].height||0;i.width+=this.options.labels.indentation*(e-1)}return i}function y(e){let{grid:t}=this,i=3===this.side;if(i||e.apply(this),!t?.isColumn){let e=t?.columns||[];i&&(e=e.slice().reverse()),e.forEach(e=>{e.getOffset()})}i&&e.apply(this)}function v(e){let t=this.options,i=t.grid||{};if(!0===i.enabled){let{axisTitle:t,height:i,horiz:o,left:r,offset:n,opposite:l,options:a,top:d,width:h}=this,c=this.tickSize(),p=t&&t.getBBox().width,f=a.title.x,g=a.title.y,m=u(a.title.margin,o?5:10),k=t?this.chart.renderer.fontMetrics(t).f:0,x=c?c[0]/2:0,b=(o?d+i:r)+(o?1:-1)*(l?-1:1)*x+(this.side===s.bottom?k:0);e.titlePosition.x=o?r-(p||0)/2-m+f:b+(l?h:0)+n+f,e.titlePosition.y=o?b-(l?i:0)+(l?k:-k)/2+n+g:d-m+g}}function P(){let{chart:t,options:{grid:i={}},userOptions:s}=this;if(i.enabled&&function(e){let t=e.options;t.labels.align=u(t.labels.align,"center"),e.categories||(t.showLastLabel=!1),e.labelRotation=0,t.labels.rotation=0,t.minTickInterval=1}(this),i.columns){let o=this.grid.columns=[],r=this.grid.columnIndex=0;for(;++r<i.columns.length;){let n=f(s,i.columns[r],{isInternal:!0,linkedTo:0,scrollbar:{enabled:!1}},{grid:{columns:void 0}}),l=new e(this.chart,n,"yAxis");l.grid.isColumn=!0,l.grid.columnIndex=r,d(t.axes,l),d(t[this.coll]||[],l),o.push(l)}}}function G(){let{axisTitle:e,grid:t,options:i}=this,o=i.grid||{};if(!0===o.enabled){let o=this.min||0,r=this.max||0,n=this.ticks[this.tickPositions[0]];if(e&&!this.chart.styledMode&&n?.slotWidth&&!this.options.title.style.width&&e.css({width:`${n.slotWidth}px`}),this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions),this.rightWall&&this.rightWall.destroy(),this.grid&&this.grid.isOuterAxis()&&this.axisLine){let e=i.lineWidth;if(e){let t=this.getLinePath(e),n=t[0],l=t[1],a=(this.tickSize("tick")||[1])[0],d=(a-1)*(this.side===s.top||this.side===s.left?-1:1);if("M"===n[0]&&"L"===l[0]&&(this.horiz?(n[2]+=d,l[2]+=d):(n[1]+=d,l[1]+=d)),!this.horiz&&this.chart.marginRight){let e=["L",this.left,n[2]||0],t=[n,e],s=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(r+this.tickmarkOffset)],a=["M",l[1]||0,this.toPixels(r+this.tickmarkOffset)],d=[a,s];this.grid.upperBorder||o%1==0||(this.grid.upperBorder=this.grid.renderBorder(t)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.upperBorder.animate({d:t})),this.grid.lowerBorder||r%1==0||(this.grid.lowerBorder=this.grid.renderBorder(d)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.lowerBorder.animate({d:d}))}this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.axisLineExtra.animate({d:t})):this.grid.axisLineExtra=this.grid.renderBorder(t),this.axisLine[this.showAxis?"show":"hide"]()}}if((t&&t.columns||[]).forEach(e=>e.render()),!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)&&this.tickPositions.length){let e,t;let i=this.tickmarkOffset,s=this.tickPositions[this.tickPositions.length-1],n=this.tickPositions[0];for(;(e=this.hiddenLabels.pop())&&e.element;)e.show();for(;(t=this.hiddenMarks.pop())&&t.element;)t.show();(e=this.ticks[n].label)&&(o-n>i?this.hiddenLabels.push(e.hide()):e.show()),(e=this.ticks[s].label)&&(s-r>i?this.hiddenLabels.push(e.hide()):e.show());let l=this.ticks[s].mark;l&&s-r<i&&s-r>0&&this.ticks[s].isLast&&this.hiddenMarks.push(l.hide())}}}function A(){let e=this.tickPositions&&this.tickPositions.info,t=this.options,i=t.grid||{},s=this.userOptions.labels||{};i.enabled&&(this.horiz?(this.series.forEach(e=>{e.options.pointRange=0}),e&&t.dateTimeLabelFormats&&t.labels&&!a(s.align)&&(!1===t.dateTimeLabelFormats[e.unitName].range||e.count>1)&&(t.labels.align="left",a(s.x)||(t.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function T(e){let t;let i=this.options,s=e.userOptions,o=i&&x(i.grid)?i.grid:{};!0===o.enabled&&(t=f(!0,{className:"highcharts-grid-axis "+(s.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,style:{fontSize:"0.9em"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0,style:{textOverflow:"ellipsis"}},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},s),"xAxis"!==this.coll||(a(s.linkedTo)&&!a(s.tickPixelInterval)&&(t.tickPixelInterval=350),!(!a(s.tickPixelInterval)&&a(s.linkedTo))||a(s.tickPositioner)||a(s.tickInterval)||a(s.units)||(t.tickPositioner=function(e,i){let s=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;if(s){let o=t.units||[],r,n=1,l="year";for(let e=0;e<o.length;e++){let t=o[e];if(t&&t[0]===s.unitName){r=e;break}}let a=p(r)&&o[r+1];if(a){l=a[0]||"year";let e=a[1];n=e&&e[0]||1}else"year"===s.unitName&&(n=10*s.count);let d=m[l];return this.tickInterval=d*n,this.chart.time.getTimeTicks({unitRange:d,count:n,unitName:l},e,i,this.options.startOfWeek)}})),f(!0,this.options,t),this.horiz&&(i.minPadding=u(s.minPadding,0),i.maxPadding=u(s.maxPadding,0)),p(i.grid.borderWidth)&&(i.tickWidth=i.lineWidth=o.borderWidth))}function C(e){let t=e.userOptions,i=t&&t.grid||{},s=i.columns;i.enabled&&s&&f(!0,this.options,s[0])}function O(){(this.grid.columns||[]).forEach(e=>e.setScale())}function B(e){let{horiz:t,maxLabelDimensions:i,options:{grid:s={}}}=this;if(s.enabled&&i){let o=2*this.options.labels.distance,r=t?s.cellHeight||o+i.height:o+i.width;c(e.tickSize)?e.tickSize[0]=r:e.tickSize=[r,0]}}function w(){this.axes.forEach(e=>{(e.grid&&e.grid.columns||[]).forEach(e=>{e.setAxisSize(),e.setAxisTranslation()})})}function I(e){let{grid:t}=this;(t.columns||[]).forEach(t=>t.destroy(e.keepEvents)),t.columns=void 0}function E(e){let t=e.userOptions||{},i=t.grid||{};i.enabled&&a(i.borderColor)&&(t.tickColor=t.lineColor=i.borderColor),this.grid||(this.grid=new j(this)),this.hiddenLabels=[],this.hiddenMarks=[]}function L(e){let t=this.label,i=this.axis,o=i.reversed,r=i.chart,n=i.options,l=n.grid||{},a=i.options.labels,d=a.align,h=s[i.side],c=e.tickmarkOffset,f=i.tickPositions,u=this.pos-c,g=p(f[e.index+1])?f[e.index+1]-c:(i.max||0)+c,m=i.tickSize("tick"),k=m?m[0]:0,x=m?m[1]/2:0;if(!0===l.enabled){let s,n,l,c;if("top"===h?n=(s=i.top+i.offset)-k:"bottom"===h?s=(n=r.chartHeight-i.bottom+i.offset)+k:(s=i.top+i.len-(i.translate(o?g:u)||0),n=i.top+i.len-(i.translate(o?u:g)||0)),"right"===h?c=(l=r.chartWidth-i.right+i.offset)+k:"left"===h?l=(c=i.left+i.offset)-k:(l=Math.round(i.left+(i.translate(o?g:u)||0))-x,c=Math.min(Math.round(i.left+(i.translate(o?u:g)||0))-x,i.left+i.len)),this.slotWidth=c-l,e.pos.x="left"===d?l:"right"===d?c:l+(c-l)/2,e.pos.y=n+(s-n)/2,t){let i=r.renderer.fontMetrics(t),s=t.getBBox().height;if(a.useHTML)e.pos.y+=i.b+-(s/2);else{let t=Math.round(s/i.h);e.pos.y+=(i.b-(i.h-i.f))/2+-((t-1)*i.h/2)}}e.pos.x+=i.horiz&&a.x||0}}function N(e){let{axis:i,value:s}=e;if(i.options.grid&&i.options.grid.enabled){let o;let r=i.tickPositions,n=(i.linkedParent||i).series[0],l=s===r[0],a=s===r[r.length-1],d=n&&h(n.options.data,function(e){return e[i.isXAxis?"x":"y"]===s});d&&n.is("gantt")&&(o=f(d),t.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(o)),e.isFirst=l,e.isLast=a,e.point=o}}function M(){this.chart;let e=this.options,t=e.grid||{},i=this.categories,s=this.tickPositions,o=s[0],r=s[1],n=s[s.length-1],l=s[s.length-2],a=this.linkedParent&&this.linkedParent.min,d=this.linkedParent&&this.linkedParent.max,h=a||this.min,c=d||this.max,f=this.tickInterval,u=p(h)&&h>=o+f&&h<r,g=p(h)&&o<h&&o+f>h,m=p(c)&&n>c&&n-f<c,k=p(c)&&c<=n-f&&c>l;!0===t.enabled&&!i&&(this.isXAxis||this.isLinked)&&((g||u)&&!e.startOnTick&&(s[0]=h),(m||k)&&!e.endOnTick&&(s[s.length-1]=c))}function S(e){var t;let{options:{grid:i={}}}=this;return!0===i.enabled&&this.categories?this.tickInterval:e.apply(this,(t=arguments,Array.prototype.slice.call(t,1)))}(o=s||(s={}))[o.top=0]="top",o[o.right=1]="right",o[o.bottom=2]="bottom",o[o.left=3]="left";class j{constructor(e){this.axis=e}isOuterAxis(){let e=this.axis,t=e.chart,i=e.grid.columnIndex,s=e.linkedParent?.grid.columns||e.grid.columns||[],o=i?e.linkedParent:e,r=-1,n=0;return 3===e.side&&!t.inverted&&s.length?!e.linkedParent:((t[e.coll]||[]).forEach((t,i)=>{t.side!==e.side||t.options.isInternal||(n=i,t!==o||(r=i))}),n===r&&(!p(i)||s.length===i))}renderBorder(e){let t=this.axis,i=t.chart.renderer,s=t.options,o=i.path(e).addClass("highcharts-axis-line").add(t.axisGroup);return i.styledMode||o.attr({stroke:s.lineColor,"stroke-width":s.lineWidth,zIndex:7}),o}}return n.E=function(e){return this.dateFormat("%a",e,!0).charAt(0)},n.W=function(e){let t=this,i=new this.Date(e);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(e){t.set(e,i,0)});let s=(this.get("Day",i)+6)%7,o=new this.Date(i.valueOf());this.set("Date",o,this.get("Date",i)-s+3);let r=new this.Date(this.get("FullYear",o),0,1);return 4!==this.get("Day",r)&&(this.set("Month",i,0),this.set("Date",i,1+(11-this.get("Day",r))%7)),(1+Math.floor((o.valueOf()-r.valueOf())/6048e5)).toString()},{compose:function e(t,i,s){return g(r,e)&&(t.keepProps.push("grid"),t.prototype.getMaxLabelDimensions=b,k(t.prototype,"unsquish",S),k(t.prototype,"getOffset",y),l(t,"init",E),l(t,"afterGetTitlePosition",v),l(t,"afterInit",P),l(t,"afterRender",G),l(t,"afterSetAxisTranslation",A),l(t,"afterSetOptions",T),l(t,"afterSetOptions",C),l(t,"afterSetScale",O),l(t,"afterTickSize",B),l(t,"trimTicks",M),l(t,"destroy",I),l(i,"afterSetChartSize",w),l(s,"afterGetLabelPosition",L),l(s,"labelFormat",N)),t}}}),i(t,"Gantt/Tree.js",[t["Core/Utilities.js"]],function(e){let{extend:t,isNumber:i,pick:s}=e;function o(e,r,n,l,a,d){let h=d&&d.after,c=d&&d.before,p={data:l,depth:n-1,id:e,level:n,parent:r||""},f=0,u=0,g,m;"function"==typeof c&&c(p,d);let k=(a[e]||[]).map(t=>{let s=o(t.id,e,n+1,t,a,d),r=t.start||NaN,l=!0===t.milestone?r:t.end||NaN;return g=!i(g)||r<g?r:g,m=!i(m)||l>m?l:m,f=f+1+s.descendants,u=Math.max(s.height+1,u),s});return l&&(l.start=s(l.start,g),l.end=s(l.end,m)),t(p,{children:k,descendants:f,height:u}),"function"==typeof h&&h(p,d),p}return{getNode:o,getTree:function(e,t){return o("",null,1,null,function(e){let t=[],i=e.reduce((e,i)=>{let{parent:s="",id:o}=i;return void 0===e[s]&&(e[s]=[]),e[s].push(i),o&&t.push(o),e},{});return Object.keys(i).forEach(e=>{if(""!==e&&-1===t.indexOf(e)){let t=i[e].map(function(e){let{parent:t,...i}=e;return i});i[""].push(...t),delete i[e]}}),i}(e),t)}}}),i(t,"Core/Axis/TreeGrid/TreeGridTick.js",[t["Core/Globals.js"],t["Core/Utilities.js"]],function(e,t){let{composed:i}=e,{addEvent:s,removeEvent:o,isObject:r,isNumber:n,pick:l,pushUnique:a,wrap:d}=t;function h(){this.treeGrid||(this.treeGrid=new f(this))}function c(e,t,i,s,o,a,d,h,c){let p,f,u;let g=l(this.options&&this.options.labels,a),m=this.pos,k=this.axis,x=k.options,b="treegrid"===x.type,y=e.apply(this,[t,i,s,o,g,d,h,c]);if(b){let{width:e=0,padding:t=k.linkedParent?0:5}=g&&r(g.symbol,!0)?g.symbol:{},i=g&&n(g.indentation)?g.indentation:0;u=(f=(p=k.treeGrid.mapOfPosToGridNode)&&p[m])&&f.depth||1,y.x+=e+2*t+(u-1)*i}return y}function p(e){let t;let{pos:i,axis:a,label:d,treeGrid:h,options:c}=this,p=h?.labelIcon,f=d?.element,{treeGrid:u,options:g,chart:m,tickPositions:k}=a,x=u.mapOfPosToGridNode,b=l(c?.labels,g?.labels),y=b&&r(b.symbol,!0)?b.symbol:{},v=x&&x[i],{descendants:P,depth:G}=v||{},A=v&&P&&P>0,T="treegrid"===g.type&&f,C=k.indexOf(i)>-1,O="highcharts-treegrid-node-",B=O+"level-",w=m.styledMode;(T&&v&&d.removeClass(RegExp(B+".*")).addClass(B+G),e.apply(this,Array.prototype.slice.call(arguments,1)),T&&A)?(t=u.isCollapsed(v),function(e,t){let i=e.treeGrid,s=!i.labelIcon,o=t.renderer,r=t.xy,a=t.options,d=a.width||0,h=a.height||0,c=a.padding??e.axis.linkedParent?0:5,p={x:r.x-d/2-c,y:r.y-h/2},f=t.collapsed?90:180,u=t.show&&n(p.y),g=i.labelIcon;g||(i.labelIcon=g=o.path(o.symbols[a.type](a.x||0,a.y||0,d,h)).addClass("highcharts-label-icon").add(t.group)),g[u?"show":"hide"](),o.styledMode||g.attr({cursor:"pointer",fill:l(t.color,"#666666"),"stroke-width":1,stroke:a.lineColor,strokeWidth:a.lineWidth||0}),g[s?"attr":"animate"]({translateX:p.x,translateY:p.y,rotation:f})}(this,{color:!w&&d.styles&&d.styles.color||"",collapsed:t,group:d.parentGroup,options:y,renderer:d.renderer,show:C,xy:d.xy}),d.addClass(O+(t?"collapsed":"expanded")).removeClass(O+(t?"expanded":"collapsed")),w||d.css({cursor:"pointer"}),[d,p].forEach(e=>{e&&!e.attachedTreeGridEvents&&(s(e.element,"mouseover",function(){d.addClass("highcharts-treegrid-node-active"),d.renderer.styledMode||d.css({textDecoration:"underline"})}),s(e.element,"mouseout",function(){!function(e,t){let i=r(t.style)?t.style:{};e.removeClass("highcharts-treegrid-node-active"),e.renderer.styledMode||e.css({textDecoration:i.textDecoration||"none"})}(d,b)}),s(e.element,"click",function(){h.toggleCollapse()}),e.attachedTreeGridEvents=!0)})):p&&(o(f),d?.css({cursor:"default"}),p.destroy())}class f{static compose(e){if(a(i,this.compose)){let t=e.prototype;s(e,"init",h),d(t,"getLabelPosition",c),d(t,"renderLabel",p),t.collapse=function(e){this.treeGrid.collapse(e)},t.expand=function(e){this.treeGrid.expand(e)},t.toggleCollapse=function(e){this.treeGrid.toggleCollapse(e)}}}constructor(e){this.tick=e}collapse(e){let t=this.tick,i=t.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){let o=t.pos,r=i.treeGrid.mapOfPosToGridNode[o],n=i.treeGrid.collapse(r);s.setBreaks(n,l(e,!0))}}destroy(){this.labelIcon&&this.labelIcon.destroy()}expand(e){let{pos:t,axis:i}=this.tick,{treeGrid:s,brokenAxis:o}=i,r=s.mapOfPosToGridNode;if(o&&r){let i=r[t],n=s.expand(i);o.setBreaks(n,l(e,!0))}}toggleCollapse(e){let t=this.tick,i=t.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){let o=t.pos,r=i.treeGrid.mapOfPosToGridNode[o],n=i.treeGrid.toggleCollapse(r);s.setBreaks(n,l(e,!0))}}}return f}),i(t,"Series/TreeUtilities.js",[t["Core/Color/Color.js"],t["Core/Utilities.js"]],function(e,t){let{extend:i,isArray:s,isNumber:o,isObject:r,merge:n,pick:l}=t;return{getColor:function(t,i){let s,o,r,n,a,d;let h=i.index,c=i.mapOptionsToLevel,p=i.parentColor,f=i.parentColorIndex,u=i.series,g=i.colors,m=i.siblings,k=u.points,x=u.chart.options.chart;return t&&(s=k[t.i],o=c[t.level]||{},s&&o.colorByPoint&&(n=s.index%(g?g.length:x.colorCount),r=g&&g[n]),u.chart.styledMode||(a=l(s&&s.options.color,o&&o.color,r,p&&(t=>{let i=o&&o.colorVariation;return i&&"brightness"===i.key&&h&&m?e.parse(t).brighten(i.to*(h/m)).get():t})(p),u.color)),d=l(s&&s.options.colorIndex,o&&o.colorIndex,n,f,i.colorIndex)),{color:a,colorIndex:d}},getLevelOptions:function(e){let t={},i,a,d,h,c,p;if(r(e))for(h=o(e.from)?e.from:1,p=e.levels,a={},i=r(e.defaults)?e.defaults:{},s(p)&&(a=p.reduce((e,t)=>{let s,a,d;return r(t)&&o(t.level)&&(a=l((d=n({},t)).levelIsConstant,i.levelIsConstant),delete d.levelIsConstant,delete d.level,r(e[s=t.level+(a?0:h-1)])?n(!0,e[s],d):e[s]=d),e},{})),c=o(e.to)?e.to:1,d=0;d<=c;d++)t[d]=n({},i,r(a[d])?a[d]:{});return t},setTreeValues:function e(t,s){let o=s.before,r=s.idRoot,n=s.mapIdToNode,a=n[r],d=!1!==s.levelIsConstant,h=s.points,c=h[t.i],p=c&&c.options||{},f=[],u=0;t.levelDynamic=t.level-(d?0:a.level),t.name=l(c&&c.name,""),t.visible=r===t.id||!0===s.visible,"function"==typeof o&&(t=o(t,s)),t.children.forEach((o,r)=>{let n=i({},s);i(n,{index:r,siblings:t.children.length,visible:t.visible}),o=e(o,n),f.push(o),o.visible&&(u+=o.val)});let g=l(p.value,u);return t.visible=g>=0&&(u>0||t.visible),t.children=f,t.childrenTotal=u,t.isLeaf=t.visible&&!u,t.val=g,t},updateRootId:function(e){let t,i;return r(e)&&(i=r(e.options)?e.options:{},t=l(e.rootNode,i.rootId,""),r(e.userOptions)&&(e.userOptions.rootId=t),e.rootNode=t),t}}}),i(t,"Core/Axis/TreeGrid/TreeGridAxis.js",[t["Core/Axis/BrokenAxis.js"],t["Core/Axis/GridAxis.js"],t["Core/Globals.js"],t["Gantt/Tree.js"],t["Core/Axis/TreeGrid/TreeGridTick.js"],t["Series/TreeUtilities.js"],t["Core/Utilities.js"]],function(e,t,i,s,o,r,n){let l;let{composed:a}=i,{getLevelOptions:d}=r,{addEvent:h,find:c,fireEvent:p,isArray:f,isObject:u,isString:g,merge:m,pick:k,pushUnique:x,removeEvent:b,wrap:y}=n;function v(e,t){let i=e.collapseEnd||0,s=e.collapseStart||0;return i>=t&&(s-=.5),{from:s,to:i,showPoints:!1}}function P(e,t,i){let o=[],r=[],n={},l="boolean"==typeof t&&t,a={},d=-1,h=s.getTree(e,{after:function(e){let t=a[e.pos],i=0,s=0;t.children.forEach(function(e){s+=(e.descendants||0)+1,i=Math.max((e.height||0)+1,i)}),t.descendants=s,t.height=i,t.collapsed&&r.push(t)},before:function(e){let t,i;let s=u(e.data,!0)?e.data:{},r=g(s.name)?s.name:"",h=n[e.parent],p=u(h,!0)?a[h.pos]:null;l&&u(p,!0)&&(t=c(p.children,function(e){return e.name===r}))?(i=t.pos,t.nodes.push(e)):i=d++,!a[i]&&(a[i]=t={depth:p?p.depth+1:0,name:r,id:s.id,nodes:[e],children:[],pos:i},-1!==i&&o.push(r),u(p,!0)&&p.children.push(t)),g(e.id)&&(n[e.id]=e),t&&!0===s.collapsed&&(t.collapsed=!0),e.pos=i}});return{categories:o,mapOfIdToNode:n,mapOfPosToGridNode:a=function(e,t){let i=function(e,s,o){let r=e.nodes,n=s+(-1===s?0:t-1),l=(n-s)/2,a=s+l;return r.forEach(function(e){let t=e.data;u(t,!0)&&(t.y=s+(t.seriesIndex||0),delete t.seriesIndex),e.pos=a}),o[a]=e,e.pos=a,e.tickmarkOffset=l+.5,e.collapseStart=n+.5,e.children.forEach(function(e){i(e,n+1,o),n=(e.collapseEnd||0)-.5}),e.collapseEnd=n+.5,o};return i(e["-1"],-1,{})}(a,i),collapsedNodes:r,tree:h}}function G(e){let t=e.target,i=t.axes;i.filter(function(e){return"treegrid"===e.options.type}).forEach(function(t){let i=t.options||{},s=i.labels,o=i.uniqueNames,r=i.max,n=!t.treeGrid.mapOfPosToGridNode||t.series.some(function(e){return!e.hasRendered||e.isDirtyData||e.isDirty}),l=0,a,h;if(n){if(a=t.series.reduce(function(e,t){return t.visible&&((t.options.data||[]).forEach(function(i){t.options.keys&&t.options.keys.length&&(i=t.pointClass.prototype.optionsToObject.call({series:t},i),t.pointClass.setGanttPointAliases(i)),u(i,!0)&&(i.seriesIndex=l,e.push(i))}),!0===o&&l++),e},[]),r&&a.length<r)for(let e=a.length;e<=r;e++)a.push({name:e+"​"});h=P(a,o||!1,!0===o?l:1),t.categories=h.categories,t.treeGrid.mapOfPosToGridNode=h.mapOfPosToGridNode,t.hasNames=!0,t.treeGrid.tree=h.tree,t.series.forEach(function(e){let t=(e.options.data||[]).map(function(t){return f(t)&&e.options.keys&&e.options.keys.length&&a.forEach(function(e){t.indexOf(e.x)>=0&&t.indexOf(e.x2)>=0&&(t=e)}),u(t,!0)?m(t):t});e.visible&&e.setData(t,!1)}),t.treeGrid.mapOptionsToLevel=d({defaults:s,from:1,levels:s&&s.levels,to:t.treeGrid.tree&&t.treeGrid.tree.height}),"beforeRender"===e.type&&(t.treeGrid.collapsedNodes=h.collapsedNodes)}})}function A(e,t){let i=this.treeGrid.mapOptionsToLevel||{},s="treegrid"===this.options.type,o=this.ticks,r=o[t],n,a,d;s&&this.treeGrid.mapOfPosToGridNode?((n=i[(d=this.treeGrid.mapOfPosToGridNode[t]).depth])&&(a={labels:n}),!r&&l?o[t]=r=new l(this,t,void 0,void 0,{category:d.name,tickmarkOffset:d.tickmarkOffset,options:a}):(r.parameters.category=d.name,r.options=a,r.addLabel())):e.apply(this,Array.prototype.slice.call(arguments,1))}function T(e,t,i,s){let o=this,r="treegrid"===i.type;o.treeGrid||(o.treeGrid=new B(o)),r&&(h(t,"beforeRender",G),h(t,"beforeRedraw",G),h(t,"addSeries",function(e){if(e.options.data){let t=P(e.options.data,i.uniqueNames||!1,1);o.treeGrid.collapsedNodes=(o.treeGrid.collapsedNodes||[]).concat(t.collapsedNodes)}}),h(o,"foundExtremes",function(){o.treeGrid.collapsedNodes&&o.treeGrid.collapsedNodes.forEach(function(e){let t=o.treeGrid.collapse(e);o.brokenAxis&&(o.brokenAxis.setBreaks(t,!1),o.treeGrid.collapsedNodes&&(o.treeGrid.collapsedNodes=o.treeGrid.collapsedNodes.filter(t=>e.collapseStart!==t.collapseStart||e.collapseEnd!==t.collapseEnd)))})}),h(o,"afterBreaks",function(){"yAxis"===o.coll&&!o.staticScale&&o.chart.options.chart.height&&(o.isDirty=!0)}),i=m({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10}},uniqueNames:!1},i,{reversed:!0})),e.apply(o,[t,i,s]),r&&(o.hasNames=!0,o.options.showLastLabel=!0)}function C(e){let t=this.options,i="number"==typeof t.linkedTo?this.chart[this.coll]?.[t.linkedTo]:void 0,s="treegrid"===t.type;if(s){if(this.min=k(this.userMin,t.min,this.dataMin),this.max=k(this.userMax,t.max,this.dataMax),p(this,"foundExtremes"),this.setAxisTranslation(),this.tickInterval=1,this.tickmarkOffset=.5,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[],i){let e=i.getExtremes();this.min=k(e.min,e.dataMin),this.max=k(e.max,e.dataMax),this.tickPositions=i.tickPositions}this.linkedParent=i}else e.apply(this,Array.prototype.slice.call(arguments,1))}function O(e){let t=this,i=t.options,s="treegrid"===i.type;s&&t.visible&&t.tickPositions.forEach(function(e){let i=t.ticks[e];i.label&&i.label.attachedTreeGridEvents&&(b(i.label.element),i.label.attachedTreeGridEvents=!1)}),e.apply(t,Array.prototype.slice.call(arguments,1))}class B{static compose(i,r,n,d){if(x(a,this.compose)){let e=i.prototype;-1===i.keepProps.indexOf("treeGrid")&&i.keepProps.push("treeGrid"),y(e,"generateTick",A),y(e,"init",T),y(e,"setTickInterval",C),y(e,"redraw",O),e.utils={getNode:s.getNode},l||(l=d)}return t.compose(i,r,d),e.compose(i,n),o.compose(d),i}constructor(e){this.axis=e}setCollapsedStatus(e){let t=this.axis,i=t.chart;t.series.forEach(function(t){let s=t.options.data;if(e.id&&s){let o=i.get(e.id),r=s[t.data.indexOf(o)];o&&r&&(o.collapsed=e.collapsed,r.collapsed=e.collapsed)}})}collapse(e){let t=this.axis,i=t.options.breaks||[],s=v(e,t.max);return i.push(s),e.collapsed=!0,t.treeGrid.setCollapsedStatus(e),i}expand(e){let t=this.axis,i=t.options.breaks||[],s=v(e,t.max);return e.collapsed=!1,t.treeGrid.setCollapsedStatus(e),i.reduce(function(e,t){return(t.to!==s.to||t.from!==s.from)&&e.push(t),e},[])}getTickPositions(){let e=this.axis,t=Math.floor(e.min/e.tickInterval)*e.tickInterval,i=Math.ceil(e.max/e.tickInterval)*e.tickInterval;return Object.keys(e.treeGrid.mapOfPosToGridNode||{}).reduce(function(s,o){let r=+o;return r>=t&&r<=i&&!(e.brokenAxis&&e.brokenAxis.isInAnyBreak(r))&&s.push(r),s},[])}isCollapsed(e){let t=this.axis,i=t.options.breaks||[],s=v(e,t.max);return i.some(function(e){return e.from===s.from&&e.to===s.to})}toggleCollapse(e){return this.isCollapsed(e)?this.expand(e):this.collapse(e)}}return B}),i(t,"masters/modules/treegrid.src.js",[t["Core/Globals.js"],t["Core/Axis/TreeGrid/TreeGridAxis.js"]],function(e,t){t.compose(e.Axis,e.Chart,e.Series,e.Tick)})});