<?php
include 'header.php';
?>

<div class="content mt-3">
  <div class="animated fadeIn">
    <div class="card shadow-sm border-0">
      <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0"><i class="fa fa-truck"></i> Registro de Unidades</h5>
    
      </div>

      <?php if (isset($_SESSION['message'])): ?>
        <div class="alert alert-success text-center mt-2">
          <?= $_SESSION['message']; unset($_SESSION['message']); ?>
        </div>
      <?php endif; ?>

      <div class="card-body">
        <div class="table-responsive">
          <table id="tablaUnidades" class="table table-striped table-hover nowrap" style="width:100%">
            <thead class="bg-primary text-white text-center">
              <tr>
                <th>#</th>
                <th>Acciones</th>
                <th>Placa</th>
                <th>Tipo</th>
                <th>Marca</th>
                <th>Modelo</th>
                <th>Aseguradora</th>
                <th>Poliza</th>
                <th>Chofer</th>
                <th>Comentarios</th>
                <th>Estado</th>
                <th>Fecha Registro</th>
              </tr>
            </thead>
            <tbody class="text-center">
              <?php
              include '../config/conexion.php';
              $db = (new Connection())->open();
              try {
                $sql = "SELECT * FROM registro_unidad ORDER BY id DESC";
                foreach ($db->query($sql) as $row):
              ?>
                  <tr>
                    <td><?= $row['id']; ?></td>
                    <td>
                      <div class="btn-group btn-group-sm">
                        <!-- Eliminar -->
                        <!-- Editar -->
                        <button class="btn btn-outline-info btn-sm" 
                                title="Actualizar Estado/Comentarios"
                                onclick="openUpdateModal(
                                  <?= $row['id']; ?>,
                                  <?= $row['estado'] ? '1' : '0'; ?>,
                                  '<?= htmlspecialchars($row['comentarios']); ?>'
                                )">
                          <i class="fa fa-edit"></i>
                        </button>
                        <!-- QR -->
                        <button class="btn btn-outline-secondary btn-sm" title="Generar QR"
                                onclick="openQRModal('<?= htmlspecialchars($row['placa']); ?>', '<?= htmlspecialchars($row['tipo']); ?>', '<?= htmlspecialchars($row['marca']); ?>', '<?= htmlspecialchars($row['modelo']); ?>')">
                          <i class="fa fa-qrcode"></i>
                        </button>
                      </div>
                    </td>
                    <td><?= $row['placa']; ?></td>
                    <td><?= $row['tipo']; ?></td>
                    <td><?= $row['marca']; ?></td>
                    <td><?= $row['modelo']; ?></td>
                    <td><?= $row['aseguradora']; ?></td>
                    <td><?= $row['nro_poliza_seguro']; ?></td>
                    <td><?= $row['chofer']; ?></td>
                    <td><?= $row['comentarios']; ?></td>
                    <td>
                      <?php if ($row['estado']): ?>
                        <span class="badge badge-success">Salida</span>
                      <?php else: ?>
                        <span class="badge badge-danger">Entrada</span>
                      <?php endif; ?>
                    </td>
                    <td><?= $row['fecha_registro']; ?></td>
                  </tr>
              <?php
                endforeach;
              } catch (PDOException $e) {
                echo "<tr><td colspan='12'>Error: " . $e->getMessage() . "</td></tr>";
              }
              $db = null;
              ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal Registrar Nueva Unidad -->
<div class="modal fade" id="modalNuevaUnidad" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <form action="../controller/create_unidad.php" method="POST" id="formNuevaUnidad">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title"><i class="fa fa-plus-circle"></i> Registrar Nueva Unidad</h5>
          <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-md-4">
              <label>Placa</label>
              <div class="input-group">
                <input type="text" name="placa" id="placa" class="form-control" required>
                <div class="input-group-append">
                  <button class="btn btn-outline-primary" type="button" id="btnBuscarPlaca"><i class="fa fa-search"></i></button>
                </div>
              </div>
            </div>
            <div class="col-md-4"><label>Tipo</label><input name="tipo" id="tipo" class="form-control"></div>
            <div class="col-md-4"><label>Marca</label><input name="marca" id="marca" class="form-control"></div>
            <div class="col-md-4 mt-2"><label>Modelo</label><input name="modelo" id="modelo" class="form-control"></div>
            <div class="col-md-4 mt-2"><label>Aseguradora</label><input name="aseguradora" id="aseguradora" class="form-control"></div>
            <div class="col-md-4 mt-2"><label>N° Póliza</label><input name="nro_poliza_seguro" id="nro_poliza_seguro" class="form-control"></div>
            <div class="col-md-6 mt-2"><label>Chofer</label><input name="chofer" value="<?= $_SESSION['sess_name']; ?>" class="form-control" required></div>
            <div class="col-md-6 mt-2"><label>Comentarios</label><input name="comentarios" class="form-control"></div>
            <input type="hidden" name="lat" id="lat">
            <input type="hidden" name="lng" id="lng">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Guardar</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Modal Actualizar Estado -->
<div class="modal fade" id="modalUpdateEstado" tabindex="-1" role="dialog" aria-labelledby="modalUpdateEstadoLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <form id="formUpdateEstado" method="POST" action="../controller/update_estado.php">
        <div class="modal-header bg-danger text-white">
          <h5 class="modal-title"><i class="fa fa-edit"></i> Actualizar Estado y Comentarios</h5>
          <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="updateId">
          <div class="form-group">
            <label>Estado</label>
            <select name="estado" id="updateEstado" class="form-control">
              <option value="1">Salida</option>
              <option value="0">Entrada</option>
            </select>
          </div>
          <div class="form-group">
            <label>Comentarios</label>
            <textarea name="comentarios" id="updateComentarios" class="form-control" rows="3" required></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-info">Actualizar</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Modal QR -->
<div class="modal fade" id="modalQR" tabindex="-1" role="dialog" aria-labelledby="modalQRLabel" aria-hidden="true">
  <div class="modal-dialog modal-sm" role="document">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title"><i class="fa fa-qrcode"></i> Código QR</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body text-center" id="qrContent">
        <div id="qrcode"></div>
        <p class="mt-2" id="qrInfo"></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" onclick="imprimirQR()">🖨️ Imprimir QR</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
<!-- JS Libraries -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="../public/vendors/popper.js/dist/umd/popper.min.js"></script>
<script src="../public/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.datatables.net/2.2.2/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/buttons/3.2.2/js/dataTables.buttons.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/3.2.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/3.2.2/js/buttons.print.min.js"></script>
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Scripts personalizados -->
<script>
$(document).ready(function() {
  // DataTable
  new DataTable('#tablaUnidades', {
    responsive: true,
    layout: { topStart: { buttons: ['copy', 'csv', 'excel', 'pdf', 'print'] } },
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json' }
  });

  // Geolocalización
  capturarUbicacion();
});

// Capturar ubicación
let map;
function capturarUbicacion() {
  if (!navigator.geolocation) return;
  navigator.geolocation.getCurrentPosition(pos => {
    const lat = pos.coords.latitude.toFixed(6);
    const lng = pos.coords.longitude.toFixed(6);
    $('#lat').val(lat);
    $('#lng').val(lng);
    if (map) map.remove();
    map = L.map('mapaUbicacion')?.setView([lat, lng], 15);
    if (map) L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19 }).addTo(map);
  });
}

// Confirm Delete
function confirmDelete(id, placa) {
  Swal.fire({
    title: '¿Estás seguro?',
    text: `Se eliminará la unidad con placa: ${placa}`,
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#d33',
    cancelButtonColor: '#3085d6',
    confirmButtonText: 'Sí, eliminar',
    cancelButtonText: 'Cancelar'
  }).then(result => {
    if (result.isConfirmed) window.location.href = `../controller/delete_registro.php?id=${id}`;
  });
}

// Modal Update
function openUpdateModal(id, estado, comentarios) {
  $('#updateId').val(id);
  $('#updateEstado').val(estado);
  $('#updateComentarios').val(comentarios);
  $('#modalUpdateEstado').modal('show');
}

// Modal QR
function openQRModal(placa, tipo, marca, modelo) {
  const qrData = `Placa: ${placa}\nTipo: ${tipo}\nMarca: ${marca}\nModelo: ${modelo}`;
  $('#qrcode').html('');
  new QRCode(document.getElementById("qrcode"), { text: qrData, width:200, height:200, colorDark:"#000", colorLight:"#fff", correctLevel:QRCode.CorrectLevel.H });
  $('#qrInfo').text(`Placa: ${placa} | ${marca} ${modelo}`);
  $('#modalQR').modal('show');
}

// Función para imprimir solo el QR
function imprimirQR() {
  const contenido = document.getElementById("qrContent").innerHTML;
  const ventana = window.open('', '', 'width=300,height=400');
  ventana.document.write('<html><head><title>Imprimir QR</title></head><body style="text-align:center;">');
  ventana.document.write(contenido);
  ventana.document.write('</body></html>');
  ventana.document.close();
  ventana.focus();
  ventana.print();
  ventana.close();
}

// Buscar placa
$('#btnBuscarPlaca').click(function() {
  const placa = $('#placa').val().trim();
  if (!placa) { Swal.fire('Atención','Ingrese una placa','warning'); return; }
  $.getJSON('../controller/buscar_flota.php',{placa},data=>{
    if (data.success) {
      if (data.flota) { $('#tipo').val(data.flota.tipo); $('#marca').val(data.flota.marca); $('#modelo').val(data.flota.modelo); }
      if (data.seguro) { $('#aseguradora').val(data.seguro.aseguradora); $('#nro_poliza_seguro').val(data.seguro.nro_poliza_seguro); }
      Swal.fire('Éxito','Datos cargados correctamente','success');
    } else { Swal.fire('No encontrado','No se encontró ningún vehículo con esa placa.','info'); }
  }).fail(()=>{ Swal.fire('Error','Ocurrió un problema al buscar la placa.','error'); });
});

// Validar geolocalización antes de enviar
$('#formNuevaUnidad').on('submit', function(e) {
  if (!$('#lat').val() || !$('#lng').val()) {
    e.preventDefault();
    Swal.fire('Ubicación no detectada','Presiona "Capturar Ubicación Actual" antes de guardar.','warning');
  }
});
</script>
