<?php
include 'header.php';
?>
<style>
body {
    background-color: #f4f6f9;
}

/* Card principal */
.card {
    border: none;
    border-radius: 1rem;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
}

/* Encabezado */
.card-header {
    background: linear-gradient(90deg, #007bff, #00bcd4);
    color: #fff;
    font-weight: 600;
    border-top-left-radius: 1rem;
    border-top-right-radius: 1rem;
    padding: 1rem 1.5rem;
}

.card-header .btn {
    font-weight: 600;
    border-radius: 8px;
}

/* Botones */
.btn-success {
    background: linear-gradient(90deg, #28a745, #20c997);
    border: none;
}
.btn-success:hover {
    background: linear-gradient(90deg, #20c997, #28a745);
    transform: scale(1.05);
}

/* Tabla */
.table {
    border-radius: 10px;
    overflow: hidden;
}
.table thead {
    background: linear-gradient(90deg, #007bff, #00bcd4);
    color: #fff;
    font-size: 14px;
    text-transform: uppercase;
}
.table-hover tbody tr:hover {
    background-color: #e3f2fd !important;
    transition: all 0.2s ease;
}

/* Botones de acción */
.btn-outline-primary, .btn-outline-danger {
    border-radius: 8px;
    transition: 0.3s;
}
.btn-outline-primary:hover {
    background: #007bff;
    color: white;
}
.btn-outline-danger:hover {
    background: #dc3545;
    color: white;
}

/* Animación de la tabla */
tbody tr {
    transition: transform 0.15s ease-in-out;
}
tbody tr:hover {
    transform: scale(1.01);
}

/* Etiquetas */
.badge {
    font-size: 0.8rem;
    border-radius: 8px;
}

/* Breadcrumbs */
.breadcrumbs {
    background: none;
}
.breadcrumb {
    background: transparent;
    margin-bottom: 0;
}
.breadcrumb li a {
    color: #007bff;
    text-decoration: none;
}
.breadcrumb li.active {
    color: #333;
}
</style>


<!-- Breadcrumb -->
<div class="breadcrumbs">
  <div class="col-sm-4">
    <div class="page-header float-left">
      <div class="page-title">
        <h1><i class="fa fa-id-card text-primary"></i> Conductores</h1>
      </div>
    </div>
  </div>
  <div class="col-sm-8">
    <div class="page-header float-right">
      <div class="page-title">
        <ol class="breadcrumb text-right">
          <li><a href="#">Dashboard</a></li>
          <li><a href="#">Gestión Vehicular</a></li>
          <li class="active">Conductores</li>
        </ol>
      </div>
    </div>
  </div>
</div>

<!-- Contenido principal -->
<div class="content mt-3">
  <div class="animated fadeIn">
    <div class="row justify-content-center">
      <div class="col-12">
        <div class="card shadow-sm border-0">
          <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
            <strong class="card-title"><i class="fa fa-users"></i> Lista de Conductores</strong>
            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#largeModal">
              <i class="fa fa-plus-circle"></i> Nuevo Conductor
            </button>
          </div>

          <?php if (isset($_SESSION['message'])): ?>
            <div class="alert alert-success text-center mt-2 mb-0">
              <?= $_SESSION['message']; unset($_SESSION['message']); ?>
            </div>
          <?php endif; ?>

          <div class="card-body">
            <div class="table-responsive">
              <table id="tablaConductores" class="table table-striped table-hover nowrap" style="width:100%">
                <thead>
                  <tr class="text-center">
                    <th>#</th>
                    <th>Acciones</th>
                    <th>Nro. Documento</th>
                    <th>Nombre Completo</th>
                    <th>N.º Licencia</th>
                    <th>Dirección</th>
                    <th>Celular</th>
                    <th>Emergencia</th>
                    <th>Categoría Licencia</th>
                    <th>Vencimiento Licencia</th>
                    <th>Creado</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  include '../config/conexion.php';
                  $database = new Connection();
                  $db = $database->open();
                  try {
                    $sql = 'SELECT * FROM conductor ORDER BY id DESC';
                    foreach ($db->query($sql) as $row): ?>
                      <tr>
                        <td><?= $row['id']; ?></td>
                        <td>
                          <div class="btn-group btn-group-sm" role="group">
                           <button 
  class="btn btn-outline-primary btn-sm"
  title="Editar"
  onclick="openEditConductor(
      <?= $row['id']; ?>,
      '<?= htmlspecialchars($row['nro_document']); ?>',
      '<?= htmlspecialchars($row['fullname']); ?>',
      '<?= htmlspecialchars($row['nro_licencia']); ?>',
      '<?= htmlspecialchars($row['direccion']); ?>',
      '<?= htmlspecialchars($row['nro_celular']); ?>',
      '<?= htmlspecialchars($row['nro_contacto_emergencia']); ?>',
      '<?= htmlspecialchars($row['categoria_licencia']); ?>',
      '<?= htmlspecialchars($row['fecha_vto_licencia']); ?>'
  )">
  <i class="fa fa-pencil"></i>
</button>
                            <button 
  class="btn btn-outline-danger btn-sm" 
  title="Eliminar" 
  onclick="confirmDelete(<?= $row['id']; ?>, '<?= htmlspecialchars($row['fullname']); ?>')">
  <i class="fa fa-trash"></i>
</button>
                          </div>
                        </td>
                        <td><?= htmlspecialchars($row['nro_document']); ?></td>
                        <td><?= htmlspecialchars($row['fullname']); ?></td>
                        <td><?= htmlspecialchars($row['nro_licencia']); ?></td>
                        <td><?= htmlspecialchars($row['direccion']); ?></td>
                        <td><?= htmlspecialchars($row['nro_celular']); ?></td>
                        <td><?= htmlspecialchars($row['nro_contacto_emergencia']); ?></td>
                        <td><span class="badge badge-primary"><?= htmlspecialchars($row['categoria_licencia']); ?></span></td>
                        <td><?= htmlspecialchars($row['fecha_vto_licencia']); ?></td>
                        <td><?= htmlspecialchars($row['fecha_creacion']); ?></td>
                      </tr>
                    <?php endforeach;
                  } catch (PDOException $e) {
                    echo "<tr><td colspan='12' class='text-danger text-center'>Error: " . $e->getMessage() . "</td></tr>";
                  }
                  $database->close();
                  ?>
                </tbody>
                <tfoot style="background-color:#346eb2;color:#ffffff">
                  <tr class="text-center">
                    <th>#</th>
                    <th>Acciones</th>
                    <th>Nro. Documento</th>
                    <th>Nombre Completo</th>
                    <th>N.º Licencia</th>
                    <th>Dirección</th>
                    <th>Celular</th>
                    <th>Emergencia</th>
                    <th>Categoría Licencia</th>
                    <th>Vencimiento Licencia</th>
                    <th>Creado</th>
                  </tr>
                </tfoot>
              </table>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</div>

<?php
include 'footer.php';
include '../modal/conductor.php';
include '../modal/actualizar_conductor.php';
?>

<script>
new DataTable('#tablaConductores', {
  responsive: true,
  layout: {
    topStart: {
      buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
    }
  },
  language: {
    url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
  }
});
</script>
<script>
function openEditConductor(id, nro_document, fullname, nro_licencia, direccion, nro_celular, nro_contacto_emergencia, categoria_licencia, fecha_vto_licencia) {
    // Asignar valores a los campos del modal
    document.getElementById('edit_id').value = id;
    document.getElementById('edit_nro_document').value = nro_document;
    document.getElementById('edit_fullname').value = fullname;
    document.getElementById('edit_nro_licencia').value = nro_licencia;
    document.getElementById('edit_direccion').value = direccion;
    document.getElementById('edit_nro_celular').value = nro_celular;
    document.getElementById('edit_nro_contacto_emergencia').value = nro_contacto_emergencia;
    document.getElementById('edit_categoria_licencia').value = categoria_licencia;
    document.getElementById('edit_fecha_vto_licencia').value = fecha_vto_licencia;

    // Mostrar el modal
    const modalId = 'editModal';
    const modalElement = document.getElementById(modalId);

    if (typeof $ !== 'undefined' && typeof $.fn.modal === 'function') {
        $('#' + modalId).modal('show');
    } else if (typeof bootstrap !== 'undefined') {
        const modal = new bootstrap.Modal(modalElement);
        modal.show();
    } else {
        console.error('No se encontró Bootstrap ni jQuery para abrir el modal.');
    }
}
</script>

<script>
function confirmDelete(id, name) {
  Swal.fire({
    title: '¿Estás seguro?',
    html: `Vas a eliminar al conductor <b>${name}</b>. Esta acción no se puede deshacer.`,
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí, eliminar',
    cancelButtonText: 'Cancelar',
    confirmButtonColor: '#d33',
    cancelButtonColor: '#3085d6',
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Redirigir al controlador de eliminación
      //window.location.href = `../controller/delete_conductor?id=${id}`;
      window.location.href = `../controller/delete_conductor.php?id=${id}`;
    }
  });
}
</script>
