<?php
include 'header.php';
session_start();
?>

<div class="content mt-3">
    <div class="animated fadeIn">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fa fa-map-marker-alt"></i> Dashboard de Rutas</h5>
            </div>

            <div class="card-body">
                <!-- Filtro de placa y fechas -->
                <form id="formFiltro" class="mb-3 row">
                    <div class="col-md-3">
                        <label for="placa">Placa</label>
                        <input type="text" class="form-control" id="placa" placeholder="Ingrese placa" required>
                    </div>
                    <div class="col-md-3">
                        <label for="fecha_inicio">Fecha Inicio</label>
                        <input type="date" class="form-control" id="fecha_inicio" required>
                    </div>
                    <div class="col-md-3">
                        <label for="fecha_fin">Fecha Fin</label>
                        <input type="date" class="form-control" id="fecha_fin" required>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Cargar Ruta</button>
                    </div>
                </form>

                <!-- Mapa -->
                <div id="map" style="width:100%; height:500px;"></div>
            </div>
        </div>
    </div>
</div>

<!-- Leaflet -->
<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css"/>
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener('DOMContentLoaded', function(){

    // Namespace
    window.rutas = window.rutas || {};
    const rutas = window.rutas;

    // Inicializar mapa
    rutas.map = L.map('map').setView([-12.0326, -77.0394], 12);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19 }).addTo(rutas.map);

    rutas.markers = [];
    rutas.rutaLine = null;

    // Iconos de inicio y fin
    rutas.iconInicio = L.icon({ iconUrl: '../public/img/entrada.png', iconSize: [25,41] });
    rutas.iconFin = L.icon({ iconUrl: '../public/img/salida.png', iconSize: [25,41] });

    // Función para cargar ruta
    rutas.cargarRuta = function(){
        const placa = document.getElementById('placa').value.trim();
        const fecha_inicio = document.getElementById('fecha_inicio').value;
        const fecha_fin = document.getElementById('fecha_fin').value;

        if(!placa || !fecha_inicio || !fecha_fin) return;

        fetch(`../controller/get_ruta_fecha.php?placa=${placa}&inicio=${fecha_inicio}&fin=${fecha_fin}`)
        .then(res => res.json())
        .then(data => {
            // Limpiar marcadores anteriores
            rutas.markers.forEach(m => rutas.map.removeLayer(m));
            rutas.markers = [];
            if(rutas.rutaLine) rutas.map.removeLayer(rutas.rutaLine);

            if(data.length === 0){
                Swal.fire('Sin datos','No se encontraron registros para estas fechas','info');
                return;
            }

            const latlngs = [];
            data.forEach((punto, index) => {
                let marker;
                if(index === 0)
                    marker = L.marker([punto.lat, punto.lng], {icon: rutas.iconInicio}).addTo(rutas.map).bindPopup('Inicio: ' + punto.fecha);
                else if(index === data.length - 1)
                    marker = L.marker([punto.lat, punto.lng], {icon: rutas.iconFin}).addTo(rutas.map).bindPopup('Fin: ' + punto.fecha);
                else
                    marker = L.marker([punto.lat, punto.lng]).addTo(rutas.map).bindPopup('Fecha: ' + punto.fecha);

                rutas.markers.push(marker);
                latlngs.push([punto.lat, punto.lng]);
            });

            rutas.rutaLine = L.polyline(latlngs, {color:'blue'}).addTo(rutas.map);
            rutas.map.fitBounds(rutas.rutaLine.getBounds());
        })
        .catch(err => console.error(err));
    };

    // Evento submit
    document.getElementById('formFiltro').addEventListener('submit', function(e){
        e.preventDefault();
        rutas.cargarRuta();
    });

    // Auto-refresh cada 60 segundos
    setInterval(() => {
        const placa = document.getElementById('placa').value.trim();
        if(placa) rutas.cargarRuta();
    }, 60000); // 60 segundos

});
</script>
<?php include 'footer.php'; ?>
