<?php
error_reporting(0);
include 'header.php';
include '../config/conexion.php';

$fechainicio = $_GET['fechainicio'] ?? '';
$fechafin = $_GET['fechafin'] ?? '';

$importe_cobustible = 0;
$importe_mantenimineto = 0;
$importe_aceite_motor = 0;
$importe_aceite_caja = 0;
$importe_cambio_llanta = 0;
$importe_sistema_rodaje = 0;
$importe_compra_lubricante = 0;
$importe_otros = 0;

if ($fechainicio && $fechafin) {
    $database = new Connection();
    $db = $database->open();

    // Consulta para cada tipo de gasto
    $tiposGasto = [
        'Combustible' => &$importe_cobustible,
        'Mantenimiento' => &$importe_mantenimineto,
        'Aceite de Motor' => &$importe_aceite_motor,
        'Aceite caja y Corona' => &$importe_aceite_caja,
        'Cambio de Llanta' => &$importe_cambio_llanta,
        'Sistema de Rodaje' => &$importe_sistema_rodaje,
        'Compras de Lubricante' => &$importe_compra_lubricante,
        'Otros' => &$importe_otros,
    ];

    try {
        foreach ($tiposGasto as $tipo => &$importe) {
            $stmt = $db->prepare("SELECT IFNULL(SUM(importe), 0) FROM gastos WHERE tipo_gasto = :tipo AND DATE_FORMAT(fecha_creacion, '%Y-%m-%d') BETWEEN :inicio AND :fin");
            $stmt->execute([':tipo' => $tipo, ':inicio' => $fechainicio, ':fin' => $fechafin]);
            $importe = $stmt->fetchColumn();
        }
    } catch (PDOException $e) {
        echo "<div class='alert alert-danger'>Error en la conexión: " . $e->getMessage() . "</div>";
    }
    $database->close();
}
?>

<style>
.highcharts-figure,
.highcharts-data-table table {
    min-width: 300px;
    max-width: 100%;
    margin: 1em auto;
}

.highcharts-data-table table {
    font-family: Verdana, sans-serif;
    border-collapse: collapse;
    border: 1px solid #ebebeb;
    margin: 10px auto;
    text-align: center;
    width: 100%;
    max-width: 500px;
}

.highcharts-data-table caption {
    padding: 1em 0;
    font-size: 1.2em;
    color: #555;
}

.highcharts-data-table th {
    font-weight: 600;
    padding: 0.5em;
}

.highcharts-data-table td,
.highcharts-data-table th,
.highcharts-data-table caption {
    padding: 0.5em;
}

.highcharts-data-table thead tr,
.highcharts-data-table tr:nth-child(even) {
    background: #f8f8f8;
}

.highcharts-data-table tr:hover {
    background: #f1f7ff;
}

#container {
    width: 100% !important;
    min-height: 400px;
    margin: 0 auto;
}
</style>

<div class="content mt-3">
    <div class="animated fadeIn">
        <div class="row">

            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="mb-3">Generar Informe de gastos por Tipo de Mantenimiento</h4>
                        <form action="" method="GET" class="form-inline mb-4">
                            <label class="mr-2"><strong>Desde:</strong></label>
                            <input type="date" name="fechainicio" class="form-control mr-3" value="<?php echo htmlspecialchars($fechainicio); ?>" required>
                            
                            <label class="mr-2"><strong>Hasta:</strong></label>
                            <input type="date" name="fechafin" class="form-control mr-3" value="<?php echo htmlspecialchars($fechafin); ?>" required>
                            
                            <button type="submit" class="btn btn-success">Generar Informe!</button>
                        </form>

                        <div id="container"></div>
                    </div>
                </div>
            </div><!-- /# column -->

        </div>
    </div><!-- .animated -->
</div><!-- .content -->

<?php include 'footer.php'; ?>

<script src="../public/grafico/code/highcharts.js"></script>
<script src="../public/grafico/code/modules/exporting.js"></script>
<script src="../public/grafico/code/modules/export-data.js"></script>
<script src="../public/grafico/code/modules/accessibility.js"></script>

<script>
Highcharts.chart('container', {
    chart: {
        type: 'line',
    },
    title: {
        text: 'Gastos Realizados por Alerta de Tipo de Mantenimiento'
    },
    xAxis: {
        categories: ['Combustible', 'Mantenimiento', 'Aceite de Motor', 'Aceite caja y Corona', 
            'Cambio de Llanta', 'Sistema de Rodaje', 'Compras de Lubricante', 'Otros']
    },
    yAxis: {
        title: {
            text: 'Gastos por Tipo de Mantenimiento'
        }
    },
    plotOptions: {
        line: {
            dataLabels: {
                enabled: true
            },
            enableMouseTracking: true
        }
    },
    series: [{
        name: 'Estadística Por Tipo de Mantenimiento',
        data: [
            <?php echo $importe_cobustible;?>, 
            <?php echo $importe_mantenimineto;?>, 
            <?php echo $importe_aceite_motor;?>,
            <?php echo $importe_aceite_caja;?>, 
            <?php echo $importe_cambio_llanta;?>, 
            <?php echo $importe_sistema_rodaje;?>, 
            <?php echo $importe_compra_lubricante;?>, 
            <?php echo $importe_otros;?>
        ]
    }],
    responsive: {
        rules: [{
            condition: {
                maxWidth: 600
            },
            chartOptions: {
                legend: {
                    layout: 'horizontal',
                    align: 'center',
                    verticalAlign: 'bottom'
                },
                yAxis: {
                    labels: {
                        align: 'left',
                        x: 0,
                        y: -5
                    },
                    title: {
                        text: null
                    }
                },
                subtitle: {
                    text: null
                },
                credits: {
                    enabled: false
                }
            }
        }]
    }
});
</script>
