<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('America/Lima');
session_start();

$error = sha1(md5("Error"));
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>VehiTracker | Sistema de Gestión Vehicular</title>
  <meta name="description" content="VehiTracker - Control y gestión de flotas, accesos y mantenimiento vehicular.">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="shortcut icon" href="../public/img/coche.png">
  <link rel="stylesheet" href="../public/vendors/bootstrap/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../public/vendors/font-awesome/css/font-awesome.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="../public/assets/css/style.css">
  <link href="../public/particles/particles.css" rel="stylesheet">

  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <style>
    body {
      background: radial-gradient(circle at top, #0d1117, #000);
      color: #fff;
      font-family: 'Inter', sans-serif;
      overflow: hidden;
      height: 100vh;
    }

    #particles-js {
      position: absolute;
      width: 100%;
      height: 100%;
      z-index: 0;
    }

    .login-container {
      position: relative;
      z-index: 10;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
    }

    .login-card {
      background: rgba(255, 255, 255, 0.05);
      backdrop-filter: blur(15px);
      border-radius: 15px;
      padding: 40px;
      box-shadow: 0 0 25px rgba(0, 0, 0, 0.6);
      width: 100%;
      max-width: 400px;
      text-align: center;
      transition: transform 0.3s ease-in-out;
    }

    .login-card:hover {
      transform: translateY(-5px);
    }

    .login-card img {
      width: 90px;
      margin-bottom: 20px;
    }

    .login-card h4 {
      font-weight: 700;
      color: #00d8ff;
      margin-bottom: 15px;
    }

    .form-control {
      background-color: rgba(255, 255, 255, 0.1);
      border: none;
      color: #fff;
      padding: 10px 15px;
      border-radius: 10px;
      margin-bottom: 15px;
    }

    .form-control:focus {
      box-shadow: 0 0 10px #00d8ff;
      background-color: rgba(255, 255, 255, 0.15);
    }

    .btn-custom {
      border: none;
      border-radius: 10px;
      padding: 12px;
      font-weight: 600;
      transition: all 0.3s ease;
    }

    .btn-login {
      background-color: #00d8ff;
      color: #000;
    }

    .btn-login:hover {
      background-color: #00bcd4;
    }

    .btn-vehiculo {
      background-color: #ff4757;
      color: #fff;
    }

    .btn-vehiculo:hover {
      background-color: #ff6b81;
    }

    small {
      color: #aaa;
    }
  </style>
</head>

<body>
  <?php
  if (isset($_GET['error']) && $_GET['error'] == $error) {
      echo "
      <script>Swal.fire({
          icon: 'error',
          title: 'Acceso Denegado',
          text: 'La contraseña ingresada no es correcta.',
          confirmButtonColor: '#00d8ff'
      });</script>";
  }
  ?>

  <div id="particles-js"></div>

  <div class="login-container">
    <div class="login-card">
      <img src="../public/img/coche.png" alt="VehiTracker Logo">
      <h4>VehiTracker</h4>
      <p class="text-light mb-4">Sistema de Control y Gestión Vehícular</p>

      <form method="POST" action="../controller/login.php">
        <div class="form-group text-left">
          <label for="usuario">Usuario:</label>
          <input type="text" name="usuario" id="usuario" class="form-control" placeholder="Ingrese su usuario" required>
        </div>
        <div class="form-group text-left">
          <label for="password">Contraseña:</label>
          <input type="password" name="password" id="password" class="form-control" placeholder="Ingrese su contraseña" required>
        </div>

        <input type="hidden" name="lat" id="lat">
        <input type="hidden" name="lng" id="lng">

        <button type="submit" name="submitBtnLogin" class="btn btn-custom btn-login btn-block mb-3">
          <i class="fa fa-user"></i> Iniciar Sesión
        </button>
        <hr style="background-color: rgba(255,255,255,0.2)">
        <small>Versión 1.0 — VehiTraker</small>
      </form>
    </div>
  </div>

  <script src="../public/vendors/jquery/dist/jquery.min.js"></script>
  <script src="../public/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
  <script src="../public/particles/particles.min.js"></script>

  <script>
    navigator.geolocation.getCurrentPosition(function(pos) {
      document.getElementById("lat").value = pos.coords.latitude;
      document.getElementById("lng").value = pos.coords.longitude;
    });

    particlesJS({
      "particles": {
        "number": {"value": 80,"density": {"enable": true,"value_area": 800}},
        "color": {"value": "#00d8ff"},
        "shape": {"type": "circle"},
        "opacity": {"value": 0.5},
        "size": {"value": 3,"random": true},
        "line_linked": {"enable": true,"distance": 150,"color": "#00d8ff","opacity": 0.3,"width": 1},
        "move": {"enable": true,"speed": 2}
      },
      "interactivity": {
        "events": {"onhover": {"enable": true,"mode": "repulse"}},
        "modes": {"repulse": {"distance": 150}}
      },
      "retina_detect": true
    });
  </script>
</body>
</html>
