<?php
include 'header.php';
session_start();
?>

<div class="content mt-3">
    <div class="animated fadeIn">
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <h5><i class="fa fa-car"></i> Registrar Placa y Geolocalización</h5>
            </div>
            <div class="card-body">
                <form id="formPlaca">
                    <div class="form-group">
                        <label for="placa">Número de Placa</label>
                        <input type="text" class="form-control" id="placa" placeholder="Ingrese su placa" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Iniciar Registro</button>
                </form>

                <div id="mensaje" class="mt-2"></div>

                <p class="mt-3 text-success">
                    <strong>Última marcación:</strong> <span id="ultimaHora">--:--:--</span>
                </p>

                <hr>

                <h5>Mapa del Vehículo</h5>
                <div id="map" style="width:100%; height:400px;"></div>
            </div>
        </div>
    </div>
</div>


<?php
include 'footer.php';

?>

<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css"/>
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let map = L.map('map').setView([-12.0326, -77.0394], 12);
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19 }).addTo(map);

let markers = [];
let rutaLine = null;
let placaActual = null;
let intervaloRegistro = null;

// Iconos personalizados
const iconInicio = L.icon({ iconUrl: '../public/img/entrada.png', iconSize: [25,41] });
const iconFin = L.icon({ iconUrl: '../public/img/salida.png', iconSize: [25,41] });

// ---------------------
// Registrar placa
// ---------------------
document.getElementById('formPlaca').addEventListener('submit', function(e) {
    e.preventDefault();
    placaActual = document.getElementById('placa').value.trim();

    if(!placaActual) return;

    Swal.fire({
        icon: 'success',
        title: 'Placa registrada',
        text: 'Se empezará a registrar la ubicación inmediatamente y luego cada 2 minutos.'
    });

    // Registrar inmediatamente
    registrarUbicacion();

    // Registrar cada 2 minutos (sin marcar fin)

    if(intervaloRegistro) clearInterval(intervaloRegistro);
    intervaloRegistro = setInterval(() => registrarUbicacion(false), 120000); // 120000= 2 Minutos
    //intervaloRegistro = setInterval(() => registrarUbicacion(false), 300000); // 300000 = 5 minutos


    // Actualizar ruta cada 30 segundos
    setInterval(cargarRutaMapa, 30000);
});

// ---------------------
// Función para registrar ubicación
// ---------------------
function registrarUbicacion(fin = false) {
    if(!placaActual) return;

    if(navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
            const lat = position.coords.latitude;
            const lng = position.coords.longitude;

            fetch('../controller/insertar_ubicacion.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    placa: placaActual,
                    lat: lat,
                    lng: lng,
                    fin: fin
                })
            })
            .then(res => res.json())
            .then(data => {
                document.getElementById('mensaje').textContent = data.msg;

                // Solo mostrar alerta si NO es salida
                if (!fin) {
                    const hora = new Date().toLocaleTimeString();
                    document.getElementById('ultimaHora').textContent = hora;

                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'info',
                        title: '📍 Ubicación actualizada a las ' + hora,
                        showConfirmButton: false,
                        timer: 2500
                    });
                }

                cargarRutaMapa();
            })
            .catch(err => console.error(err));
        }, function(err) {
            console.error(err);
            document.getElementById('mensaje').textContent = "No se pudo obtener la ubicación.";
        });
    } else {
        alert("Tu navegador no soporta geolocalización.");
    }
}

// ---------------------
// Registrar última ubicación al salir o recargar
// ---------------------
window.addEventListener('beforeunload', function() {
    if (navigator.geolocation && placaActual) {
        // Hacer la última marca con fin=1
        navigator.geolocation.getCurrentPosition(position => {
            fetch('../controller/insertar_ubicacion.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                keepalive: true, // permite que el request se complete incluso si la página se cierra
                body: JSON.stringify({
                    placa: placaActual,
                    lat: position.coords.latitude,
                    lng: position.coords.longitude,
                    fin: true
                })
            });
        });
    }
});

// ---------------------
// Cargar recorrido en mapa
// ---------------------
function cargarRutaMapa() {
    if(!placaActual) return;

    fetch('../controller/get_ruta.php?placa=' + placaActual)
    .then(res => res.json())
    .then(data => {
        // Limpiar marcadores anteriores
        markers.forEach(m => map.removeLayer(m));
        markers = [];

        let latlngs = [];

        data.forEach((punto, index) => {
            let marker;
            if(index === 0) {
                marker = L.marker([punto.lat, punto.lng], {icon: iconInicio})
                    .addTo(map)
                    .bindPopup('Inicio: ' + punto.fecha);
            } else if(index === data.length - 1 && punto.fin == 1) {
                marker = L.marker([punto.lat, punto.lng], {icon: iconFin})
                    .addTo(map)
                    .bindPopup('Fin: ' + punto.fecha);
            } else {
                marker = L.marker([punto.lat, punto.lng])
                    .addTo(map)
                    .bindPopup('Fecha: ' + punto.fecha);
            }
            markers.push(marker);
            latlngs.push([punto.lat, punto.lng]);
        });

        // Dibujar línea del recorrido
        if(rutaLine) map.removeLayer(rutaLine);
        if(latlngs.length > 1) {
            rutaLine = L.polyline(latlngs, { color: 'blue' }).addTo(map);
            map.fitBounds(rutaLine.getBounds());
        } else if(latlngs.length === 1) {
            map.setView(latlngs[0], 15);
        }
    });
}
</script>
