<?php
error_reporting(0);
include 'header.php';
$fechainicio = $_POST['fechainicio'] ?? '';
$fechafin = $_POST['fechafin'] ?? '';
?>

<div class="content mt-3">
    <div class="animated fadeIn">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <strong class="card-title">Registro Histórico de Entradas y Salidas</strong>
                    </div>
                    <div class="card-body">
                        <form action="" method="POST" class="mb-3 row g-2">
                            <div class="col-md-3">
                                <label>Desde:</label>
                                <input type="date" name="fechainicio" class="form-control" required value="<?= $fechainicio ?>">
                            </div>
                            <div class="col-md-3">
                                <label>Hasta:</label>
                                <input type="date" name="fechafin" class="form-control" required value="<?= $fechafin ?>">
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-success w-100"><i class="fa fa-eye"></i> Consultar</button>
                            </div>
                        </form>

                        <table id="example" class="display nowrap table table-striped table-bordered" style="width:100%">
                            <thead class="bg-primary text-white">
                                <tr>
                                    <th>#</th>
                                    <th>Placa</th>
                                    <th>Tipo</th>
                                    <th>Marca</th>
                                    <th>Modelo</th>
                                    <th>Conductor</th>
                                    <th>Estado</th>
                                    <th>Comentarios</th>
                                    <th>Fecha Ingreso</th>
                                    <th>Comentario Salida</th>
                                    <th>Hora Salida</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                include '../config/conexion.php';
                                $database = new Connection();
                                $db = $database->open();
                                try {
                                    if ($fechainicio && $fechafin) {
                                        $sql = "SELECT * FROM registro_unidad 
                                                WHERE DATE(fecha_registro) BETWEEN :inicio AND :fin 
                                                ORDER BY fecha_registro ASC";
                                        $stmt = $db->prepare($sql);
                                        $stmt->execute([':inicio' => $fechainicio, ':fin' => $fechafin]);
                                        $idx = 1;
                                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                            ?>
                                            <tr>
                                                <td><?= $idx++ ?></td>
                                                <td><?= htmlspecialchars($row['placa']) ?></td>
                                                <td><?= htmlspecialchars($row['tipo']) ?></td>
                                                <td><?= htmlspecialchars($row['marca']) ?></td>
                                                <td><?= htmlspecialchars($row['modelo']) ?></td>
                                                <td><?= htmlspecialchars($row['chofer']) ?></td>
                                            <td>
                                                <?php if (isset($row['estado'])): ?>
                                                    <?php if ($row['estado']): ?>
                                                    <span class="text-success fw-bold">
                                                        <i class="fa fa-arrow-down"></i> Entrada
                                                    </span>
                                                    <?php else: ?>
                                                    <span class="text-danger fw-bold">
                                                        <i class="fa fa-arrow-up"></i> Salida
                                                    </span>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                                </td>
                                                <td><?= htmlspecialchars($row['comentarios']) ?></td>
                                                <td><?= $row['fecha_registro'] ?></td>
                                                <td><?= htmlspecialchars($row['comentario_salida'] ?? '-') ?></td>
                                                <td><?= $row['hora_salida'] ?></td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                } catch (PDOException $e) {
                                    echo "<tr><td colspan='11'>Error: " . $e->getMessage() . "</td></tr>";
                                }
                                $database->close();
                                ?>
                            </tbody>
                            <tfoot class="bg-primary text-white">
                                <tr>
                                    <th>#</th>
                                    <th>Placa</th>
                                    <th>Tipo</th>
                                    <th>Marca</th>
                                    <th>Modelo</th>
                                    <th>Conductor</th>
                                    <th>Estado</th>
                                    <th>Comentarios</th>
                                    <th>Fecha Ingreso</th>
                                    <th>Comentario Salida</th>
                                    <th>Hora Salida</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- DataTables CSS y JS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

<!-- Dependencias para export Excel y PDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<script>
    $(document).ready(function () {
        $('#example').DataTable({
            responsive: true,
            dom: 'Bfrtip',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
            pageLength: 25
        });
    });
</script>
