<?php
include 'header.php';
include '../config/conexion.php';

$database = new Connection();
$db = $database->open();

$iconosPermisos = [
    'ver_cheklist' => 'fa-clipboard-check',
    'ver_reportes' => 'fa-file-alt',
    'ver_dashboard_principal' => 'fa-chart-line',
    'ver_gestion' => 'fa-cogs',
    'ver_mantenimiento' => 'fa-tools',
    'ver_alertas' => 'fa-bell',
    'ver_estadisticas' => 'fa-chart-pie'
];
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
/* Fondo general */
body {
    background-color: #f5f6fa;
}

/* Estilos del card */
.card {
    border: none;
    border-radius: 1rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.card-header {
    background: linear-gradient(90deg, #007bff, #00c6ff);
    color: white;
    border-top-left-radius: 1rem;
    border-top-right-radius: 1rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.form-check {
    background: #ffffff;
    border: 1px solid #e5e9f2;
    border-radius: 10px;
    padding: 10px 15px;
    margin-bottom: 10px;
    transition: all 0.2s ease-in-out;
    cursor: pointer;
}

.form-check:hover {
    background: #f1f9ff;
    transform: scale(1.02);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

/* Colores por tipo de permiso */
.permiso-icon.ver_cheklist { color: #4CAF50; }
.permiso-icon.ver_reportes { color: #2196F3; }
.permiso-icon.ver_dashboard_principal { color: #9C27B0; }
.permiso-icon.ver_conductor { color: #FF9800; }
.permiso-icon.ver_mantenimiento { color: #795548; }
.permiso-icon.ver_alertas { color: #f44336; }
.permiso-icon.ver_estadisticas { color: #3F51B5; }

/* Checkbox moderno */
.form-check-input {
    transform: scale(1.2);
    margin-right: 10px;
}

.form-check-input:checked + .form-check-label {
    color: #007bff;
    font-weight: 500;
}

/* Botón guardar */
.btn-success {
    background: linear-gradient(90deg, #28a745, #20c997);
    border: none;
    border-radius: 10px;
    padding: 10px 25px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-success:hover {
    background: linear-gradient(90deg, #20c997, #28a745);
    transform: scale(1.05);
}

.select-container {
    background: #fff;
    border-radius: 8px;
    padding: 15px;
    box-shadow: inset 0 0 3px rgba(0,0,0,0.1);
}
</style>

<div class="breadcrumbs">
    <div class="col-sm-12 text-center mb-4">
        <h5 class="text-primary font-weight-bold"><i class="fa fa-user-shield"></i> Asignación de Roles y Permisos</h5>
        <p class="text-muted">Define qué puede hacer cada usuario en el sistema</p>
    </div>
</div>

<div class="content mt-3">
    <div class="animated fadeIn">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-key"></i> Asignar Permisos a Usuario
                    </div>
                    <div class="card-body">

                        <?php if(isset($_SESSION['message'])): ?>
                            <div class="alert alert-success text-center mt-2">
                                <?= $_SESSION['message']; unset($_SESSION['message']); ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="../controller/CrearRoles.php">
                            <div class="form-group select-container">
                                <label for="usuario" class="font-weight-bold mb-2">👤 Seleccione Usuario:</label>
                                <select name="usuario_id" class="form-control" required>
                                    <option value="">-- Seleccione --</option>
                                    <?php
                                    $usuarios = $db->query('SELECT id, fullname FROM usuarios');
                                    foreach ($usuarios as $usuario) {
                                        echo '<option value="'.$usuario['id'].'">'.$usuario['fullname'].'</option>';
                                    }
                                    ?>
                                </select>
                            </div>

                            <hr>

                            <div class="form-group">
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="checkbox" id="checkAll">
                                    <label class="form-check-label font-weight-bold text-dark" for="checkAll">
                                        <i class="fa fa-check-double text-success"></i> Seleccionar todos los permisos (modo administrador)
                                    </label>
                                </div>

                                <div class="row">
                                    <?php
                                    $sql = 'SELECT * FROM permisos';
                                    foreach ($db->query($sql) as $row): 
                                        $permisoNombre = $row['nombre'];
                                        $icono = $iconosPermisos[$permisoNombre] ?? 'fa-question-circle';
                                        $claseColor = 'permiso-icon ' . htmlspecialchars($permisoNombre);
                                    ?>
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input permiso-checkbox" type="checkbox" name="permisos[]" value="<?= $row['id']; ?>" id="permiso_<?= $row['id']; ?>">
                                                <label class="form-check-label" for="permiso_<?= $row['id']; ?>">
                                                    <i class="fas <?= $icono ?> <?= $claseColor ?> me-2"></i>
                                                    <strong><?= ucfirst(str_replace('_', ' ', htmlspecialchars($row['nombre']))) ?></strong><br>
                                                    <small class="text-muted"><?= htmlspecialchars($row['descripcion']); ?></small>
                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>

                            <div class="text-center mt-4">
                                <button type="submit" class="btn btn-success shadow-lg">
                                    <i class="fa fa-save"></i> Guardar Permisos
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include 'footer.php';
?>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const checkAll = document.getElementById('checkAll');
    const checkboxes = document.querySelectorAll('.permiso-checkbox');

    checkAll.addEventListener('change', function () {
        checkboxes.forEach(cb => cb.checked = this.checked);
    });
});
</script>
